/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.Headers;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.http.HttpConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.HttpConnectionMetricsImpl;
import org.apache.http.impl.entity.EntitySerializer;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.impl.io.ChunkedInputStream;
import org.apache.http.impl.io.ContentLengthInputStream;
import org.apache.http.impl.io.HttpRequestWriter;
import org.apache.http.impl.io.IdentityInputStream;
import org.apache.http.impl.io.SocketInputBuffer;
import org.apache.http.impl.io.SocketOutputBuffer;
import org.apache.http.io.HttpMessageWriter;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.CharArrayBuffer;

public class AndroidHttpClientConnection
implements HttpInetConnection,
HttpConnection {
    private final EntitySerializer entityserializer;
    private SessionInputBuffer inbuffer = null;
    private int maxHeaderCount;
    private int maxLineLength;
    private HttpConnectionMetricsImpl metrics = null;
    private volatile boolean open;
    private SessionOutputBuffer outbuffer = null;
    private HttpMessageWriter requestWriter = null;
    private Socket socket = null;

    public AndroidHttpClientConnection() {
        EntitySerializer entitySerializer;
        StrictContentLengthStrategy strictContentLengthStrategy = new StrictContentLengthStrategy();
        this.entityserializer = entitySerializer = new EntitySerializer(strictContentLengthStrategy);
    }

    private void assertNotOpen() {
        if (!this.open) {
            return;
        }
        throw new IllegalStateException("Connection is already open");
    }

    private void assertOpen() {
        if (this.open) {
            return;
        }
        throw new IllegalStateException("Connection is not open");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long determineLength(Headers headers) {
        long l = headers.getTransferEncoding();
        if (l < 0L) {
            return l;
        }
        long l2 = headers.getContentLength();
        if (l2 <= 65535L) return 65535L;
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void bind(Socket socket, HttpParams httpParams) throws IOException {
        HttpConnectionMetricsImpl httpConnectionMetricsImpl;
        int n;
        int n2;
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.assertNotOpen();
        boolean bl = HttpConnectionParams.getTcpNoDelay(httpParams);
        socket.setTcpNoDelay(bl);
        int n3 = HttpConnectionParams.getSoTimeout(httpParams);
        socket.setSoTimeout(n3);
        int n4 = HttpConnectionParams.getLinger(httpParams);
        if (n4 >= 0) {
            boolean bl2 = n4 > 0;
            socket.setSoLinger(bl2, n4);
        }
        this.socket = socket;
        int n5 = HttpConnectionParams.getSocketBufferSize(httpParams);
        SocketInputBuffer socketInputBuffer = new SocketInputBuffer(socket, n5, httpParams);
        this.inbuffer = socketInputBuffer;
        SocketOutputBuffer socketOutputBuffer = new SocketOutputBuffer(socket, n5, httpParams);
        this.outbuffer = socketOutputBuffer;
        this.maxHeaderCount = n2 = httpParams.getIntParameter("http.connection.max-header-count", -1);
        this.maxLineLength = n = httpParams.getIntParameter("http.connection.max-line-length", -1);
        SessionOutputBuffer sessionOutputBuffer = this.outbuffer;
        HttpRequestWriter httpRequestWriter = new HttpRequestWriter(sessionOutputBuffer, null, httpParams);
        this.requestWriter = httpRequestWriter;
        HttpTransportMetrics httpTransportMetrics = this.inbuffer.getMetrics();
        HttpTransportMetrics httpTransportMetrics2 = this.outbuffer.getMetrics();
        this.metrics = httpConnectionMetricsImpl = new HttpConnectionMetricsImpl(httpTransportMetrics, httpTransportMetrics2);
        this.open = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.doFlush();
        try {
            try {
                this.socket.shutdownOutput();
            }
            catch (IOException iOException) {}
            try {
                this.socket.shutdownInput();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        this.socket.close();
    }

    protected void doFlush() throws IOException {
        this.outbuffer.flush();
    }

    public void flush() throws IOException {
        this.assertOpen();
        this.doFlush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InetAddress getLocalAddress() {
        if (this.socket == null) return null;
        return this.socket.getLocalAddress();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getLocalPort() {
        if (this.socket == null) return -1;
        return this.socket.getLocalPort();
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return this.metrics;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InetAddress getRemoteAddress() {
        if (this.socket == null) return null;
        return this.socket.getInetAddress();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getRemotePort() {
        if (this.socket == null) return -1;
        return this.socket.getPort();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getSocketTimeout() {
        if (this.socket == null) return -1;
        try {
            int n = this.socket.getSoTimeout();
            return n;
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isOpen() {
        if (!this.open) return false;
        if (this.socket == null) return false;
        if (!this.socket.isConnected()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isStale() {
        this.assertOpen();
        try {
            boolean bl = this.inbuffer.isDataAvailable(1);
            return false;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public StatusLine parseResponseHeader(Headers headers) throws IOException, ParseException {
        int n;
        this.assertOpen();
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(64);
        if (this.inbuffer.readLine(charArrayBuffer) == -1) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        BasicLineParser basicLineParser = BasicLineParser.DEFAULT;
        int n2 = charArrayBuffer.length();
        ParserCursor parserCursor = new ParserCursor(0, n2);
        StatusLine statusLine = basicLineParser.parseStatusLine(charArrayBuffer, parserCursor);
        int n3 = statusLine.getStatusCode();
        CharArrayBuffer charArrayBuffer2 = null;
        int n4 = 0;
        do {
            if (charArrayBuffer == null) {
                charArrayBuffer = new CharArrayBuffer(64);
            } else {
                charArrayBuffer.clear();
            }
            if (this.inbuffer.readLine(charArrayBuffer) == -1 || charArrayBuffer.length() < 1) {
                if (charArrayBuffer2 != null) {
                    headers.parseHeader(charArrayBuffer2);
                }
                if (n3 >= 200) {
                    this.metrics.incrementResponseCount();
                }
                return statusLine;
            }
            char c = charArrayBuffer.charAt(0);
            if (c != ' ' && c != '\t' || charArrayBuffer2 == null) {
                if (charArrayBuffer2 != null) {
                    headers.parseHeader(charArrayBuffer2);
                }
                ++n4;
                charArrayBuffer2 = charArrayBuffer;
                charArrayBuffer = null;
                continue;
            }
            int n5 = 0;
            int n6 = charArrayBuffer.length();
            while (true) {
                char c2;
                if (n5 >= n6 || (c2 = charArrayBuffer.charAt(n5)) != ' ' && c2 != '\t') {
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    if (this.maxLineLength <= 0 || (n10 = (n9 = charArrayBuffer2.length() + 1) + (n8 = charArrayBuffer.length()) - n5) <= (n7 = this.maxLineLength)) break;
                    throw new IOException("Maximum line length limit exceeded");
                }
                ++n5;
            }
            charArrayBuffer2.append(' ');
            int n11 = charArrayBuffer.length() - n5;
            charArrayBuffer2.append(charArrayBuffer, n5, n11);
        } while (this.maxHeaderCount <= 0 || n4 < (n = this.maxHeaderCount));
        throw new IOException("Maximum header count exceeded");
    }

    /*
     * Enabled aggressive block sorting
     */
    public HttpEntity receiveResponseEntity(Headers headers) {
        String string2;
        String string3;
        this.assertOpen();
        BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
        long l = this.determineLength(headers);
        if (l == 65534L) {
            basicHttpEntity.setChunked(true);
            basicHttpEntity.setContentLength(65535L);
            SessionInputBuffer sessionInputBuffer = this.inbuffer;
            ChunkedInputStream chunkedInputStream = new ChunkedInputStream(sessionInputBuffer);
            basicHttpEntity.setContent(chunkedInputStream);
        } else if (l == 65535L) {
            basicHttpEntity.setChunked(false);
            basicHttpEntity.setContentLength(65535L);
            SessionInputBuffer sessionInputBuffer = this.inbuffer;
            IdentityInputStream identityInputStream = new IdentityInputStream(sessionInputBuffer);
            basicHttpEntity.setContent(identityInputStream);
        } else {
            basicHttpEntity.setChunked(false);
            basicHttpEntity.setContentLength(l);
            SessionInputBuffer sessionInputBuffer = this.inbuffer;
            ContentLengthInputStream contentLengthInputStream = new ContentLengthInputStream(sessionInputBuffer, l);
            basicHttpEntity.setContent(contentLengthInputStream);
        }
        if ((string3 = headers.getContentType()) != null) {
            basicHttpEntity.setContentType(string3);
        }
        if ((string2 = headers.getContentEncoding()) != null) {
            basicHttpEntity.setContentEncoding(string2);
        }
        return basicHttpEntity;
    }

    public void sendRequestEntity(HttpEntityEnclosingRequest httpEntityEnclosingRequest) throws HttpException, IOException {
        if (httpEntityEnclosingRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.assertOpen();
        if (httpEntityEnclosingRequest.getEntity() == null) {
            return;
        }
        EntitySerializer entitySerializer = this.entityserializer;
        SessionOutputBuffer sessionOutputBuffer = this.outbuffer;
        HttpEntity httpEntity = httpEntityEnclosingRequest.getEntity();
        entitySerializer.serialize(sessionOutputBuffer, httpEntityEnclosingRequest, httpEntity);
    }

    public void sendRequestHeader(HttpRequest httpRequest) throws HttpException, IOException {
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.assertOpen();
        this.requestWriter.write(httpRequest);
        this.metrics.incrementRequestCount();
    }

    @Override
    public void setSocketTimeout(int n) {
        this.assertOpen();
        if (this.socket == null) {
            return;
        }
        try {
            this.socket.setSoTimeout(n);
            return;
        }
        catch (SocketException socketException) {
            return;
        }
    }

    @Override
    public void shutdown() throws IOException {
        this.open = false;
        Socket socket = this.socket;
        if (socket == null) {
            return;
        }
        socket.close();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.getClass().getSimpleName();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("[");
        if (this.isOpen()) {
            int n = this.getRemotePort();
            StringBuilder stringBuilder3 = stringBuilder.append(n);
        } else {
            StringBuilder stringBuilder4 = stringBuilder.append("closed");
        }
        StringBuilder stringBuilder5 = stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

