/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.HttpsConnection;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import com.android.internal.net.DomainNameValidator;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509TrustManager;
import org.apache.harmony.xnet.provider.jsse.SSLParametersImpl;

class CertificateChainValidator {
    private static final CertificateChainValidator sInstance = new CertificateChainValidator();

    private CertificateChainValidator() {
    }

    private void closeSocketThrowException(SSLSocket sSLSocket, String string2) throws IOException {
        if (sSLSocket != null) {
            SSLSession sSLSession = sSLSocket.getSession();
            if (sSLSession != null) {
                sSLSession.invalidate();
            }
            sSLSocket.close();
        }
        throw new SSLHandshakeException(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void closeSocketThrowException(SSLSocket sSLSocket, String string2, String string3) throws IOException {
        String string4 = string2 != null ? string2 : string3;
        this.closeSocketThrowException(sSLSocket, string4);
    }

    public static CertificateChainValidator getInstance() {
        return sInstance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SslError doHandshakeAndValidateServerCertificates(HttpsConnection httpsConnection, SSLSocket sSLSocket, String string2) throws IOException {
        SslError sslError;
        X509Certificate x509Certificate;
        Certificate[] certificateArray;
        X509Certificate[] x509CertificateArray = null;
        try {
            SSLSocket sSLSocket2 = sSLSocket;
            boolean bl = true;
            sSLSocket2.setUseClientMode(bl);
            sSLSocket.startHandshake();
        }
        catch (IOException iOException) {
            String string3 = iOException.getMessage();
            CertificateChainValidator certificateChainValidator = this;
            SSLSocket sSLSocket3 = sSLSocket;
            String string4 = string3;
            String string5 = "failed to perform SSL handshake";
            certificateChainValidator.closeSocketThrowException(sSLSocket3, string4, string5);
        }
        if ((certificateArray = sSLSocket.getSession().getPeerCertificates()) == null || certificateArray.length <= 0) {
            CertificateChainValidator certificateChainValidator = this;
            SSLSocket sSLSocket4 = sSLSocket;
            String string6 = "failed to retrieve peer certificates";
            certificateChainValidator.closeSocketThrowException(sSLSocket4, string6);
        } else {
            int n;
            int n2;
            int n3;
            x509CertificateArray = new X509Certificate[certificateArray.length];
            int n4 = 0;
            while ((n3 = ++n4) < (n2 = (n = certificateArray.length))) {
                X509Certificate x509Certificate2;
                x509CertificateArray[n4] = x509Certificate2 = (X509Certificate)certificateArray[n4];
            }
            if (httpsConnection != null && x509CertificateArray[0] != null) {
                X509Certificate x509Certificate3 = x509CertificateArray[0];
                SslCertificate sslCertificate = new SslCertificate(x509Certificate3);
                HttpsConnection httpsConnection2 = httpsConnection;
                SslCertificate sslCertificate2 = sslCertificate;
                httpsConnection2.setCertificate(sslCertificate2);
            }
        }
        if ((x509Certificate = x509CertificateArray[0]) == null) {
            CertificateChainValidator certificateChainValidator = this;
            SSLSocket sSLSocket5 = sSLSocket;
            String string7 = "certificate for this site is null";
            certificateChainValidator.closeSocketThrowException(sSLSocket5, string7);
        } else {
            X509Certificate x509Certificate4 = x509Certificate;
            String string8 = string2;
            if (!DomainNameValidator.match(x509Certificate4, string8)) {
                StringBuilder stringBuilder = new StringBuilder().append("certificate not for this host: ");
                String string9 = string2;
                String string10 = stringBuilder.append(string9).toString();
                sSLSocket.getSession().invalidate();
                SslError sslError2 = sslError;
                int n = 2;
                X509Certificate x509Certificate5 = x509Certificate;
                sslError2(n, x509Certificate5);
                return sslError;
            }
        }
        int n = x509CertificateArray.length;
        int n5 = x509CertificateArray.length;
        int n6 = 1;
        if (n5 > n6) {
            Date date;
            Date date2;
            Date date3;
            Principal principal;
            int n7;
            int n8;
            int n9;
            int n10 = 0;
            while ((n9 = ++n10) < (n8 = (n7 = x509CertificateArray.length))) {
                int n11;
                int n12;
                int n13;
                boolean bl = false;
                int n14 = n10 + 1;
                while ((n13 = ++n14) < (n12 = (n11 = x509CertificateArray.length))) {
                    X509Certificate x509Certificate6;
                    Principal principal2;
                    Principal principal3 = x509CertificateArray[n10].getIssuerDN();
                    if (!((Object)principal3).equals(principal2 = x509CertificateArray[n14].getSubjectDN())) continue;
                    bl = true;
                    int n15 = n14;
                    int n16 = n10 + 1;
                    int n17 = n16;
                    if (n15 == n17) break;
                    X509Certificate x509Certificate7 = x509CertificateArray[n14];
                    int n18 = n10 + 1;
                    x509CertificateArray[n14] = x509Certificate6 = x509CertificateArray[n18];
                    int n19 = n10 + 1;
                    x509CertificateArray[n19] = x509Certificate7;
                    break;
                }
                if (bl) continue;
                break;
            }
            n = n10 + 1;
            int n20 = n - 1;
            X509Certificate x509Certificate8 = x509CertificateArray[n20];
            Date date4 = new Date();
            Principal principal4 = x509Certificate8.getSubjectDN();
            if (((Object)principal4).equals(principal = x509Certificate8.getIssuerDN()) && (date3 = date4).after(date2 = (date = x509Certificate8.getNotAfter()))) {
                n += -1;
            }
        }
        X509Certificate[] x509CertificateArray2 = new X509Certificate[n];
        for (int i = 0; i < n; ++i) {
            X509Certificate x509Certificate9;
            x509CertificateArray2[i] = x509Certificate9 = x509CertificateArray[i];
        }
        try {
            X509TrustManager x509TrustManager = SSLParametersImpl.getDefaultTrustManager();
            X509Certificate[] x509CertificateArray3 = x509CertificateArray2;
            String string11 = "RSA";
            x509TrustManager.checkServerTrusted(x509CertificateArray3, string11);
            return null;
        }
        catch (CertificateException certificateException) {
            sSLSocket.getSession().invalidate();
            SslError sslError3 = sslError;
            int n21 = 3;
            X509Certificate x509Certificate10 = x509Certificate;
            sslError3(n21, x509Certificate10);
            return sslError;
        }
    }
}

