/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.os.SystemClock;
import android.security.Sha1MessageDigest;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

class CertificateValidatorCache {
    private static final long CACHE_ENTRY_LIFETIME = 600000L;
    public static long mCost;
    public static long mSave;
    private static CertificateFactory sCertificateFactory;
    private int mBigScrew;
    private HashMap<Integer, CacheEntry> mCacheMap;

    static {
        mSave = 0L;
        mCost = 0L;
    }

    public CertificateValidatorCache() {
        int n;
        this.mBigScrew = n = new Random().nextInt();
        HashMap hashMap = new HashMap();
        this.mCacheMap = hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] secureHash(Certificate[] certificateArray) {
        byte[] byArray = null;
        long l = SystemClock.uptimeMillis();
        if (certificateArray != null && certificateArray.length != 0) {
            byte[] byArray2;
            block11: {
                try {
                    Class<CertificateValidatorCache> clazz = CertificateValidatorCache.class;
                    synchronized (clazz) {
                        CertificateFactory certificateFactory = sCertificateFactory;
                        if (certificateFactory != null) break block11;
                    }
                }
                catch (GeneralSecurityException generalSecurityException) {}
                {
                    try {
                        sCertificateFactory = CertificateFactory.getInstance("X.509");
                    }
                    catch (GeneralSecurityException generalSecurityException) {}
                }
            }
            CertificateFactory certificateFactory = sCertificateFactory;
            List<Certificate> list = Arrays.asList(certificateArray);
            CertPath certPath = certificateFactory.generateCertPath(list);
            if (certPath != null && (byArray2 = certPath.getEncoded()) != null) {
                byte[] byArray3;
                byArray = byArray3 = new Sha1MessageDigest().digest(byArray2);
            }
        }
        long l2 = SystemClock.uptimeMillis();
        long l3 = mCost;
        long l4 = l2 - l;
        mCost = l3 + l4;
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean has(String string2, byte[] byArray) {
        CacheEntry cacheEntry;
        boolean bl;
        block6: {
            block5: {
                int n;
                int n2;
                int n3;
                Integer n4;
                HashMap<Integer, CacheEntry> hashMap;
                bl = false;
                if (string2 == null || string2.length() == 0 || byArray == null || byArray.length == 0 || (cacheEntry = (hashMap = this.mCacheMap).get(n4 = new Integer(n3 = (n2 = this.mBigScrew) ^ (n = string2.hashCode())))) == null) break block5;
                if (cacheEntry.expired()) break block6;
                bl = cacheEntry.has(string2, byArray);
                if (bl) {
                    long l = mSave;
                    long l2 = cacheEntry.mSave;
                    mSave = l + l2;
                }
            }
            return bl;
        }
        CacheEntry cacheEntry2 = this.mCacheMap.remove(cacheEntry);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean put(String string2, byte[] byArray, long l) {
        if (string2 == null) return false;
        if (string2.length() == 0) return false;
        if (byArray == null) return false;
        if (byArray.length == 0) return false;
        HashMap<Integer, CacheEntry> hashMap = this.mCacheMap;
        int n = this.mBigScrew;
        int n2 = string2.hashCode();
        int n3 = n ^ n2;
        Integer n4 = new Integer(n3);
        CertificateValidatorCache certificateValidatorCache = this;
        String string3 = string2;
        byte[] byArray2 = byArray;
        long l2 = l;
        CacheEntry cacheEntry = certificateValidatorCache.new CacheEntry(string3, byArray2, l2);
        CacheEntry cacheEntry2 = hashMap.put(n4, cacheEntry);
        return true;
    }

    private class CacheEntry {
        private String mDomain;
        private byte[] mHash;
        public long mSave;
        private long mTime;

        public CacheEntry(String string2, byte[] byArray, long l) {
            long l2;
            this.mDomain = string2;
            this.mHash = byArray;
            this.mSave = l;
            this.mTime = l2 = SystemClock.uptimeMillis();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean expired() {
            long l;
            long l2 = SystemClock.uptimeMillis();
            long l3 = l2 - (l = this.mTime);
            if (600000L >= l3) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean has(String string2, byte[] byArray) {
            if (string2 != null && string2.length() > 0 && !this.mDomain.equals(string2)) {
                return false;
            }
            if (byArray == null) return false;
            int n = byArray.length;
            if (n <= 0) return false;
            int n2 = this.mHash.length;
            if (n == n2) return false;
            int n3 = 0;
            while (n3 < n) {
                byte by = byArray[n3];
                byte by2 = this.mHash[n3];
                if (by != by2) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
    }
}

