/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.Context;
import android.net.http.AndroidHttpClientConnection;
import android.net.http.EventHandler;
import android.net.http.HttpConnection;
import android.net.http.HttpsConnection;
import android.net.http.Request;
import android.net.http.RequestFeeder;
import android.net.http.SSLConnectionClosedByUserException;
import android.net.http.SslCertificate;
import android.os.SystemClock;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

abstract class Connection {
    private static final int DONE = 3;
    private static final int DRAIN = 2;
    private static final String HTTP_CONNECTION = "http.connection";
    private static final int MAX_PIPE = 3;
    private static final int MIN_PIPE = 2;
    private static final int READ = 1;
    private static final int RETRY_REQUEST_LIMIT = 2;
    private static final int SEND = 0;
    static final int SOCKET_TIMEOUT = 60000;
    private static int STATE_CANCEL_REQUESTED;
    private static int STATE_NORMAL;
    private static final String[] states;
    private int mActive;
    private byte[] mBuf;
    private boolean mCanPersist;
    protected SslCertificate mCertificate = null;
    Context mContext;
    HttpHost mHost;
    protected AndroidHttpClientConnection mHttpClientConnection = null;
    private HttpContext mHttpContext;
    RequestFeeder mRequestFeeder;

    static {
        String[] stringArray = new String[]{"SEND", "READ", "DRAIN", "DONE"};
        states = stringArray;
        STATE_NORMAL = 0;
        STATE_CANCEL_REQUESTED = 1;
    }

    protected Connection(Context context, HttpHost httpHost, RequestFeeder requestFeeder) {
        int n;
        this.mActive = n = STATE_NORMAL;
        this.mContext = context;
        this.mHost = httpHost;
        this.mRequestFeeder = requestFeeder;
        this.mCanPersist = false;
        BasicHttpContext basicHttpContext = new BasicHttpContext(null);
        this.mHttpContext = basicHttpContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean clearPipe(LinkedList<Request> linkedList) {
        boolean bl = true;
        RequestFeeder requestFeeder = this.mRequestFeeder;
        synchronized (requestFeeder) {
            while (!linkedList.isEmpty()) {
                Request request = linkedList.removeLast();
                this.mRequestFeeder.requeueRequest(request);
                bl = false;
            }
            if (!bl) return bl;
            RequestFeeder requestFeeder2 = this.mRequestFeeder;
            HttpHost httpHost = this.mHost;
            if (requestFeeder2.haveRequest(httpHost)) return false;
            return true;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Connection getConnection(Context context, HttpHost httpHost, HttpHost httpHost2, RequestFeeder requestFeeder) {
        void var4_5;
        if (httpHost.getSchemeName().equals("http")) {
            HttpConnection httpConnection = new HttpConnection(context, httpHost, requestFeeder);
            return var4_5;
        }
        HttpsConnection httpsConnection = new HttpsConnection(context, httpHost, httpHost2, requestFeeder);
        return var4_5;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean httpFailure(Request request, int n, Exception exception) {
        int n2;
        boolean bl = true;
        request.mFailCount = n2 = request.mFailCount + 1;
        if (n2 >= 2) {
            String string2;
            bl = false;
            if (n < 0) {
                Context context = this.mContext;
                int[] nArray = EventHandler.errorStringResources;
                int n3 = -n;
                int n4 = nArray[n3];
                string2 = ((Object)context.getText(n4)).toString();
            } else {
                Throwable throwable = exception.getCause();
                string2 = throwable != null ? throwable.toString() : exception.getMessage();
            }
            request.mEventHandler.error(n, string2);
            request.complete();
        }
        this.closeConnection();
        Object object = this.mHttpContext.removeAttribute(HTTP_CONNECTION);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean keepAlive(HttpEntity httpEntity, ProtocolVersion protocolVersion, int n, HttpContext httpContext) {
        org.apache.http.HttpConnection httpConnection = (org.apache.http.HttpConnection)httpContext.getAttribute(HTTP_CONNECTION);
        if (httpConnection != null && !httpConnection.isOpen()) {
            return false;
        }
        if (httpEntity != null && httpEntity.getContentLength() < 0L) {
            if (!httpEntity.isChunked()) return false;
            HttpVersion httpVersion = HttpVersion.HTTP_1_0;
            if (protocolVersion.lessEquals(httpVersion)) {
                return false;
            }
        }
        if (n == 1) {
            return false;
        }
        if (n == 2) {
            return true;
        }
        HttpVersion httpVersion = HttpVersion.HTTP_1_0;
        if (protocolVersion.lessEquals(httpVersion)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean openHttpConnection(Request request) {
        long l = SystemClock.uptimeMillis();
        int n = 0;
        Object var5_4 = null;
        boolean bl = false;
        try {
            AndroidHttpClientConnection androidHttpClientConnection;
            this.mCertificate = null;
            this.mHttpClientConnection = androidHttpClientConnection = this.openConnection(request);
            if (this.mHttpClientConnection == null) {
                request.mFailCount = 2;
                return false;
            }
            this.mHttpClientConnection.setSocketTimeout(60000);
            HttpContext httpContext = this.mHttpContext;
            AndroidHttpClientConnection androidHttpClientConnection2 = this.mHttpClientConnection;
            httpContext.setAttribute(HTTP_CONNECTION, androidHttpClientConnection2);
        }
        catch (UnknownHostException unknownHostException) {
            n = -1;
            UnknownHostException unknownHostException2 = unknownHostException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n = -1;
            request.mFailCount = 2;
            IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
        }
        catch (SSLConnectionClosedByUserException sSLConnectionClosedByUserException) {
            request.mFailCount = 2;
            return false;
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            request.mFailCount = 2;
            n = 65525;
            SSLHandshakeException sSLHandshakeException2 = sSLHandshakeException;
        }
        catch (IOException iOException) {
            n = -1;
            IOException iOException2 = iOException;
        }
        if (n == 0) {
            return true;
        }
        if (request.mFailCount < 2) {
            int n2;
            this.mRequestFeeder.requeueRequest(request);
            request.mFailCount = n2 = request.mFailCount + 1;
        } else {
            void var5_5;
            boolean bl2 = this.httpFailure(request, n, (Exception)var5_5);
        }
        if (n != 0) return false;
        return true;
    }

    void cancel() {
        int n;
        this.mActive = n = STATE_CANCEL_REQUESTED;
        this.closeConnection();
    }

    abstract void closeConnection();

    byte[] getBuf() {
        if (this.mBuf == null) {
            byte[] byArray = new byte[8192];
            this.mBuf = byArray;
        }
        return this.mBuf;
    }

    boolean getCanPersist() {
        return this.mCanPersist;
    }

    SslCertificate getCertificate() {
        return this.mCertificate;
    }

    HttpHost getHost() {
        return this.mHost;
    }

    HttpContext getHttpContext() {
        return this.mHttpContext;
    }

    abstract String getScheme();

    abstract AndroidHttpClientConnection openConnection(Request var1) throws IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processRequests(Request request) {
        int n = 0;
        Object var3_3 = null;
        LinkedList<Request> linkedList = new LinkedList<Request>();
        int n2 = 2;
        int n3 = 3;
        int n4 = 0;
        block14: while (n4 != 3) {
            Request request2;
            int n5 = this.mActive;
            int n6 = STATE_CANCEL_REQUESTED;
            if (n5 != n6) {
                int n7;
                long l = 100L;
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {}
                this.mActive = n7 = STATE_NORMAL;
            }
            switch (n4) {
                default: {
                    continue block14;
                }
                case 0: {
                    if (linkedList.size() == n3) {
                        n4 = 1;
                        continue block14;
                    }
                    if (request == null) {
                        RequestFeeder requestFeeder = this.mRequestFeeder;
                        HttpHost httpHost = this.mHost;
                        request2 = requestFeeder.getRequest(httpHost);
                    } else {
                        request2 = request;
                        request = null;
                    }
                    if (request2 == null) {
                        n4 = 2;
                        continue block14;
                    }
                    request2.setConnection(this);
                    if (request2.mCancelled) {
                        request2.complete();
                        continue block14;
                    }
                    if (!(this.mHttpClientConnection != null && this.mHttpClientConnection.isOpen() || this.openHttpConnection(request2))) {
                        return;
                    }
                    EventHandler eventHandler = request2.mEventHandler;
                    SslCertificate sslCertificate = this.mCertificate;
                    eventHandler.certificate(sslCertificate);
                    try {
                        AndroidHttpClientConnection androidHttpClientConnection = this.mHttpClientConnection;
                        request2.sendRequest(androidHttpClientConnection);
                    }
                    catch (HttpException httpException) {
                        n = -1;
                    }
                    catch (IOException iOException) {
                        n = -1;
                    }
                    catch (IllegalStateException illegalStateException) {
                        n = -1;
                    }
                    if (var3_3 != null) {
                        if (this.httpFailure(request2, n, var3_3) && !request2.mCancelled) {
                            linkedList.addLast(request2);
                        }
                        var3_3 = null;
                        if (this.clearPipe(linkedList)) {
                            return;
                        }
                        n4 = 0;
                        n2 = n3 = 1;
                        continue block14;
                    }
                    linkedList.addLast(request2);
                    if (this.mCanPersist) continue block14;
                    n4 = 1;
                    continue block14;
                }
                case 1: 
                case 2: 
            }
            RequestFeeder requestFeeder = this.mRequestFeeder;
            HttpHost httpHost = this.mHost;
            boolean bl = !requestFeeder.haveRequest(httpHost);
            int n8 = linkedList.size();
            if (n4 != 2 && n8 < n2 && !bl && this.mCanPersist) {
                n4 = 0;
                continue;
            }
            if (n8 == 0) {
                if (bl) {
                    return;
                }
                n4 = 0;
                continue;
            }
            request2 = (Request)linkedList.removeFirst();
            try {
                AndroidHttpClientConnection androidHttpClientConnection = this.mHttpClientConnection;
                request2.readResponse(androidHttpClientConnection);
            }
            catch (ParseException parseException) {
                n = -1;
            }
            catch (IOException iOException) {
                n = -1;
            }
            catch (IllegalStateException illegalStateException) {
                n = -1;
            }
            if (var3_3 != null) {
                if (this.httpFailure(request2, n, var3_3) && !request2.mCancelled) {
                    request2.reset();
                    linkedList.addFirst(request2);
                }
                var3_3 = null;
                this.mCanPersist = false;
            }
            if (this.mCanPersist) continue;
            this.closeConnection();
            Object object = this.mHttpContext.removeAttribute(HTTP_CONNECTION);
            boolean bl2 = this.clearPipe(linkedList);
            n2 = n3 = 1;
            n4 = 0;
        }
        return;
    }

    void setCanPersist(HttpEntity httpEntity, ProtocolVersion protocolVersion, int n) {
        boolean bl;
        HttpContext httpContext = this.mHttpContext;
        this.mCanPersist = bl = this.keepAlive(httpEntity, protocolVersion, n, httpContext);
    }

    void setCanPersist(boolean bl) {
        this.mCanPersist = bl;
    }

    public String toString() {
        synchronized (this) {
            String string2;
            String string3 = string2 = this.mHost.toString();
            return string3;
        }
    }
}

