/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.Context;
import android.net.http.Connection;
import android.net.http.Request;
import android.net.http.RequestFeeder;
import android.net.http.RequestQueue;
import android.os.Process;
import android.os.SystemClock;
import org.apache.http.HttpHost;

class ConnectionThread
extends Thread {
    static final int WAIT_TICK = 1000;
    static final int WAIT_TIMEOUT = 5000;
    Connection mConnection;
    private RequestQueue.ConnectionManager mConnectionManager;
    private Context mContext;
    long mCurrentThreadTime;
    private int mId;
    private RequestFeeder mRequestFeeder;
    private volatile boolean mRunning = true;
    long mTotalThreadTime;
    private boolean mWaiting;

    ConnectionThread(Context context, int n, RequestQueue.ConnectionManager connectionManager, RequestFeeder requestFeeder) {
        this.mContext = context;
        String string2 = "http" + n;
        this.setName(string2);
        this.mId = n;
        this.mConnectionManager = connectionManager;
        this.mRequestFeeder = requestFeeder;
    }

    void requestStop() {
        RequestFeeder requestFeeder = this.mRequestFeeder;
        synchronized (requestFeeder) {
            this.mRunning = false;
            this.mRequestFeeder.notify();
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Process.setThreadPriority(1);
        this.mCurrentThreadTime = 0L;
        this.mTotalThreadTime = 0L;
        while (this.mRunning) {
            long l;
            long l2;
            Connection connection;
            boolean bl;
            Request request;
            if (this.mCurrentThreadTime == 65535L) {
                long l3;
                this.mCurrentThreadTime = l3 = SystemClock.currentThreadTimeMillis();
            }
            if ((request = this.mRequestFeeder.getRequest()) == null) {
                RequestFeeder requestFeeder = this.mRequestFeeder;
                synchronized (requestFeeder) {
                    this.mWaiting = bl = true;
                    this.mRequestFeeder.wait();
                    break block12;
                }
            }
            RequestQueue.ConnectionManager connectionManager = this.mConnectionManager;
            Context context = this.mContext;
            HttpHost httpHost = request.mHost;
            this.mConnection = connection = connectionManager.getConnection(context, httpHost);
            this.mConnection.processRequests(request);
            if (this.mConnection.getCanPersist()) {
                RequestQueue.ConnectionManager connectionManager2 = this.mConnectionManager;
                Connection connection2 = this.mConnection;
                if (!connectionManager2.recycleConnection(connection2)) {
                    this.mConnection.closeConnection();
                }
            } else {
                this.mConnection.closeConnection();
            }
            this.mConnection = null;
            if (this.mCurrentThreadTime <= 0L) continue;
            long l4 = this.mCurrentThreadTime;
            this.mCurrentThreadTime = l2 = SystemClock.currentThreadTimeMillis();
            long l5 = this.mTotalThreadTime;
            long l6 = this.mCurrentThreadTime - l4;
            this.mTotalThreadTime = l = l5 + l6;
            continue;
            {
                block12: {
                    catch (InterruptedException interruptedException) {}
                }
                this.mWaiting = bl = false;
                if (this.mCurrentThreadTime != 0L) {
                    long l7;
                    this.mCurrentThreadTime = l7 = SystemClock.currentThreadTimeMillis();
                }
            }
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String toString() {
        synchronized (this) {
            String string2;
            String string3 = this.mConnection == null ? "" : this.mConnection.toString();
            String string4 = this.mWaiting ? "w" : (string2 = "a");
            StringBuilder stringBuilder = new StringBuilder().append("cid ");
            int n = this.mId;
            String string5 = stringBuilder.append(n).append(" ").append(string4).append(" ").append(string3).toString();
            return string5;
        }
    }
}

