/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.CharArrayBuffers;
import java.util.ArrayList;
import org.apache.http.HeaderElement;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;

public final class Headers {
    public static final String ACCEPT_RANGES = "accept-ranges";
    public static final String CACHE_CONTROL = "cache-control";
    public static final int CONN_CLOSE = 1;
    public static final String CONN_DIRECTIVE = "connection";
    public static final int CONN_KEEP_ALIVE = 2;
    public static final String CONTENT_DISPOSITION = "content-disposition";
    public static final String CONTENT_ENCODING = "content-encoding";
    public static final String CONTENT_LEN = "content-length";
    public static final String CONTENT_TYPE = "content-type";
    public static final String ETAG = "etag";
    public static final String EXPIRES = "expires";
    private static final int HASH_ACCEPT_RANGES = 1397189435;
    private static final int HASH_CACHE_CONTROL = -208775662;
    private static final int HASH_CONN_DIRECTIVE = -775651618;
    private static final int HASH_CONTENT_DISPOSITION = -1267267485;
    private static final int HASH_CONTENT_ENCODING = 2095084583;
    private static final int HASH_CONTENT_LEN = -1132779846;
    private static final int HASH_CONTENT_TYPE = 785670158;
    private static final int HASH_ETAG = 3123477;
    private static final int HASH_EXPIRES = -1309235404;
    private static final int HASH_LAST_MODIFIED = 150043680;
    private static final int HASH_LOCATION = 1901043637;
    private static final int HASH_PRAGMA = -980228804;
    private static final int HASH_PROXY_AUTHENTICATE = -301767724;
    private static final int HASH_PROXY_CONNECTION = 285929373;
    private static final int HASH_REFRESH = 1085444827;
    private static final int HASH_SET_COOKIE = 1237214767;
    private static final int HASH_TRANSFER_ENCODING = 1274458357;
    private static final int HASH_WWW_AUTHENTICATE = -243037365;
    private static final int HASH_X_PERMITTED_CROSS_DOMAIN_POLICIES = -1345594014;
    private static final int HEADER_COUNT = 19;
    private static final int IDX_ACCEPT_RANGES = 10;
    private static final int IDX_CACHE_CONTROL = 12;
    private static final int IDX_CONN_DIRECTIVE = 4;
    private static final int IDX_CONTENT_DISPOSITION = 9;
    private static final int IDX_CONTENT_ENCODING = 3;
    private static final int IDX_CONTENT_LEN = 1;
    private static final int IDX_CONTENT_TYPE = 2;
    private static final int IDX_ETAG = 14;
    private static final int IDX_EXPIRES = 11;
    private static final int IDX_LAST_MODIFIED = 13;
    private static final int IDX_LOCATION = 5;
    private static final int IDX_PRAGMA = 16;
    private static final int IDX_PROXY_AUTHENTICATE = 8;
    private static final int IDX_PROXY_CONNECTION = 6;
    private static final int IDX_REFRESH = 17;
    private static final int IDX_SET_COOKIE = 15;
    private static final int IDX_TRANSFER_ENCODING = 0;
    private static final int IDX_WWW_AUTHENTICATE = 7;
    private static final int IDX_X_PERMITTED_CROSS_DOMAIN_POLICIES = 18;
    public static final String LAST_MODIFIED = "last-modified";
    public static final String LOCATION = "location";
    private static final String LOGTAG = "Http";
    public static final int NO_CONN_TYPE = 0;
    public static final long NO_CONTENT_LENGTH = 255L;
    public static final long NO_TRANSFER_ENCODING = 0L;
    public static final String PRAGMA = "pragma";
    public static final String PROXY_AUTHENTICATE = "proxy-authenticate";
    public static final String PROXY_CONNECTION = "proxy-connection";
    public static final String REFRESH = "refresh";
    public static final String SET_COOKIE = "set-cookie";
    public static final String TRANSFER_ENCODING = "transfer-encoding";
    public static final String WWW_AUTHENTICATE = "www-authenticate";
    public static final String X_PERMITTED_CROSS_DOMAIN_POLICIES = "x-permitted-cross-domain-policies";
    private static final String[] sHeaderNames;
    private int connectionType;
    private long contentLength;
    private ArrayList<String> cookies;
    private ArrayList<String> mExtraHeaderNames;
    private ArrayList<String> mExtraHeaderValues;
    private String[] mHeaders;
    private long transferEncoding;

    static {
        String[] stringArray = new String[]{TRANSFER_ENCODING, CONTENT_LEN, CONTENT_TYPE, CONTENT_ENCODING, CONN_DIRECTIVE, LOCATION, PROXY_CONNECTION, WWW_AUTHENTICATE, PROXY_AUTHENTICATE, CONTENT_DISPOSITION, ACCEPT_RANGES, EXPIRES, CACHE_CONTROL, LAST_MODIFIED, ETAG, SET_COOKIE, PRAGMA, REFRESH, X_PERMITTED_CROSS_DOMAIN_POLICIES};
        sHeaderNames = stringArray;
    }

    public Headers() {
        ArrayList arrayList = new ArrayList(2);
        this.cookies = arrayList;
        String[] stringArray = new String[19];
        this.mHeaders = stringArray;
        ArrayList arrayList2 = new ArrayList(4);
        this.mExtraHeaderNames = arrayList2;
        ArrayList arrayList3 = new ArrayList(4);
        this.mExtraHeaderValues = arrayList3;
        this.transferEncoding = 0L;
        this.contentLength = 65535L;
        this.connectionType = 0;
    }

    private void setConnectionType(CharArrayBuffer charArrayBuffer, int n) {
        if (CharArrayBuffers.containsIgnoreCaseTrimmed(charArrayBuffer, n, "Close")) {
            this.connectionType = 1;
            return;
        }
        if (!CharArrayBuffers.containsIgnoreCaseTrimmed(charArrayBuffer, n, "Keep-Alive")) {
            return;
        }
        this.connectionType = 2;
    }

    public String getAcceptRanges() {
        return this.mHeaders[10];
    }

    public String getCacheControl() {
        return this.mHeaders[12];
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public String getContentDisposition() {
        return this.mHeaders[9];
    }

    public String getContentEncoding() {
        return this.mHeaders[3];
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.mHeaders[2];
    }

    public String getEtag() {
        return this.mHeaders[14];
    }

    public String getExpires() {
        return this.mHeaders[11];
    }

    public void getHeaders(HeaderCallback headerCallback) {
        for (int i = 0; i < 19; ++i) {
            String string2 = this.mHeaders[i];
            if (string2 == null) continue;
            String string3 = sHeaderNames[i];
            headerCallback.header(string3, string2);
        }
        int n = this.mExtraHeaderNames.size();
        int n2 = 0;
        while (n2 < n) {
            String string4 = this.mExtraHeaderNames.get(n2);
            String string5 = this.mExtraHeaderValues.get(n2);
            headerCallback.header(string4, string5);
            ++n2;
        }
        return;
    }

    public String getLastModified() {
        return this.mHeaders[13];
    }

    public String getLocation() {
        return this.mHeaders[5];
    }

    public String getPragma() {
        return this.mHeaders[16];
    }

    public String getProxyAuthenticate() {
        return this.mHeaders[8];
    }

    public String getRefresh() {
        return this.mHeaders[17];
    }

    public ArrayList<String> getSetCookie() {
        return this.cookies;
    }

    public long getTransferEncoding() {
        return this.transferEncoding;
    }

    public String getWwwAuthenticate() {
        return this.mHeaders[7];
    }

    public String getXPermittedCrossDomainPolicies() {
        return this.mHeaders[18];
    }

    public void parseHeader(CharArrayBuffer charArrayBuffer) {
        int n = CharArrayBuffers.setLowercaseIndexOf(charArrayBuffer, 58);
        if (n == -1) {
            return;
        }
        String string2 = charArrayBuffer.substringTrimmed(0, n);
        if (string2.length() == 0) {
            return;
        }
        int n2 = charArrayBuffer.length();
        String string3 = charArrayBuffer.substringTrimmed(++n, n2);
        switch (string2.hashCode()) {
            default: {
                boolean bl = this.mExtraHeaderNames.add(string2);
                boolean bl2 = this.mExtraHeaderValues.add(string3);
                return;
            }
            case 1274458357: {
                int n3;
                String string4;
                if (!string2.equals(TRANSFER_ENCODING)) {
                    return;
                }
                this.mHeaders[0] = string3;
                BasicHeaderValueParser basicHeaderValueParser = BasicHeaderValueParser.DEFAULT;
                int n4 = charArrayBuffer.length();
                ParserCursor parserCursor = new ParserCursor(n, n4);
                HeaderElement[] headerElementArray = basicHeaderValueParser.parseElements(charArrayBuffer, parserCursor);
                int n5 = headerElementArray.length;
                if ("identity".equalsIgnoreCase(string3)) {
                    this.transferEncoding = 65535L;
                    return;
                }
                if (n5 > 0 && "chunked".equalsIgnoreCase(string4 = headerElementArray[n3 = n5 - 1].getName())) {
                    this.transferEncoding = 65534L;
                    return;
                }
                this.transferEncoding = 65535L;
                return;
            }
            case -1132779846: {
                if (!string2.equals(CONTENT_LEN)) {
                    return;
                }
                this.mHeaders[1] = string3;
                try {
                    long l;
                    this.contentLength = l = Long.parseLong(string3);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
            }
            case 785670158: {
                if (!string2.equals(CONTENT_TYPE)) {
                    return;
                }
                this.mHeaders[2] = string3;
                return;
            }
            case 2095084583: {
                if (!string2.equals(CONTENT_ENCODING)) {
                    return;
                }
                this.mHeaders[3] = string3;
                return;
            }
            case -775651618: {
                if (!string2.equals(CONN_DIRECTIVE)) {
                    return;
                }
                this.mHeaders[4] = string3;
                this.setConnectionType(charArrayBuffer, n);
                return;
            }
            case 1901043637: {
                if (!string2.equals(LOCATION)) {
                    return;
                }
                this.mHeaders[5] = string3;
                return;
            }
            case 285929373: {
                if (!string2.equals(PROXY_CONNECTION)) {
                    return;
                }
                this.mHeaders[6] = string3;
                this.setConnectionType(charArrayBuffer, n);
                return;
            }
            case -243037365: {
                if (!string2.equals(WWW_AUTHENTICATE)) {
                    return;
                }
                this.mHeaders[7] = string3;
                return;
            }
            case -301767724: {
                if (!string2.equals(PROXY_AUTHENTICATE)) {
                    return;
                }
                this.mHeaders[8] = string3;
                return;
            }
            case -1267267485: {
                if (!string2.equals(CONTENT_DISPOSITION)) {
                    return;
                }
                this.mHeaders[9] = string3;
                return;
            }
            case 1397189435: {
                if (!string2.equals(ACCEPT_RANGES)) {
                    return;
                }
                this.mHeaders[10] = string3;
                return;
            }
            case -1309235404: {
                if (!string2.equals(EXPIRES)) {
                    return;
                }
                this.mHeaders[11] = string3;
                return;
            }
            case -208775662: {
                if (!string2.equals(CACHE_CONTROL)) {
                    return;
                }
                this.mHeaders[12] = string3;
                return;
            }
            case 150043680: {
                if (!string2.equals(LAST_MODIFIED)) {
                    return;
                }
                this.mHeaders[13] = string3;
                return;
            }
            case 3123477: {
                if (!string2.equals(ETAG)) {
                    return;
                }
                this.mHeaders[14] = string3;
                return;
            }
            case 1237214767: {
                if (!string2.equals(SET_COOKIE)) {
                    return;
                }
                this.mHeaders[15] = string3;
                boolean bl = this.cookies.add(string3);
                return;
            }
            case -980228804: {
                if (!string2.equals(PRAGMA)) {
                    return;
                }
                this.mHeaders[16] = string3;
                return;
            }
            case 1085444827: {
                if (!string2.equals(REFRESH)) {
                    return;
                }
                this.mHeaders[17] = string3;
                return;
            }
            case -1345594014: 
        }
        if (!string2.equals(X_PERMITTED_CROSS_DOMAIN_POLICIES)) {
            return;
        }
        this.mHeaders[18] = string3;
    }

    public void setAcceptRanges(String string2) {
        this.mHeaders[10] = string2;
    }

    public void setCacheControl(String string2) {
        this.mHeaders[12] = string2;
    }

    public void setContentDisposition(String string2) {
        this.mHeaders[9] = string2;
    }

    public void setContentEncoding(String string2) {
        this.mHeaders[3] = string2;
    }

    public void setContentLength(long l) {
        this.contentLength = l;
    }

    public void setContentType(String string2) {
        this.mHeaders[2] = string2;
    }

    public void setEtag(String string2) {
        this.mHeaders[14] = string2;
    }

    public void setExpires(String string2) {
        this.mHeaders[11] = string2;
    }

    public void setLastModified(String string2) {
        this.mHeaders[13] = string2;
    }

    public void setLocation(String string2) {
        this.mHeaders[5] = string2;
    }

    public void setProxyAuthenticate(String string2) {
        this.mHeaders[8] = string2;
    }

    public void setWwwAuthenticate(String string2) {
        this.mHeaders[7] = string2;
    }

    public void setXPermittedCrossDomainPolicies(String string2) {
        this.mHeaders[18] = string2;
    }

    public static interface HeaderCallback {
        public void header(String var1, String var2);
    }
}

