/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

public class HttpAuthHeader {
    private static final String ALGORITHM_TOKEN = "algorithm";
    public static final int BASIC = 1;
    public static final String BASIC_TOKEN = "Basic";
    public static final int DIGEST = 2;
    public static final String DIGEST_TOKEN = "Digest";
    private static final String NONCE_TOKEN = "nonce";
    private static final String OPAQUE_TOKEN = "opaque";
    private static final String QOP_TOKEN = "qop";
    private static final String REALM_TOKEN = "realm";
    private static final String STALE_TOKEN = "stale";
    public static final int UNKNOWN;
    private String mAlgorithm;
    private boolean mIsProxy;
    private String mNonce;
    private String mOpaque;
    private String mPassword;
    private String mQop;
    private String mRealm;
    private int mScheme;
    private boolean mStale;
    private String mUsername;

    public HttpAuthHeader(String string2) {
        if (string2 == null) {
            return;
        }
        this.parseHeader(string2);
    }

    private void parseHeader(String string2) {
        if (string2 == null) {
            return;
        }
        String string3 = this.parseScheme(string2);
        if (string3 == null) {
            return;
        }
        if (this.mScheme == 0) {
            return;
        }
        this.parseParameters(string3);
    }

    private void parseParameter(String string2) {
        if (string2 == null) {
            return;
        }
        int n = string2.indexOf(61);
        if (n < 0) {
            return;
        }
        String string3 = string2.substring(0, n).trim();
        int n2 = n + 1;
        String string4 = HttpAuthHeader.trimDoubleQuotesIfAny(string2.substring(n2).trim());
        if (string3.equalsIgnoreCase(REALM_TOKEN)) {
            this.mRealm = string4;
            return;
        }
        if (this.mScheme != 2) {
            return;
        }
        this.parseParameter(string3, string4);
    }

    private void parseParameter(String string2, String string3) {
        String string4;
        if (string2 == null) {
            return;
        }
        if (string3 == null) {
            return;
        }
        if (string2.equalsIgnoreCase(NONCE_TOKEN)) {
            this.mNonce = string3;
            return;
        }
        if (string2.equalsIgnoreCase(STALE_TOKEN)) {
            this.parseStale(string3);
            return;
        }
        if (string2.equalsIgnoreCase(OPAQUE_TOKEN)) {
            this.mOpaque = string3;
            return;
        }
        if (string2.equalsIgnoreCase(QOP_TOKEN)) {
            String string5;
            this.mQop = string5 = string3.toLowerCase();
            return;
        }
        if (!string2.equalsIgnoreCase(ALGORITHM_TOKEN)) {
            return;
        }
        this.mAlgorithm = string4 = string3.toLowerCase();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseParameters(String string2) {
        int n;
        if (string2 == null) {
            return;
        }
        do {
            if ((n = string2.indexOf(44)) < 0) {
                this.parseParameter(string2);
                continue;
            }
            String string3 = string2.substring(0, n);
            this.parseParameter(string3);
            int n2 = n + 1;
            string2 = string2.substring(n2);
        } while (n >= 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String parseScheme(String string2) {
        if (string2 == null) return null;
        int n = string2.indexOf(32);
        if (n < 0) return null;
        String string3 = string2.substring(0, n).trim();
        if (string3.equalsIgnoreCase(DIGEST_TOKEN)) {
            this.mScheme = 2;
            this.mAlgorithm = "md5";
        } else if (string3.equalsIgnoreCase(BASIC_TOKEN)) {
            this.mScheme = 1;
        }
        int n2 = n + 1;
        return string2.substring(n2);
    }

    private void parseStale(String string2) {
        if (string2 == null) {
            return;
        }
        if (!string2.equalsIgnoreCase("true")) {
            return;
        }
        this.mStale = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String trimDoubleQuotesIfAny(String string2) {
        if (string2 == null) return string2;
        int n = string2.length();
        if (n <= 2) return string2;
        if (string2.charAt(0) != '\"') return string2;
        int n2 = n - 1;
        if (string2.charAt(n2) != '\"') return string2;
        int n3 = n - 1;
        return string2.substring(1, n3);
    }

    public String getAlgorithm() {
        return this.mAlgorithm;
    }

    public String getNonce() {
        return this.mNonce;
    }

    public String getOpaque() {
        return this.mOpaque;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public String getQop() {
        return this.mQop;
    }

    public String getRealm() {
        return this.mRealm;
    }

    public int getScheme() {
        return this.mScheme;
    }

    public boolean getStale() {
        return this.mStale;
    }

    public String getUsername() {
        return this.mUsername;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isBasic() {
        if (this.mScheme != 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDigest() {
        if (this.mScheme != 2) return false;
        return true;
    }

    public boolean isProxy() {
        return this.mIsProxy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupportedScheme() {
        if (this.mRealm == null) return false;
        if (this.mScheme == 1) {
            return true;
        }
        if (this.mScheme != 2) return false;
        if (!this.mAlgorithm.equals("md5")) return false;
        if (this.mQop == null) return true;
        if (!this.mQop.equals("auth")) return false;
        return true;
    }

    public void setPassword(String string2) {
        this.mPassword = string2;
    }

    public void setProxy() {
        this.mIsProxy = true;
    }

    public void setUsername(String string2) {
        this.mUsername = string2;
    }
}

