/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.Connection;
import android.os.Process;
import android.os.SystemClock;
import org.apache.http.HttpHost;

class IdleCache {
    private static final int CHECK_INTERVAL = 2000;
    private static final int EMPTY_CHECK_MAX = 5;
    private static final int IDLE_CACHE_MAX = 8;
    private static final int TIMEOUT = 6000;
    private int mCached;
    private int mCount;
    private Entry[] mEntries;
    private int mReused;
    private IdleReaper mThread;

    IdleCache() {
        Entry[] entryArray = new Entry[8];
        this.mEntries = entryArray;
        this.mCount = 0;
        this.mThread = null;
        this.mCached = 0;
        this.mReused = 0;
        int n = 0;
        while (n < 8) {
            Entry entry;
            Entry[] entryArray2 = this.mEntries;
            entryArray2[n] = entry = new Entry();
            ++n;
        }
        return;
    }

    static /* synthetic */ IdleReaper access$302(IdleCache idleCache, IdleReaper idleReaper) {
        idleCache.mThread = idleReaper;
        return idleReaper;
    }

    private void clearIdle() {
        synchronized (this) {
            block4: {
                if (this.mCount <= 0) break block4;
                long l = SystemClock.uptimeMillis();
                for (int i = 0; i < 8; ++i) {
                    int n;
                    long l2;
                    Entry entry = this.mEntries[i];
                    if (entry.mHost == null || l <= (l2 = entry.mTimeout)) continue;
                    entry.mHost = null;
                    entry.mConnection.closeConnection();
                    entry.mConnection = null;
                    this.mCount = n = this.mCount - 1;
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean cacheConnection(HttpHost httpHost, Connection connection) {
        synchronized (this) {
            boolean bl = false;
            if (this.mCount < 8) {
                long l = SystemClock.uptimeMillis();
                for (int i = 0; i < 8; ++i) {
                    IdleReaper idleReaper;
                    int n;
                    long l2;
                    Entry entry = this.mEntries[i];
                    if (entry.mHost != null) continue;
                    entry.mHost = httpHost;
                    entry.mConnection = connection;
                    entry.mTimeout = l2 = 6000L + l;
                    this.mCount = n = this.mCount + 1;
                    bl = true;
                    if (this.mThread != null) break;
                    this.mThread = idleReaper = new IdleReaper();
                    this.mThread.start();
                    break;
                }
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void clear() {
        synchronized (this) {
            for (int n = 0; this.mCount > 0 && n < 8; ++n) {
                int n2;
                Entry entry = this.mEntries[n];
                if (entry.mHost == null) continue;
                entry.mHost = null;
                entry.mConnection.closeConnection();
                entry.mConnection = null;
                this.mCount = n2 = this.mCount - 1;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Connection getConnection(HttpHost httpHost) {
        synchronized (this) {
            Connection connection = null;
            if (this.mCount > 0) {
                for (int i = 0; i < 8; ++i) {
                    int n;
                    Entry entry = this.mEntries[i];
                    HttpHost httpHost2 = entry.mHost;
                    if (httpHost2 == null || !httpHost2.equals(httpHost)) continue;
                    connection = entry.mConnection;
                    entry.mHost = null;
                    entry.mConnection = null;
                    this.mCount = n = this.mCount - 1;
                    break;
                }
            }
            return connection;
        }
    }

    private class IdleReaper
    extends Thread {
        private IdleReaper() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            int n = 0;
            this.setName("IdleReaper");
            Process.setThreadPriority(10);
            IdleCache idleCache = IdleCache.this;
            synchronized (idleCache) {
                while (true) {
                    if (n >= 5) {
                        IdleReaper idleReaper = IdleCache.access$302(IdleCache.this, null);
                        return;
                    }
                    try {
                        IdleCache.this.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (IdleCache.this.mCount == 0) {
                        ++n;
                        continue;
                    }
                    n = 0;
                    IdleCache.this.clearIdle();
                }
            }
        }
    }

    class Entry {
        Connection mConnection;
        HttpHost mHost;
        long mTimeout;

        Entry() {
        }
    }
}

