/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.AndroidHttpClientConnection;
import android.net.http.Connection;
import android.net.http.EventHandler;
import android.net.http.HttpLog;
import android.net.http.HttpsConnection;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ParseException;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.RequestContent;

class Request {
    private static final String ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    private static final String CONTENT_LENGTH_HEADER = "content-length";
    private static final String HOST_HEADER = "Host";
    private static RequestContent requestContentProcessor = new RequestContent();
    private int mBodyLength;
    private InputStream mBodyProvider;
    volatile boolean mCancelled = false;
    private final Object mClientResource;
    private Connection mConnection;
    EventHandler mEventHandler;
    int mFailCount = 0;
    HttpHost mHost;
    BasicHttpRequest mHttpRequest;
    private boolean mLoadingPaused;
    String mPath;
    HttpHost mProxyHost;
    private int mReceivedBytes = 0;

    /*
     * Enabled aggressive block sorting
     */
    Request(String string2, HttpHost httpHost, HttpHost httpHost2, String string3, InputStream inputStream, int n, EventHandler eventHandler, Map<String, String> map) {
        Object object;
        this.mClientResource = object = new Object();
        this.mLoadingPaused = false;
        this.mEventHandler = eventHandler;
        this.mHost = httpHost;
        this.mProxyHost = httpHost2;
        this.mPath = string3;
        this.mBodyProvider = inputStream;
        this.mBodyLength = n;
        if (inputStream == null && !"POST".equalsIgnoreCase(string2)) {
            BasicHttpRequest basicHttpRequest;
            String string4 = this.getUri();
            this.mHttpRequest = basicHttpRequest = new BasicHttpRequest(string2, string4);
        } else {
            String string5 = this.getUri();
            BasicHttpEntityEnclosingRequest basicHttpEntityEnclosingRequest = new BasicHttpEntityEnclosingRequest(string2, string5);
            this.mHttpRequest = basicHttpEntityEnclosingRequest;
            if (inputStream != null) {
                this.setBodyProvider(inputStream, n);
            }
        }
        String string6 = this.getHostPort();
        this.addHeader(HOST_HEADER, string6);
        this.addHeader(ACCEPT_ENCODING_HEADER, "gzip");
        this.addHeaders(map);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canResponseHaveBody(HttpRequest httpRequest, int n) {
        String string2 = httpRequest.getRequestLine().getMethod();
        if ("HEAD".equalsIgnoreCase(string2)) {
            return false;
        }
        if (n < 200) return false;
        if (n == 204) return false;
        if (n == 304) return false;
        return true;
    }

    private void setBodyProvider(InputStream inputStream, int n) {
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("bodyProvider must support mark()");
        }
        inputStream.mark(Integer.MAX_VALUE);
        BasicHttpEntityEnclosingRequest basicHttpEntityEnclosingRequest = (BasicHttpEntityEnclosingRequest)this.mHttpRequest;
        long l = n;
        InputStreamEntity inputStreamEntity = new InputStreamEntity(inputStream, l);
        basicHttpEntityEnclosingRequest.setEntity(inputStreamEntity);
    }

    void addHeader(String string2, String string3) {
        if (string2 == null) {
            HttpLog.e("Null http header name");
            throw new NullPointerException("Null http header name");
        }
        if (string3 == null || string3.length() == 0) {
            String string4 = "Null or empty value for header \"" + string2 + "\"";
            HttpLog.e(string4);
            throw new RuntimeException(string4);
        }
        this.mHttpRequest.addHeader(string2, string3);
    }

    void addHeaders(Map<String, String> map) {
        if (map == null) {
            return;
        }
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            this.addHeader(string2, string3);
        }
        return;
    }

    void cancel() {
        synchronized (this) {
            this.mLoadingPaused = false;
            this.notify();
            this.mCancelled = true;
            if (this.mConnection != null) {
                this.mConnection.cancel();
            }
            return;
        }
    }

    void complete() {
        Object object = this.mClientResource;
        synchronized (object) {
            this.mClientResource.notifyAll();
            return;
        }
    }

    void error(int n, int n2) {
        EventHandler eventHandler = this.mEventHandler;
        String string2 = ((Object)this.mConnection.mContext.getText(n2)).toString();
        eventHandler.error(n, string2);
    }

    EventHandler getEventHandler() {
        return this.mEventHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getHostPort() {
        String string2 = this.mHost.getSchemeName();
        int n = this.mHost.getPort();
        if (n != 80) {
            if (string2.equals("http")) return this.mHost.toHostString();
        }
        if (n == 443) return this.mHost.getHostName();
        if (!string2.equals("https")) return this.mHost.getHostName();
        return this.mHost.toHostString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getUri() {
        if (this.mProxyHost == null) return this.mPath;
        if (this.mHost.getSchemeName().equals("https")) {
            return this.mPath;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.mHost.getSchemeName();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("://");
        String string3 = this.getHostPort();
        StringBuilder stringBuilder3 = stringBuilder2.append(string3);
        String string4 = this.mPath;
        return stringBuilder3.append(string4).toString();
    }

    public void handleSslErrorResponse(boolean bl) {
        HttpsConnection httpsConnection = (HttpsConnection)this.mConnection;
        if (httpsConnection == null) {
            return;
        }
        httpsConnection.restartConnection(bl);
    }

    /*
     * Exception decompiling
     */
    void readResponse(AndroidHttpClientConnection var1_1) throws IOException, ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [11 : 492->494)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void reset() {
        this.mHttpRequest.removeHeaders(CONTENT_LENGTH_HEADER);
        if (this.mBodyProvider != null) {
            try {
                this.mBodyProvider.reset();
            }
            catch (IOException iOException) {}
            InputStream inputStream = this.mBodyProvider;
            int n = this.mBodyLength;
            this.setBodyProvider(inputStream, n);
        }
        if (this.mReceivedBytes <= 0) {
            return;
        }
        this.mFailCount = 0;
        StringBuilder stringBuilder = new StringBuilder().append("*** Request.reset() to range:");
        int n = this.mReceivedBytes;
        HttpLog.v(stringBuilder.append(n).toString());
        BasicHttpRequest basicHttpRequest = this.mHttpRequest;
        StringBuilder stringBuilder2 = new StringBuilder().append("bytes=");
        int n2 = this.mReceivedBytes;
        String string2 = stringBuilder2.append(n2).append("-").toString();
        basicHttpRequest.setHeader("Range", string2);
    }

    void sendRequest(AndroidHttpClientConnection androidHttpClientConnection) throws HttpException, IOException {
        if (this.mCancelled) {
            return;
        }
        RequestContent requestContent = requestContentProcessor;
        BasicHttpRequest basicHttpRequest = this.mHttpRequest;
        HttpContext httpContext = this.mConnection.getHttpContext();
        requestContent.process(basicHttpRequest, httpContext);
        BasicHttpRequest basicHttpRequest2 = this.mHttpRequest;
        androidHttpClientConnection.sendRequestHeader(basicHttpRequest2);
        if (!(this.mHttpRequest instanceof HttpEntityEnclosingRequest)) {
            return;
        }
        HttpEntityEnclosingRequest httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)((Object)this.mHttpRequest);
        androidHttpClientConnection.sendRequestEntity(httpEntityEnclosingRequest);
    }

    void setConnection(Connection connection) {
        this.mConnection = connection;
    }

    void setLoadingPaused(boolean bl) {
        synchronized (this) {
            this.mLoadingPaused = bl;
            if (!this.mLoadingPaused) {
                this.notify();
            }
            return;
        }
    }

    public String toString() {
        return this.mPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void waitUntilComplete() {
        Object object = this.mClientResource;
        synchronized (object) {
            try {
                this.mClientResource.wait();
            }
            catch (InterruptedException interruptedException) {}
            return;
        }
    }
}

