/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.ParseException;
import android.net.WebAddress;
import android.net.http.Connection;
import android.net.http.EventHandler;
import android.net.http.Request;
import android.net.http.RequestQueue;
import android.security.Md5MessageDigest;
import android.webkit.CookieManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import org.apache.commons.codec.binary.Base64;

public class RequestHandle {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    public static final int MAX_REDIRECT_COUNT = 16;
    private static final String PROXY_AUTHORIZATION_HEADER = "Proxy-Authorization";
    private int mBodyLength;
    private InputStream mBodyProvider;
    private Connection mConnection;
    private Map<String, String> mHeaders;
    private String mMethod;
    private int mRedirectCount = 0;
    private Request mRequest;
    private RequestQueue mRequestQueue;
    private WebAddress mUri;
    private String mUrl;

    /*
     * Enabled aggressive block sorting
     */
    public RequestHandle(RequestQueue requestQueue, String string2, WebAddress webAddress, String string3, Map<String, String> map, InputStream inputStream, int n, Request request) {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        this.mHeaders = map;
        this.mBodyProvider = inputStream;
        this.mBodyLength = n;
        String string4 = string3 == null ? "GET" : string3;
        this.mMethod = string4;
        this.mUrl = string2;
        this.mUri = webAddress;
        this.mRequestQueue = requestQueue;
        this.mRequest = request;
    }

    public RequestHandle(RequestQueue requestQueue, String string2, WebAddress webAddress, String string3, Map<String, String> map, InputStream inputStream, int n, Request request, Connection connection) {
        this(requestQueue, string2, webAddress, string3, map, inputStream, n, request);
        this.mConnection = connection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String H(String string2) {
        if (string2 == null) return null;
        Md5MessageDigest md5MessageDigest = new Md5MessageDigest();
        byte[] byArray = string2.getBytes();
        byte[] byArray2 = md5MessageDigest.digest(byArray);
        if (byArray2 == null) return null;
        return this.bufferToHex(byArray2);
    }

    private String KD(String string2, String string3) {
        String string4 = string2 + ":" + string3;
        return this.H(string4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String authorizationHeader(boolean bl) {
        if (bl) return PROXY_AUTHORIZATION_HEADER;
        return AUTHORIZATION_HEADER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String bufferToHex(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        if (byArray == null) return null;
        int n = byArray.length;
        if (n <= 0) return "";
        int n2 = n * 2;
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n3 = 0;
        while (n3 < n) {
            byte by = (byte)(byArray[n3] & 0xF);
            byte by2 = (byte)((byArray[n3] & 0xF0) >> 4);
            char c = cArray[by2];
            StringBuilder stringBuilder2 = stringBuilder.append(c);
            char c2 = cArray[by];
            StringBuilder stringBuilder3 = stringBuilder.append(c2);
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static String computeBasicAuthResponse(String string2, String string3) {
        Assert.assertNotNull(string2);
        Assert.assertNotNull(string3);
        byte[] byArray = Base64.encodeBase64((byte[])(string2 + ':' + string3).getBytes());
        return new String(byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String computeCnonce() {
        int n;
        int n2 = new Random().nextInt();
        if (n2 == Integer.MIN_VALUE) {
            n = Integer.MAX_VALUE;
            return Integer.toString(n, 16);
        }
        n = Math.abs(n2);
        return Integer.toString(n, 16);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String computeDigest(String string2, String string3, String string4, String string5, String string6, String string7) {
        if (string5 == null) {
            String string8 = this.H(string2);
            StringBuilder stringBuilder = new StringBuilder().append(string4).append(":");
            String string9 = this.H(string3);
            String string10 = stringBuilder.append(string9).toString();
            return this.KD(string8, string10);
        }
        if (!string5.equalsIgnoreCase("auth")) return null;
        String string11 = this.H(string2);
        StringBuilder stringBuilder = new StringBuilder().append(string4).append(":").append(string6).append(":").append(string7).append(":").append(string5).append(":");
        String string12 = this.H(string3);
        String string13 = stringBuilder.append(string12).toString();
        return this.KD(string11, string13);
    }

    private String computeDigestAuthResponse(String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        Assert.assertNotNull(string2);
        Assert.assertNotNull(string3);
        Assert.assertNotNull(string4);
        String string9 = string2 + ":" + string4 + ":" + string3;
        StringBuilder stringBuilder = new StringBuilder();
        String string10 = this.mMethod;
        StringBuilder stringBuilder2 = stringBuilder.append(string10).append(":");
        String string11 = this.mUrl;
        String string12 = stringBuilder2.append(string11).toString();
        String string13 = this.computeCnonce();
        RequestHandle requestHandle = this;
        String string14 = string5;
        String string15 = string6;
        String string16 = requestHandle.computeDigest(string9, string12, string14, string15, "000001", string13);
        StringBuilder stringBuilder3 = new StringBuilder().append("").append("username=");
        String string17 = this.doubleQuote(string2);
        String string18 = stringBuilder3.append(string17).append(", ").toString();
        StringBuilder stringBuilder4 = new StringBuilder().append(string18).append("realm=");
        String string19 = this.doubleQuote(string4);
        String string20 = stringBuilder4.append(string19).append(", ").toString();
        StringBuilder stringBuilder5 = new StringBuilder().append(string20).append("nonce=");
        String string21 = this.doubleQuote(string5);
        String string22 = stringBuilder5.append(string21).append(", ").toString();
        StringBuilder stringBuilder6 = new StringBuilder().append(string22).append("uri=");
        String string23 = this.mUrl;
        String string24 = this.doubleQuote(string23);
        String string25 = stringBuilder6.append(string24).append(", ").toString();
        StringBuilder stringBuilder7 = new StringBuilder().append(string25).append("response=");
        String string26 = this.doubleQuote(string16);
        String string27 = stringBuilder7.append(string26).toString();
        if (string8 != null) {
            StringBuilder stringBuilder8 = new StringBuilder().append(string27).append(", opaque=");
            RequestHandle requestHandle2 = this;
            String string28 = string8;
            String string29 = requestHandle2.doubleQuote(string28);
            string27 = stringBuilder8.append(string29).toString();
        }
        if (string7 != null) {
            StringBuilder stringBuilder9 = new StringBuilder().append(string27).append(", algorithm=");
            String string30 = string7;
            string27 = stringBuilder9.append(string30).toString();
        }
        if (string6 != null) {
            StringBuilder stringBuilder10 = new StringBuilder().append(string27).append(", qop=");
            String string31 = string6;
            StringBuilder stringBuilder11 = stringBuilder10.append(string31).append(", nc=").append("000001").append(", cnonce=");
            String string32 = this.doubleQuote(string13);
            string27 = stringBuilder11.append(string32).toString();
        }
        return string27;
    }

    private void createAndQueueNewRequest() {
        Request request;
        if (this.mConnection != null) {
            Connection connection;
            Request request2;
            RequestQueue requestQueue = this.mRequestQueue;
            String string2 = this.mUrl;
            WebAddress webAddress = this.mUri;
            String string3 = this.mMethod;
            Map<String, String> map = this.mHeaders;
            EventHandler eventHandler = this.mRequest.mEventHandler;
            InputStream inputStream = this.mBodyProvider;
            int n = this.mBodyLength;
            RequestHandle requestHandle = requestQueue.queueSynchronousRequest(string2, webAddress, string3, map, eventHandler, inputStream, n);
            this.mRequest = request2 = requestHandle.mRequest;
            this.mConnection = connection = requestHandle.mConnection;
            requestHandle.processRequest();
            return;
        }
        RequestQueue requestQueue = this.mRequestQueue;
        String string4 = this.mUrl;
        WebAddress webAddress = this.mUri;
        String string5 = this.mMethod;
        Map<String, String> map = this.mHeaders;
        EventHandler eventHandler = this.mRequest.mEventHandler;
        InputStream inputStream = this.mBodyProvider;
        int n = this.mBodyLength;
        this.mRequest = request = requestQueue.queueRequest((String)string4, (WebAddress)webAddress, (String)string5, map, (EventHandler)eventHandler, (InputStream)inputStream, (int)n).mRequest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String doubleQuote(String string2) {
        if (string2 == null) return null;
        return "\"" + string2 + "\"";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setupAuthResponse() {
        try {
            if (this.mBodyProvider != null) {
                this.mBodyProvider.reset();
            }
        }
        catch (IOException iOException) {}
        this.createAndQueueNewRequest();
    }

    public void cancel() {
        if (this.mRequest == null) {
            return;
        }
        this.mRequest.cancel();
    }

    public String getMethod() {
        return this.mMethod;
    }

    public int getRedirectCount() {
        return this.mRedirectCount;
    }

    public void handleSslErrorResponse(boolean bl) {
        if (this.mRequest == null) {
            return;
        }
        this.mRequest.handleSslErrorResponse(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRedirectMax() {
        if (this.mRedirectCount < 16) return false;
        return true;
    }

    public void pauseRequest(boolean bl) {
        if (this.mRequest == null) {
            return;
        }
        this.mRequest.setLoadingPaused(bl);
    }

    public void processRequest() {
        if (this.mConnection == null) {
            return;
        }
        Connection connection = this.mConnection;
        Request request = this.mRequest;
        connection.processRequests(request);
    }

    public void setRedirectCount(int n) {
        this.mRedirectCount = n;
    }

    public void setupBasicAuthResponse(boolean bl, String string2, String string3) {
        String string4 = RequestHandle.computeBasicAuthResponse(string2, string3);
        Map<String, String> map = this.mHeaders;
        String string5 = RequestHandle.authorizationHeader(bl);
        String string6 = "Basic " + string4;
        String string7 = map.put(string5, string6);
        this.setupAuthResponse();
    }

    public void setupDigestAuthResponse(boolean bl, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        RequestHandle requestHandle = this;
        String string9 = string2;
        String string10 = string3;
        String string11 = string4;
        String string12 = string5;
        String string13 = string6;
        String string14 = string7;
        String string15 = string8;
        String string16 = requestHandle.computeDigestAuthResponse(string9, string10, string11, string12, string13, string14, string15);
        Map<String, String> map = this.mHeaders;
        String string17 = RequestHandle.authorizationHeader(bl);
        String string18 = "Digest " + string16;
        String string19 = map.put(string17, string18);
        this.setupAuthResponse();
    }

    /*
     * Unable to fully structure code
     */
    public boolean setupRedirect(String var1_1, int var2_2, Map<String, String> var3_3) {
        block11: {
            var4_4 = this.mHeaders.remove("Authorization");
            var5_5 = this.mHeaders.remove("Proxy-Authorization");
            this.mRedirectCount = var6_6 = this.mRedirectCount + 1;
            if (var6_6 == 16) {
                this.mRequest.error(65527, 17039619);
                var7_7 = false;
lbl7:
                // 3 sources

                return var7_7;
            }
            if (this.mUrl.startsWith("https:") && var1_1.startsWith("http:")) {
                var8_8 = this.mHeaders.remove("Referer");
            }
            this.mUrl = var1_1;
            try {
                var9_9 = this.mUrl;
                this.mUri = var10_10 = new WebAddress(var9_9);
            }
            catch (ParseException v0) {
                v0.printStackTrace();
                ** continue;
            }
lbl15:
            // 2 sources

            while (true) {
                block12: {
                    var11_11 = this.mHeaders.remove("Cookie");
                    var12_12 = CookieManager.getInstance();
                    var14_14 = var12_12.getCookie(var13_13 = this.mUri);
                    if (var14_14 != null && var14_14.length() > 0) {
                        var15_15 = this.mHeaders.put("Cookie", var14_14);
                    }
                    if ((var2_2 == 302 || var2_2 == 303) && this.mMethod.equals("POST")) {
                        this.mMethod = "GET";
                    }
                    if (var2_2 != 307) break block11;
                    if (this.mBodyProvider == null) break block12;
                    this.mBodyProvider.reset();
                }
lbl28:
                // 2 sources

                while (true) {
                    this.mHeaders.putAll(var3_3);
                    this.createAndQueueNewRequest();
                    var7_7 = true;
                    ** GOTO lbl7
                    break;
                }
                break;
            }
            catch (IOException var16_16) {
                var7_7 = false;
                ** continue;
            }
        }
        var17_17 = this.mHeaders.remove("Content-Type");
        this.mBodyProvider = null;
        ** while (true)
    }

    public void waitUntilComplete() {
        this.mRequest.waitUntilComplete();
    }
}

