/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.net.WebAddress;
import android.net.http.Connection;
import android.net.http.ConnectionThread;
import android.net.http.EventHandler;
import android.net.http.HttpLog;
import android.net.http.IdleCache;
import android.net.http.LoggingEventHandler;
import android.net.http.Request;
import android.net.http.RequestFeeder;
import android.net.http.RequestHandle;
import android.util.Log;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.apache.http.HttpHost;

public class RequestQueue
implements RequestFeeder {
    private static final int CONNECTION_COUNT = 4;
    private final ActivePool mActivePool;
    private final ConnectivityManager mConnectivityManager;
    private final Context mContext;
    private final LinkedHashMap<HttpHost, LinkedList<Request>> mPending;
    private BroadcastReceiver mProxyChangeReceiver;
    private HttpHost mProxyHost = null;

    public RequestQueue(Context context) {
        this(context, 4);
    }

    public RequestQueue(Context context, int n) {
        ConnectivityManager connectivityManager;
        ActivePool activePool;
        this.mContext = context;
        LinkedHashMap linkedHashMap = new LinkedHashMap(32);
        this.mPending = linkedHashMap;
        this.mActivePool = activePool = new ActivePool(n);
        this.mActivePool.startup();
        this.mConnectivityManager = connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HttpHost determineHost(HttpHost httpHost) {
        if (this.mProxyHost == null) return httpHost;
        String string2 = httpHost.getSchemeName();
        if (!"https".equals(string2)) return this.mProxyHost;
        return httpHost;
    }

    private Request removeFirst(LinkedHashMap<HttpHost, LinkedList<Request>> linkedHashMap) {
        Request request = null;
        Iterator iterator = linkedHashMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            LinkedList linkedList = (LinkedList)entry.getValue();
            request = (Request)linkedList.removeFirst();
            if (linkedList.isEmpty()) {
                Object k = entry.getKey();
                Object v = linkedHashMap.remove(k);
            }
        }
        return request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setProxyConfig() {
        synchronized (this) {
            NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.getType() == 1) {
                this.mProxyHost = null;
            } else {
                String string2 = Proxy.getHost(this.mContext);
                if (string2 == null) {
                    this.mProxyHost = null;
                } else {
                    HttpHost httpHost;
                    this.mActivePool.disablePersistence();
                    int n = Proxy.getPort(this.mContext);
                    this.mProxyHost = httpHost = new HttpHost(string2, n, "http");
                }
            }
            return;
        }
    }

    public void disablePlatformNotifications() {
        synchronized (this) {
            if (this.mProxyChangeReceiver != null) {
                Context context = this.mContext;
                BroadcastReceiver broadcastReceiver = this.mProxyChangeReceiver;
                context.unregisterReceiver(broadcastReceiver);
                this.mProxyChangeReceiver = null;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dump() {
        synchronized (this) {
            HttpLog.v("dump()");
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            if (!this.mPending.isEmpty()) {
                Iterator iterator = this.mPending.entrySet().iterator();
                int n2 = n;
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string2 = ((HttpHost)entry.getKey()).getHostName();
                    StringBuilder stringBuilder2 = new StringBuilder().append("p");
                    n = n2 + 1;
                    String string3 = stringBuilder2.append(n2).append(" ").append(string2).append(" ").toString();
                    StringBuilder stringBuilder3 = new StringBuilder(string3);
                    ListIterator listIterator = ((LinkedList)entry.getValue()).listIterator(0);
                    while (iterator.hasNext()) {
                        Request request = (Request)((Object)iterator.next());
                        String string4 = request + " ";
                        StringBuilder stringBuilder4 = stringBuilder3.append(string4);
                    }
                    StringBuilder stringBuilder5 = stringBuilder.append(stringBuilder3);
                    StringBuilder stringBuilder6 = stringBuilder.append("\n");
                    n2 = n;
                }
                int n3 = n2;
            }
            HttpLog.v(stringBuilder.toString());
            return;
        }
    }

    public void enablePlatformNotifications() {
        synchronized (this) {
            if (this.mProxyChangeReceiver == null) {
                BroadcastReceiver broadcastReceiver;
                this.mProxyChangeReceiver = broadcastReceiver = new BroadcastReceiver(){

                    @Override
                    public void onReceive(Context context, Intent intent) {
                        RequestQueue.this.setProxyConfig();
                    }
                };
                Context context = this.mContext;
                BroadcastReceiver broadcastReceiver2 = this.mProxyChangeReceiver;
                IntentFilter intentFilter = new IntentFilter("android.intent.action.PROXY_CHANGE");
                Intent intent = context.registerReceiver(broadcastReceiver2, intentFilter);
            }
            this.setProxyConfig();
            return;
        }
    }

    public HttpHost getProxyHost() {
        return this.mProxyHost;
    }

    @Override
    public Request getRequest() {
        synchronized (this) {
            Request request;
            block3: {
                Request request2;
                request = null;
                if (this.mPending.isEmpty()) break block3;
                LinkedHashMap<HttpHost, LinkedList<Request>> linkedHashMap = this.mPending;
                request = request2 = this.removeFirst(linkedHashMap);
            }
            return request;
        }
    }

    @Override
    public Request getRequest(HttpHost httpHost) {
        synchronized (this) {
            Request request = null;
            if (this.mPending.containsKey(httpHost)) {
                LinkedList<Request> linkedList = this.mPending.get(httpHost);
                request = linkedList.removeFirst();
                if (linkedList.isEmpty()) {
                    Object v = this.mPending.remove(httpHost);
                }
            }
            return request;
        }
    }

    @Override
    public boolean haveRequest(HttpHost httpHost) {
        synchronized (this) {
            boolean bl;
            boolean bl2 = bl = this.mPending.containsKey(httpHost);
            return bl2;
        }
    }

    public RequestHandle queueRequest(String string2, WebAddress webAddress, String string3, Map<String, String> map, EventHandler eventHandler, InputStream inputStream, int n) {
        if (eventHandler == null) {
            eventHandler = new LoggingEventHandler();
        }
        String string4 = webAddress.mHost;
        int n2 = webAddress.mPort;
        String string5 = webAddress.mScheme;
        HttpHost httpHost = new HttpHost(string4, n2, string5);
        HttpHost httpHost2 = this.mProxyHost;
        String string6 = webAddress.mPath;
        String string7 = string3;
        InputStream inputStream2 = inputStream;
        int n3 = n;
        EventHandler eventHandler2 = eventHandler;
        Map<String, String> map2 = map;
        Request request = new Request(string7, httpHost, httpHost2, string6, inputStream2, n3, eventHandler2, map2);
        this.queueRequest(request, false);
        int n4 = ActivePool.access$408(this.mActivePool);
        this.mActivePool.startConnectionThread();
        RequestQueue requestQueue = this;
        String string8 = string2;
        WebAddress webAddress2 = webAddress;
        String string9 = string3;
        Map<String, String> map3 = map;
        InputStream inputStream3 = inputStream;
        int n5 = n;
        Request request2 = request;
        return new RequestHandle(requestQueue, string8, webAddress2, string9, map3, inputStream3, n5, request2);
    }

    public RequestHandle queueRequest(String string2, String string3, Map<String, String> map, EventHandler eventHandler, InputStream inputStream, int n) {
        WebAddress webAddress = new WebAddress(string2);
        RequestQueue requestQueue = this;
        String string4 = string2;
        String string5 = string3;
        Map<String, String> map2 = map;
        EventHandler eventHandler2 = eventHandler;
        InputStream inputStream2 = inputStream;
        int n2 = n;
        return requestQueue.queueRequest(string4, webAddress, string5, map2, eventHandler2, inputStream2, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void queueRequest(Request request, boolean bl) {
        synchronized (this) {
            LinkedList<Object> linkedList;
            HttpHost httpHost = request.mProxyHost == null ? request.mHost : request.mProxyHost;
            if (this.mPending.containsKey(httpHost)) {
                linkedList = this.mPending.get(httpHost);
            } else {
                linkedList = new LinkedList();
                LinkedList linkedList2 = this.mPending.put(httpHost, linkedList);
            }
            if (bl) {
                linkedList.addFirst(request);
            } else {
                boolean bl2 = linkedList.add(request);
            }
            return;
        }
    }

    public RequestHandle queueSynchronousRequest(String string2, WebAddress webAddress, String string3, Map<String, String> map, EventHandler eventHandler, InputStream inputStream, int n) {
        String string4 = webAddress.mHost;
        int n2 = webAddress.mPort;
        String string5 = webAddress.mScheme;
        HttpHost httpHost = new HttpHost(string4, n2, string5);
        HttpHost httpHost2 = this.mProxyHost;
        String string6 = webAddress.mPath;
        String string7 = string3;
        InputStream inputStream2 = inputStream;
        int n3 = n;
        EventHandler eventHandler2 = eventHandler;
        Map<String, String> map2 = map;
        Request request = new Request(string7, httpHost, httpHost2, string6, inputStream2, n3, eventHandler2, map2);
        HttpHost httpHost3 = this.determineHost(httpHost);
        Context context = this.mContext;
        HttpHost httpHost4 = this.mProxyHost;
        SyncFeeder syncFeeder = new SyncFeeder();
        Connection connection = Connection.getConnection(context, httpHost3, httpHost4, syncFeeder);
        RequestQueue requestQueue = this;
        String string8 = string2;
        WebAddress webAddress2 = webAddress;
        String string9 = string3;
        Map<String, String> map3 = map;
        InputStream inputStream3 = inputStream;
        int n4 = n;
        Request request2 = request;
        return new RequestHandle(requestQueue, string8, webAddress2, string9, map3, inputStream3, n4, request2, connection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean requestsPending() {
        synchronized (this) {
            boolean bl = this.mPending.isEmpty();
            if (bl) return false;
            return true;
        }
    }

    @Override
    public void requeueRequest(Request request) {
        this.queueRequest(request, true);
    }

    public void shutdown() {
        this.mActivePool.shutdown();
    }

    public void startTiming() {
        this.mActivePool.startTiming();
    }

    public void stopTiming() {
        this.mActivePool.stopTiming();
    }

    static interface ConnectionManager {
        public Connection getConnection(Context var1, HttpHost var2);

        public HttpHost getProxyHost();

        public boolean recycleConnection(Connection var1);
    }

    private static class SyncFeeder
    implements RequestFeeder {
        private Request mRequest;

        SyncFeeder() {
        }

        @Override
        public Request getRequest() {
            Request request = this.mRequest;
            this.mRequest = null;
            return request;
        }

        @Override
        public Request getRequest(HttpHost httpHost) {
            return this.getRequest();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean haveRequest(HttpHost httpHost) {
            if (this.mRequest == null) return false;
            return true;
        }

        @Override
        public void requeueRequest(Request request) {
            this.mRequest = request;
        }
    }

    class ActivePool
    implements ConnectionManager {
        private int mConnectionCount;
        IdleCache mIdleCache;
        ConnectionThread[] mThreads;
        private int mTotalConnection;
        private int mTotalRequest;

        ActivePool(int n) {
            IdleCache idleCache;
            this.mIdleCache = idleCache = new IdleCache();
            this.mConnectionCount = n;
            ConnectionThread[] connectionThreadArray = new ConnectionThread[this.mConnectionCount];
            this.mThreads = connectionThreadArray;
            int n2 = 0;
            int n3;
            while (n2 < (n3 = this.mConnectionCount)) {
                ConnectionThread connectionThread;
                ConnectionThread[] connectionThreadArray2 = this.mThreads;
                Context context = RequestQueue.this.mContext;
                connectionThreadArray2[n2] = connectionThread = new ConnectionThread(context, n2, this, RequestQueue.this);
                ++n2;
            }
            return;
        }

        static /* synthetic */ int access$408(ActivePool activePool) {
            int n;
            int n2 = activePool.mTotalRequest;
            activePool.mTotalRequest = n = n2 + 1;
            return n2;
        }

        void disablePersistence() {
            int n;
            for (int i = 0; i < (n = this.mConnectionCount); ++i) {
                Connection connection = this.mThreads[i].mConnection;
                if (connection == null) continue;
                connection.setCanPersist(false);
            }
            this.mIdleCache.clear();
        }

        @Override
        public Connection getConnection(Context context, HttpHost httpHost) {
            HttpHost httpHost2 = RequestQueue.this.determineHost(httpHost);
            Connection connection = this.mIdleCache.getConnection(httpHost2);
            if (connection == null) {
                int n;
                this.mTotalConnection = n = this.mTotalConnection + 1;
                Context context2 = RequestQueue.this.mContext;
                HttpHost httpHost3 = RequestQueue.this.mProxyHost;
                RequestQueue requestQueue = RequestQueue.this;
                connection = Connection.getConnection(context2, httpHost2, httpHost3, requestQueue);
            }
            return connection;
        }

        @Override
        public HttpHost getProxyHost() {
            return RequestQueue.this.mProxyHost;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        ConnectionThread getThread(HttpHost httpHost) {
            RequestQueue requestQueue = RequestQueue.this;
            synchronized (requestQueue) {
                int n;
                int n2 = 0;
                while (n2 < (n = this.mThreads.length)) {
                    ConnectionThread connectionThread = this.mThreads[n2];
                    Connection connection = connectionThread.mConnection;
                    if (connection != null && connection.mHost.equals(httpHost)) {
                        return connectionThread;
                    }
                    ++n2;
                }
                return null;
            }
        }

        void logState() {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < (n = this.mConnectionCount); ++i) {
                StringBuilder stringBuilder2 = new StringBuilder();
                ConnectionThread connectionThread = this.mThreads[i];
                String string2 = stringBuilder2.append(connectionThread).append("\n").toString();
                StringBuilder stringBuilder3 = stringBuilder.append(string2);
            }
            HttpLog.v(stringBuilder.toString());
        }

        @Override
        public boolean recycleConnection(Connection connection) {
            IdleCache idleCache = this.mIdleCache;
            HttpHost httpHost = connection.getHost();
            return idleCache.cacheConnection(httpHost, connection);
        }

        void shutdown() {
            int n = 0;
            int n2;
            while (n < (n2 = this.mConnectionCount)) {
                this.mThreads[n].requestStop();
                ++n;
            }
            return;
        }

        void startConnectionThread() {
            RequestQueue requestQueue = RequestQueue.this;
            synchronized (requestQueue) {
                RequestQueue.this.notify();
                return;
            }
        }

        public void startTiming() {
            int n;
            for (int i = 0; i < (n = this.mConnectionCount); ++i) {
                ConnectionThread connectionThread = this.mThreads[i];
                connectionThread.mCurrentThreadTime = 65535L;
                connectionThread.mTotalThreadTime = 0L;
            }
            this.mTotalRequest = 0;
            this.mTotalConnection = 0;
        }

        void startup() {
            int n = 0;
            int n2;
            while (n < (n2 = this.mConnectionCount)) {
                this.mThreads[n].start();
                ++n;
            }
            return;
        }

        public void stopTiming() {
            int n;
            int n2 = 0;
            for (int i = 0; i < (n = this.mConnectionCount); ++i) {
                ConnectionThread connectionThread = this.mThreads[i];
                if (connectionThread.mCurrentThreadTime != 65535L) {
                    long l = n2;
                    long l2 = connectionThread.mTotalThreadTime;
                    n2 = (int)(l + l2);
                }
                connectionThread.mCurrentThreadTime = 0L;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Http thread used ").append(n2).append(" ms ").append(" for ");
            int n3 = this.mTotalRequest;
            StringBuilder stringBuilder2 = stringBuilder.append(n3).append(" requests and ");
            int n4 = this.mTotalConnection;
            String string2 = stringBuilder2.append(n4).append(" new connections").toString();
            int n5 = Log.d("Http", string2);
        }
    }
}

