/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.os.Bundle;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;

public class SslCertificate {
    private static String ISO_8601_DATE_FORMAT = "yyyy-MM-dd HH:mm:ssZ";
    private static final String ISSUED_BY = "issued-by";
    private static final String ISSUED_TO = "issued-to";
    private static final String VALID_NOT_AFTER = "valid-not-after";
    private static final String VALID_NOT_BEFORE = "valid-not-before";
    private DName mIssuedBy;
    private DName mIssuedTo;
    private Date mValidNotAfter;
    private Date mValidNotBefore;

    @Deprecated
    public SslCertificate(String string2, String string3, String string4, String string5) {
        Date date = SslCertificate.parseDate(string4);
        Date date2 = SslCertificate.parseDate(string5);
        this(string2, string3, date, date2);
    }

    public SslCertificate(String string2, String string3, Date date, Date date2) {
        Date date3;
        Date date4;
        DName dName;
        DName dName2;
        this.mIssuedTo = dName2 = new DName(string2);
        this.mIssuedBy = dName = new DName(string3);
        this.mValidNotBefore = date4 = SslCertificate.cloneDate(date);
        this.mValidNotAfter = date3 = SslCertificate.cloneDate(date2);
    }

    public SslCertificate(X509Certificate x509Certificate) {
        String string2 = x509Certificate.getSubjectDN().getName();
        String string3 = x509Certificate.getIssuerDN().getName();
        Date date = x509Certificate.getNotBefore();
        Date date2 = x509Certificate.getNotAfter();
        this(string2, string3, date, date2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Date cloneDate(Date date) {
        if (date != null) return (Date)date.clone();
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        String string2 = ISO_8601_DATE_FORMAT;
        return new SimpleDateFormat(string2).format(date);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Date parseDate(String string2) {
        try {
            String string3 = ISO_8601_DATE_FORMAT;
            Date date = new SimpleDateFormat(string3).parse(string2);
            return date;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SslCertificate restoreState(Bundle bundle) {
        if (bundle == null) return null;
        String string2 = bundle.getString(ISSUED_TO);
        String string3 = bundle.getString(ISSUED_BY);
        String string4 = bundle.getString(VALID_NOT_BEFORE);
        String string5 = bundle.getString(VALID_NOT_AFTER);
        return new SslCertificate(string2, string3, string4, string5);
    }

    public static Bundle saveState(SslCertificate sslCertificate) {
        Bundle bundle = null;
        if (sslCertificate != null) {
            bundle = new Bundle();
            String string2 = sslCertificate.getIssuedTo().getDName();
            bundle.putString(ISSUED_TO, string2);
            String string3 = sslCertificate.getIssuedBy().getDName();
            bundle.putString(ISSUED_BY, string3);
            String string4 = sslCertificate.getValidNotBefore();
            bundle.putString(VALID_NOT_BEFORE, string4);
            String string5 = sslCertificate.getValidNotAfter();
            bundle.putString(VALID_NOT_AFTER, string5);
        }
        return bundle;
    }

    public DName getIssuedBy() {
        return this.mIssuedBy;
    }

    public DName getIssuedTo() {
        return this.mIssuedTo;
    }

    @Deprecated
    public String getValidNotAfter() {
        return SslCertificate.formatDate(this.mValidNotAfter);
    }

    public Date getValidNotAfterDate() {
        return SslCertificate.cloneDate(this.mValidNotAfter);
    }

    @Deprecated
    public String getValidNotBefore() {
        return SslCertificate.formatDate(this.mValidNotBefore);
    }

    public Date getValidNotBeforeDate() {
        return SslCertificate.cloneDate(this.mValidNotBefore);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Issued to: ");
        String string2 = this.mIssuedTo.getDName();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(";\n").append("Issued by: ");
        String string3 = this.mIssuedBy.getDName();
        return stringBuilder2.append(string3).append(";\n").toString();
    }

    public class DName {
        private String mCName;
        private String mDName;
        private String mOName;
        private String mUName;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public DName(String string2) {
            if (string2 == null) {
                return;
            }
            this.mDName = string2;
            try {
                X509Name x509Name = new X509Name(string2);
                Vector vector = x509Name.getValues();
                Vector vector2 = x509Name.getOIDs();
                int n = 0;
                while (true) {
                    DERObjectIdentifier dERObjectIdentifier;
                    int n2;
                    if (n >= (n2 = vector2.size())) {
                        return;
                    }
                    Object e = vector2.elementAt(n);
                    if (e.equals(dERObjectIdentifier = X509Name.CN)) {
                        String string3;
                        this.mCName = string3 = (String)vector.elementAt(n);
                    } else {
                        DERObjectIdentifier dERObjectIdentifier2;
                        Object e2 = vector2.elementAt(n);
                        if (e2.equals(dERObjectIdentifier2 = X509Name.O)) {
                            String string4;
                            this.mOName = string4 = (String)vector.elementAt(n);
                        } else {
                            DERObjectIdentifier dERObjectIdentifier3;
                            Object e3 = vector2.elementAt(n);
                            if (e3.equals(dERObjectIdentifier3 = X509Name.OU)) {
                                String string5;
                                this.mUName = string5 = (String)vector.elementAt(n);
                            }
                        }
                    }
                    ++n;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getCName() {
            if (this.mCName == null) return "";
            return this.mCName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getDName() {
            if (this.mDName == null) return "";
            return this.mDName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getOName() {
            if (this.mOName == null) return "";
            return this.mOName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getUName() {
            if (this.mUName == null) return "";
            return this.mUName;
        }
    }
}

