/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.SslCertificate;
import java.security.cert.X509Certificate;

public class SslError {
    public static final int SSL_EXPIRED = 1;
    public static final int SSL_IDMISMATCH = 2;
    public static final int SSL_MAX_ERROR = 4;
    public static final int SSL_NOTYETVALID = 0;
    public static final int SSL_UNTRUSTED = 3;
    SslCertificate mCertificate;
    int mErrors;

    public SslError(int n, SslCertificate sslCertificate) {
        boolean bl = this.addError(n);
        this.mCertificate = sslCertificate;
    }

    public SslError(int n, X509Certificate x509Certificate) {
        SslCertificate sslCertificate;
        boolean bl = this.addError(n);
        this.mCertificate = sslCertificate = new SslCertificate(x509Certificate);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addError(int n) {
        int n2;
        if (n < 0) return false;
        if (n >= 4) return false;
        boolean bl = true;
        if (!bl) return bl;
        int n3 = this.mErrors;
        int n4 = 1 << n;
        this.mErrors = n2 = n3 | n4;
        return bl;
    }

    public SslCertificate getCertificate() {
        return this.mCertificate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPrimaryError() {
        if (this.mErrors == 0) return 0;
        int n = 3;
        while (n >= 0) {
            int n2 = this.mErrors;
            int n3 = 1 << n;
            if ((n2 & n3) != 0) {
                return n;
            }
            n += -1;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasError(int n) {
        if (n < 0) return false;
        if (n >= 4) return false;
        boolean bl = true;
        if (!bl) return bl;
        int n2 = this.mErrors;
        int n3 = 1 << n;
        if ((n2 & n3) == 0) return false;
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("primary error: ");
        int n = this.getPrimaryError();
        StringBuilder stringBuilder2 = stringBuilder.append(n).append(" certificate: ");
        SslCertificate sslCertificate = this.getCertificate();
        return stringBuilder2.append(sslCertificate).toString();
    }
}

