/*
 * Decompiled with CFR 0.152.
 */
package android.net.rtp;

import android.net.rtp.AudioCodec;
import android.net.rtp.AudioGroup;
import android.net.rtp.RtpStream;
import java.net.InetAddress;
import java.net.SocketException;

public class AudioStream
extends RtpStream {
    private AudioCodec mCodec;
    private int mDtmfType = -1;
    private AudioGroup mGroup;

    public AudioStream(InetAddress inetAddress) throws SocketException {
        super(inetAddress);
    }

    public AudioCodec getCodec() {
        return this.mCodec;
    }

    public int getDtmfType() {
        return this.mDtmfType;
    }

    public AudioGroup getGroup() {
        return this.mGroup;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean isBusy() {
        if (this.mGroup == null) return false;
        return true;
    }

    public void join(AudioGroup audioGroup) {
        if (this.mGroup == audioGroup) {
            return;
        }
        if (this.mGroup != null) {
            this.mGroup.remove(this);
            this.mGroup = null;
        }
        if (audioGroup == null) {
            return;
        }
        AudioCodec audioCodec = this.mCodec;
        int n = this.mDtmfType;
        audioGroup.add(this, audioCodec, n);
        this.mGroup = audioGroup;
    }

    public void setCodec(AudioCodec audioCodec) {
        if (this.isBusy()) {
            throw new IllegalStateException("Busy");
        }
        int n = audioCodec.type;
        int n2 = this.mDtmfType;
        if (n != n2) {
            throw new IllegalArgumentException("The type is used by DTMF");
        }
        this.mCodec = audioCodec;
    }

    public void setDtmfType(int n) {
        if (this.isBusy()) {
            throw new IllegalStateException("Busy");
        }
        if (n != -1) {
            if (n < 96 || n > 127) {
                throw new IllegalArgumentException("Invalid type");
            }
            int n2 = this.mCodec.type;
            if (n != n2) {
                throw new IllegalArgumentException("The type is used by codec");
            }
        }
        this.mDtmfType = n;
    }
}

