/*
 * Decompiled with CFR 0.152.
 */
package android.net.rtp;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;

public class RtpStream {
    public static final int MODE_NORMAL = 0;
    public static final int MODE_RECEIVE_ONLY = 2;
    public static final int MODE_SEND_ONLY = 1;
    private final InetAddress mLocalAddress;
    private final int mLocalPort;
    private int mMode = 0;
    private int mNative;
    private InetAddress mRemoteAddress;
    private int mRemotePort = -1;

    static {
        System.loadLibrary("rtp_jni");
    }

    RtpStream(InetAddress inetAddress) throws SocketException {
        int n;
        String string2 = inetAddress.getHostAddress();
        this.mLocalPort = n = this.create(string2);
        this.mLocalAddress = inetAddress;
    }

    private synchronized native void close();

    private native int create(String var1) throws SocketException;

    public void associate(InetAddress inetAddress, int n) {
        if (this.isBusy()) {
            throw new IllegalStateException("Busy");
        }
        if (!(inetAddress instanceof Inet4Address && this.mLocalAddress instanceof Inet4Address || inetAddress instanceof Inet6Address && this.mLocalAddress instanceof Inet6Address)) {
            throw new IllegalArgumentException("Unsupported address");
        }
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Invalid port");
        }
        this.mRemoteAddress = inetAddress;
        this.mRemotePort = n;
    }

    synchronized native int dup();

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public InetAddress getLocalAddress() {
        return this.mLocalAddress;
    }

    public int getLocalPort() {
        return this.mLocalPort;
    }

    public int getMode() {
        return this.mMode;
    }

    public InetAddress getRemoteAddress() {
        return this.mRemoteAddress;
    }

    public int getRemotePort() {
        return this.mRemotePort;
    }

    public boolean isBusy() {
        return false;
    }

    public void release() {
        if (this.isBusy()) {
            throw new IllegalStateException("Busy");
        }
        this.close();
    }

    public void setMode(int n) {
        if (this.isBusy()) {
            throw new IllegalStateException("Busy");
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Invalid mode");
        }
        this.mMode = n;
    }
}

