/*
 * Decompiled with CFR 0.152.
 */
package android.net.sip;

import android.app.PendingIntent;
import android.net.sip.ISipSession;
import android.net.sip.ISipSessionListener;
import android.net.sip.SipProfile;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public interface ISipService
extends IInterface {
    public void close(String var1) throws RemoteException;

    public ISipSession createSession(SipProfile var1, ISipSessionListener var2) throws RemoteException;

    public SipProfile[] getListOfProfiles() throws RemoteException;

    public ISipSession getPendingSession(String var1) throws RemoteException;

    public boolean isOpened(String var1) throws RemoteException;

    public boolean isRegistered(String var1) throws RemoteException;

    public void open(SipProfile var1) throws RemoteException;

    public void open3(SipProfile var1, PendingIntent var2, ISipSessionListener var3) throws RemoteException;

    public void setRegistrationListener(String var1, ISipSessionListener var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISipService {
        private static final String DESCRIPTOR = "android.net.sip.ISipService";
        static final int TRANSACTION_close = 3;
        static final int TRANSACTION_createSession = 7;
        static final int TRANSACTION_getListOfProfiles = 9;
        static final int TRANSACTION_getPendingSession = 8;
        static final int TRANSACTION_isOpened = 4;
        static final int TRANSACTION_isRegistered = 5;
        static final int TRANSACTION_open = 1;
        static final int TRANSACTION_open3 = 2;
        static final int TRANSACTION_setRegistrationListener = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ISipService asInterface(IBinder iBinder) {
            void var1_2;
            if (iBinder == null) {
                return var1_2;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ISipService) {
                ISipService iSipService = (ISipService)iInterface;
                return var1_2;
            }
            Proxy proxy = new Proxy(iBinder);
            return var1_2;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    SipProfile sipProfile = parcel.readInt() != 0 ? SipProfile.CREATOR.createFromParcel(parcel) : null;
                    this.open(sipProfile);
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    SipProfile sipProfile = parcel.readInt() != 0 ? SipProfile.CREATOR.createFromParcel(parcel) : null;
                    PendingIntent pendingIntent = parcel.readInt() != 0 ? PendingIntent.CREATOR.createFromParcel(parcel) : null;
                    ISipSessionListener iSipSessionListener = ISipSessionListener.Stub.asInterface(parcel.readStrongBinder());
                    this.open3(sipProfile, pendingIntent, iSipSessionListener);
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    this.close(string2);
                    parcel2.writeNoException();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string3 = parcel.readString();
                    boolean bl = this.isOpened(string3);
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    parcel2.writeInt(n3);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string4 = parcel.readString();
                    boolean bl = this.isRegistered(string4);
                    parcel2.writeNoException();
                    int n4 = bl ? 1 : 0;
                    parcel2.writeInt(n4);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string5 = parcel.readString();
                    ISipSessionListener iSipSessionListener = ISipSessionListener.Stub.asInterface(parcel.readStrongBinder());
                    this.setRegistrationListener(string5, iSipSessionListener);
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    SipProfile sipProfile = parcel.readInt() != 0 ? SipProfile.CREATOR.createFromParcel(parcel) : null;
                    ISipSessionListener iSipSessionListener = ISipSessionListener.Stub.asInterface(parcel.readStrongBinder());
                    ISipSession iSipSession = this.createSession(sipProfile, iSipSessionListener);
                    parcel2.writeNoException();
                    IBinder iBinder = iSipSession != null ? iSipSession.asBinder() : null;
                    parcel2.writeStrongBinder(iBinder);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string6 = parcel.readString();
                    ISipSession iSipSession = this.getPendingSession(string6);
                    parcel2.writeNoException();
                    IBinder iBinder = iSipSession != null ? iSipSession.asBinder() : null;
                    parcel2.writeStrongBinder(iBinder);
                    return true;
                }
                case 9: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            Parcelable[] parcelableArray = this.getListOfProfiles();
            parcel2.writeNoException();
            parcel2.writeTypedArray(parcelableArray, 1);
            return true;
        }

        private static class Proxy
        implements ISipService {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void close(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ISipSession createSession(SipProfile sipProfile, ISipSessionListener iSipSessionListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    ISipSession iSipSession;
                    IBinder iBinder;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (sipProfile != null) {
                        parcel.writeInt(1);
                        sipProfile.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    iBinder = iSipSessionListener != null ? iSipSessionListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    ISipSession iSipSession2 = iSipSession = ISipSession.Stub.asInterface(parcel2.readStrongBinder());
                    parcel2.recycle();
                    parcel.recycle();
                    return iSipSession2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public SipProfile[] getListOfProfiles() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    Parcelable.Creator<SipProfile> creator = SipProfile.CREATOR;
                    SipProfile[] sipProfileArray = parcel2.createTypedArray(creator);
                    return sipProfileArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public ISipSession getPendingSession(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    ISipSession iSipSession;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    ISipSession iSipSession2 = iSipSession = ISipSession.Stub.asInterface(parcel2.readStrongBinder());
                    parcel2.recycle();
                    parcel.recycle();
                    return iSipSession2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isOpened(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isRegistered(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void open(SipProfile sipProfile) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (sipProfile != null) {
                        parcel.writeInt(1);
                        sipProfile.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void open3(SipProfile sipProfile, PendingIntent pendingIntent, ISipSessionListener iSipSessionListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    IBinder iBinder;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (sipProfile != null) {
                        parcel.writeInt(1);
                        sipProfile.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    if (pendingIntent != null) {
                        parcel.writeInt(1);
                        pendingIntent.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    iBinder = iSipSessionListener != null ? iSipSessionListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setRegistrationListener(String string2, ISipSessionListener iSipSessionListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iSipSessionListener != null ? iSipSessionListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }
        }
    }
}

