/*
 * Decompiled with CFR 0.152.
 */
package android.net.sip;

import android.content.Context;
import android.media.AudioManager;
import android.net.rtp.AudioCodec;
import android.net.rtp.AudioGroup;
import android.net.rtp.AudioStream;
import android.net.sip.SimpleSessionDescription;
import android.net.sip.SipErrorCode;
import android.net.sip.SipException;
import android.net.sip.SipManager;
import android.net.sip.SipProfile;
import android.net.sip.SipSession;
import android.net.wifi.WifiManager;
import android.os.Message;
import android.util.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SipAudioCall {
    private static final boolean DONT_RELEASE_SOCKET = false;
    private static final boolean RELEASE_SOCKET = true;
    private static final int SESSION_TIMEOUT = 5;
    private static final String TAG = SipAudioCall.class.getSimpleName();
    private AudioGroup mAudioGroup;
    private AudioStream mAudioStream;
    private Context mContext;
    private int mErrorCode;
    private String mErrorMessage;
    private boolean mHold;
    private boolean mInCall;
    private Listener mListener;
    private SipProfile mLocalProfile;
    private boolean mMuted;
    private String mPeerSd;
    private SipProfile mPendingCallRequest;
    private long mSessionId;
    private SipSession mSipSession;
    private WifiManager.WifiLock mWifiHighPerfLock;
    private WifiManager mWm;

    public SipAudioCall(Context context, SipProfile sipProfile) {
        WifiManager wifiManager;
        long l;
        this.mSessionId = l = System.currentTimeMillis();
        this.mInCall = false;
        this.mMuted = false;
        this.mHold = false;
        this.mErrorCode = 0;
        this.mContext = context;
        this.mLocalProfile = sipProfile;
        this.mWm = wifiManager = (WifiManager)context.getSystemService("wifi");
    }

    static /* synthetic */ String access$502(SipAudioCall sipAudioCall, String string2) {
        sipAudioCall.mPeerSd = string2;
        return string2;
    }

    static /* synthetic */ int access$802(SipAudioCall sipAudioCall, int n) {
        sipAudioCall.mErrorCode = n;
        return n;
    }

    static /* synthetic */ String access$902(SipAudioCall sipAudioCall, String string2) {
        sipAudioCall.mErrorMessage = string2;
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void close(boolean bl) {
        synchronized (this) {
            long l;
            if (bl) {
                boolean bl2 = true;
                this.stopCall(bl2);
            }
            this.mInCall = false;
            this.mHold = false;
            this.mSessionId = l = System.currentTimeMillis();
            this.mErrorCode = 0;
            this.mErrorMessage = null;
            if (this.mSipSession != null) {
                this.mSipSession.setListener(null);
                this.mSipSession = null;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private SimpleSessionDescription createAnswer(String string2) {
        SimpleSessionDescription simpleSessionDescription;
        SimpleSessionDescription simpleSessionDescription2;
        SimpleSessionDescription simpleSessionDescription3 = simpleSessionDescription2;
        String string3 = string2;
        simpleSessionDescription3(string3);
        long l = this.mSessionId;
        String string4 = this.getLocalIp();
        SimpleSessionDescription simpleSessionDescription4 = simpleSessionDescription;
        long l2 = l;
        String string5 = string4;
        simpleSessionDescription4(l2, string5);
        AudioCodec audioCodec = null;
        SimpleSessionDescription.Media[] mediaArray = simpleSessionDescription2.getMedia();
        int n = mediaArray.length;
        int n2 = 0;
        while (true) {
            block10: {
                SimpleSessionDescription.Media media;
                SimpleSessionDescription.Media media2;
                block6: {
                    block12: {
                        block11: {
                            block9: {
                                block8: {
                                    block7: {
                                        String string6;
                                        String string7;
                                        if (n2 >= n) break block7;
                                        media2 = mediaArray[n2];
                                        if (audioCodec != null || media2.getPort() <= 0 || !"audio".equals(string7 = media2.getType()) || !"RTP/AVP".equals(string6 = media2.getProtocol())) break block6;
                                        break block8;
                                    }
                                    if (audioCodec == null) {
                                        throw new IllegalStateException("Reject SDP: no suitable codecs");
                                    }
                                    return simpleSessionDescription;
                                }
                                int[] nArray = media2.getRtpPayloadTypes();
                                int n3 = nArray.length;
                                int n4 = 0;
                                while (true) {
                                    int n5;
                                    SimpleSessionDescription.Media media3;
                                    String string8;
                                    int n6;
                                    SimpleSessionDescription.Media media4;
                                    String string9;
                                    int n7;
                                    if (n4 >= n3 || (audioCodec = AudioCodec.getCodec(n7 = nArray[n4], string9 = (media4 = media2).getRtpmap(n6 = n7), string8 = (media3 = media2).getFmtp(n5 = n7))) != null) {
                                        if (audioCodec == null) break block6;
                                        int n8 = this.mAudioStream.getLocalPort();
                                        SimpleSessionDescription simpleSessionDescription5 = simpleSessionDescription;
                                        String string10 = "audio";
                                        int n9 = n8;
                                        int n10 = 1;
                                        String string11 = "RTP/AVP";
                                        media = simpleSessionDescription5.newMedia(string10, n9, n10, string11);
                                        int n11 = audioCodec.type;
                                        String string12 = audioCodec.rtpmap;
                                        String string13 = audioCodec.fmtp;
                                        SimpleSessionDescription.Media media5 = media;
                                        int n12 = n11;
                                        String string14 = string12;
                                        String string15 = string13;
                                        media5.setRtpPayload(n12, string14, string15);
                                        for (int n13 : media2.getRtpPayloadTypes()) {
                                            String string16;
                                            String string17;
                                            SimpleSessionDescription.Media media6 = media2;
                                            int n14 = n13;
                                            String string18 = media6.getRtpmap(n14);
                                            int n15 = n13;
                                            int n16 = audioCodec.type;
                                            int n17 = n16;
                                            if (n15 == n17 || string18 == null || !(string17 = string18).startsWith(string16 = "telephone-event")) continue;
                                            SimpleSessionDescription.Media media7 = media2;
                                            int n18 = n13;
                                            String string19 = media7.getFmtp(n18);
                                            SimpleSessionDescription.Media media8 = media;
                                            int n19 = n13;
                                            String string20 = string18;
                                            String string21 = string19;
                                            media8.setRtpPayload(n19, string20, string21);
                                        }
                                        break;
                                    }
                                    ++n4;
                                }
                                SimpleSessionDescription.Media media9 = media2;
                                String string22 = "recvonly";
                                if (media9.getAttribute(string22) == null) break block9;
                                SimpleSessionDescription simpleSessionDescription6 = simpleSessionDescription;
                                String string23 = "sendonly";
                                String string24 = "";
                                simpleSessionDescription6.setAttribute(string23, string24);
                                break block10;
                            }
                            SimpleSessionDescription.Media media10 = media2;
                            String string25 = "sendonly";
                            if (media10.getAttribute(string25) == null) break block11;
                            SimpleSessionDescription simpleSessionDescription7 = simpleSessionDescription;
                            String string26 = "recvonly";
                            String string27 = "";
                            simpleSessionDescription7.setAttribute(string26, string27);
                            break block10;
                        }
                        SimpleSessionDescription simpleSessionDescription8 = simpleSessionDescription2;
                        String string28 = "recvonly";
                        if (simpleSessionDescription8.getAttribute(string28) == null) break block12;
                        SimpleSessionDescription simpleSessionDescription9 = simpleSessionDescription;
                        String string29 = "sendonly";
                        String string30 = "";
                        simpleSessionDescription9.setAttribute(string29, string30);
                        break block10;
                    }
                    SimpleSessionDescription simpleSessionDescription10 = simpleSessionDescription2;
                    String string31 = "sendonly";
                    if (simpleSessionDescription10.getAttribute(string31) == null) break block10;
                    SimpleSessionDescription simpleSessionDescription11 = simpleSessionDescription;
                    String string32 = "recvonly";
                    String string33 = "";
                    simpleSessionDescription11.setAttribute(string32, string33);
                    break block10;
                }
                String string34 = media2.getType();
                String string35 = media2.getProtocol();
                SimpleSessionDescription simpleSessionDescription12 = simpleSessionDescription;
                String string36 = string34;
                int n20 = 0;
                int n21 = 1;
                String string37 = string35;
                media = simpleSessionDescription12.newMedia(string36, n20, n21, string37);
                for (String string38 : media2.getFormats()) {
                    SimpleSessionDescription.Media media11 = media;
                    String string39 = string38;
                    String string40 = null;
                    media11.setFormat(string39, string40);
                }
            }
            ++n2;
        }
    }

    private SimpleSessionDescription createContinueOffer() {
        long l = this.mSessionId;
        String string2 = this.getLocalIp();
        SimpleSessionDescription simpleSessionDescription = new SimpleSessionDescription(l, string2);
        int n = this.mAudioStream.getLocalPort();
        SimpleSessionDescription.Media media = simpleSessionDescription.newMedia("audio", n, 1, "RTP/AVP");
        AudioCodec audioCodec = this.mAudioStream.getCodec();
        int n2 = audioCodec.type;
        String string3 = audioCodec.rtpmap;
        String string4 = audioCodec.fmtp;
        media.setRtpPayload(n2, string3, string4);
        int n3 = this.mAudioStream.getDtmfType();
        if (n3 != -1) {
            media.setRtpPayload(n3, "telephone-event/8000", "0-15");
        }
        return simpleSessionDescription;
    }

    private SimpleSessionDescription createHoldOffer() {
        SimpleSessionDescription simpleSessionDescription = this.createContinueOffer();
        simpleSessionDescription.setAttribute("sendonly", "");
        return simpleSessionDescription;
    }

    private SipSession.Listener createListener() {
        return new SipSession.Listener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onCallBusy(SipSession sipSession) {
                String string2 = TAG;
                String string3 = "sip call busy: " + sipSession;
                int n = Log.d(string2, string3);
                Listener listener = SipAudioCall.this.mListener;
                if (listener != null) {
                    try {
                        SipAudioCall sipAudioCall = SipAudioCall.this;
                        listener.onCallBusy(sipAudioCall);
                    }
                    catch (Throwable throwable) {
                        String string4 = TAG;
                        String string5 = "onCallBusy(): " + throwable;
                        int n2 = Log.i(string4, string5);
                    }
                }
                SipAudioCall.this.close(false);
            }

            @Override
            public void onCallChangeFailed(SipSession sipSession, int n, String string2) {
                String string3 = TAG;
                String string4 = "sip call change failed: " + string2;
                int n2 = Log.d(string3, string4);
                int n3 = SipAudioCall.access$802(SipAudioCall.this, n);
                String string5 = SipAudioCall.access$902(SipAudioCall.this, string2);
                Listener listener = SipAudioCall.this.mListener;
                if (listener == null) {
                    return;
                }
                try {
                    SipAudioCall sipAudioCall = SipAudioCall.this;
                    int n4 = SipAudioCall.this.mErrorCode;
                    listener.onError(sipAudioCall, n4, string2);
                    return;
                }
                catch (Throwable throwable) {
                    String string6 = TAG;
                    String string7 = "onCallBusy(): " + throwable;
                    int n5 = Log.i(string6, string7);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onCallEnded(SipSession sipSession) {
                String string2 = TAG;
                String string3 = "sip call ended: " + sipSession;
                int n = Log.d(string2, string3);
                Listener listener = SipAudioCall.this.mListener;
                if (listener != null) {
                    try {
                        SipAudioCall sipAudioCall = SipAudioCall.this;
                        listener.onCallEnded(sipAudioCall);
                    }
                    catch (Throwable throwable) {
                        String string4 = TAG;
                        String string5 = "onCallEnded(): " + throwable;
                        int n2 = Log.i(string4, string5);
                    }
                }
                SipAudioCall.this.close();
            }

            @Override
            public void onCallEstablished(SipSession sipSession, String string2) {
                String string3 = SipAudioCall.access$502(SipAudioCall.this, string2);
                String string4 = TAG;
                StringBuilder stringBuilder = new StringBuilder().append("onCallEstablished()");
                String string5 = SipAudioCall.this.mPeerSd;
                String string6 = stringBuilder.append(string5).toString();
                int n = Log.v(string4, string6);
                Listener listener = SipAudioCall.this.mListener;
                if (listener == null) {
                    return;
                }
                try {
                    if (SipAudioCall.this.mHold) {
                        SipAudioCall sipAudioCall = SipAudioCall.this;
                        listener.onCallHeld(sipAudioCall);
                        return;
                    }
                    SipAudioCall sipAudioCall = SipAudioCall.this;
                    listener.onCallEstablished(sipAudioCall);
                    return;
                }
                catch (Throwable throwable) {
                    String string7 = TAG;
                    String string8 = "onCallEstablished(): " + throwable;
                    int n2 = Log.i(string7, string8);
                    return;
                }
            }

            @Override
            public void onCalling(SipSession sipSession) {
                String string2 = TAG;
                String string3 = "calling... " + sipSession;
                int n = Log.d(string2, string3);
                Listener listener = SipAudioCall.this.mListener;
                if (listener == null) {
                    return;
                }
                try {
                    SipAudioCall sipAudioCall = SipAudioCall.this;
                    listener.onCalling(sipAudioCall);
                    return;
                }
                catch (Throwable throwable) {
                    String string4 = TAG;
                    String string5 = "onCalling(): " + throwable;
                    int n2 = Log.i(string4, string5);
                    return;
                }
            }

            @Override
            public void onError(SipSession sipSession, int n, String string2) {
                SipAudioCall.this.onError(n, string2);
            }

            @Override
            public void onRegistering(SipSession sipSession) {
            }

            @Override
            public void onRegistrationDone(SipSession sipSession, int n) {
            }

            @Override
            public void onRegistrationFailed(SipSession sipSession, int n, String string2) {
            }

            @Override
            public void onRegistrationTimeout(SipSession sipSession) {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onRinging(SipSession sipSession, SipProfile sipProfile, String string2) {
                SipAudioCall sipAudioCall = SipAudioCall.this;
                synchronized (sipAudioCall) {
                    String string3;
                    String string4;
                    if (SipAudioCall.this.mSipSession == null || !SipAudioCall.this.mInCall || !(string4 = sipSession.getCallId()).equals(string3 = SipAudioCall.this.mSipSession.getCallId())) {
                        sipSession.endCall();
                        return;
                    }
                    try {
                        String string5 = SipAudioCall.this.createAnswer(string2).encode();
                        SipAudioCall.this.mSipSession.answerCall(string5, 5);
                    }
                    catch (Throwable throwable) {
                        int n = Log.e(TAG, "onRinging()", throwable);
                        sipSession.endCall();
                    }
                    return;
                }
            }

            @Override
            public void onRingingBack(SipSession sipSession) {
                String string2 = TAG;
                String string3 = "sip call ringing back: " + sipSession;
                int n = Log.d(string2, string3);
                Listener listener = SipAudioCall.this.mListener;
                if (listener == null) {
                    return;
                }
                try {
                    SipAudioCall sipAudioCall = SipAudioCall.this;
                    listener.onRingingBack(sipAudioCall);
                    return;
                }
                catch (Throwable throwable) {
                    String string4 = TAG;
                    String string5 = "onRingingBack(): " + throwable;
                    int n2 = Log.i(string4, string5);
                    return;
                }
            }
        };
    }

    private SimpleSessionDescription createOffer() {
        long l = this.mSessionId;
        String string2 = this.getLocalIp();
        SimpleSessionDescription simpleSessionDescription = new SimpleSessionDescription(l, string2);
        AudioCodec[] audioCodecArray = AudioCodec.getCodecs();
        int n = this.mAudioStream.getLocalPort();
        SimpleSessionDescription.Media media = simpleSessionDescription.newMedia("audio", n, 1, "RTP/AVP");
        for (AudioCodec audioCodec : AudioCodec.getCodecs()) {
            int n2 = audioCodec.type;
            String string3 = audioCodec.rtpmap;
            String string4 = audioCodec.fmtp;
            media.setRtpPayload(n2, string3, string4);
        }
        media.setRtpPayload(127, "telephone-event/8000", "0-15");
        return simpleSessionDescription;
    }

    private String getLocalIp() {
        return this.mSipSession.getLocalIp();
    }

    private SipProfile getPeerProfile(SipSession sipSession) {
        return sipSession.getPeerProfile();
    }

    private void grabWifiHighPerfLock() {
        WifiManager.WifiLock wifiLock;
        if (this.mWifiHighPerfLock != null) {
            return;
        }
        int n = Log.v(TAG, "acquire wifi high perf lock");
        WifiManager wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        String string2 = TAG;
        this.mWifiHighPerfLock = wifiLock = wifiManager.createWifiLock(3, string2);
        this.mWifiHighPerfLock.acquire();
    }

    private boolean isSpeakerOn() {
        return ((AudioManager)this.mContext.getSystemService("audio")).isSpeakerphoneOn();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isWifiOn() {
        if (this.mWm.getConnectionInfo().getBSSID() != null) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onError(int n, String string2) {
        String string3 = TAG;
        StringBuilder stringBuilder = new StringBuilder().append("sip session error: ");
        String string4 = SipErrorCode.toString(n);
        String string5 = stringBuilder.append(string4).append(": ").append(string2).toString();
        int n2 = Log.d(string3, string5);
        this.mErrorCode = n;
        this.mErrorMessage = string2;
        Listener listener = this.mListener;
        if (listener != null) {
            try {
                listener.onError(this, n, string2);
            }
            catch (Throwable throwable) {
                String string6 = TAG;
                String string7 = "onError(): " + throwable;
                int n3 = Log.i(string6, string7);
            }
        }
        synchronized (this) {
            if (n == 65526 || !this.isInCall()) {
                this.close(true);
            }
            return;
        }
    }

    private void releaseWifiHighPerfLock() {
        if (this.mWifiHighPerfLock == null) {
            return;
        }
        int n = Log.v(TAG, "release wifi high perf lock");
        this.mWifiHighPerfLock.release();
        this.mWifiHighPerfLock = null;
    }

    private void setAudioGroupMode() {
        AudioGroup audioGroup = this.getAudioGroup();
        if (audioGroup == null) {
            return;
        }
        if (this.mHold) {
            audioGroup.setMode(0);
            return;
        }
        if (this.mMuted) {
            audioGroup.setMode(1);
            return;
        }
        if (this.isSpeakerOn()) {
            audioGroup.setMode(3);
            return;
        }
        audioGroup.setMode(2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startAudioInternal() throws UnknownHostException {
        synchronized (this) {
            SimpleSessionDescription simpleSessionDescription;
            boolean bl;
            if (this.mPeerSd == null) {
                int n = Log.v(TAG, "startAudioInternal() mPeerSd = null");
                throw new IllegalStateException("mPeerSd = null");
            }
            boolean bl2 = false;
            SipAudioCall sipAudioCall = this;
            boolean bl3 = bl2;
            sipAudioCall.stopCall(bl3);
            this.mInCall = bl = true;
            String string2 = this.mPeerSd;
            SimpleSessionDescription simpleSessionDescription2 = simpleSessionDescription;
            String string3 = string2;
            simpleSessionDescription2(string3);
            AudioStream audioStream = this.mAudioStream;
            AudioCodec audioCodec = null;
            Object[] objectArray = simpleSessionDescription.getMedia();
            int n = objectArray.length;
            block3: for (int i = 0; i < n; ++i) {
                String string4;
                String string5;
                SimpleSessionDescription.Media media = objectArray[i];
                if (audioCodec != null || media.getPort() <= 0 || !"audio".equals(string5 = media.getType()) || !"RTP/AVP".equals(string4 = media.getProtocol())) continue;
                int[] nArray = media.getRtpPayloadTypes();
                int n2 = nArray.length;
                int n3 = 0;
                while (true) {
                    int n4;
                    SimpleSessionDescription.Media media2;
                    String string6;
                    int n5;
                    SimpleSessionDescription.Media media3;
                    String string7;
                    int n6;
                    if (n3 >= n2 || (audioCodec = AudioCodec.getCodec(n6 = nArray[n3], string7 = (media3 = media).getRtpmap(n5 = n6), string6 = (media2 = media).getFmtp(n4 = n6))) != null) {
                        if (audioCodec == null) continue block3;
                        String string8 = media.getAddress();
                        if (string8 == null) {
                            string8 = simpleSessionDescription.getAddress();
                        }
                        InetAddress inetAddress = InetAddress.getByName(string8);
                        int n7 = media.getPort();
                        AudioStream audioStream2 = audioStream;
                        InetAddress inetAddress2 = inetAddress;
                        int n8 = n7;
                        audioStream2.associate(inetAddress2, n8);
                        AudioStream audioStream3 = audioStream;
                        int n9 = 65535;
                        audioStream3.setDtmfType(n9);
                        audioStream.setCodec(audioCodec);
                        for (SimpleSessionDescription.Media media4 : (Object[])media.getRtpPayloadTypes()) {
                            String string9;
                            String string10;
                            SimpleSessionDescription.Media media5 = media;
                            SimpleSessionDescription.Media media6 = media4;
                            String string11 = media5.getRtpmap((int)media6);
                            SimpleSessionDescription.Media media7 = media4;
                            int n10 = audioCodec.type;
                            int n11 = n10;
                            if (media7 == n11 || string11 == null || !(string10 = string11).startsWith(string9 = "telephone-event")) continue;
                            audioStream.setDtmfType((int)media4);
                        }
                        break;
                    }
                    ++n3;
                }
                if (this.mHold) {
                    AudioStream audioStream4 = audioStream;
                    int n12 = 0;
                    audioStream4.setMode(n12);
                    break;
                }
                SimpleSessionDescription.Media media8 = media;
                String string12 = "recvonly";
                if (media8.getAttribute(string12) != null) {
                    AudioStream audioStream5 = audioStream;
                    int n13 = 1;
                    audioStream5.setMode(n13);
                    break;
                }
                SimpleSessionDescription.Media media9 = media;
                String string13 = "sendonly";
                if (media9.getAttribute(string13) != null) {
                    AudioStream audioStream6 = audioStream;
                    int n14 = 2;
                    audioStream6.setMode(n14);
                    break;
                }
                SimpleSessionDescription simpleSessionDescription3 = simpleSessionDescription;
                String string14 = "recvonly";
                if (simpleSessionDescription3.getAttribute(string14) != null) {
                    AudioStream audioStream7 = audioStream;
                    int n15 = 1;
                    audioStream7.setMode(n15);
                    break;
                }
                SimpleSessionDescription simpleSessionDescription4 = simpleSessionDescription;
                String string15 = "sendonly";
                if (simpleSessionDescription4.getAttribute(string15) != null) {
                    AudioStream audioStream8 = audioStream;
                    int n16 = 2;
                    audioStream8.setMode(n16);
                    break;
                }
                AudioStream audioStream9 = audioStream;
                int n17 = 0;
                audioStream9.setMode(n17);
                break;
            }
            if (audioCodec == null) {
                throw new IllegalStateException("Reject SDP: no suitable codecs");
            }
            if (this.isWifiOn()) {
                this.grabWifiHighPerfLock();
            }
            if (!this.mHold) {
                AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
                int n18 = 0;
                audioManager.setMode(n18);
            }
            AudioGroup audioGroup = this.getAudioGroup();
            if (!this.mHold) {
                if (audioGroup == null) {
                    audioGroup = new AudioGroup();
                }
                audioStream.join(audioGroup);
            }
            this.setAudioGroupMode();
            return;
        }
    }

    private void stopCall(boolean bl) {
        int n = Log.d(TAG, "stop audiocall");
        this.releaseWifiHighPerfLock();
        if (this.mAudioStream == null) {
            return;
        }
        this.mAudioStream.join(null);
        if (!bl) {
            return;
        }
        this.mAudioStream.release();
        this.mAudioStream = null;
    }

    private void throwSipException(Throwable throwable) throws SipException {
        if (throwable instanceof SipException) {
            throw (SipException)throwable;
        }
        throw new SipException("", throwable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void answerCall(int n) throws SipException {
        synchronized (this) {
            if (this.mSipSession == null) {
                throw new SipException("No call to answer");
            }
            try {
                AudioStream audioStream;
                InetAddress inetAddress = InetAddress.getByName(this.getLocalIp());
                this.mAudioStream = audioStream = new AudioStream(inetAddress);
                SipSession sipSession = this.mSipSession;
                String string2 = this.mPeerSd;
                String string3 = this.createAnswer(string2).encode();
                sipSession.answerCall(string3, n);
                return;
            }
            catch (IOException iOException) {
                throw new SipException("answerCall()", iOException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void attachCall(SipSession sipSession, String string2) throws SipException {
        if (!SipManager.isVoipSupported(this.mContext)) {
            throw new SipException("VOIP API is not supported");
        }
        synchronized (this) {
            this.mSipSession = sipSession;
            this.mPeerSd = string2;
            String string3 = TAG;
            StringBuilder stringBuilder = new StringBuilder().append("attachCall()");
            String string4 = this.mPeerSd;
            String string5 = stringBuilder.append(string4).toString();
            int n = Log.v(string3, string5);
            try {
                SipSession.Listener listener = this.createListener();
                sipSession.setListener(listener);
            }
            catch (Throwable throwable) {
                int n2 = Log.e(TAG, "attachCall()", throwable);
                this.throwSipException(throwable);
            }
            return;
        }
    }

    public void close() {
        this.close(true);
    }

    public void continueCall(int n) throws SipException {
        synchronized (this) {
            if (!this.mHold) {
                return;
            }
            SipSession sipSession = this.mSipSession;
            String string2 = this.createContinueOffer().encode();
            sipSession.changeCall(string2, n);
            this.mHold = false;
            this.setAudioGroupMode();
            return;
        }
    }

    public void endCall() throws SipException {
        synchronized (this) {
            this.stopCall(true);
            this.mInCall = false;
            if (this.mSipSession != null) {
                this.mSipSession.endCall();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AudioGroup getAudioGroup() {
        synchronized (this) {
            if (this.mAudioGroup != null) {
                return this.mAudioGroup;
            }
            AudioGroup audioGroup = this.mAudioStream.getGroup();
            if (this.mAudioStream != null) return audioGroup;
            return null;
        }
    }

    public AudioStream getAudioStream() {
        synchronized (this) {
            AudioStream audioStream = this.mAudioStream;
            return audioStream;
        }
    }

    public SipProfile getLocalProfile() {
        synchronized (this) {
            SipProfile sipProfile = this.mLocalProfile;
            return sipProfile;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SipProfile getPeerProfile() {
        synchronized (this) {
            if (this.mSipSession != null) return this.mSipSession.getPeerProfile();
            return null;
        }
    }

    public SipSession getSipSession() {
        synchronized (this) {
            SipSession sipSession = this.mSipSession;
            return sipSession;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getState() {
        synchronized (this) {
            if (this.mSipSession != null) return this.mSipSession.getState();
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void holdCall(int n) throws SipException {
        synchronized (this) {
            if (this.mHold) {
                return;
            }
            if (this.mSipSession == null) {
                throw new SipException("Not in a call to hold call");
            }
            SipSession sipSession = this.mSipSession;
            String string2 = this.createHoldOffer().encode();
            sipSession.changeCall(string2, n);
            this.mHold = true;
            this.setAudioGroupMode();
            return;
        }
    }

    public boolean isInCall() {
        synchronized (this) {
            boolean bl = this.mInCall;
            return bl;
        }
    }

    public boolean isMuted() {
        synchronized (this) {
            boolean bl = this.mMuted;
            return bl;
        }
    }

    public boolean isOnHold() {
        synchronized (this) {
            boolean bl = this.mHold;
            return bl;
        }
    }

    public void makeCall(SipProfile sipProfile, SipSession sipSession, int n) throws SipException {
        if (!SipManager.isVoipSupported(this.mContext)) {
            throw new SipException("VOIP API is not supported");
        }
        synchronized (this) {
            this.mSipSession = sipSession;
            try {
                AudioStream audioStream;
                InetAddress inetAddress = InetAddress.getByName(this.getLocalIp());
                this.mAudioStream = audioStream = new AudioStream(inetAddress);
                SipSession.Listener listener = this.createListener();
                sipSession.setListener(listener);
                String string2 = this.createOffer().encode();
                sipSession.makeCall(sipProfile, string2, n);
                return;
            }
            catch (IOException iOException) {
                throw new SipException("makeCall()", iOException);
            }
        }
    }

    public void sendDtmf(int n) {
        this.sendDtmf(n, null);
    }

    public void sendDtmf(int n, Message message) {
        synchronized (this) {
            int n2;
            AudioGroup audioGroup = this.getAudioGroup();
            if (audioGroup != null && this.mSipSession != null && 8 != (n2 = this.getState())) {
                String string2 = TAG;
                String string3 = "send DTMF: " + n;
                int n3 = Log.v(string2, string3);
                audioGroup.sendDtmf(n);
            }
            if (message != null) {
                message.sendToTarget();
            }
            return;
        }
    }

    public void setAudioGroup(AudioGroup audioGroup) {
        synchronized (this) {
            if (this.mAudioStream != null && this.mAudioStream.getGroup() != null) {
                this.mAudioStream.join(audioGroup);
            }
            this.mAudioGroup = audioGroup;
            return;
        }
    }

    public void setListener(Listener listener) {
        this.setListener(listener, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setListener(Listener listener, boolean bl) {
        this.mListener = listener;
        if (listener == null) {
            return;
        }
        if (!bl) {
            return;
        }
        try {
            if (this.mErrorCode != 0) {
                int n = this.mErrorCode;
                String string2 = this.mErrorMessage;
                listener.onError(this, n, string2);
                return;
            }
        }
        catch (Throwable throwable) {
            int n = Log.e(TAG, "setListener()", throwable);
            return;
        }
        {
            if (this.mInCall) {
                if (this.mHold) {
                    listener.onCallHeld(this);
                    return;
                }
                listener.onCallEstablished(this);
                return;
            }
            switch (this.getState()) {
                default: {
                    return;
                }
                case 0: {
                    listener.onReadyToCall(this);
                    return;
                }
                case 3: {
                    SipProfile sipProfile = this.getPeerProfile();
                    listener.onRinging(this, sipProfile);
                    return;
                }
                case 5: {
                    listener.onCalling(this);
                    return;
                }
                case 6: 
            }
            listener.onRingingBack(this);
            return;
        }
    }

    public void setSpeakerMode(boolean bl) {
        synchronized (this) {
            ((AudioManager)this.mContext.getSystemService("audio")).setSpeakerphoneOn(bl);
            this.setAudioGroupMode();
            return;
        }
    }

    public void startAudio() {
        try {
            this.startAudioInternal();
            return;
        }
        catch (UnknownHostException unknownHostException) {
            String string2 = unknownHostException.getMessage();
            this.onError(-1, string2);
            return;
        }
        catch (Throwable throwable) {
            String string3 = throwable.getMessage();
            this.onError(-1, string3);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void toggleMute() {
        synchronized (this) {
            boolean bl = !this.mMuted;
            this.mMuted = bl;
            this.setAudioGroupMode();
            return;
        }
    }

    public static class Listener {
        public void onCallBusy(SipAudioCall sipAudioCall) {
            this.onChanged(sipAudioCall);
        }

        public void onCallEnded(SipAudioCall sipAudioCall) {
            this.onChanged(sipAudioCall);
        }

        public void onCallEstablished(SipAudioCall sipAudioCall) {
            this.onChanged(sipAudioCall);
        }

        public void onCallHeld(SipAudioCall sipAudioCall) {
            this.onChanged(sipAudioCall);
        }

        public void onCalling(SipAudioCall sipAudioCall) {
            this.onChanged(sipAudioCall);
        }

        public void onChanged(SipAudioCall sipAudioCall) {
        }

        public void onError(SipAudioCall sipAudioCall, int n, String string2) {
        }

        public void onReadyToCall(SipAudioCall sipAudioCall) {
            this.onChanged(sipAudioCall);
        }

        public void onRinging(SipAudioCall sipAudioCall, SipProfile sipProfile) {
            this.onChanged(sipAudioCall);
        }

        public void onRingingBack(SipAudioCall sipAudioCall) {
            this.onChanged(sipAudioCall);
        }
    }
}

