/*
 * Decompiled with CFR 0.152.
 */
package android.net.sip;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.sip.ISipService;
import android.net.sip.ISipSession;
import android.net.sip.ISipSessionListener;
import android.net.sip.SipAudioCall;
import android.net.sip.SipException;
import android.net.sip.SipProfile;
import android.net.sip.SipRegistrationListener;
import android.net.sip.SipSession;
import android.net.sip.SipSessionAdapter;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.text.ParseException;

public class SipManager {
    public static final String ACTION_SIP_ADD_PHONE = "com.android.phone.SIP_ADD_PHONE";
    public static final String ACTION_SIP_INCOMING_CALL = "com.android.phone.SIP_INCOMING_CALL";
    public static final String ACTION_SIP_REMOVE_PHONE = "com.android.phone.SIP_REMOVE_PHONE";
    public static final String ACTION_SIP_SERVICE_UP = "android.net.sip.SIP_SERVICE_UP";
    public static final String EXTRA_CALL_ID = "android:sipCallID";
    public static final String EXTRA_LOCAL_URI = "android:localSipUri";
    public static final String EXTRA_OFFER_SD = "android:sipOfferSD";
    public static final int INCOMING_CALL_RESULT_CODE = 101;
    private static final String TAG = "SipManager";
    private Context mContext;
    private ISipService mSipService;

    private SipManager(Context context) {
        this.mContext = context;
        this.createSipService();
    }

    public static Intent createIncomingCallBroadcast(String string2, String string3) {
        Intent intent = new Intent();
        Intent intent2 = intent.putExtra(EXTRA_CALL_ID, string2);
        Intent intent3 = intent.putExtra(EXTRA_OFFER_SD, string3);
        return intent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ISipSessionListener createRelay(SipRegistrationListener sipRegistrationListener, String string2) {
        if (sipRegistrationListener != null) return new ListenerRelay(sipRegistrationListener, string2);
        return null;
    }

    private void createSipService() {
        ISipService iSipService;
        this.mSipService = iSipService = ISipService.Stub.asInterface(ServiceManager.getService("sip"));
    }

    public static String getCallId(Intent intent) {
        return intent.getStringExtra(EXTRA_CALL_ID);
    }

    public static String getOfferSessionDescription(Intent intent) {
        return intent.getStringExtra(EXTRA_OFFER_SD);
    }

    public static boolean isApiSupported(Context context) {
        return context.getPackageManager().hasSystemFeature("android.software.sip");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isIncomingCallIntent(Intent intent) {
        boolean bl = false;
        if (intent == null) {
            return bl;
        }
        String string2 = SipManager.getCallId(intent);
        String string3 = SipManager.getOfferSessionDescription(intent);
        if (string2 == null) return bl;
        if (string3 == null) return bl;
        return true;
    }

    public static boolean isSipWifiOnly(Context context) {
        return context.getResources().getBoolean(17629202);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isVoipSupported(Context context) {
        if (!context.getPackageManager().hasSystemFeature("android.software.sip.voip")) return false;
        if (!SipManager.isApiSupported(context)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SipManager newInstance(Context context) {
        if (!SipManager.isApiSupported(context)) return null;
        return new SipManager(context);
    }

    public void close(String string2) throws SipException {
        try {
            this.mSipService.close(string2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new SipException("close()", remoteException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SipSession createSipSession(SipProfile sipProfile, SipSession.Listener listener) throws SipException {
        try {
            ISipSession iSipSession = this.mSipService.createSession(sipProfile, null);
            if (iSipSession != null) return new SipSession(iSipSession, listener);
            throw new SipException("Failed to create SipSession; network unavailable?");
        }
        catch (RemoteException remoteException) {
            throw new SipException("createSipSession()", remoteException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SipProfile[] getListOfProfiles() {
        try {
            SipProfile[] sipProfileArray = this.mSipService.getListOfProfiles();
            return sipProfileArray;
        }
        catch (RemoteException remoteException) {
            return new SipProfile[0];
        }
    }

    public SipSession getSessionFor(Intent intent) throws SipException {
        try {
            String string2 = SipManager.getCallId(intent);
            ISipSession iSipSession = this.mSipService.getPendingSession(string2);
            SipSession sipSession = new SipSession(iSipSession);
            return sipSession;
        }
        catch (RemoteException remoteException) {
            throw new SipException("getSessionFor()", remoteException);
        }
    }

    public boolean isOpened(String string2) throws SipException {
        try {
            boolean bl = this.mSipService.isOpened(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new SipException("isOpened()", remoteException);
        }
    }

    public boolean isRegistered(String string2) throws SipException {
        try {
            boolean bl = this.mSipService.isRegistered(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new SipException("isRegistered()", remoteException);
        }
    }

    public SipAudioCall makeAudioCall(SipProfile sipProfile, SipProfile sipProfile2, SipAudioCall.Listener listener, int n) throws SipException {
        if (!SipManager.isVoipSupported(this.mContext)) {
            throw new SipException("VOIP API is not supported");
        }
        Context context = this.mContext;
        SipAudioCall sipAudioCall = new SipAudioCall(context, sipProfile);
        sipAudioCall.setListener(listener);
        SipSession sipSession = this.createSipSession(sipProfile, null);
        sipAudioCall.makeCall(sipProfile2, sipSession, n);
        return sipAudioCall;
    }

    public SipAudioCall makeAudioCall(String string2, String string3, SipAudioCall.Listener listener, int n) throws SipException {
        if (!SipManager.isVoipSupported(this.mContext)) {
            throw new SipException("VOIP API is not supported");
        }
        try {
            SipProfile sipProfile = new SipProfile.Builder(string2).build();
            SipProfile sipProfile2 = new SipProfile.Builder(string3).build();
            SipAudioCall sipAudioCall = this.makeAudioCall(sipProfile, sipProfile2, listener, n);
            return sipAudioCall;
        }
        catch (ParseException parseException) {
            throw new SipException("build SipProfile", parseException);
        }
    }

    public void open(SipProfile sipProfile) throws SipException {
        try {
            this.mSipService.open(sipProfile);
            return;
        }
        catch (RemoteException remoteException) {
            throw new SipException("open()", remoteException);
        }
    }

    public void open(SipProfile sipProfile, PendingIntent pendingIntent, SipRegistrationListener sipRegistrationListener) throws SipException {
        if (pendingIntent == null) {
            throw new NullPointerException("incomingCallPendingIntent cannot be null");
        }
        try {
            ISipService iSipService = this.mSipService;
            String string2 = sipProfile.getUriString();
            ISipSessionListener iSipSessionListener = SipManager.createRelay(sipRegistrationListener, string2);
            iSipService.open3(sipProfile, pendingIntent, iSipSessionListener);
            return;
        }
        catch (RemoteException remoteException) {
            throw new SipException("open()", remoteException);
        }
    }

    public void register(SipProfile sipProfile, int n, SipRegistrationListener sipRegistrationListener) throws SipException {
        try {
            ISipService iSipService = this.mSipService;
            String string2 = sipProfile.getUriString();
            ISipSessionListener iSipSessionListener = SipManager.createRelay(sipRegistrationListener, string2);
            iSipService.createSession(sipProfile, iSipSessionListener).register(n);
            return;
        }
        catch (RemoteException remoteException) {
            throw new SipException("register()", remoteException);
        }
    }

    public void setRegistrationListener(String string2, SipRegistrationListener sipRegistrationListener) throws SipException {
        try {
            ISipService iSipService = this.mSipService;
            ISipSessionListener iSipSessionListener = SipManager.createRelay(sipRegistrationListener, string2);
            iSipService.setRegistrationListener(string2, iSipSessionListener);
            return;
        }
        catch (RemoteException remoteException) {
            throw new SipException("setRegistrationListener()", remoteException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SipAudioCall takeAudioCall(Intent intent, SipAudioCall.Listener listener) throws SipException {
        ISipSession iSipSession;
        if (intent == null) {
            throw new SipException("Cannot retrieve session with null intent");
        }
        String string2 = SipManager.getCallId(intent);
        if (string2 == null) {
            throw new SipException("Call ID missing in incoming call intent");
        }
        String string3 = SipManager.getOfferSessionDescription(intent);
        if (string3 == null) {
            throw new SipException("Session description missing in incoming call intent");
        }
        try {
            iSipSession = this.mSipService.getPendingSession(string2);
            if (iSipSession == null) {
                throw new SipException("No pending session for the call");
            }
        }
        catch (Throwable throwable) {
            throw new SipException("takeAudioCall()", throwable);
        }
        {
            Context context = this.mContext;
            SipProfile sipProfile = iSipSession.getLocalProfile();
            SipAudioCall sipAudioCall = new SipAudioCall(context, sipProfile);
            SipSession sipSession = new SipSession(iSipSession);
            sipAudioCall.attachCall(sipSession, string3);
            sipAudioCall.setListener(listener);
            return sipAudioCall;
        }
    }

    public void unregister(SipProfile sipProfile, SipRegistrationListener sipRegistrationListener) throws SipException {
        try {
            ISipService iSipService = this.mSipService;
            String string2 = sipProfile.getUriString();
            ISipSessionListener iSipSessionListener = SipManager.createRelay(sipRegistrationListener, string2);
            iSipService.createSession(sipProfile, iSipSessionListener).unregister();
            return;
        }
        catch (RemoteException remoteException) {
            throw new SipException("unregister()", remoteException);
        }
    }

    private static class ListenerRelay
    extends SipSessionAdapter {
        private SipRegistrationListener mListener;
        private String mUri;

        public ListenerRelay(SipRegistrationListener sipRegistrationListener, String string2) {
            this.mListener = sipRegistrationListener;
            this.mUri = string2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String getUri(ISipSession iSipSession) {
            String string2 = iSipSession.getLocalProfile().getUriString();
            if (iSipSession != null) return string2;
            try {
                return this.mUri;
            }
            catch (Throwable throwable) {
                String string3 = "getUri(): " + throwable;
                int n = Log.w(SipManager.TAG, string3);
                return null;
            }
        }

        @Override
        public void onRegistering(ISipSession iSipSession) {
            SipRegistrationListener sipRegistrationListener = this.mListener;
            String string2 = this.getUri(iSipSession);
            sipRegistrationListener.onRegistering(string2);
        }

        @Override
        public void onRegistrationDone(ISipSession iSipSession, int n) {
            long l = n;
            if (n > 0) {
                long l2 = System.currentTimeMillis();
                l += l2;
            }
            SipRegistrationListener sipRegistrationListener = this.mListener;
            String string2 = this.getUri(iSipSession);
            sipRegistrationListener.onRegistrationDone(string2, l);
        }

        @Override
        public void onRegistrationFailed(ISipSession iSipSession, int n, String string2) {
            SipRegistrationListener sipRegistrationListener = this.mListener;
            String string3 = this.getUri(iSipSession);
            sipRegistrationListener.onRegistrationFailed(string3, n, string2);
        }

        @Override
        public void onRegistrationTimeout(ISipSession iSipSession) {
            SipRegistrationListener sipRegistrationListener = this.mListener;
            String string2 = this.getUri(iSipSession);
            sipRegistrationListener.onRegistrationFailed(string2, -1, "registration timed out");
        }
    }
}

