/*
 * Decompiled with CFR 0.152.
 */
package android.net.sip;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.PeerUnavailableException;
import javax.sip.SipFactory;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;

public class SipProfile
implements Parcelable,
Serializable,
Cloneable {
    public static final Parcelable.Creator<SipProfile> CREATOR = new Parcelable.Creator<SipProfile>(){

        @Override
        public SipProfile createFromParcel(Parcel parcel) {
            return new SipProfile(parcel);
        }

        public SipProfile[] newArray(int n) {
            return new SipProfile[n];
        }
    };
    private static final int DEFAULT_PORT = 5060;
    private static final String TCP = "TCP";
    private static final String UDP = "UDP";
    private static final long serialVersionUID = 1L;
    private Address mAddress;
    private String mAuthUserName;
    private boolean mAutoRegistration = true;
    private transient int mCallingUid = 0;
    private String mDomain;
    private String mPassword;
    private int mPort = 5060;
    private String mProfileName;
    private String mProtocol = "UDP";
    private String mProxyAddress;
    private boolean mSendKeepAlive = false;

    private SipProfile() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private SipProfile(Parcel parcel) {
        String string2;
        int n;
        int n2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        Address address;
        this.mAddress = address = (Address)parcel.readSerializable();
        this.mProxyAddress = string7 = parcel.readString();
        this.mPassword = string6 = parcel.readString();
        this.mDomain = string5 = parcel.readString();
        this.mProtocol = string4 = parcel.readString();
        this.mProfileName = string3 = parcel.readString();
        boolean bl = parcel.readInt() != 0;
        this.mSendKeepAlive = bl;
        boolean bl2 = parcel.readInt() != 0;
        this.mAutoRegistration = bl2;
        this.mCallingUid = n2 = parcel.readInt();
        this.mPort = n = parcel.readInt();
        this.mAuthUserName = string2 = parcel.readString();
    }

    static /* synthetic */ boolean access$1002(SipProfile sipProfile, boolean bl) {
        sipProfile.mAutoRegistration = bl;
        return bl;
    }

    static /* synthetic */ String access$1102(SipProfile sipProfile, String string2) {
        sipProfile.mPassword = string2;
        return string2;
    }

    static /* synthetic */ String access$1202(SipProfile sipProfile, String string2) {
        sipProfile.mProxyAddress = string2;
        return string2;
    }

    static /* synthetic */ Address access$302(SipProfile sipProfile, Address address) {
        sipProfile.mAddress = address;
        return address;
    }

    static /* synthetic */ int access$402(SipProfile sipProfile, int n) {
        sipProfile.mPort = n;
        return n;
    }

    static /* synthetic */ String access$502(SipProfile sipProfile, String string2) {
        sipProfile.mDomain = string2;
        return string2;
    }

    static /* synthetic */ String access$602(SipProfile sipProfile, String string2) {
        sipProfile.mAuthUserName = string2;
        return string2;
    }

    static /* synthetic */ String access$702(SipProfile sipProfile, String string2) {
        sipProfile.mProfileName = string2;
        return string2;
    }

    static /* synthetic */ String access$802(SipProfile sipProfile, String string2) {
        sipProfile.mProtocol = string2;
        return string2;
    }

    static /* synthetic */ boolean access$902(SipProfile sipProfile, boolean bl) {
        sipProfile.mSendKeepAlive = bl;
        return bl;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.mPort == 0) {
            this.mPort = 5060;
        }
        return this;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getAuthUserName() {
        return this.mAuthUserName;
    }

    public boolean getAutoRegistration() {
        return this.mAutoRegistration;
    }

    public int getCallingUid() {
        return this.mCallingUid;
    }

    public String getDisplayName() {
        return this.mAddress.getDisplayName();
    }

    public String getPassword() {
        return this.mPassword;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getProfileName() {
        return this.mProfileName;
    }

    public String getProtocol() {
        return this.mProtocol;
    }

    public String getProxyAddress() {
        return this.mProxyAddress;
    }

    public boolean getSendKeepAlive() {
        return this.mSendKeepAlive;
    }

    public Address getSipAddress() {
        return this.mAddress;
    }

    public String getSipDomain() {
        return this.mDomain;
    }

    public SipURI getUri() {
        return (SipURI)this.mAddress.getURI();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getUriString() {
        if (TextUtils.isEmpty(this.mProxyAddress)) return this.getUri().toString();
        StringBuilder stringBuilder = new StringBuilder().append("sip:");
        String string2 = this.getUserName();
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("@");
        String string3 = this.mDomain;
        return stringBuilder2.append(string3).toString();
    }

    public String getUserName() {
        return this.getUri().getUser();
    }

    public void setCallingUid(int n) {
        this.mCallingUid = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        Address address = this.mAddress;
        parcel.writeSerializable((Serializable)address);
        String string2 = this.mProxyAddress;
        parcel.writeString(string2);
        String string3 = this.mPassword;
        parcel.writeString(string3);
        String string4 = this.mDomain;
        parcel.writeString(string4);
        String string5 = this.mProtocol;
        parcel.writeString(string5);
        String string6 = this.mProfileName;
        parcel.writeString(string6);
        int n2 = this.mSendKeepAlive ? 1 : 0;
        parcel.writeInt(n2);
        int n3 = this.mAutoRegistration ? 1 : 0;
        parcel.writeInt(n3);
        int n4 = this.mCallingUid;
        parcel.writeInt(n4);
        int n5 = this.mPort;
        parcel.writeInt(n5);
        String string7 = this.mAuthUserName;
        parcel.writeString(string7);
    }

    public static class Builder {
        private AddressFactory mAddressFactory;
        private String mDisplayName;
        private SipProfile mProfile;
        private String mProxyAddress;
        private SipURI mUri;

        public Builder(SipProfile sipProfile) {
            String string2;
            String string3;
            SipURI sipURI;
            SipProfile sipProfile2;
            this.mProfile = sipProfile2 = new SipProfile();
            try {
                AddressFactory addressFactory;
                this.mAddressFactory = addressFactory = SipFactory.getInstance().createAddressFactory();
                if (sipProfile == null) {
                    throw new NullPointerException();
                }
            }
            catch (PeerUnavailableException peerUnavailableException) {
                throw new RuntimeException(peerUnavailableException);
            }
            try {
                SipProfile sipProfile3;
                this.mProfile = sipProfile3 = (SipProfile)sipProfile.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException("should not occur", cloneNotSupportedException);
            }
            Address address = SipProfile.access$302(this.mProfile, null);
            SipURI sipURI2 = this.mUri = (sipURI = sipProfile.getUri());
            String string4 = sipProfile.getPassword();
            sipURI2.setUserPassword(string4);
            this.mDisplayName = string3 = sipProfile.getDisplayName();
            this.mProxyAddress = string2 = sipProfile.getProxyAddress();
            SipProfile sipProfile4 = this.mProfile;
            int n = sipProfile.getPort();
            int n2 = SipProfile.access$402(sipProfile4, n);
        }

        public Builder(String string2) throws ParseException {
            SipProfile sipProfile;
            this.mProfile = sipProfile = new SipProfile();
            try {
                AddressFactory addressFactory;
                this.mAddressFactory = addressFactory = SipFactory.getInstance().createAddressFactory();
                if (string2 == null) {
                    throw new NullPointerException("uriString cannot be null");
                }
            }
            catch (PeerUnavailableException peerUnavailableException) {
                throw new RuntimeException(peerUnavailableException);
            }
            AddressFactory addressFactory = this.mAddressFactory;
            String string3 = this.fix(string2);
            URI uRI = addressFactory.createURI(string3);
            if (uRI instanceof SipURI) {
                SipURI sipURI;
                this.mUri = sipURI = (SipURI)uRI;
                SipProfile sipProfile2 = this.mProfile;
                String string4 = this.mUri.getHost();
                String string5 = SipProfile.access$502(sipProfile2, string4);
                return;
            }
            String string6 = string2 + " is not a SIP URI";
            throw new ParseException(string6, 0);
        }

        public Builder(String string2, String string3) throws ParseException {
            SipURI sipURI;
            SipProfile sipProfile;
            this.mProfile = sipProfile = new SipProfile();
            try {
                AddressFactory addressFactory;
                this.mAddressFactory = addressFactory = SipFactory.getInstance().createAddressFactory();
                if (string2 == null || string3 == null) {
                    throw new NullPointerException("username and serverDomain cannot be null");
                }
            }
            catch (PeerUnavailableException peerUnavailableException) {
                throw new RuntimeException(peerUnavailableException);
            }
            this.mUri = sipURI = this.mAddressFactory.createSipURI(string2, string3);
            String string4 = SipProfile.access$502(this.mProfile, string3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String fix(String string2) {
            if (!string2.trim().toLowerCase().startsWith("sip:")) return "sip:" + string2;
            return string2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public SipProfile build() {
            SipProfile sipProfile = this.mProfile;
            String string2 = this.mUri.getUserPassword();
            String string3 = SipProfile.access$1102(sipProfile, string2);
            this.mUri.setUserPassword(null);
            try {
                if (!TextUtils.isEmpty(this.mProxyAddress)) {
                    AddressFactory addressFactory = this.mAddressFactory;
                    String string4 = this.mProxyAddress;
                    String string5 = this.fix(string4);
                    SipURI sipURI = (SipURI)addressFactory.createURI(string5);
                    SipProfile sipProfile2 = this.mProfile;
                    String string6 = sipURI.getHost();
                    String string7 = SipProfile.access$1202(sipProfile2, string6);
                } else {
                    if (!this.mProfile.mProtocol.equals(SipProfile.UDP)) {
                        SipURI sipURI = this.mUri;
                        String string8 = this.mProfile.mProtocol;
                        sipURI.setTransportParam(string8);
                    }
                    if (this.mProfile.mPort != 5060) {
                        SipURI sipURI = this.mUri;
                        int n = this.mProfile.mPort;
                        sipURI.setPort(n);
                    }
                }
                SipProfile sipProfile3 = this.mProfile;
                AddressFactory addressFactory = this.mAddressFactory;
                String string9 = this.mDisplayName;
                SipURI sipURI = this.mUri;
                Address address = addressFactory.createAddress(string9, (URI)sipURI);
                Address address2 = SipProfile.access$302(sipProfile3, address);
                return this.mProfile;
            }
            catch (InvalidArgumentException invalidArgumentException) {
                throw new RuntimeException(invalidArgumentException);
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
        }

        public Builder setAuthUserName(String string2) {
            String string3 = SipProfile.access$602(this.mProfile, string2);
            return this;
        }

        public Builder setAutoRegistration(boolean bl) {
            boolean bl2 = SipProfile.access$1002(this.mProfile, bl);
            return this;
        }

        public Builder setDisplayName(String string2) {
            this.mDisplayName = string2;
            return this;
        }

        public Builder setOutboundProxy(String string2) {
            this.mProxyAddress = string2;
            return this;
        }

        public Builder setPassword(String string2) {
            this.mUri.setUserPassword(string2);
            return this;
        }

        public Builder setPort(int n) throws IllegalArgumentException {
            if (n > 65535 || n < 1000) {
                String string2 = "incorrect port arugment: " + n;
                throw new IllegalArgumentException(string2);
            }
            int n2 = SipProfile.access$402(this.mProfile, n);
            return this;
        }

        public Builder setProfileName(String string2) {
            String string3 = SipProfile.access$702(this.mProfile, string2);
            return this;
        }

        public Builder setProtocol(String string2) throws IllegalArgumentException {
            if (string2 == null) {
                throw new NullPointerException("protocol cannot be null");
            }
            String string3 = string2.toUpperCase();
            if (!string3.equals(SipProfile.UDP) && !string3.equals(SipProfile.TCP)) {
                String string4 = "unsupported protocol: " + string3;
                throw new IllegalArgumentException(string4);
            }
            String string5 = SipProfile.access$802(this.mProfile, string3);
            return this;
        }

        public Builder setSendKeepAlive(boolean bl) {
            boolean bl2 = SipProfile.access$902(this.mProfile, bl);
            return this;
        }
    }
}

