/*
 * Decompiled with CFR 0.152.
 */
package android.net.sip;

import android.net.sip.ISipSession;
import android.net.sip.ISipSessionListener;
import android.net.sip.SipProfile;
import android.os.RemoteException;
import android.util.Log;

public final class SipSession {
    private static final String TAG = "SipSession";
    private Listener mListener;
    private final ISipSession mSession;

    SipSession(ISipSession iSipSession) {
        this.mSession = iSipSession;
        if (iSipSession == null) {
            return;
        }
        try {
            ISipSessionListener iSipSessionListener = this.createListener();
            iSipSession.setListener(iSipSessionListener);
            return;
        }
        catch (RemoteException remoteException) {
            String string2 = "SipSession.setListener(): " + remoteException;
            int n = Log.e(TAG, string2);
            return;
        }
    }

    SipSession(ISipSession iSipSession, Listener listener) {
        this(iSipSession);
        this.setListener(listener);
    }

    private ISipSessionListener createListener() {
        return new ISipSessionListener.Stub(){

            @Override
            public void onCallBusy(ISipSession iSipSession) {
                if (SipSession.this.mListener == null) {
                    return;
                }
                Listener listener = SipSession.this.mListener;
                SipSession sipSession = SipSession.this;
                listener.onCallBusy(sipSession);
            }

            @Override
            public void onCallChangeFailed(ISipSession iSipSession, int n, String string2) {
                if (SipSession.this.mListener == null) {
                    return;
                }
                Listener listener = SipSession.this.mListener;
                SipSession sipSession = SipSession.this;
                listener.onCallChangeFailed(sipSession, n, string2);
            }

            @Override
            public void onCallEnded(ISipSession iSipSession) {
                if (SipSession.this.mListener == null) {
                    return;
                }
                Listener listener = SipSession.this.mListener;
                SipSession sipSession = SipSession.this;
                listener.onCallEnded(sipSession);
            }

            @Override
            public void onCallEstablished(ISipSession iSipSession, String string2) {
                if (SipSession.this.mListener == null) {
                    return;
                }
                Listener listener = SipSession.this.mListener;
                SipSession sipSession = SipSession.this;
                listener.onCallEstablished(sipSession, string2);
            }

            @Override
            public void onCalling(ISipSession iSipSession) {
                if (SipSession.this.mListener == null) {
                    return;
                }
                Listener listener = SipSession.this.mListener;
                SipSession sipSession = SipSession.this;
                listener.onCalling(sipSession);
            }

            @Override
            public void onError(ISipSession iSipSession, int n, String string2) {
                if (SipSession.this.mListener == null) {
                    return;
                }
                Listener listener = SipSession.this.mListener;
                SipSession sipSession = SipSession.this;
                listener.onError(sipSession, n, string2);
            }

            @Override
            public void onRegistering(ISipSession iSipSession) {
                if (SipSession.this.mListener == null) {
                    return;
                }
                Listener listener = SipSession.this.mListener;
                SipSession sipSession = SipSession.this;
                listener.onRegistering(sipSession);
            }

            @Override
            public void onRegistrationDone(ISipSession iSipSession, int n) {
                if (SipSession.this.mListener == null) {
                    return;
                }
                Listener listener = SipSession.this.mListener;
                SipSession sipSession = SipSession.this;
                listener.onRegistrationDone(sipSession, n);
            }

            @Override
            public void onRegistrationFailed(ISipSession iSipSession, int n, String string2) {
                if (SipSession.this.mListener == null) {
                    return;
                }
                Listener listener = SipSession.this.mListener;
                SipSession sipSession = SipSession.this;
                listener.onRegistrationFailed(sipSession, n, string2);
            }

            @Override
            public void onRegistrationTimeout(ISipSession iSipSession) {
                if (SipSession.this.mListener == null) {
                    return;
                }
                Listener listener = SipSession.this.mListener;
                SipSession sipSession = SipSession.this;
                listener.onRegistrationTimeout(sipSession);
            }

            @Override
            public void onRinging(ISipSession iSipSession, SipProfile sipProfile, String string2) {
                if (SipSession.this.mListener == null) {
                    return;
                }
                Listener listener = SipSession.this.mListener;
                SipSession sipSession = SipSession.this;
                listener.onRinging(sipSession, sipProfile, string2);
            }

            @Override
            public void onRingingBack(ISipSession iSipSession) {
                if (SipSession.this.mListener == null) {
                    return;
                }
                Listener listener = SipSession.this.mListener;
                SipSession sipSession = SipSession.this;
                listener.onRingingBack(sipSession);
            }
        };
    }

    public void answerCall(String string2, int n) {
        try {
            this.mSession.answerCall(string2, n);
            return;
        }
        catch (RemoteException remoteException) {
            String string3 = "answerCall(): " + remoteException;
            int n2 = Log.e(TAG, string3);
            return;
        }
    }

    public void changeCall(String string2, int n) {
        try {
            this.mSession.changeCall(string2, n);
            return;
        }
        catch (RemoteException remoteException) {
            String string3 = "changeCall(): " + remoteException;
            int n2 = Log.e(TAG, string3);
            return;
        }
    }

    public void endCall() {
        try {
            this.mSession.endCall();
            return;
        }
        catch (RemoteException remoteException) {
            String string2 = "endCall(): " + remoteException;
            int n = Log.e(TAG, string2);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getCallId() {
        try {
            String string2 = this.mSession.getCallId();
            return string2;
        }
        catch (RemoteException remoteException) {
            String string3 = "getCallId(): " + remoteException;
            int n = Log.e(TAG, string3);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getLocalIp() {
        try {
            String string2 = this.mSession.getLocalIp();
            return string2;
        }
        catch (RemoteException remoteException) {
            String string3 = "getLocalIp(): " + remoteException;
            int n = Log.e(TAG, string3);
            return "127.0.0.1";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SipProfile getLocalProfile() {
        try {
            SipProfile sipProfile = this.mSession.getLocalProfile();
            return sipProfile;
        }
        catch (RemoteException remoteException) {
            String string2 = "getLocalProfile(): " + remoteException;
            int n = Log.e(TAG, string2);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SipProfile getPeerProfile() {
        try {
            SipProfile sipProfile = this.mSession.getPeerProfile();
            return sipProfile;
        }
        catch (RemoteException remoteException) {
            String string2 = "getPeerProfile(): " + remoteException;
            int n = Log.e(TAG, string2);
            return null;
        }
    }

    ISipSession getRealSession() {
        return this.mSession;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getState() {
        try {
            int n = this.mSession.getState();
            return n;
        }
        catch (RemoteException remoteException) {
            String string2 = "getState(): " + remoteException;
            int n = Log.e(TAG, string2);
            return 101;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInCall() {
        try {
            boolean bl = this.mSession.isInCall();
            return bl;
        }
        catch (RemoteException remoteException) {
            String string2 = "isInCall(): " + remoteException;
            int n = Log.e(TAG, string2);
            return false;
        }
    }

    public void makeCall(SipProfile sipProfile, String string2, int n) {
        try {
            this.mSession.makeCall(sipProfile, string2, n);
            return;
        }
        catch (RemoteException remoteException) {
            String string3 = "makeCall(): " + remoteException;
            int n2 = Log.e(TAG, string3);
            return;
        }
    }

    public void register(int n) {
        try {
            this.mSession.register(n);
            return;
        }
        catch (RemoteException remoteException) {
            String string2 = "register(): " + remoteException;
            int n2 = Log.e(TAG, string2);
            return;
        }
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public void unregister() {
        try {
            this.mSession.unregister();
            return;
        }
        catch (RemoteException remoteException) {
            String string2 = "unregister(): " + remoteException;
            int n = Log.e(TAG, string2);
            return;
        }
    }

    public static class Listener {
        public void onCallBusy(SipSession sipSession) {
        }

        public void onCallChangeFailed(SipSession sipSession, int n, String string2) {
        }

        public void onCallEnded(SipSession sipSession) {
        }

        public void onCallEstablished(SipSession sipSession, String string2) {
        }

        public void onCalling(SipSession sipSession) {
        }

        public void onError(SipSession sipSession, int n, String string2) {
        }

        public void onRegistering(SipSession sipSession) {
        }

        public void onRegistrationDone(SipSession sipSession, int n) {
        }

        public void onRegistrationFailed(SipSession sipSession, int n, String string2) {
        }

        public void onRegistrationTimeout(SipSession sipSession) {
        }

        public void onRinging(SipSession sipSession, SipProfile sipProfile, String string2) {
        }

        public void onRingingBack(SipSession sipSession) {
        }
    }

    public static class State {
        public static final int DEREGISTERING = 2;
        public static final int INCOMING_CALL = 3;
        public static final int INCOMING_CALL_ANSWERING = 4;
        public static final int IN_CALL = 8;
        public static final int NOT_DEFINED = 101;
        public static final int OUTGOING_CALL = 5;
        public static final int OUTGOING_CALL_CANCELING = 7;
        public static final int OUTGOING_CALL_RING_BACK = 6;
        public static final int PINGING = 9;
        public static final int READY_TO_CALL = 0;
        public static final int REGISTERING = 1;

        private State() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static String toString(int n) {
            switch (n) {
                default: {
                    return "NOT_DEFINED";
                }
                case 0: {
                    return "READY_TO_CALL";
                }
                case 1: {
                    return "REGISTERING";
                }
                case 2: {
                    return "DEREGISTERING";
                }
                case 3: {
                    return "INCOMING_CALL";
                }
                case 4: {
                    return "INCOMING_CALL_ANSWERING";
                }
                case 5: {
                    return "OUTGOING_CALL";
                }
                case 6: {
                    return "OUTGOING_CALL_RING_BACK";
                }
                case 7: {
                    return "OUTGOING_CALL_CANCELING";
                }
                case 8: {
                    return "IN_CALL";
                }
                case 9: 
            }
            return "PINGING";
        }
    }
}

