/*
 * Decompiled with CFR 0.152.
 */
package android.net.vpn;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.net.vpn.VpnProfile;
import android.net.vpn.VpnState;
import android.net.vpn.VpnType;
import android.os.Environment;
import android.util.Log;
import java.io.Serializable;

public class VpnManager {
    private static final String ACTION_VPN_CONNECTIVITY = "vpn.connectivity";
    private static final String ACTION_VPN_SERVICE;
    private static final String ACTION_VPN_SETTINGS;
    public static final String BROADCAST_CONNECTION_STATE = "connection_state";
    public static final String BROADCAST_ERROR_CODE = "err";
    public static final String BROADCAST_PROFILE_NAME = "profile_name";
    private static final String PACKAGE_PREFIX;
    public static final String PROFILES_PATH = "/misc/vpn/profiles";
    public static final String TAG;
    public static final int VPN_ERROR_AUTH = 51;
    public static final int VPN_ERROR_CHALLENGE = 5;
    public static final int VPN_ERROR_CONNECTION_FAILED = 101;
    public static final int VPN_ERROR_CONNECTION_LOST = 103;
    public static final int VPN_ERROR_LARGEST = 200;
    public static final int VPN_ERROR_NO_ERROR = 0;
    public static final int VPN_ERROR_PPP_NEGOTIATION_FAILED = 42;
    public static final int VPN_ERROR_REMOTE_HUNG_UP = 7;
    public static final int VPN_ERROR_REMOTE_PPP_HUNG_UP = 48;
    public static final int VPN_ERROR_UNKNOWN_SERVER = 102;
    private Context mContext;

    static {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = VpnManager.class.getPackage().getName();
        PACKAGE_PREFIX = stringBuilder.append(string2).append(".").toString();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string3 = PACKAGE_PREFIX;
        ACTION_VPN_SERVICE = stringBuilder2.append(string3).append("SERVICE").toString();
        StringBuilder stringBuilder3 = new StringBuilder();
        String string4 = PACKAGE_PREFIX;
        ACTION_VPN_SETTINGS = stringBuilder3.append(string4).append("SETTINGS").toString();
        TAG = VpnManager.class.getSimpleName();
    }

    public VpnManager(Context context) {
        this.mContext = context;
    }

    public static String getProfilePath() {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = Environment.getSecureDataDirectory().getPath();
        return stringBuilder.append(string2).append(PROFILES_PATH).toString();
    }

    public static VpnType[] getSupportedVpnTypes() {
        return VpnType.values();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean bindVpnService(ServiceConnection serviceConnection) {
        Context context = this.mContext;
        String string2 = ACTION_VPN_SERVICE;
        Intent intent = new Intent(string2);
        if (!context.bindService(intent, serviceConnection, 0)) {
            int n = Log.w(TAG, "failed to connect to VPN service");
            return false;
        }
        int n = Log.d(TAG, "succeeded to connect to VPN service");
        return true;
    }

    public void broadcastConnectivity(String string2, VpnState vpnState) {
        this.broadcastConnectivity(string2, vpnState, 0);
    }

    public void broadcastConnectivity(String string2, VpnState vpnState, int n) {
        Intent intent = new Intent(ACTION_VPN_CONNECTIVITY);
        Intent intent2 = intent.putExtra(BROADCAST_PROFILE_NAME, string2);
        Intent intent3 = intent.putExtra(BROADCAST_CONNECTION_STATE, (Serializable)((Object)vpnState));
        if (n != 0) {
            Intent intent4 = intent.putExtra(BROADCAST_ERROR_CODE, n);
        }
        this.mContext.sendBroadcast(intent);
    }

    public Intent createSettingsActivityIntent() {
        String string2 = ACTION_VPN_SETTINGS;
        Intent intent = new Intent(string2);
        Intent intent2 = intent.setFlags(0x10000000);
        return intent;
    }

    public VpnProfile createVpnProfile(VpnType vpnType) {
        return this.createVpnProfile(vpnType, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VpnProfile createVpnProfile(VpnType vpnType, boolean bl) {
        try {
            VpnProfile vpnProfile = vpnType.getProfileClass().newInstance();
            vpnProfile.setCustomized(bl);
            return vpnProfile;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public void registerConnectivityReceiver(BroadcastReceiver broadcastReceiver) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(ACTION_VPN_CONNECTIVITY);
        Intent intent = this.mContext.registerReceiver(broadcastReceiver, intentFilter);
    }

    public void startSettingsActivity() {
        String string2 = ACTION_VPN_SETTINGS;
        Intent intent = new Intent(string2);
        Intent intent2 = intent.setFlags(0x10000000);
        this.mContext.startActivity(intent);
    }

    public void startVpnService() {
        Context context = this.mContext;
        String string2 = ACTION_VPN_SERVICE;
        Intent intent = new Intent(string2);
        ComponentName componentName = context.startService(intent);
    }

    public void stopVpnService() {
        Context context = this.mContext;
        String string2 = ACTION_VPN_SERVICE;
        Intent intent = new Intent(string2);
        boolean bl = context.stopService(intent);
    }

    public void unregisterConnectivityReceiver(BroadcastReceiver broadcastReceiver) {
        this.mContext.unregisterReceiver(broadcastReceiver);
    }
}

