/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.BitSet;

public class WifiConfiguration
implements Parcelable {
    public static final Parcelable.Creator<WifiConfiguration> CREATOR;
    public static final String bssidVarName = "bssid";
    public static final String hiddenSSIDVarName = "scan_ssid";
    public static final String priorityVarName = "priority";
    public static final String pskVarName = "psk";
    public static final String ssidVarName = "ssid";
    public static final String[] wepKeyVarNames;
    public static final String wepTxKeyIdxVarName = "wep_tx_keyidx";
    public String BSSID;
    public String SSID;
    public BitSet allowedAuthAlgorithms;
    public BitSet allowedGroupCiphers;
    public BitSet allowedKeyManagement;
    public BitSet allowedPairwiseCiphers;
    public BitSet allowedProtocols;
    public EnterpriseField anonymous_identity;
    public EnterpriseField ca_cert;
    public EnterpriseField client_cert;
    public EnterpriseField eap;
    public EnterpriseField[] enterpriseFields;
    public boolean hiddenSSID;
    public EnterpriseField identity;
    public int networkId;
    public EnterpriseField password;
    public EnterpriseField phase2;
    public String preSharedKey;
    public int priority;
    public EnterpriseField private_key;
    public int status;
    public String[] wepKeys;
    public int wepTxKeyIndex;

    static {
        String[] stringArray = new String[]{"wep_key0", "wep_key1", "wep_key2", "wep_key3"};
        wepKeyVarNames = stringArray;
        CREATOR = new Parcelable.Creator<WifiConfiguration>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public WifiConfiguration createFromParcel(Parcel parcel) {
                BitSet bitSet;
                BitSet bitSet2;
                BitSet bitSet3;
                BitSet bitSet4;
                BitSet bitSet5;
                int n;
                int n2;
                int n3;
                String string2;
                String string3;
                String string4;
                int n4;
                int n5;
                WifiConfiguration wifiConfiguration = new WifiConfiguration();
                wifiConfiguration.networkId = n5 = parcel.readInt();
                wifiConfiguration.status = n4 = parcel.readInt();
                wifiConfiguration.SSID = string4 = parcel.readString();
                wifiConfiguration.BSSID = string3 = parcel.readString();
                wifiConfiguration.preSharedKey = string2 = parcel.readString();
                for (int i = 0; i < (n3 = wifiConfiguration.wepKeys.length); ++i) {
                    String string5;
                    String[] stringArray = wifiConfiguration.wepKeys;
                    stringArray[i] = string5 = parcel.readString();
                }
                wifiConfiguration.wepTxKeyIndex = n2 = parcel.readInt();
                wifiConfiguration.priority = n = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                wifiConfiguration.hiddenSSID = bl;
                wifiConfiguration.allowedKeyManagement = bitSet5 = WifiConfiguration.readBitSet(parcel);
                wifiConfiguration.allowedProtocols = bitSet4 = WifiConfiguration.readBitSet(parcel);
                wifiConfiguration.allowedAuthAlgorithms = bitSet3 = WifiConfiguration.readBitSet(parcel);
                wifiConfiguration.allowedPairwiseCiphers = bitSet2 = WifiConfiguration.readBitSet(parcel);
                wifiConfiguration.allowedGroupCiphers = bitSet = WifiConfiguration.readBitSet(parcel);
                EnterpriseField[] enterpriseFieldArray = wifiConfiguration.enterpriseFields;
                int n6 = enterpriseFieldArray.length;
                int n7 = 0;
                while (n7 < n6) {
                    EnterpriseField enterpriseField = enterpriseFieldArray[n7];
                    String string6 = parcel.readString();
                    enterpriseField.setValue(string6);
                    ++n7;
                }
                return wifiConfiguration;
            }

            public WifiConfiguration[] newArray(int n) {
                return new WifiConfiguration[n];
            }
        };
    }

    public WifiConfiguration() {
        int n;
        BitSet bitSet;
        BitSet bitSet2;
        BitSet bitSet3;
        BitSet bitSet4;
        BitSet bitSet5;
        EnterpriseField enterpriseField;
        EnterpriseField enterpriseField2;
        EnterpriseField enterpriseField3;
        EnterpriseField enterpriseField4;
        EnterpriseField enterpriseField5;
        EnterpriseField enterpriseField6;
        EnterpriseField enterpriseField7;
        EnterpriseField enterpriseField8;
        this.eap = enterpriseField8 = new EnterpriseField("eap");
        this.phase2 = enterpriseField7 = new EnterpriseField("phase2");
        this.identity = enterpriseField6 = new EnterpriseField("identity");
        this.anonymous_identity = enterpriseField5 = new EnterpriseField("anonymous_identity");
        this.password = enterpriseField4 = new EnterpriseField("password");
        this.client_cert = enterpriseField3 = new EnterpriseField("client_cert");
        this.private_key = enterpriseField2 = new EnterpriseField("private_key");
        this.ca_cert = enterpriseField = new EnterpriseField("ca_cert");
        EnterpriseField enterpriseField9 = this.eap;
        EnterpriseField enterpriseField10 = this.phase2;
        EnterpriseField enterpriseField11 = this.identity;
        EnterpriseField enterpriseField12 = this.anonymous_identity;
        EnterpriseField enterpriseField13 = this.password;
        EnterpriseField enterpriseField14 = this.client_cert;
        EnterpriseField enterpriseField15 = this.private_key;
        EnterpriseField enterpriseField16 = this.ca_cert;
        EnterpriseField[] enterpriseFieldArray = new EnterpriseField[]{enterpriseField9, enterpriseField10, enterpriseField11, enterpriseField12, enterpriseField13, enterpriseField14, enterpriseField15, enterpriseField16};
        this.enterpriseFields = enterpriseFieldArray;
        this.networkId = -1;
        this.SSID = null;
        this.BSSID = null;
        this.priority = 0;
        this.hiddenSSID = false;
        this.allowedKeyManagement = bitSet5 = new BitSet();
        this.allowedProtocols = bitSet4 = new BitSet();
        this.allowedAuthAlgorithms = bitSet3 = new BitSet();
        this.allowedPairwiseCiphers = bitSet2 = new BitSet();
        this.allowedGroupCiphers = bitSet = new BitSet();
        String[] stringArray = new String[4];
        this.wepKeys = stringArray;
        for (int i = 0; i < (n = this.wepKeys.length); ++i) {
            this.wepKeys[i] = null;
        }
        EnterpriseField[] enterpriseFieldArray2 = this.enterpriseFields;
        int n2 = enterpriseFieldArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            enterpriseFieldArray2[n3].setValue(null);
            ++n3;
        }
        return;
    }

    private static BitSet readBitSet(Parcel parcel) {
        int n = parcel.readInt();
        BitSet bitSet = new BitSet();
        for (int i = 0; i < n; ++i) {
            int n2 = parcel.readInt();
            bitSet.set(n2);
        }
        return bitSet;
    }

    private static void writeBitSet(Parcel parcel, BitSet bitSet) {
        int n = -1;
        int n2 = bitSet.cardinality();
        parcel.writeInt(n2);
        int n3;
        while ((n = bitSet.nextSetBit(n3 = n + 1)) != -1) {
            parcel.writeInt(n);
        }
        return;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.status == 0) {
            StringBuffer stringBuffer2 = stringBuffer.append("* ");
        } else if (this.status == 1) {
            StringBuffer stringBuffer3 = stringBuffer.append("- ");
        }
        StringBuffer stringBuffer4 = stringBuffer.append("ID: ");
        int n6 = this.networkId;
        StringBuffer stringBuffer5 = stringBuffer4.append(n6).append(" SSID: ");
        String string2 = this.SSID;
        StringBuffer stringBuffer6 = stringBuffer5.append(string2).append(" BSSID: ");
        String string3 = this.BSSID;
        StringBuffer stringBuffer7 = stringBuffer6.append(string3).append(" PRIO: ");
        int n7 = this.priority;
        StringBuffer stringBuffer8 = stringBuffer7.append(n7).append('\n');
        StringBuffer stringBuffer9 = stringBuffer.append(" KeyMgmt:");
        for (int i = 0; i < (n5 = this.allowedKeyManagement.size()); ++i) {
            if (!this.allowedKeyManagement.get(i)) continue;
            StringBuffer stringBuffer10 = stringBuffer.append(" ");
            int n8 = KeyMgmt.strings.length;
            if (i < n8) {
                String string4 = KeyMgmt.strings[i];
                StringBuffer stringBuffer11 = stringBuffer.append(string4);
                continue;
            }
            StringBuffer stringBuffer12 = stringBuffer.append("??");
        }
        StringBuffer stringBuffer13 = stringBuffer.append(" Protocols:");
        for (int i = 0; i < (n4 = this.allowedProtocols.size()); ++i) {
            if (!this.allowedProtocols.get(i)) continue;
            StringBuffer stringBuffer14 = stringBuffer.append(" ");
            int n9 = Protocol.strings.length;
            if (i < n9) {
                String string5 = Protocol.strings[i];
                StringBuffer stringBuffer15 = stringBuffer.append(string5);
                continue;
            }
            StringBuffer stringBuffer16 = stringBuffer.append("??");
        }
        StringBuffer stringBuffer17 = stringBuffer.append('\n');
        StringBuffer stringBuffer18 = stringBuffer.append(" AuthAlgorithms:");
        for (int i = 0; i < (n3 = this.allowedAuthAlgorithms.size()); ++i) {
            if (!this.allowedAuthAlgorithms.get(i)) continue;
            StringBuffer stringBuffer19 = stringBuffer.append(" ");
            int n10 = AuthAlgorithm.strings.length;
            if (i < n10) {
                String string6 = AuthAlgorithm.strings[i];
                StringBuffer stringBuffer20 = stringBuffer.append(string6);
                continue;
            }
            StringBuffer stringBuffer21 = stringBuffer.append("??");
        }
        StringBuffer stringBuffer22 = stringBuffer.append('\n');
        StringBuffer stringBuffer23 = stringBuffer.append(" PairwiseCiphers:");
        for (int i = 0; i < (n2 = this.allowedPairwiseCiphers.size()); ++i) {
            if (!this.allowedPairwiseCiphers.get(i)) continue;
            StringBuffer stringBuffer24 = stringBuffer.append(" ");
            int n11 = PairwiseCipher.strings.length;
            if (i < n11) {
                String string7 = PairwiseCipher.strings[i];
                StringBuffer stringBuffer25 = stringBuffer.append(string7);
                continue;
            }
            StringBuffer stringBuffer26 = stringBuffer.append("??");
        }
        StringBuffer stringBuffer27 = stringBuffer.append('\n');
        StringBuffer stringBuffer28 = stringBuffer.append(" GroupCiphers:");
        for (int i = 0; i < (n = this.allowedGroupCiphers.size()); ++i) {
            if (!this.allowedGroupCiphers.get(i)) continue;
            StringBuffer stringBuffer29 = stringBuffer.append(" ");
            int n12 = GroupCipher.strings.length;
            if (i < n12) {
                String string8 = GroupCipher.strings[i];
                StringBuffer stringBuffer30 = stringBuffer.append(string8);
                continue;
            }
            StringBuffer stringBuffer31 = stringBuffer.append("??");
        }
        StringBuffer stringBuffer32 = stringBuffer.append('\n').append(" PSK: ");
        if (this.preSharedKey != null) {
            StringBuffer stringBuffer33 = stringBuffer.append('*');
        }
        EnterpriseField[] enterpriseFieldArray = this.enterpriseFields;
        int n13 = enterpriseFieldArray.length;
        int n14 = 0;
        while (true) {
            if (n14 >= n13) {
                StringBuffer stringBuffer34 = stringBuffer.append('\n');
                return stringBuffer.toString();
            }
            EnterpriseField enterpriseField = enterpriseFieldArray[n14];
            StringBuffer stringBuffer35 = stringBuffer.append('\n');
            StringBuilder stringBuilder = new StringBuilder().append(" ");
            String string9 = enterpriseField.varName();
            String string10 = stringBuilder.append(string9).append(": ").toString();
            StringBuffer stringBuffer36 = stringBuffer35.append(string10);
            String string11 = enterpriseField.value();
            if (string11 != null) {
                StringBuffer stringBuffer37 = stringBuffer.append(string11);
            }
            ++n14;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.networkId;
        parcel.writeInt(n2);
        int n3 = this.status;
        parcel.writeInt(n3);
        String string2 = this.SSID;
        parcel.writeString(string2);
        String string3 = this.BSSID;
        parcel.writeString(string3);
        String string4 = this.preSharedKey;
        parcel.writeString(string4);
        for (String string5 : this.wepKeys) {
            parcel.writeString(string5);
        }
        int n4 = this.wepTxKeyIndex;
        parcel.writeInt(n4);
        int n5 = this.priority;
        parcel.writeInt(n5);
        int n6 = this.hiddenSSID ? 1 : 0;
        parcel.writeInt(n6);
        BitSet bitSet = this.allowedKeyManagement;
        WifiConfiguration.writeBitSet(parcel, bitSet);
        BitSet bitSet2 = this.allowedProtocols;
        WifiConfiguration.writeBitSet(parcel, bitSet2);
        BitSet bitSet3 = this.allowedAuthAlgorithms;
        WifiConfiguration.writeBitSet(parcel, bitSet3);
        BitSet bitSet4 = this.allowedPairwiseCiphers;
        WifiConfiguration.writeBitSet(parcel, bitSet4);
        BitSet bitSet5 = this.allowedGroupCiphers;
        WifiConfiguration.writeBitSet(parcel, bitSet5);
        EnterpriseField[] enterpriseFieldArray = this.enterpriseFields;
        int n7 = enterpriseFieldArray.length;
        int n8 = 0;
        while (n8 < n7) {
            String string6 = enterpriseFieldArray[n8].value();
            parcel.writeString(string6);
            ++n8;
        }
        return;
    }

    public static class Status {
        public static final int CURRENT = 0;
        public static final int DISABLED = 1;
        public static final int ENABLED = 2;
        public static final String[] strings;

        static {
            String[] stringArray = new String[]{"current", "disabled", "enabled"};
            strings = stringArray;
        }

        private Status() {
        }
    }

    public static class GroupCipher {
        public static final int CCMP = 3;
        public static final int TKIP = 2;
        public static final int WEP104 = 1;
        public static final int WEP40 = 0;
        public static final String[] strings;
        public static final String varName = "group";

        static {
            String[] stringArray = new String[]{"WEP40", "WEP104", "TKIP", "CCMP"};
            strings = stringArray;
        }

        private GroupCipher() {
        }
    }

    public static class PairwiseCipher {
        public static final int CCMP = 2;
        public static final int NONE = 0;
        public static final int TKIP = 1;
        public static final String[] strings;
        public static final String varName = "pairwise";

        static {
            String[] stringArray = new String[]{"NONE", "TKIP", "CCMP"};
            strings = stringArray;
        }

        private PairwiseCipher() {
        }
    }

    public static class AuthAlgorithm {
        public static final int LEAP = 2;
        public static final int OPEN = 0;
        public static final int SHARED = 1;
        public static final String[] strings;
        public static final String varName = "auth_alg";

        static {
            String[] stringArray = new String[]{"OPEN", "SHARED", "LEAP"};
            strings = stringArray;
        }

        private AuthAlgorithm() {
        }
    }

    public static class Protocol {
        public static final int RSN = 1;
        public static final int WPA = 0;
        public static final String[] strings;
        public static final String varName = "proto";

        static {
            String[] stringArray = new String[]{"WPA", "RSN"};
            strings = stringArray;
        }

        private Protocol() {
        }
    }

    public static class KeyMgmt {
        public static final int IEEE8021X = 3;
        public static final int NONE = 0;
        public static final int WPA_EAP = 2;
        public static final int WPA_PSK = 1;
        public static final String[] strings;
        public static final String varName = "key_mgmt";

        static {
            String[] stringArray = new String[]{"NONE", "WPA_PSK", "WPA_EAP", "IEEE8021X"};
            strings = stringArray;
        }

        private KeyMgmt() {
        }
    }

    public class EnterpriseField {
        private String value;
        private String varName;

        private EnterpriseField(String string2) {
            this.varName = string2;
            this.value = null;
        }

        public void setValue(String string2) {
            this.value = string2;
        }

        public String value() {
            return this.value;
        }

        public String varName() {
            return this.varName;
        }
    }
}

