/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.NetworkInfo;
import android.net.wifi.SupplicantState;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.EnumMap;

public class WifiInfo
implements Parcelable {
    public static final Parcelable.Creator<WifiInfo> CREATOR;
    public static final String LINK_SPEED_UNITS = "Mbps";
    private static final EnumMap<SupplicantState, NetworkInfo.DetailedState> stateMap;
    private String mBSSID = null;
    private boolean mHiddenSSID;
    private int mIpAddress;
    private int mLinkSpeed;
    private String mMacAddress;
    private int mNetworkId = -1;
    private int mRssi;
    private String mSSID = null;
    private SupplicantState mSupplicantState;

    static {
        EnumMap<SupplicantState, NetworkInfo.DetailedState> enumMap = stateMap = new EnumMap(SupplicantState.class);
        SupplicantState supplicantState = SupplicantState.DISCONNECTED;
        NetworkInfo.DetailedState detailedState = NetworkInfo.DetailedState.DISCONNECTED;
        NetworkInfo.DetailedState detailedState2 = enumMap.put(supplicantState, detailedState);
        EnumMap<SupplicantState, NetworkInfo.DetailedState> enumMap2 = stateMap;
        SupplicantState supplicantState2 = SupplicantState.INACTIVE;
        NetworkInfo.DetailedState detailedState3 = NetworkInfo.DetailedState.IDLE;
        NetworkInfo.DetailedState detailedState4 = enumMap2.put(supplicantState2, detailedState3);
        EnumMap<SupplicantState, NetworkInfo.DetailedState> enumMap3 = stateMap;
        SupplicantState supplicantState3 = SupplicantState.SCANNING;
        NetworkInfo.DetailedState detailedState5 = NetworkInfo.DetailedState.SCANNING;
        NetworkInfo.DetailedState detailedState6 = enumMap3.put(supplicantState3, detailedState5);
        EnumMap<SupplicantState, NetworkInfo.DetailedState> enumMap4 = stateMap;
        SupplicantState supplicantState4 = SupplicantState.ASSOCIATING;
        NetworkInfo.DetailedState detailedState7 = NetworkInfo.DetailedState.CONNECTING;
        NetworkInfo.DetailedState detailedState8 = enumMap4.put(supplicantState4, detailedState7);
        EnumMap<SupplicantState, NetworkInfo.DetailedState> enumMap5 = stateMap;
        SupplicantState supplicantState5 = SupplicantState.ASSOCIATED;
        NetworkInfo.DetailedState detailedState9 = NetworkInfo.DetailedState.CONNECTING;
        NetworkInfo.DetailedState detailedState10 = enumMap5.put(supplicantState5, detailedState9);
        EnumMap<SupplicantState, NetworkInfo.DetailedState> enumMap6 = stateMap;
        SupplicantState supplicantState6 = SupplicantState.FOUR_WAY_HANDSHAKE;
        NetworkInfo.DetailedState detailedState11 = NetworkInfo.DetailedState.AUTHENTICATING;
        NetworkInfo.DetailedState detailedState12 = enumMap6.put(supplicantState6, detailedState11);
        EnumMap<SupplicantState, NetworkInfo.DetailedState> enumMap7 = stateMap;
        SupplicantState supplicantState7 = SupplicantState.GROUP_HANDSHAKE;
        NetworkInfo.DetailedState detailedState13 = NetworkInfo.DetailedState.AUTHENTICATING;
        NetworkInfo.DetailedState detailedState14 = enumMap7.put(supplicantState7, detailedState13);
        EnumMap<SupplicantState, NetworkInfo.DetailedState> enumMap8 = stateMap;
        SupplicantState supplicantState8 = SupplicantState.COMPLETED;
        NetworkInfo.DetailedState detailedState15 = NetworkInfo.DetailedState.OBTAINING_IPADDR;
        NetworkInfo.DetailedState detailedState16 = enumMap8.put(supplicantState8, detailedState15);
        EnumMap<SupplicantState, NetworkInfo.DetailedState> enumMap9 = stateMap;
        SupplicantState supplicantState9 = SupplicantState.DORMANT;
        NetworkInfo.DetailedState detailedState17 = NetworkInfo.DetailedState.DISCONNECTED;
        NetworkInfo.DetailedState detailedState18 = enumMap9.put(supplicantState9, detailedState17);
        EnumMap<SupplicantState, NetworkInfo.DetailedState> enumMap10 = stateMap;
        SupplicantState supplicantState10 = SupplicantState.UNINITIALIZED;
        NetworkInfo.DetailedState detailedState19 = NetworkInfo.DetailedState.IDLE;
        NetworkInfo.DetailedState detailedState20 = enumMap10.put(supplicantState10, detailedState19);
        EnumMap<SupplicantState, NetworkInfo.DetailedState> enumMap11 = stateMap;
        SupplicantState supplicantState11 = SupplicantState.INVALID;
        NetworkInfo.DetailedState detailedState21 = NetworkInfo.DetailedState.FAILED;
        NetworkInfo.DetailedState detailedState22 = enumMap11.put(supplicantState11, detailedState21);
        CREATOR = new Parcelable.Creator<WifiInfo>(){

            @Override
            public WifiInfo createFromParcel(Parcel parcel) {
                WifiInfo wifiInfo = new WifiInfo();
                int n = parcel.readInt();
                wifiInfo.setNetworkId(n);
                int n2 = parcel.readInt();
                wifiInfo.setRssi(n2);
                int n3 = parcel.readInt();
                wifiInfo.setLinkSpeed(n3);
                int n4 = parcel.readInt();
                wifiInfo.setIpAddress(n4);
                String string2 = parcel.readString();
                wifiInfo.setSSID(string2);
                String string3 = parcel.readString();
                String string4 = WifiInfo.access$002(wifiInfo, string3);
                String string5 = parcel.readString();
                String string6 = WifiInfo.access$102(wifiInfo, string5);
                SupplicantState supplicantState = SupplicantState.CREATOR.createFromParcel(parcel);
                SupplicantState supplicantState2 = WifiInfo.access$202(wifiInfo, supplicantState);
                return wifiInfo;
            }

            public WifiInfo[] newArray(int n) {
                return new WifiInfo[n];
            }
        };
    }

    WifiInfo() {
        SupplicantState supplicantState;
        this.mSupplicantState = supplicantState = SupplicantState.UNINITIALIZED;
        this.mRssi = 55537;
        this.mLinkSpeed = -1;
        this.mIpAddress = 0;
        this.mHiddenSSID = false;
    }

    static /* synthetic */ String access$002(WifiInfo wifiInfo, String string2) {
        wifiInfo.mBSSID = string2;
        return string2;
    }

    static /* synthetic */ String access$102(WifiInfo wifiInfo, String string2) {
        wifiInfo.mMacAddress = string2;
        return string2;
    }

    static /* synthetic */ SupplicantState access$202(WifiInfo wifiInfo, SupplicantState supplicantState) {
        wifiInfo.mSupplicantState = supplicantState;
        return supplicantState;
    }

    public static NetworkInfo.DetailedState getDetailedStateOf(SupplicantState supplicantState) {
        return stateMap.get(supplicantState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static SupplicantState valueOf(String string2) {
        if ("4WAY_HANDSHAKE".equalsIgnoreCase(string2)) {
            return SupplicantState.FOUR_WAY_HANDSHAKE;
        }
        try {
            SupplicantState supplicantState = SupplicantState.valueOf(string2.toUpperCase());
            return supplicantState;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return SupplicantState.INVALID;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getBSSID() {
        return this.mBSSID;
    }

    public boolean getHiddenSSID() {
        return this.mHiddenSSID;
    }

    public int getIpAddress() {
        return this.mIpAddress;
    }

    public int getLinkSpeed() {
        return this.mLinkSpeed;
    }

    public String getMacAddress() {
        return this.mMacAddress;
    }

    public int getNetworkId() {
        return this.mNetworkId;
    }

    public int getRssi() {
        return this.mRssi;
    }

    public String getSSID() {
        return this.mSSID;
    }

    public SupplicantState getSupplicantState() {
        return this.mSupplicantState;
    }

    void setBSSID(String string2) {
        this.mBSSID = string2;
    }

    public void setHiddenSSID(boolean bl) {
        this.mHiddenSSID = bl;
    }

    void setIpAddress(int n) {
        this.mIpAddress = n;
    }

    void setLinkSpeed(int n) {
        this.mLinkSpeed = n;
    }

    void setMacAddress(String string2) {
        this.mMacAddress = string2;
    }

    void setNetworkId(int n) {
        this.mNetworkId = n;
    }

    void setRssi(int n) {
        this.mRssi = n;
    }

    void setSSID(String string2) {
        this.mSSID = string2;
        this.mHiddenSSID = false;
    }

    void setSupplicantState(SupplicantState supplicantState) {
        this.mSupplicantState = supplicantState;
    }

    void setSupplicantState(String string2) {
        SupplicantState supplicantState;
        this.mSupplicantState = supplicantState = WifiInfo.valueOf(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = stringBuffer.append("SSID: ");
        String string2 = this.mSSID == null ? "<none>" : this.mSSID;
        StringBuffer stringBuffer3 = stringBuffer2.append(string2).append(", BSSID: ");
        String string3 = this.mBSSID == null ? "<none>" : this.mBSSID;
        StringBuffer stringBuffer4 = stringBuffer3.append(string3).append(", MAC: ");
        String string4 = this.mMacAddress == null ? "<none>" : this.mMacAddress;
        StringBuffer stringBuffer5 = stringBuffer4.append(string4).append(", Supplicant state: ");
        Object object = this.mSupplicantState == null ? "<none>" : this.mSupplicantState;
        StringBuffer stringBuffer6 = stringBuffer5.append(object).append(", RSSI: ");
        int n = this.mRssi;
        StringBuffer stringBuffer7 = stringBuffer6.append(n).append(", Link speed: ");
        int n2 = this.mLinkSpeed;
        StringBuffer stringBuffer8 = stringBuffer7.append(n2).append(", Net ID: ");
        int n3 = this.mNetworkId;
        StringBuffer stringBuffer9 = stringBuffer8.append(n3);
        return stringBuffer.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.mNetworkId;
        parcel.writeInt(n2);
        int n3 = this.mRssi;
        parcel.writeInt(n3);
        int n4 = this.mLinkSpeed;
        parcel.writeInt(n4);
        int n5 = this.mIpAddress;
        parcel.writeInt(n5);
        String string2 = this.getSSID();
        parcel.writeString(string2);
        String string3 = this.mBSSID;
        parcel.writeString(string3);
        String string4 = this.mMacAddress;
        parcel.writeString(string4);
        this.mSupplicantState.writeToParcel(parcel, n);
    }
}

