/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.DhcpInfo;
import android.net.wifi.IWifiManager;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.WorkSource;
import java.util.List;

public class WifiManager {
    public static final String ACTION_PICK_WIFI_NETWORK = "android.net.wifi.PICK_WIFI_NETWORK";
    public static final int ERROR_AUTHENTICATING = 1;
    public static final String EXTRA_BSSID = "bssid";
    public static final String EXTRA_NETWORK_INFO = "networkInfo";
    public static final String EXTRA_NEW_RSSI = "newRssi";
    public static final String EXTRA_NEW_STATE = "newState";
    public static final String EXTRA_PREVIOUS_WIFI_AP_STATE = "previous_wifi_state";
    public static final String EXTRA_PREVIOUS_WIFI_STATE = "previous_wifi_state";
    public static final String EXTRA_SUPPLICANT_CONNECTED = "connected";
    public static final String EXTRA_SUPPLICANT_ERROR = "supplicantError";
    public static final String EXTRA_WIFI_AP_STATE = "wifi_state";
    public static final String EXTRA_WIFI_STATE = "wifi_state";
    private static final int MAX_ACTIVE_LOCKS = 50;
    private static final int MAX_RSSI = 201;
    private static final int MIN_RSSI = 156;
    public static final String NETWORK_IDS_CHANGED_ACTION = "android.net.wifi.NETWORK_IDS_CHANGED";
    public static final String NETWORK_STATE_CHANGED_ACTION = "android.net.wifi.STATE_CHANGE";
    public static final String RSSI_CHANGED_ACTION = "android.net.wifi.RSSI_CHANGED";
    public static final String SCAN_RESULTS_AVAILABLE_ACTION = "android.net.wifi.SCAN_RESULTS";
    public static final String SUPPLICANT_CONNECTION_CHANGE_ACTION = "android.net.wifi.supplicant.CONNECTION_CHANGE";
    public static final String SUPPLICANT_STATE_CHANGED_ACTION = "android.net.wifi.supplicant.STATE_CHANGE";
    public static final String WIFI_AP_STATE_CHANGED_ACTION = "android.net.wifi.WIFI_AP_STATE_CHANGED";
    public static final int WIFI_AP_STATE_DISABLED = 1;
    public static final int WIFI_AP_STATE_DISABLING = 0;
    public static final int WIFI_AP_STATE_ENABLED = 3;
    public static final int WIFI_AP_STATE_ENABLING = 2;
    public static final int WIFI_AP_STATE_FAILED = 4;
    public static final int WIFI_MODE_FULL = 1;
    public static final int WIFI_MODE_FULL_HIGH_PERF = 3;
    public static final int WIFI_MODE_SCAN_ONLY = 2;
    public static final String WIFI_STATE_CHANGED_ACTION = "android.net.wifi.WIFI_STATE_CHANGED";
    public static final int WIFI_STATE_DISABLED = 1;
    public static final int WIFI_STATE_DISABLING = 0;
    public static final int WIFI_STATE_ENABLED = 3;
    public static final int WIFI_STATE_ENABLING = 2;
    public static final int WIFI_STATE_UNKNOWN = 4;
    private int mActiveLockCount;
    Handler mHandler;
    IWifiManager mService;

    public WifiManager(IWifiManager iWifiManager, Handler handler) {
        this.mService = iWifiManager;
        this.mHandler = handler;
    }

    static /* synthetic */ int access$000(WifiManager wifiManager) {
        return wifiManager.mActiveLockCount;
    }

    static /* synthetic */ int access$008(WifiManager wifiManager) {
        int n;
        int n2 = wifiManager.mActiveLockCount;
        wifiManager.mActiveLockCount = n = n2 + 1;
        return n2;
    }

    static /* synthetic */ int access$010(WifiManager wifiManager) {
        int n;
        int n2 = wifiManager.mActiveLockCount;
        wifiManager.mActiveLockCount = n = n2 - 1;
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int addOrUpdateNetwork(WifiConfiguration wifiConfiguration) {
        try {
            int n = this.mService.addOrUpdateNetwork(wifiConfiguration);
            return n;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int calculateSignalLevel(int n, int n2) {
        if (n <= 65436) {
            return 0;
        }
        if (n >= 65481) {
            return n2 - 1;
        }
        int n3 = n2 - 1;
        int n4 = 45 / n3;
        return (n - 65436) / n4;
    }

    public static int compareSignalLevel(int n, int n2) {
        return n - n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int addNetwork(WifiConfiguration wifiConfiguration) {
        int n = -1;
        if (wifiConfiguration == null) {
            return n;
        }
        wifiConfiguration.networkId = -1;
        return this.addOrUpdateNetwork(wifiConfiguration);
    }

    public MulticastLock createMulticastLock(String string2) {
        return new MulticastLock(string2);
    }

    public WifiLock createWifiLock(int n, String string2) {
        return new WifiLock(n, string2);
    }

    public WifiLock createWifiLock(String string2) {
        return new WifiLock(1, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disableNetwork(int n) {
        try {
            boolean bl = this.mService.disableNetwork(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnect() {
        try {
            boolean bl = this.mService.disconnect();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enableNetwork(int n, boolean bl) {
        try {
            boolean bl2 = this.mService.enableNetwork(n, bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<WifiConfiguration> getConfiguredNetworks() {
        try {
            List<WifiConfiguration> list = this.mService.getConfiguredNetworks();
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WifiInfo getConnectionInfo() {
        try {
            WifiInfo wifiInfo = this.mService.getConnectionInfo();
            return wifiInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DhcpInfo getDhcpInfo() {
        try {
            DhcpInfo dhcpInfo = this.mService.getDhcpInfo();
            return dhcpInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getNumAllowedChannels() {
        try {
            int n = this.mService.getNumAllowedChannels();
            return n;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ScanResult> getScanResults() {
        try {
            List<ScanResult> list = this.mService.getScanResults();
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] getValidChannelCounts() {
        try {
            int[] nArray = this.mService.getValidChannelCounts();
            return nArray;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WifiConfiguration getWifiApConfiguration() {
        try {
            WifiConfiguration wifiConfiguration = this.mService.getWifiApConfiguration();
            return wifiConfiguration;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getWifiApState() {
        try {
            int n = this.mService.getWifiApEnabledState();
            return n;
        }
        catch (RemoteException remoteException) {
            return 4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getWifiState() {
        try {
            int n = this.mService.getWifiEnabledState();
            return n;
        }
        catch (RemoteException remoteException) {
            return 4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean initializeMulticastFiltering() {
        try {
            this.mService.initializeMulticastFiltering();
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMulticastEnabled() {
        try {
            boolean bl = this.mService.isMulticastEnabled();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isWifiApEnabled() {
        if (this.getWifiApState() != 3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isWifiEnabled() {
        if (this.getWifiState() != 3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean pingSupplicant() {
        if (this.mService == null) {
            return false;
        }
        try {
            boolean bl = this.mService.pingSupplicant();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean reassociate() {
        try {
            boolean bl = this.mService.reassociate();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean reconnect() {
        try {
            boolean bl = this.mService.reconnect();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeNetwork(int n) {
        try {
            boolean bl = this.mService.removeNetwork(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean saveConfiguration() {
        try {
            boolean bl = this.mService.saveConfiguration();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setNumAllowedChannels(int n, boolean bl) {
        try {
            boolean bl2 = this.mService.setNumAllowedChannels(n, bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setWifiApConfiguration(WifiConfiguration wifiConfiguration) {
        try {
            this.mService.setWifiApConfiguration(wifiConfiguration);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setWifiApEnabled(WifiConfiguration wifiConfiguration, boolean bl) {
        try {
            boolean bl2 = this.mService.setWifiApEnabled(wifiConfiguration, bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setWifiEnabled(boolean bl) {
        try {
            boolean bl2 = this.mService.setWifiEnabled(bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean startScan() {
        try {
            this.mService.startScan(false);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean startScanActive() {
        try {
            this.mService.startScan(true);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateNetwork(WifiConfiguration wifiConfiguration) {
        if (wifiConfiguration == null) return -1;
        if (wifiConfiguration.networkId >= 0) return this.addOrUpdateNetwork(wifiConfiguration);
        return -1;
    }

    public class MulticastLock {
        private final IBinder mBinder;
        private boolean mHeld;
        private int mRefCount;
        private boolean mRefCounted;
        private String mTag;

        private MulticastLock(String string2) {
            this.mTag = string2;
            Binder binder = new Binder();
            this.mBinder = binder;
            this.mRefCount = 0;
            this.mRefCounted = true;
            this.mHeld = false;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void acquire() {
            var1_1 = this.mBinder;
            synchronized (var1_1) {
                block16: {
                    if (!this.mRefCounted) break block16;
                    this.mRefCount = var2_2 = this.mRefCount + 1;
                    if (var2_2 <= 0) ** GOTO lbl24
lbl6:
                    // 2 sources

                    while (true) {
                        block14: {
                            try {
                                var3_3 = WifiManager.this.mService;
                                var4_4 = this.mBinder;
                                var5_5 = this.mTag;
                                var3_3.acquireMulticastLock(var4_4, var5_5);
                                var6_6 = WifiManager.this;
                                synchronized (var6_6) {
                                }
                            }
                            catch (RemoteException var8_7) lbl-1000:
                            // 2 sources

                            {
                                while (true) {
                                    var2_2 = 1;
                                    this.mHeld = var2_2;
                                    break block14;
                                    break;
                                }
                            }
                            {
                                if (WifiManager.access$000(WifiManager.this) >= 50) {
                                    WifiManager.this.mService.releaseMulticastLock();
                                    throw new UnsupportedOperationException("Exceeded maximum number of wifi locks");
                                }
                                ** break block15
                            }
                        }
                        return;
                    }
                }
                if ((var2_2 = this.mHeld) != 0) ** continue;
                ** continue;
lbl-1000:
                // 1 sources

                {
                    var9_8 = WifiManager.access$008(WifiManager.this);
                }
                ** continue;
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.setReferenceCounted(false);
            this.release();
        }

        public boolean isHeld() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                boolean bl = this.mHeld;
                return bl;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void release() {
            block13: {
                block14: {
                    int n;
                    block12: {
                        IBinder iBinder = this.mBinder;
                        // MONITORENTER : iBinder
                        if (!this.mRefCounted) break block12;
                        this.mRefCount = n = this.mRefCount - 1;
                        if (n != 0) break block13;
                        break block14;
                    }
                    n = this.mHeld;
                    if (n == 0) break block13;
                }
                try {
                    WifiManager.this.mService.releaseMulticastLock();
                    WifiManager wifiManager = WifiManager.this;
                    // MONITORENTER : wifiManager
                }
                catch (RemoteException remoteException) {}
                int n = WifiManager.access$010(WifiManager.this);
                // MONITOREXIT : wifiManager
                Object var2_4 = null;
                this.mHeld = var2_4;
            }
            if (this.mRefCount < 0) {
                StringBuilder stringBuilder = new StringBuilder().append("MulticastLock under-locked ");
                String string2 = this.mTag;
                String string3 = stringBuilder.append(string2).toString();
                throw new RuntimeException(string3);
            }
            // MONITOREXIT : iBinder
        }

        public void setReferenceCounted(boolean bl) {
            this.mRefCounted = bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String toString() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                String string2;
                String string3 = Integer.toHexString(System.identityHashCode(this));
                String string4 = this.mHeld ? "held; " : "";
                if (this.mRefCounted) {
                    StringBuilder stringBuilder = new StringBuilder().append("refcounted: refcount = ");
                    int n = this.mRefCount;
                    string2 = stringBuilder.append(n).toString();
                    return "MulticastLock{ " + string3 + "; " + string4 + string2 + " }";
                } else {
                    string2 = "not refcounted";
                }
                return "MulticastLock{ " + string3 + "; " + string4 + string2 + " }";
            }
        }
    }

    public class WifiLock {
        private final IBinder mBinder;
        private boolean mHeld;
        int mLockType;
        private int mRefCount;
        private boolean mRefCounted;
        private String mTag;
        private WorkSource mWorkSource;

        private WifiLock(int n, String string2) {
            this.mTag = string2;
            this.mLockType = n;
            Binder binder = new Binder();
            this.mBinder = binder;
            this.mRefCount = 0;
            this.mRefCounted = true;
            this.mHeld = false;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void acquire() {
            var1_1 = this.mBinder;
            synchronized (var1_1) {
                block16: {
                    if (!this.mRefCounted) break block16;
                    this.mRefCount = var2_2 = this.mRefCount + 1;
                    if (var2_2 <= 0) ** GOTO lbl28
lbl6:
                    // 2 sources

                    while (true) {
                        block14: {
                            try {
                                var3_3 = WifiManager.this.mService;
                                var4_4 = this.mBinder;
                                var5_5 = this.mLockType;
                                var6_6 = this.mTag;
                                var7_7 = this.mWorkSource;
                                var8_8 = var3_3.acquireWifiLock(var4_4, var5_5, var6_6, var7_7);
                                var9_9 = WifiManager.this;
                                synchronized (var9_9) {
                                }
                            }
                            catch (RemoteException var14_13) lbl-1000:
                            // 2 sources

                            {
                                while (true) {
                                    var2_2 = 1;
                                    this.mHeld = var2_2;
                                    break block14;
                                    break;
                                }
                            }
                            {
                                if (WifiManager.access$000(WifiManager.this) >= 50) {
                                    var10_10 = WifiManager.this.mService;
                                    var11_11 = this.mBinder;
                                    var12_12 = var10_10.releaseWifiLock(var11_11);
                                    throw new UnsupportedOperationException("Exceeded maximum number of wifi locks");
                                }
                                ** break block15
                            }
                        }
                        return;
                    }
                }
                if ((var2_2 = this.mHeld) != 0) ** continue;
                ** continue;
lbl-1000:
                // 1 sources

                {
                    var15_14 = WifiManager.access$008(WifiManager.this);
                }
                ** continue;
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        protected void finalize() throws Throwable {
            super.finalize();
            IBinder iBinder = this.mBinder;
            // MONITORENTER : iBinder
            Object object = this.mHeld;
            if (object != null) {
                IWifiManager iWifiManager = WifiManager.this.mService;
                IBinder iBinder2 = this.mBinder;
                boolean bl = iWifiManager.releaseWifiLock(iBinder2);
                object = WifiManager.this;
                // MONITORENTER : object
                int n = WifiManager.access$010(WifiManager.this);
                // MONITOREXIT : object
            }
            // MONITOREXIT : iBinder
            return;
            catch (RemoteException remoteException) {
                return;
            }
        }

        public boolean isHeld() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                boolean bl = this.mHeld;
                return bl;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void release() {
            block13: {
                block14: {
                    int n;
                    block12: {
                        IBinder iBinder = this.mBinder;
                        // MONITORENTER : iBinder
                        if (!this.mRefCounted) break block12;
                        this.mRefCount = n = this.mRefCount - 1;
                        if (n != 0) break block13;
                        break block14;
                    }
                    n = this.mHeld;
                    if (n == 0) break block13;
                }
                try {
                    IWifiManager iWifiManager = WifiManager.this.mService;
                    IBinder iBinder = this.mBinder;
                    boolean bl = iWifiManager.releaseWifiLock(iBinder);
                    WifiManager wifiManager = WifiManager.this;
                    // MONITORENTER : wifiManager
                }
                catch (RemoteException remoteException) {}
                int n = WifiManager.access$010(WifiManager.this);
                // MONITOREXIT : wifiManager
                Object var2_4 = null;
                this.mHeld = var2_4;
            }
            if (this.mRefCount < 0) {
                StringBuilder stringBuilder = new StringBuilder().append("WifiLock under-locked ");
                String string2 = this.mTag;
                String string3 = stringBuilder.append(string2).toString();
                throw new RuntimeException(string3);
            }
            // MONITOREXIT : iBinder
        }

        public void setReferenceCounted(boolean bl) {
            this.mRefCounted = bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setWorkSource(WorkSource workSource) {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                boolean bl;
                if (workSource != null && workSource.size() == 0) {
                    workSource = null;
                }
                boolean bl2 = true;
                if (workSource == null) {
                    this.mWorkSource = null;
                } else if (this.mWorkSource == null) {
                    WorkSource workSource2;
                    bl2 = this.mWorkSource != null;
                    this.mWorkSource = workSource2 = new WorkSource(workSource);
                } else {
                    bl2 = this.mWorkSource.diff(workSource);
                    if (bl2) {
                        this.mWorkSource.set(workSource);
                    }
                }
                if (bl2 && (bl = this.mHeld)) {
                    try {
                        IWifiManager iWifiManager = WifiManager.this.mService;
                        IBinder iBinder2 = this.mBinder;
                        WorkSource workSource3 = this.mWorkSource;
                        iWifiManager.updateWifiLockWorkSource(iBinder2, workSource3);
                    }
                    catch (RemoteException remoteException) {}
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String toString() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                String string2;
                String string3 = Integer.toHexString(System.identityHashCode(this));
                String string4 = this.mHeld ? "held; " : "";
                if (this.mRefCounted) {
                    StringBuilder stringBuilder = new StringBuilder().append("refcounted: refcount = ");
                    int n = this.mRefCount;
                    string2 = stringBuilder.append(n).toString();
                    return "WifiLock{ " + string3 + "; " + string4 + string2 + " }";
                } else {
                    string2 = "not refcounted";
                }
                return "WifiLock{ " + string3 + "; " + string4 + string2 + " }";
            }
        }
    }
}

