/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiNative;
import android.net.wifi.WifiStateTracker;
import android.util.Log;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WifiMonitor {
    private static final int CONNECTED = 1;
    private static final int DISCONNECTED = 2;
    private static final int DRIVER_STATE = 7;
    private static final int LINK_SPEED = 5;
    private static final int MAX_RECV_ERRORS = 10;
    private static final int SCAN_RESULTS = 4;
    private static final int STATE_CHANGE = 3;
    private static final String TAG = "WifiMonitor";
    private static final int TERMINATING = 6;
    private static final int UNKNOWN = 8;
    private static final String connectedEvent = "CONNECTED";
    private static final String disconnectedEvent = "DISCONNECTED";
    private static final String driverStateEvent = "DRIVER-STATE";
    private static final String eventPrefix = "CTRL-EVENT-";
    private static final int eventPrefixLen = 0;
    private static final String linkSpeedEvent = "LINK-SPEED";
    private static Pattern mConnectedEventPattern;
    private static final String monitorSocketClosed = "connection closed";
    private static final String passwordKeyMayBeIncorrectEvent = "pre-shared key may be incorrect";
    private static final String scanResultsEvent = "SCAN-RESULTS";
    private static final String stateChangeEvent = "STATE-CHANGE";
    private static final String terminatingEvent = "TERMINATING";
    private static final String wpaEventPrefix = "WPA:";
    private static final String wpaRecvError = "recv error";
    private int mRecvErrors = 0;
    private final WifiStateTracker mWifiStateTracker;

    static {
        eventPrefixLen = eventPrefix.length();
        mConnectedEventPattern = Pattern.compile("((?:[0-9a-f]{2}:){5}[0-9a-f]{2}) .* \\[id=([0-9]+) ");
    }

    public WifiMonitor(WifiStateTracker wifiStateTracker) {
        this.mWifiStateTracker = wifiStateTracker;
    }

    static /* synthetic */ int access$202(WifiMonitor wifiMonitor, int n) {
        wifiMonitor.mRecvErrors = n;
        return n;
    }

    static /* synthetic */ int access$204(WifiMonitor wifiMonitor) {
        int n;
        wifiMonitor.mRecvErrors = n = wifiMonitor.mRecvErrors + 1;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleNetworkStateChange(NetworkInfo.DetailedState detailedState, String string2) {
        String string3 = null;
        int n = -1;
        NetworkInfo.DetailedState detailedState2 = NetworkInfo.DetailedState.CONNECTED;
        if (detailedState == detailedState2) {
            Matcher matcher = mConnectedEventPattern.matcher(string2);
            if (!matcher.find()) {
                int n2 = Log.d(TAG, "Could not find BSSID in CONNECTED event string");
            } else {
                string3 = matcher.group(1);
                int n3 = 2;
                try {
                    int n4;
                    n = n4 = Integer.parseInt(matcher.group(n3));
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
            }
        }
        this.mWifiStateTracker.notifyStateChange(detailedState, string3, n);
    }

    private static void nap(int n) {
        long l = n * 1000;
        try {
            Thread.sleep(l);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public NetworkStateTracker getNetworkStateTracker() {
        return this.mWifiStateTracker;
    }

    public void startMonitoring() {
        new MonitorThread().start();
    }

    class MonitorThread
    extends Thread {
        public MonitorThread() {
            super(WifiMonitor.TAG);
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean connectToSupplicant() {
            int n = 0;
            while (!WifiMonitor.this.mWifiStateTracker.connectToSupplicant()) {
                int n2 = n + 1;
                if (n >= 3) {
                    boolean bl = false;
                    int n3 = n2;
                    return bl;
                }
                WifiMonitor.nap(5);
                n = n2;
            }
            return true;
        }

        private void handleDriverEvent(String string2) {
            if (string2 == null) {
                return;
            }
            if (string2.equals("STOPPED")) {
                WifiMonitor.this.mWifiStateTracker.notifyDriverStopped();
                return;
            }
            if (string2.equals("STARTED")) {
                WifiMonitor.this.mWifiStateTracker.notifyDriverStarted();
                return;
            }
            if (!string2.equals("HANGED")) {
                return;
            }
            WifiMonitor.this.mWifiStateTracker.notifyDriverHung();
        }

        private void handlePasswordKeyMayBeIncorrect() {
            WifiMonitor.this.mWifiStateTracker.notifyPasswordKeyMayBeIncorrect();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleSupplicantStateChange(String string2) {
            String string3 = string2;
            String string4 = " ";
            String[] stringArray = string3.split(string4);
            String string5 = null;
            int n = -1;
            int n2 = -1;
            for (String string6 : stringArray) {
                int n3;
                int n4;
                String[] stringArray2 = string6.split("=");
                int n5 = stringArray2.length;
                if (n5 != (n4 = 2)) continue;
                if (stringArray2[0].equals("BSSID")) {
                    string5 = stringArray2[1];
                    continue;
                }
                int n6 = 1;
                try {
                    int n7;
                    n3 = n7 = Integer.parseInt(stringArray2[n6]);
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuilder stringBuilder = new StringBuilder().append("STATE-CHANGE non-integer parameter: ");
                    String string7 = string6;
                    String string8 = stringBuilder.append(string7).toString();
                    int n8 = Log.w(WifiMonitor.TAG, string8);
                    continue;
                }
                if (stringArray2[0].equals("id")) {
                    n = n3;
                    continue;
                }
                if (!stringArray2[0].equals("state")) continue;
                n2 = n3;
            }
            if (n2 == -1) {
                return;
            }
            Object object = SupplicantState.INVALID;
            Object[] objectArray = SupplicantState.values();
            int n9 = objectArray.length;
            int n10 = 0;
            while (true) {
                block13: {
                    SupplicantState supplicantState;
                    block12: {
                        if (n10 >= n9) break block12;
                        Object object2 = objectArray[n10];
                        if (((Enum)object2).ordinal() == n2) break block13;
                        object = object2;
                    }
                    if (object == (supplicantState = SupplicantState.INVALID)) {
                        StringBuilder stringBuilder = new StringBuilder().append("Invalid supplicant state: ");
                        int n11 = n2;
                        String string9 = stringBuilder.append(n11).toString();
                        int n12 = Log.w(WifiMonitor.TAG, string9);
                    }
                    WifiMonitor.this.mWifiStateTracker.notifyStateChange(n, string5, (SupplicantState)object);
                    return;
                }
                ++n10;
            }
        }

        void handleEvent(int n, String string2) {
            switch (n) {
                default: {
                    return;
                }
                case 2: {
                    WifiMonitor wifiMonitor = WifiMonitor.this;
                    NetworkInfo.DetailedState detailedState = NetworkInfo.DetailedState.DISCONNECTED;
                    wifiMonitor.handleNetworkStateChange(detailedState, string2);
                    return;
                }
                case 1: {
                    WifiMonitor wifiMonitor = WifiMonitor.this;
                    NetworkInfo.DetailedState detailedState = NetworkInfo.DetailedState.CONNECTED;
                    wifiMonitor.handleNetworkStateChange(detailedState, string2);
                    return;
                }
                case 4: 
            }
            WifiMonitor.this.mWifiStateTracker.notifyScanResultsAvailable();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            if (!this.connectToSupplicant()) {
                WifiMonitor.this.mWifiStateTracker.notifySupplicantLost();
                return;
            }
            WifiMonitor.this.mWifiStateTracker.notifySupplicantConnection();
            while (true) {
                int n;
                String string2;
                if ((string2 = WifiNative.waitForEvent()).indexOf(WifiMonitor.scanResultsEvent) == -1) {
                    String string3 = "Event [" + string2 + "]";
                    int n2 = Log.v(WifiMonitor.TAG, string3);
                }
                if (!string2.startsWith(WifiMonitor.eventPrefix)) {
                    if (!string2.startsWith(WifiMonitor.wpaEventPrefix) || string2.indexOf(WifiMonitor.passwordKeyMayBeIncorrectEvent) <= 0) continue;
                    this.handlePasswordKeyMayBeIncorrect();
                    continue;
                }
                int n3 = eventPrefixLen;
                String string4 = string2.substring(n3);
                int n4 = string4.indexOf(32);
                if (n4 != -1) {
                    string4 = string4.substring(0, n4);
                }
                if (string4.length() == 0) {
                    int n5 = Log.i(WifiMonitor.TAG, "Received wpa_supplicant event with empty event name");
                    continue;
                }
                int n6 = string4.equals(WifiMonitor.connectedEvent) ? 1 : (string4.equals(WifiMonitor.disconnectedEvent) ? 2 : (string4.equals(WifiMonitor.stateChangeEvent) ? 3 : (string4.equals(WifiMonitor.scanResultsEvent) ? 4 : (string4.equals(WifiMonitor.linkSpeedEvent) ? 5 : (string4.equals(WifiMonitor.terminatingEvent) ? 6 : (string4.equals(WifiMonitor.driverStateEvent) ? 7 : 8))))));
                String string5 = string2;
                if (n6 == 7 || n6 == 5) {
                    string5 = string5.split(" ")[1];
                } else if (n6 == 3) {
                    n = string2.indexOf(" ");
                    if (n != -1) {
                        int n7 = n + 1;
                        string5 = string2.substring(n7);
                    }
                } else {
                    n = string2.indexOf(" - ");
                    if (n != -1) {
                        int n8 = n + 3;
                        string5 = string2.substring(n8);
                    }
                }
                if (n6 == 3) {
                    this.handleSupplicantStateChange(string5);
                } else if (n6 == 7) {
                    this.handleDriverEvent(string5);
                } else {
                    if (n6 == 6) {
                        if (string5.startsWith(WifiMonitor.monitorSocketClosed)) {
                            int n9 = Log.d(WifiMonitor.TAG, "Monitor socket is closed, exiting thread");
                            return;
                        }
                        if (string5.startsWith(WifiMonitor.wpaRecvError)) {
                            if (WifiMonitor.access$204(WifiMonitor.this) <= 10) continue;
                            int n10 = Log.d(WifiMonitor.TAG, "too many recv errors, closing connection");
                        }
                        WifiMonitor.this.mWifiStateTracker.notifySupplicantLost();
                        return;
                    }
                    this.handleEvent(n6, string5);
                }
                int n11 = WifiMonitor.access$202(WifiMonitor.this, 0);
            }
        }
    }
}

