/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.app.ActivityManagerNative;
import android.app.Notification;
import android.app.PendingIntent;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.net.NetworkUtils;
import android.net.Uri;
import android.net.wifi.ScanResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiMonitor;
import android.net.wifi.WifiNative;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.app.IBatteryStats;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class WifiStateTracker
extends NetworkStateTracker {
    private static final int DEFAULT_MAX_DHCP_RETRIES = 9;
    private static final int DISCONNECT_DELAY_MSECS = 5000;
    private static final int DRIVER_HUNG = 2;
    private static final int DRIVER_POWER_MODE_ACTIVE = 1;
    private static final int DRIVER_POWER_MODE_AUTO = 0;
    private static final int DRIVER_STARTED = 0;
    private static final int DRIVER_STOPPED = 1;
    private static final int EVENTLOG_DRIVER_STATE_CHANGED = 50023;
    private static final int EVENTLOG_INTERFACE_CONFIGURATION_STATE_CHANGED = 50024;
    private static final int EVENTLOG_NETWORK_STATE_CHANGED = 50021;
    private static final int EVENTLOG_SUPPLICANT_CONNECTION_STATE_CHANGED = 50025;
    private static final int EVENTLOG_SUPPLICANT_STATE_CHANGED = 50022;
    private static final int EVENT_DEFERRED_DISCONNECT = 10;
    private static final int EVENT_DEFERRED_RECONNECT = 11;
    private static final int EVENT_DHCP_START = 9;
    private static final int EVENT_DRIVER_STATE_CHANGED = 12;
    private static final int EVENT_INTERFACE_CONFIGURATION_FAILED = 7;
    private static final int EVENT_INTERFACE_CONFIGURATION_SUCCEEDED = 6;
    private static final int EVENT_MAYBE_START_SCAN_POST_DISCONNECT = 14;
    private static final int EVENT_NETWORK_STATE_CHANGED = 4;
    private static final int EVENT_PASSWORD_KEY_MAY_BE_INCORRECT = 13;
    private static final int EVENT_POLL_INTERVAL = 8;
    private static final int EVENT_SCAN_RESULTS_AVAILABLE = 5;
    private static final int EVENT_SUPPLICANT_CONNECTION = 1;
    private static final int EVENT_SUPPLICANT_DISCONNECT = 2;
    private static final int EVENT_SUPPLICANT_STATE_CHANGED = 3;
    private static final int ICON_NETWORKS_AVAILABLE = 17302164;
    private static final int KICKSTART_SCANNING_DELAY_MSECS = 15000;
    private static final boolean LOCAL_LOGD = true;
    private static String LS;
    private static final int MAX_SUPPLICANT_LOOP_ITERATIONS = 4;
    private static final int NUM_SCANS_BEFORE_ACTUALLY_SCANNING = 3;
    private static final int POLL_STATUS_INTERVAL_MSECS = 3000;
    private static final int RECONNECT_DELAY_MSECS = 2000;
    private static final int RUN_STATE_RUNNING = 2;
    private static final int RUN_STATE_STARTING = 1;
    private static final int RUN_STATE_STOPPED = 4;
    private static final int RUN_STATE_STOPPING = 3;
    public static final int SUPPL_SCAN_HANDLING_LIST_ONLY = 2;
    public static final int SUPPL_SCAN_HANDLING_NORMAL = 1;
    private static final String TAG = "WifiStateTracker";
    private static final String[] mRunStateNames;
    private static String[] sDnsPropNames;
    private final long NOTIFICATION_REPEAT_DELAY_MS;
    private final IBatteryStats mBatteryStats;
    private BluetoothA2dp mBluetoothA2dp;
    private DhcpInfo mDhcpInfo;
    private DhcpHandler mDhcpTarget;
    private boolean mDisconnectExpected;
    private boolean mDisconnectPending;
    private boolean mEnableRssiPolling;
    private boolean mHaveIpAddress;
    private String mInterfaceName;
    private AtomicBoolean mIsAnyNetworkDisabled;
    private boolean mIsHighPerfEnabled;
    private boolean mIsScanModeActive;
    private boolean mIsScanOnly;
    private String mLastBssid;
    private int mLastNetworkId;
    private final WorkSource mLastRunningWifiUids;
    private int mLastSignalLevel;
    private String mLastSsid;
    private Notification mNotification;
    private boolean mNotificationEnabled;
    private NotificationEnabledSettingObserver mNotificationEnabledSettingObserver;
    private long mNotificationRepeatTime;
    private boolean mNotificationShown;
    private int mNumAllowedChannels;
    private int mNumScansSinceNetworkStateChange;
    private int mNumSupplicantLoopIterations;
    private int mNumSupplicantStateChanges;
    private boolean mObtainingIpAddress;
    private int mOptimizationsDisabledRefCount;
    private boolean mPasswordKeyMayBeIncorrect;
    private int mPowerModeRefCount;
    private int mReconnectCount;
    private boolean mReportedRunning;
    private int mRunState;
    private final WorkSource mRunningWifiUids;
    private List<ScanResult> mScanResults;
    private SettingsObserver mSettingsObserver;
    private SupplicantState mSupplicantLoopState;
    private boolean mTornDownByConnMgr;
    private boolean mUseStaticIp;
    private WifiManager mWM;
    private WifiInfo mWifiInfo;
    private WifiMonitor mWifiMonitor;
    private final AtomicInteger mWifiState;

    static {
        String[] stringArray = new String[]{"Starting", "Running", "Stopping", "Stopped"};
        mRunStateNames = stringArray;
        LS = System.getProperty("line.separator");
    }

    public WifiStateTracker(Context context, Handler handler) {
        IBatteryStats iBatteryStats;
        String string2;
        String string3;
        String string4;
        SettingsObserver settingsObserver;
        NotificationEnabledSettingObserver notificationEnabledSettingObserver;
        long l;
        DhcpInfo dhcpInfo;
        WifiMonitor wifiMonitor;
        WifiInfo wifiInfo;
        WorkSource workSource;
        WorkSource workSource2;
        AtomicInteger atomicInteger;
        AtomicBoolean atomicBoolean;
        SupplicantState supplicantState;
        WifiStateTracker wifiStateTracker = this;
        Context context2 = context;
        Handler handler2 = handler;
        super(context2, handler2, 1, 0, "WIFI", "");
        this.mSupplicantLoopState = supplicantState = SupplicantState.DISCONNECTED;
        this.mNumSupplicantLoopIterations = 0;
        this.mNumSupplicantStateChanges = 0;
        this.mPasswordKeyMayBeIncorrect = false;
        this.mLastSignalLevel = -1;
        this.mLastNetworkId = -1;
        this.mUseStaticIp = false;
        this.mIsAnyNetworkDisabled = atomicBoolean = new AtomicBoolean(false);
        this.mNumAllowedChannels = 0;
        this.mPowerModeRefCount = 0;
        this.mOptimizationsDisabledRefCount = 0;
        this.mWifiState = atomicInteger = new AtomicInteger(4);
        this.mReportedRunning = false;
        this.mRunningWifiUids = workSource2 = new WorkSource();
        this.mLastRunningWifiUids = workSource = new WorkSource();
        this.mWifiInfo = wifiInfo = new WifiInfo();
        this.mWifiMonitor = wifiMonitor = new WifiMonitor(this);
        this.mHaveIpAddress = false;
        this.mObtainingIpAddress = false;
        this.setTornDownByConnMgr(false);
        this.mDisconnectPending = false;
        ArrayList<ScanResult> arrayList = new ArrayList<ScanResult>();
        this.mScanResults = arrayList;
        this.mDhcpInfo = dhcpInfo = new DhcpInfo();
        this.mRunState = 1;
        this.NOTIFICATION_REPEAT_DELAY_MS = l = (long)Settings.Secure.getInt(context.getContentResolver(), "wifi_networks_available_repeat_delay", 900) * 1000L;
        Handler handler3 = new Handler();
        this.mNotificationEnabledSettingObserver = notificationEnabledSettingObserver = new NotificationEnabledSettingObserver(handler3);
        this.mNotificationEnabledSettingObserver.register();
        Handler handler4 = new Handler();
        this.mSettingsObserver = settingsObserver = new SettingsObserver(handler4);
        this.mInterfaceName = string4 = SystemProperties.get("wifi.interface", "tiwlan0");
        String[] stringArray = new String[2];
        StringBuilder stringBuilder = new StringBuilder().append("dhcp.");
        String string5 = this.mInterfaceName;
        stringArray[0] = string3 = stringBuilder.append(string5).append(".dns1").toString();
        StringBuilder stringBuilder2 = new StringBuilder().append("dhcp.");
        String string6 = this.mInterfaceName;
        stringArray[1] = string2 = stringBuilder2.append(string6).append(".dns2").toString();
        sDnsPropNames = stringArray;
        this.mBatteryStats = iBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batteryinfo"));
    }

    static /* synthetic */ boolean access$1202(WifiStateTracker wifiStateTracker, boolean bl) {
        wifiStateTracker.mNotificationEnabled = bl;
        return bl;
    }

    private void cancelDisconnect() {
        this.mDisconnectPending = false;
        this.removeMessages(10);
    }

    private void checkIsBluetoothPlaying() {
        boolean bl = false;
        for (BluetoothDevice bluetoothDevice : this.mBluetoothA2dp.getConnectedSinks()) {
            if (this.mBluetoothA2dp.getSinkState(bluetoothDevice) != 4) continue;
            bl = true;
            break;
        }
        this.setBluetoothScanMode(bl);
    }

    private void checkPollTimer() {
        synchronized (this) {
            SupplicantState supplicantState;
            SupplicantState supplicantState2;
            if (this.mEnableRssiPolling && (supplicantState2 = this.mWifiInfo.getSupplicantState()) == (supplicantState = SupplicantState.COMPLETED) && !this.hasMessages(8)) {
                boolean bl = this.sendEmptyMessageDelayed(8, 3000L);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkUseStaticIp() {
        this.mUseStaticIp = false;
        ContentResolver contentResolver = this.mContext.getContentResolver();
        try {
            int n = Settings.System.getInt(contentResolver, "wifi_use_static_ip");
            if (n == 0) {
                return;
            }
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return;
        }
        try {
            int n;
            int n2;
            int n3;
            int n4;
            String string2 = Settings.System.getString(contentResolver, "wifi_static_ip");
            if (string2 == null) {
                return;
            }
            DhcpInfo dhcpInfo = this.mDhcpInfo;
            dhcpInfo.ipAddress = n4 = WifiStateTracker.stringToIpAddr(string2);
            string2 = Settings.System.getString(contentResolver, "wifi_static_gateway");
            if (string2 == null) {
                return;
            }
            DhcpInfo dhcpInfo2 = this.mDhcpInfo;
            dhcpInfo2.gateway = n3 = WifiStateTracker.stringToIpAddr(string2);
            string2 = Settings.System.getString(contentResolver, "wifi_static_netmask");
            if (string2 == null) {
                return;
            }
            DhcpInfo dhcpInfo3 = this.mDhcpInfo;
            dhcpInfo3.netmask = n2 = WifiStateTracker.stringToIpAddr(string2);
            string2 = Settings.System.getString(contentResolver, "wifi_static_dns1");
            if (string2 == null) {
                return;
            }
            DhcpInfo dhcpInfo4 = this.mDhcpInfo;
            dhcpInfo4.dns1 = n = WifiStateTracker.stringToIpAddr(string2);
            string2 = Settings.System.getString(contentResolver, "wifi_static_dns2");
            if (string2 != null) {
                int n5;
                DhcpInfo dhcpInfo5 = this.mDhcpInfo;
                dhcpInfo5.dns2 = n5 = WifiStateTracker.stringToIpAddr(string2);
            } else {
                this.mDhcpInfo.dns2 = 0;
            }
            this.mUseStaticIp = true;
            return;
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void configureInterface() {
        int n;
        this.checkPollTimer();
        this.mLastSignalLevel = -1;
        if (!this.mUseStaticIp) {
            if (this.mHaveIpAddress) {
                return;
            }
            if (this.mObtainingIpAddress) {
                return;
            }
            this.mObtainingIpAddress = true;
            boolean bl = this.mDhcpTarget.sendEmptyMessage(9);
            return;
        }
        String string2 = this.mInterfaceName;
        DhcpInfo dhcpInfo = this.mDhcpInfo;
        if (NetworkUtils.configureInterface(string2, dhcpInfo)) {
            this.mHaveIpAddress = true;
            n = 6;
            int n2 = Log.v(TAG, "Static IP configuration succeeded");
        } else {
            this.mHaveIpAddress = false;
            n = 7;
            int n3 = Log.v(TAG, "Static IP configuration failed");
        }
        boolean bl = this.sendEmptyMessage(n);
    }

    private int getMaxDhcpRetries() {
        return Settings.Secure.getInt(this.mContext.getContentResolver(), "wifi_max_dhcp_retry_count", 9);
    }

    private void handleDisconnectedState(NetworkInfo.DetailedState detailedState, boolean bl) {
        if (this.mDisconnectPending) {
            this.cancelDisconnect();
        }
        this.mDisconnectExpected = false;
        this.resetConnections(bl);
        this.setDetailedState(detailedState);
        String string2 = this.mLastBssid;
        this.sendNetworkStateChangeBroadcast(string2);
        this.mWifiInfo.setBSSID(null);
        this.mLastBssid = null;
        this.mLastSsid = null;
        this.mDisconnectPending = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isSupplicantLooping(SupplicantState supplicantState) {
        int n;
        int n2;
        int n3;
        int n4 = SupplicantState.ASSOCIATING.ordinal();
        if (n4 <= (n3 = supplicantState.ordinal()) && (n2 = supplicantState.ordinal()) < (n = SupplicantState.COMPLETED.ordinal())) {
            if (this.mSupplicantLoopState != supplicantState) {
                int n5;
                int n6 = supplicantState.ordinal();
                if (n6 < (n5 = this.mSupplicantLoopState.ordinal())) {
                    int n7;
                    this.mNumSupplicantLoopIterations = n7 = this.mNumSupplicantLoopIterations + 1;
                }
                this.mSupplicantLoopState = supplicantState;
            }
        } else {
            SupplicantState supplicantState2 = SupplicantState.COMPLETED;
            if (supplicantState == supplicantState2) {
                this.resetSupplicantLoopState();
            }
        }
        if (this.mNumSupplicantLoopIterations < 4) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void requestConnectionStatus(WifiInfo wifiInfo) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = -1;
        String string5 = this.status();
        if (string5 != null) {
            String[] stringArray = string5.split("\n");
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3;
                String[] stringArray2 = stringArray[i].split(" *= *");
                int n4 = stringArray2.length;
                if (n4 < (n3 = 2)) continue;
                String string6 = stringArray2[0];
                String string7 = stringArray2[1];
                if (string6.equalsIgnoreCase("id")) {
                    n = Integer.parseInt(string7);
                    continue;
                }
                if (string6.equalsIgnoreCase("ssid")) {
                    string2 = string7;
                    continue;
                }
                if (string6.equalsIgnoreCase("bssid")) {
                    string3 = string7;
                    continue;
                }
                if (!string6.equalsIgnoreCase("wpa_state")) continue;
                string4 = string7;
            }
        }
        WifiInfo wifiInfo2 = wifiInfo;
        int n5 = n;
        wifiInfo2.setNetworkId(n5);
        WifiInfo wifiInfo3 = wifiInfo;
        String string8 = string2;
        wifiInfo3.setSSID(string8);
        WifiInfo wifiInfo4 = wifiInfo;
        String string9 = string3;
        wifiInfo4.setBSSID(string9);
        SupplicantState supplicantState = this.mWifiInfo.getSupplicantState();
        SupplicantState supplicantState2 = SupplicantState.UNINITIALIZED;
        SupplicantState supplicantState3 = supplicantState;
        SupplicantState supplicantState4 = supplicantState2;
        if (supplicantState3 != supplicantState4) {
            return;
        }
        if (string4 == null) {
            return;
        }
        WifiStateTracker wifiStateTracker = this;
        String string10 = string4;
        wifiStateTracker.setSupplicantState(string10);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void requestPolledInfo(WifiInfo wifiInfo, boolean bl) {
        synchronized (this) {
            int n;
            int n2 = bl ? this.getRssiApprox() : this.getRssi();
            if (n2 != -1 && 65336 < n2 && n2 < 256) {
                if (n2 > 0) {
                    n2 += -256;
                }
                wifiInfo.setRssi(n2);
                int n3 = WifiManager.calculateSignalLevel(n2, 4);
                int n4 = this.mLastSignalLevel;
                if (n3 != n4) {
                    this.sendRssiChangeBroadcast(n2);
                }
                this.mLastSignalLevel = n3;
            } else {
                wifiInfo.setRssi(65336);
            }
            if ((n = this.getLinkSpeed()) != -1) {
                wifiInfo.setLinkSpeed(n);
            }
            return;
        }
    }

    private void resetNotificationTimer() {
        this.mNotificationRepeatTime = 0L;
        this.mNumScansSinceNetworkStateChange = 0;
    }

    private void resetSupplicantLoopState() {
        this.mNumSupplicantLoopIterations = 0;
    }

    private void scheduleDisconnect() {
        this.mDisconnectPending = true;
        if (this.hasMessages(10)) {
            return;
        }
        boolean bl = this.sendEmptyMessageDelayed(10, 5000L);
    }

    private void sendNetworkStateChangeBroadcast(String string2) {
        Intent intent = new Intent("android.net.wifi.STATE_CHANGE");
        Intent intent2 = intent.addFlags(0x30000000);
        NetworkInfo networkInfo = this.mNetworkInfo;
        Intent intent3 = intent.putExtra("networkInfo", networkInfo);
        if (string2 != null) {
            Intent intent4 = intent.putExtra("bssid", string2);
        }
        this.mContext.sendStickyBroadcast(intent);
    }

    private void sendRssiChangeBroadcast(int n) {
        if (!ActivityManagerNative.isSystemReady()) {
            return;
        }
        Intent intent = new Intent("android.net.wifi.RSSI_CHANGED");
        Intent intent2 = intent.putExtra("newRssi", n);
        this.mContext.sendBroadcast(intent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setPowerMode(int n) {
        synchronized (this) {
            block9: {
                boolean bl;
                switch (n) {
                    case 1: {
                        int n2;
                        this.mPowerModeRefCount = n2 = this.mPowerModeRefCount + 1;
                        break;
                    }
                    case 0: {
                        int n3;
                        this.mPowerModeRefCount = n3 = this.mPowerModeRefCount - 1;
                        if (this.mPowerModeRefCount > 0) break block9;
                        this.mPowerModeRefCount = 0;
                    }
                }
                if (this.mWifiState.get() == 3 && !(bl = this.isDriverStopped())) {
                    boolean bl2 = WifiNative.setPowerModeCommand(n);
                }
            }
            return;
        }
    }

    private void setSupplicantState(SupplicantState supplicantState) {
        this.mWifiInfo.setSupplicantState(supplicantState);
        this.updateNetworkInfo();
        this.checkPollTimer();
    }

    private void setSupplicantState(String string2) {
        this.mWifiInfo.setSupplicantState(string2);
        this.updateNetworkInfo();
        this.checkPollTimer();
    }

    private void setTornDownByConnMgr(boolean bl) {
        this.mTornDownByConnMgr = bl;
        this.updateNetworkInfo();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int stringToIpAddr(String string2) throws UnknownHostException {
        String[] stringArray;
        try {
            stringArray = string2.split("\\.");
            if (stringArray.length != 4) {
                throw new UnknownHostException(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new UnknownHostException(string2);
        }
        int n = 0;
        {
            int n2 = Integer.parseInt(stringArray[n]);
            int n3 = Integer.parseInt(stringArray[1]) << 8;
            int n4 = Integer.parseInt(stringArray[2]) << 16;
            int n5 = Integer.parseInt(stringArray[3]);
            int n6 = n5 << 24;
            return n2 | n3 | n4 | n6;
        }
    }

    private void updateNetworkInfo() {
        NetworkInfo networkInfo = this.mNetworkInfo;
        boolean bl = this.isAvailable();
        networkInfo.setIsAvailable(bl);
    }

    private boolean wifiManagerDisableNetwork(int n) {
        boolean bl = false;
        if (n >= 0 && (bl = this.mWM.disableNetwork(n))) {
            String string2 = "Disabled network: " + n;
            int n2 = Log.v(TAG, string2);
        }
        if (!bl) {
            String string3 = "Failed to disable network: invalid network id: " + n;
            int n3 = Log.e(TAG, string3);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int addNetwork() {
        synchronized (this) {
            int n;
            block4: {
                n = this.mWifiState.get();
                if (n == 3) break block4;
                return -1;
            }
            n = WifiNative.addNetworkCommand();
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addToBlacklist(String string2) {
        synchronized (this) {
            int n;
            block4: {
                n = this.mWifiState.get();
                if (n == 3) break block4;
                return 0 != 0;
            }
            n = WifiNative.addToBlacklistCommand(string2) ? 1 : 0;
            return n != 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean clearBlacklist() {
        synchronized (this) {
            block4: {
                int n = this.mWifiState.get();
                if (n == 3) break block4;
                return false;
            }
            boolean bl = WifiNative.clearBlacklistCommand();
            return bl;
        }
    }

    public void closeSupplicantConnection() {
        synchronized (this) {
            WifiNative.closeSupplicantConnection();
            return;
        }
    }

    public boolean connectToSupplicant() {
        synchronized (this) {
            boolean bl;
            boolean bl2 = bl = WifiNative.connectToSupplicant();
            return bl2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disableNetwork(int n) {
        synchronized (this) {
            int n2;
            block4: {
                n2 = this.mWifiState.get();
                if (n2 == 3) break block4;
                return 0 != 0;
            }
            this.mIsAnyNetworkDisabled.set(true);
            n2 = WifiNative.disableNetworkCommand(n) ? 1 : 0;
            return n2 != 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnect() {
        synchronized (this) {
            boolean bl;
            block4: {
                if (this.mWifiState.get() != 3) return false;
                bl = this.isDriverStopped();
                if (!bl) break block4;
                return false;
            }
            bl = WifiNative.disconnectCommand();
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean disconnectAndStop() {
        synchronized (this) {
            boolean bl = true;
            if (this.mRunState != 3 && this.mRunState != 4) {
                boolean bl2;
                this.setNotificationVisible(false, 0, false, 0);
                SupplicantState supplicantState = this.mWifiInfo.getSupplicantState();
                SupplicantState supplicantState2 = SupplicantState.DORMANT;
                bl = supplicantState == supplicantState2 ? this.stopDriver() : (bl2 = this.disconnect());
                this.mRunState = 3;
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enableAllNetworks(List<WifiConfiguration> list) {
        synchronized (this) {
            int n = this.mWifiState.get();
            if (n == 3) {
                this.mIsAnyNetworkDisabled.set(false);
                for (WifiConfiguration wifiConfiguration : list) {
                    if (wifiConfiguration.status != 1) continue;
                    boolean bl = WifiNative.enableNetworkCommand(wifiConfiguration.networkId, false);
                }
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enableNetwork(int n, boolean bl) {
        synchronized (this) {
            int n2;
            block4: {
                n2 = this.mWifiState.get();
                if (n2 == 3) break block4;
                return 0 != 0;
            }
            n2 = WifiNative.enableNetworkCommand(n, bl) ? 1 : 0;
            if (!bl) return n2 != 0;
            this.mIsAnyNetworkDisabled.set(true);
            return n2 != 0;
        }
    }

    public void enableRssiPolling(boolean bl) {
        if (this.mEnableRssiPolling != bl) {
            return;
        }
        this.mEnableRssiPolling = bl;
        this.checkPollTimer();
    }

    public DhcpInfo getDhcpInfo() {
        return this.mDhcpInfo;
    }

    public String getInterfaceName() {
        return this.mInterfaceName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getLinkSpeed() {
        synchronized (this) {
            int n;
            block4: {
                if (this.mWifiState.get() != 3) return -1;
                n = this.isDriverStopped();
                if (n == 0) break block4;
                return -1;
            }
            n = WifiNative.getLinkSpeedCommand();
            return n;
        }
    }

    @Override
    public String[] getNameServers() {
        return WifiStateTracker.getNameServerList(sDnsPropNames);
    }

    public int getNetworkSubtype() {
        return 0;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNetworkVariable(int n, String string2) {
        synchronized (this) {
            void var4_6;
            int n2 = this.mWifiState.get();
            if (n2 != 3) {
                Object var4_5 = null;
            } else {
                String string3;
                String string4 = string3 = WifiNative.getNetworkVariableCommand(n, string2);
            }
            return var4_6;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getNumAllowedChannels() {
        synchronized (this) {
            int n;
            block4: {
                if (this.mWifiState.get() != 3) return -1;
                n = this.isDriverStopped();
                if (n == 0) break block4;
                return -1;
            }
            n = WifiNative.getNumAllowedChannelsCommand();
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPowerMode() {
        synchronized (this) {
            int n;
            block4: {
                if (this.mWifiState.get() == 3 || (n = this.isDriverStopped()) != 0) break block4;
                return -1;
            }
            n = WifiNative.getPowerModeCommand();
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRssi() {
        synchronized (this) {
            int n;
            block4: {
                if (this.mWifiState.get() != 3) return -1;
                n = this.isDriverStopped();
                if (n == 0) break block4;
                return -1;
            }
            n = WifiNative.getRssiApproxCommand();
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRssiApprox() {
        synchronized (this) {
            int n;
            block4: {
                if (this.mWifiState.get() != 3) return -1;
                n = this.isDriverStopped();
                if (n == 0) break block4;
                return -1;
            }
            n = WifiNative.getRssiApproxCommand();
            return n;
        }
    }

    public List<ScanResult> getScanResultsList() {
        synchronized (this) {
            List<ScanResult> list = this.mScanResults;
            return list;
        }
    }

    public SupplicantState getSupplicantState() {
        return this.mWifiInfo.getSupplicantState();
    }

    @Override
    public String getTcpBufferSizesPropName() {
        return "net.tcp.buffersize.wifi";
    }

    public int getWifiState() {
        return this.mWifiState.get();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void handleMessage(Message var1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 563->565)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean hasIpAddress() {
        return this.mHaveIpAddress;
    }

    @Override
    public void interpretScanResultsAvailable() {
        List<ScanResult> list;
        NetworkInfo.State state;
        NetworkInfo.State state2;
        if (!this.mNotificationEnabled) {
            return;
        }
        NetworkInfo.State state3 = this.getNetworkInfo().getState();
        if ((state3 == (state2 = NetworkInfo.State.DISCONNECTED) || state3 == (state = NetworkInfo.State.UNKNOWN)) && (list = this.getScanResultsList()) != null) {
            int n = 0;
            for (int i = list.size() - 1; i >= 0; i += -1) {
                if (!TextUtils.isEmpty(list.get((int)i).capabilities)) continue;
                ++n;
            }
            if (n > 0) {
                int n2;
                this.mNumScansSinceNetworkStateChange = n2 = this.mNumScansSinceNetworkStateChange + 1;
                if (n2 < 3) {
                    return;
                }
                this.setNotificationVisible(true, n, false, 0);
                return;
            }
        }
        this.setNotificationVisible(false, 0, false, 0);
    }

    public boolean isAnyNetworkDisabled() {
        return this.mIsAnyNetworkDisabled.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAvailable() {
        synchronized (this) {
            SupplicantState supplicantState = this.mWifiInfo.getSupplicantState();
            SupplicantState supplicantState2 = SupplicantState.UNINITIALIZED;
            if (supplicantState == supplicantState2) return false;
            SupplicantState supplicantState3 = SupplicantState.INACTIVE;
            if (supplicantState == supplicantState3) return false;
            if (this.mTornDownByConnMgr) return true;
            boolean bl = this.isDriverStopped();
            if (bl) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnectionCompleted() {
        SupplicantState supplicantState;
        SupplicantState supplicantState2 = this.mWifiInfo.getSupplicantState();
        if (supplicantState2 != (supplicantState = SupplicantState.COMPLETED)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDriverStopped() {
        synchronized (this) {
            if (this.mRunState == 4) return true;
            int n = this.mRunState;
            if (n != 3) return false;
            return true;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String listNetworks() {
        synchronized (this) {
            void var2_4;
            int n = this.mWifiState.get();
            if (n != 3) {
                Object var2_3 = null;
            } else {
                String string2;
                String string3 = string2 = WifiNative.listNetworksCommand();
            }
            return var2_4;
        }
    }

    public boolean loadDriver() {
        synchronized (this) {
            boolean bl;
            boolean bl2 = bl = WifiNative.loadDriver();
            return bl2;
        }
    }

    void notifyDriverHung() {
        Message.obtain(this, 12, 2, 0).sendToTarget();
    }

    void notifyDriverStarted() {
        Message.obtain(this, 12, 0, 0).sendToTarget();
    }

    void notifyDriverStopped() {
        Message.obtain(this, 12, 1, 0).sendToTarget();
    }

    void notifyPasswordKeyMayBeIncorrect() {
        boolean bl = this.sendEmptyMessage(13);
    }

    void notifyScanResultsAvailable() {
        boolean bl = this.setScanResultHandling(1);
        boolean bl2 = this.sendEmptyMessage(5);
    }

    void notifyStateChange(int n, String string2, SupplicantState supplicantState) {
        SupplicantStateChangeResult supplicantStateChangeResult = new SupplicantStateChangeResult(n, string2, supplicantState);
        Message.obtain(this, 3, supplicantStateChangeResult).sendToTarget();
    }

    void notifyStateChange(NetworkInfo.DetailedState detailedState, String string2, int n) {
        NetworkStateChangeResult networkStateChangeResult = new NetworkStateChangeResult(detailedState, string2, n);
        Message.obtain(this, 4, networkStateChangeResult).sendToTarget();
    }

    void notifySupplicantConnection() {
        boolean bl = this.sendEmptyMessage(1);
    }

    void notifySupplicantLost() {
        boolean bl = this.sendEmptyMessage(2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean ping() {
        synchronized (this) {
            block4: {
                int n = this.mWifiState.get();
                if (n == 3) break block4;
                return false;
            }
            boolean bl = WifiNative.pingCommand();
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean reassociate() {
        synchronized (this) {
            boolean bl;
            block4: {
                if (this.mWifiState.get() != 3) return false;
                bl = this.isDriverStopped();
                if (!bl) break block4;
                return false;
            }
            bl = WifiNative.reassociateCommand();
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean reconnect() {
        if (!this.mTornDownByConnMgr) return true;
        if (!this.restart()) return false;
        this.setTornDownByConnMgr(false);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean reconnectCommand() {
        synchronized (this) {
            boolean bl;
            block4: {
                if (this.mWifiState.get() != 3) return false;
                bl = this.isDriverStopped();
                if (!bl) break block4;
                return false;
            }
            bl = WifiNative.reconnectCommand();
            return bl;
        }
    }

    @Override
    public void releaseWakeLock() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean reloadConfig() {
        synchronized (this) {
            block4: {
                int n = this.mWifiState.get();
                if (n == 3) break block4;
                return false;
            }
            boolean bl = WifiNative.reloadConfigCommand();
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeNetwork(int n) {
        synchronized (this) {
            boolean bl;
            block6: {
                int n2 = this.mWifiState.get();
                if (n2 == 3) break block6;
                return false;
            }
            this.mDisconnectExpected = bl = WifiNative.removeNetworkCommand(n);
            return bl;
        }
    }

    public WifiInfo requestConnectionInfo() {
        WifiInfo wifiInfo = this.mWifiInfo;
        this.requestConnectionStatus(wifiInfo);
        WifiInfo wifiInfo2 = this.mWifiInfo;
        this.requestPolledInfo(wifiInfo2, false);
        return this.mWifiInfo;
    }

    public void resetConnections(boolean bl) {
        int n = Log.d(TAG, "Reset connections and stopping DHCP");
        this.mHaveIpAddress = false;
        this.mObtainingIpAddress = false;
        this.mWifiInfo.setIpAddress(0);
        int n2 = NetworkUtils.resetConnections(this.mInterfaceName);
        this.mDhcpTarget.setCancelCallback(true);
        this.mDhcpTarget.removeMessages(9);
        if (!NetworkUtils.stopDhcp(this.mInterfaceName)) {
            int n3 = Log.e(TAG, "Could not stop DHCP");
        }
        if (!bl) {
            return;
        }
        int n4 = Log.d(TAG, "Disabling interface");
        int n5 = NetworkUtils.disableInterface(this.mInterfaceName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean restart() {
        synchronized (this) {
            if (!this.isDriverStopped()) return true;
            this.mRunState = 1;
            this.resetConnections(true);
            boolean bl = this.startDriver();
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean saveConfig() {
        synchronized (this) {
            block4: {
                int n = this.mWifiState.get();
                if (n == 3) break block4;
                return false;
            }
            boolean bl = WifiNative.saveConfigCommand();
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean scan(boolean bl) {
        synchronized (this) {
            boolean bl2;
            block4: {
                if (this.mWifiState.get() != 3) return false;
                bl2 = this.isDriverStopped();
                if (!bl2) break block4;
                return false;
            }
            bl2 = WifiNative.scanCommand(bl);
            return bl2;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String scanResults() {
        synchronized (this) {
            void var2_4;
            boolean bl;
            if (this.mWifiState.get() != 3 || (bl = this.isDriverStopped()) != null) {
                Object var2_3 = null;
            } else {
                String string2;
                String string3 = string2 = WifiNative.scanResultsCommand();
            }
            return var2_4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setBluetoothCoexistenceMode(int n) {
        synchronized (this) {
            boolean bl;
            block4: {
                if (this.mWifiState.get() != 3) return false;
                bl = this.isDriverStopped();
                if (!bl) break block4;
                return false;
            }
            bl = WifiNative.setBluetoothCoexistenceModeCommand(n);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBluetoothScanMode(boolean bl) {
        synchronized (this) {
            block6: {
                boolean bl2;
                if (this.mWifiState.get() == 3 && !(bl2 = this.isDriverStopped())) break block6;
                return;
            }
            boolean bl3 = WifiNative.setBluetoothCoexistenceScanModeCommand(bl);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setHighPerfMode(boolean bl) {
        synchronized (this) {
            if (this.mIsHighPerfEnabled != bl) {
                if (bl) {
                    this.setPowerMode(1);
                    this.setSuspendModeOptimizations(false);
                } else {
                    int n = 0;
                    this.setPowerMode(n);
                    this.setSuspendModeOptimizations(true);
                }
                this.mIsHighPerfEnabled = bl;
                String string2 = "high performance mode: " + bl;
                int n = Log.d(TAG, string2);
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setNetworkVariable(int n, String string2, String string3) {
        synchronized (this) {
            int n2;
            block4: {
                n2 = this.mWifiState.get();
                if (n2 == 3) break block4;
                return 0 != 0;
            }
            n2 = WifiNative.setNetworkVariableCommand(n, string2, string3) ? 1 : 0;
            return n2 != 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setNotificationVisible(boolean bl, int n, boolean bl2, int n2) {
        Message message;
        if (!(bl || this.mNotificationShown || bl2)) {
            return;
        }
        if (bl) {
            long l;
            long l2;
            long l3 = System.currentTimeMillis();
            if (l3 < (l2 = this.mNotificationRepeatTime)) {
                return;
            }
            if (this.mNotification == null) {
                PendingIntent pendingIntent;
                Notification notification;
                this.mNotification = notification = new Notification();
                this.mNotification.when = 0L;
                this.mNotification.icon = 17302164;
                this.mNotification.flags = 16;
                Notification notification2 = this.mNotification;
                Context context = this.mContext;
                Intent intent = new Intent("android.net.wifi.PICK_WIFI_NETWORK");
                notification2.contentIntent = pendingIntent = PendingIntent.getActivity(context, 0, intent, 0);
            }
            CharSequence charSequence = this.mContext.getResources().getQuantityText(0x10F0011, n);
            CharSequence charSequence2 = this.mContext.getResources().getQuantityText(17760274, n);
            this.mNotification.tickerText = charSequence;
            Notification notification = this.mNotification;
            Context context = this.mContext;
            PendingIntent pendingIntent = this.mNotification.contentIntent;
            notification.setLatestEventInfo(context, charSequence, charSequence2, pendingIntent);
            long l4 = System.currentTimeMillis();
            long l5 = this.NOTIFICATION_REPEAT_DELAY_MS;
            this.mNotificationRepeatTime = l = l4 + l5;
            Handler handler = this.mTarget;
            Notification notification3 = this.mNotification;
            message = handler.obtainMessage(3, 1, 17302164, notification3);
        } else {
            Handler handler = this.mTarget;
            Notification notification = this.mNotification;
            handler.removeMessages(3, notification);
            message = this.mTarget.obtainMessage(3, 0, 17302164);
        }
        Handler handler = this.mTarget;
        long l = n2;
        boolean bl3 = handler.sendMessageDelayed(message, l);
        this.mNotificationShown = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setNumAllowedChannels() {
        synchronized (this) {
            if (this.mWifiState.get() != 3) return false;
            boolean bl = this.isDriverStopped();
            if (bl) {
                return false;
            }
            try {
                int n = Settings.Secure.getInt(this.mContext.getContentResolver(), "wifi_num_allowed_channels");
                bl = this.setNumAllowedChannels(n);
                return bl;
            }
            catch (Settings.SettingNotFoundException settingNotFoundException) {
                if (this.mNumAllowedChannels == 0) return true;
                boolean bl2 = WifiNative.setNumAllowedChannelsCommand(this.mNumAllowedChannels);
                return true;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setNumAllowedChannels(int n) {
        synchronized (this) {
            boolean bl;
            block4: {
                if (this.mWifiState.get() != 3) return false;
                bl = this.isDriverStopped();
                if (!bl) break block4;
                return false;
            }
            this.mNumAllowedChannels = n;
            bl = WifiNative.setNumAllowedChannelsCommand(n);
            return bl;
        }
    }

    @Override
    public boolean setRadio(boolean bl) {
        return this.mWM.setWifiEnabled(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setScanMode(boolean bl) {
        synchronized (this) {
            boolean bl2;
            block4: {
                if (this.mWifiState.get() != 3) return false;
                bl2 = this.isDriverStopped();
                if (!bl2) break block4;
                return false;
            }
            if (this.mIsScanModeActive == bl) return true;
            this.mIsScanModeActive = bl;
            bl2 = WifiNative.setScanModeCommand(bl);
            return bl2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setScanOnlyMode(boolean bl) {
        synchronized (this) {
            if (this.mIsScanOnly != bl) {
                int n = bl ? 2 : 1;
                String string2 = "Scan-only mode changing to " + bl + " scanType=" + n;
                int n2 = Log.v(TAG, string2);
                if (this.setScanResultHandling(n)) {
                    this.mIsScanOnly = bl;
                    if (!this.isDriverStopped()) {
                        if (bl) {
                            boolean bl2 = this.disconnect();
                        } else {
                            boolean bl3 = this.reconnectCommand();
                        }
                    }
                }
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setScanResultHandling(int n) {
        synchronized (this) {
            int n2;
            block4: {
                n2 = this.mWifiState.get();
                if (n2 == 3) break block4;
                return 0 != 0;
            }
            n2 = WifiNative.setScanResultHandlingCommand(n) ? 1 : 0;
            return n2 != 0;
        }
    }

    public void setScanResultsList(List<ScanResult> list) {
        synchronized (this) {
            this.mScanResults = list;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSuspendModeOptimizations(boolean bl) {
        synchronized (this) {
            block10: {
                boolean bl2;
                block9: {
                    int n;
                    block8: {
                        int n2;
                        if (bl) break block8;
                        this.mOptimizationsDisabledRefCount = n2 = this.mOptimizationsDisabledRefCount + 1;
                        break block9;
                    }
                    this.mOptimizationsDisabledRefCount = n = this.mOptimizationsDisabledRefCount - 1;
                    if (this.mOptimizationsDisabledRefCount > 0) break block10;
                    this.mOptimizationsDisabledRefCount = 0;
                }
                if (this.mWifiState.get() == 3 && !(bl2 = this.isDriverStopped())) {
                    boolean bl3 = WifiNative.setSuspendOptimizationsCommand(bl);
                }
            }
            return;
        }
    }

    public void setWifiState(int n) {
        this.mWifiState.set(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean startDriver() {
        synchronized (this) {
            block4: {
                int n = this.mWifiState.get();
                if (n == 3) break block4;
                return false;
            }
            boolean bl = WifiNative.startDriverCommand();
            return bl;
        }
    }

    public void startEventLoop() {
        this.mWifiMonitor.startMonitoring();
    }

    @Override
    public void startMonitoring() {
        WifiManager wifiManager;
        this.mWM = wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean startPacketFiltering() {
        synchronized (this) {
            boolean bl;
            block4: {
                if (this.mWifiState.get() != 3) return false;
                bl = this.isDriverStopped();
                if (!bl) break block4;
                return false;
            }
            bl = WifiNative.startPacketFiltering();
            return bl;
        }
    }

    public boolean startSupplicant() {
        synchronized (this) {
            boolean bl;
            boolean bl2 = bl = WifiNative.startSupplicant();
            return bl2;
        }
    }

    @Override
    public int startUsingNetworkFeature(String string2, int n, int n2) {
        return -1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String status() {
        synchronized (this) {
            void var2_4;
            int n = this.mWifiState.get();
            if (n != 3) {
                Object var2_3 = null;
            } else {
                String string2;
                String string3 = string2 = WifiNative.statusCommand();
            }
            return var2_4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean stopDriver() {
        synchronized (this) {
            block4: {
                if (this.mWifiState.get() != 3) return false;
                int n = this.mRunState;
                if (n != 4) break block4;
                return false;
            }
            boolean bl = WifiNative.stopDriverCommand();
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean stopPacketFiltering() {
        synchronized (this) {
            boolean bl;
            block4: {
                if (this.mWifiState.get() != 3) return false;
                bl = this.isDriverStopped();
                if (!bl) break block4;
                return false;
            }
            bl = WifiNative.stopPacketFiltering();
            return bl;
        }
    }

    public boolean stopSupplicant() {
        synchronized (this) {
            boolean bl;
            boolean bl2 = bl = WifiNative.stopSupplicant();
            return bl2;
        }
    }

    @Override
    public int stopUsingNetworkFeature(String string2, int n, int n2) {
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean teardown() {
        if (this.mTornDownByConnMgr) return true;
        if (!this.disconnectAndStop()) return false;
        this.setTornDownByConnMgr(true);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String toString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = stringBuffer.append("interface ");
        String string2 = this.mInterfaceName;
        StringBuffer stringBuffer3 = stringBuffer2.append(string2);
        StringBuffer stringBuffer4 = stringBuffer.append(" runState=");
        if (this.mRunState >= 1 && (n2 = this.mRunState) <= (n = mRunStateNames.length)) {
            String[] stringArray = mRunStateNames;
            int n3 = this.mRunState - 1;
            String string3 = stringArray[n3];
            StringBuffer stringBuffer5 = stringBuffer.append(string3);
        } else {
            int n4 = this.mRunState;
            StringBuffer stringBuffer6 = stringBuffer.append(n4);
        }
        String string4 = LS;
        StringBuffer stringBuffer7 = stringBuffer.append(string4);
        WifiInfo wifiInfo = this.mWifiInfo;
        StringBuffer stringBuffer8 = stringBuffer7.append(wifiInfo);
        String string5 = LS;
        StringBuffer stringBuffer9 = stringBuffer8.append(string5);
        DhcpInfo dhcpInfo = this.mDhcpInfo;
        StringBuffer stringBuffer10 = stringBuffer.append(dhcpInfo);
        String string6 = LS;
        StringBuffer stringBuffer11 = stringBuffer10.append(string6);
        StringBuffer stringBuffer12 = stringBuffer.append("haveIpAddress=");
        boolean bl = this.mHaveIpAddress;
        StringBuffer stringBuffer13 = stringBuffer12.append(bl).append(", obtainingIpAddress=");
        boolean bl2 = this.mObtainingIpAddress;
        StringBuffer stringBuffer14 = stringBuffer13.append(bl2).append(", scanModeActive=");
        boolean bl3 = this.mIsScanModeActive;
        StringBuffer stringBuffer15 = stringBuffer14.append(bl3);
        String string7 = LS;
        StringBuffer stringBuffer16 = stringBuffer15.append(string7).append("lastSignalLevel=");
        int n5 = this.mLastSignalLevel;
        StringBuffer stringBuffer17 = stringBuffer16.append(n5).append(", explicitlyDisabled=");
        boolean bl4 = this.mTornDownByConnMgr;
        StringBuffer stringBuffer18 = stringBuffer17.append(bl4);
        return stringBuffer.toString();
    }

    public boolean unloadDriver() {
        synchronized (this) {
            boolean bl;
            boolean bl2 = bl = WifiNative.unloadDriver();
            return bl2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void updateBatteryWorkSourceLocked(WorkSource var1_1) {
        if (var1_1 == null) ** GOTO lbl4
        try {
            this.mRunningWifiUids.set(var1_1);
lbl4:
            // 2 sources

            if (this.mRunState == 2) {
                if (this.mReportedRunning) {
                    var2_2 = this.mLastRunningWifiUids;
                    var3_3 = this.mRunningWifiUids;
                    if (!var2_2.diff(var3_3)) {
                        return;
                    }
                    var4_4 = this.mBatteryStats;
                    var5_5 = this.mLastRunningWifiUids;
                    var6_6 = this.mRunningWifiUids;
                    var4_4.noteWifiRunningChanged(var5_5, var6_6);
                    var7_7 = this.mLastRunningWifiUids;
                    var8_8 = this.mRunningWifiUids;
                    var7_7.set(var8_8);
                    return;
                }
                var9_9 = this.mBatteryStats;
                var10_10 = this.mRunningWifiUids;
                var9_9.noteWifiRunning(var10_10);
                var11_11 = this.mLastRunningWifiUids;
                var12_12 = this.mRunningWifiUids;
                var11_11.set(var12_12);
                this.mReportedRunning = true;
                return;
            }
        }
        catch (RemoteException var13_13) {
            return;
        }
        if (this.mRunState != 4) {
            return;
        }
        if (!this.mReportedRunning) {
            return;
        }
        var14_14 = this.mBatteryStats;
        var15_15 = this.mLastRunningWifiUids;
        var14_14.noteWifiStopped(var15_15);
        this.mLastRunningWifiUids.clear();
        this.mReportedRunning = false;
    }

    private class NotificationEnabledSettingObserver
    extends ContentObserver {
        public NotificationEnabledSettingObserver(Handler handler) {
            super(handler);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean getValue() {
            if (Settings.Secure.getInt(WifiStateTracker.this.mContext.getContentResolver(), "wifi_networks_available_notification_on", 1) != 1) return false;
            return true;
        }

        @Override
        public void onChange(boolean bl) {
            super.onChange(bl);
            WifiStateTracker wifiStateTracker = WifiStateTracker.this;
            boolean bl2 = this.getValue();
            boolean bl3 = WifiStateTracker.access$1202(wifiStateTracker, bl2);
            if (!WifiStateTracker.this.mNotificationEnabled) {
                WifiStateTracker.this.setNotificationVisible(false, 0, true, 0);
            }
            WifiStateTracker.this.resetNotificationTimer();
        }

        public void register() {
            ContentResolver contentResolver = WifiStateTracker.this.mContext.getContentResolver();
            Uri uri = Settings.Secure.getUriFor("wifi_networks_available_notification_on");
            contentResolver.registerContentObserver(uri, true, this);
            WifiStateTracker wifiStateTracker = WifiStateTracker.this;
            boolean bl = this.getValue();
            boolean bl2 = WifiStateTracker.access$1202(wifiStateTracker, bl);
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        public SettingsObserver(Handler handler) {
            super(handler);
            ContentResolver contentResolver = WifiStateTracker.this.mContext.getContentResolver();
            Uri uri = Settings.System.getUriFor("wifi_use_static_ip");
            contentResolver.registerContentObserver(uri, false, this);
            Uri uri2 = Settings.System.getUriFor("wifi_static_ip");
            contentResolver.registerContentObserver(uri2, false, this);
            Uri uri3 = Settings.System.getUriFor("wifi_static_gateway");
            contentResolver.registerContentObserver(uri3, false, this);
            Uri uri4 = Settings.System.getUriFor("wifi_static_netmask");
            contentResolver.registerContentObserver(uri4, false, this);
            Uri uri5 = Settings.System.getUriFor("wifi_static_dns1");
            contentResolver.registerContentObserver(uri5, false, this);
            Uri uri6 = Settings.System.getUriFor("wifi_static_dns2");
            contentResolver.registerContentObserver(uri6, false, this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onChange(boolean bl) {
            boolean bl2;
            int n;
            super.onChange(bl);
            boolean bl3 = WifiStateTracker.this.mUseStaticIp;
            int n2 = n = 0;
            int n3 = n;
            int n4 = n;
            int n5 = n;
            if (bl3) {
                n5 = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.ipAddress;
                n4 = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.gateway;
                n3 = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.netmask;
                n2 = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.dns1;
                n = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.dns2;
            }
            WifiStateTracker.this.checkUseStaticIp();
            SupplicantState supplicantState = WifiStateTracker.this.mWifiInfo.getSupplicantState();
            SupplicantState supplicantState2 = SupplicantState.UNINITIALIZED;
            if (supplicantState == supplicantState2) {
                return;
            }
            boolean bl4 = WifiStateTracker.this.mUseStaticIp;
            if (bl3 != bl4) {
                int n6;
                int n7;
                int n8;
                if (!bl3) return;
                int n9 = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.ipAddress;
                if (n5 != n9 && n4 != (n8 = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.gateway) && n3 != (n7 = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.netmask) && n2 != (n6 = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.dns1)) {
                    int n10 = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.dns2;
                    if (n == n10) return;
                }
            }
            if (!(bl2 = true)) {
                return;
            }
            WifiStateTracker.this.resetConnections(true);
            WifiStateTracker.this.configureInterface();
            if (!WifiStateTracker.this.mUseStaticIp) {
                return;
            }
            Handler handler = WifiStateTracker.this.mTarget;
            NetworkInfo networkInfo = WifiStateTracker.this.mNetworkInfo;
            handler.obtainMessage(4, networkInfo).sendToTarget();
        }
    }

    private class DhcpHandler
    extends Handler {
        private BluetoothHeadset mBluetoothHeadset;
        private boolean mCancelCallback;
        private Handler mTarget;

        public DhcpHandler(Looper looper, Handler handler) {
            BluetoothHeadset bluetoothHeadset;
            super(looper);
            this.mTarget = handler;
            Context context = WifiStateTracker.this.mContext;
            this.mBluetoothHeadset = bluetoothHeadset = new BluetoothHeadset(context, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean shouldDisableCoexistenceMode() {
            BluetoothHeadset bluetoothHeadset = this.mBluetoothHeadset;
            BluetoothDevice bluetoothDevice = this.mBluetoothHeadset.getCurrentHeadset();
            if (bluetoothHeadset.getState(bluetoothDevice) != 0) return false;
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            int n;
            int n2;
            switch (message.what) {
                default: {
                    return;
                }
                case 9: 
            }
            boolean bl = false;
            if (this.shouldDisableCoexistenceMode()) {
                bl = true;
                boolean bl2 = WifiStateTracker.this.setBluetoothCoexistenceMode(1);
            }
            if ((n2 = WifiStateTracker.this.getPowerMode()) < 0) {
                n2 = 0;
            }
            if (n2 != 1) {
                WifiStateTracker.this.setPowerMode(1);
            }
            synchronized (this) {
                Object var5_5 = null;
                this.mCancelCallback = var5_5;
            }
            int n3 = Log.d(WifiStateTracker.TAG, "DhcpHandler: DHCP request started");
            String string2 = WifiStateTracker.this.mInterfaceName;
            DhcpInfo dhcpInfo = WifiStateTracker.this.mDhcpInfo;
            if (NetworkUtils.runDhcp(string2, dhcpInfo)) {
                n = 6;
                int n4 = Log.v(WifiStateTracker.TAG, "DhcpHandler: DHCP request succeeded");
            } else {
                n = 7;
                StringBuilder stringBuilder = new StringBuilder().append("DhcpHandler: DHCP request failed: ");
                String string3 = NetworkUtils.getDhcpError();
                String string4 = stringBuilder.append(string3).toString();
                int n5 = Log.i(WifiStateTracker.TAG, string4);
            }
            if (n2 != 1) {
                WifiStateTracker.this.setPowerMode(n2);
            }
            if (bl) {
                boolean bl3 = WifiStateTracker.this.setBluetoothCoexistenceMode(2);
            }
            synchronized (this) {
                if (!this.mCancelCallback) {
                    boolean bl4 = this.mTarget.sendEmptyMessage(n);
                }
                return;
            }
        }

        public void setCancelCallback(boolean bl) {
            synchronized (this) {
                this.mCancelCallback = bl;
                return;
            }
        }
    }

    private static class NetworkStateChangeResult {
        String BSSID;
        int networkId;
        NetworkInfo.DetailedState state;

        NetworkStateChangeResult(NetworkInfo.DetailedState detailedState, String string2, int n) {
            this.state = detailedState;
            this.BSSID = string2;
            this.networkId = n;
        }
    }

    private static class SupplicantStateChangeResult {
        String BSSID;
        int networkId;
        SupplicantState state;

        SupplicantStateChangeResult(int n, String string2, SupplicantState supplicantState) {
            this.state = supplicantState;
            this.BSSID = string2;
            this.networkId = n;
        }
    }
}

