/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

public class ErrorCodes {
    public static final int ERROR_BUFFER_TO_SMALL = 244;
    public static final int ERROR_BUSY = 252;
    public static final int ERROR_CANCELLED = 254;
    public static final int ERROR_CONNECT = 251;
    public static final int ERROR_DISCONNECT = 251;
    public static final int ERROR_INSUFFICIENT_RESOURCES = 247;
    public static final int ERROR_INVALID_PARAM = 248;
    public static final int ERROR_IO = 255;
    public static final int ERROR_NFC_ON = 240;
    public static final int ERROR_NOT_INITIALIZED = 239;
    public static final int ERROR_NO_SE_CONNECTED = 236;
    public static final int ERROR_READ = 250;
    public static final int ERROR_SAP_USED = 243;
    public static final int ERROR_SERVICE_NAME_USED = 242;
    public static final int ERROR_SE_ALREADY_SELECTED = 238;
    public static final int ERROR_SE_CONNECTED = 237;
    public static final int ERROR_SOCKET_CREATION = 246;
    public static final int ERROR_SOCKET_NOT_CONNECTED = 245;
    public static final int ERROR_SOCKET_OPTIONS = 241;
    public static final int ERROR_TIMEOUT = 253;
    public static final int ERROR_WRITE = 249;
    public static final int SUCCESS;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String asString(int n) {
        switch (n) {
            default: {
                return "UNKNOWN ERROR";
            }
            case 0: {
                return "SUCCESS";
            }
            case -1: {
                return "IO";
            }
            case -2: {
                return "CANCELLED";
            }
            case -3: {
                return "TIMEOUT";
            }
            case -4: {
                return "BUSY";
            }
            case -5: {
                return "CONNECT/DISCONNECT";
            }
            case -6: {
                return "READ";
            }
            case -7: {
                return "WRITE";
            }
            case -8: {
                return "INVALID_PARAM";
            }
            case -9: {
                return "INSUFFICIENT_RESOURCES";
            }
            case -10: {
                return "SOCKET_CREATION";
            }
            case -11: {
                return "SOCKET_NOT_CONNECTED";
            }
            case -12: {
                return "BUFFER_TO_SMALL";
            }
            case -13: {
                return "SAP_USED";
            }
            case -14: {
                return "SERVICE_NAME_USED";
            }
            case -15: {
                return "SOCKET_OPTIONS";
            }
            case -16: {
                return "NFC_ON";
            }
            case -17: {
                return "NOT_INITIALIZED";
            }
            case -18: {
                return "SE_ALREADY_SELECTED";
            }
            case -19: {
                return "SE_CONNECTED";
            }
            case -20: 
        }
        return "NO_SE_CONNECTED";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isError(int n) {
        if (n >= 0) return false;
        return true;
    }
}

