/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.nfc.FormatException;
import android.nfc.NdefRecord;
import android.os.Parcel;
import android.os.Parcelable;

public final class NdefMessage
implements Parcelable {
    public static final Parcelable.Creator<NdefMessage> CREATOR = new Parcelable.Creator<NdefMessage>(){

        @Override
        public NdefMessage createFromParcel(Parcel parcel) {
            NdefRecord[] ndefRecordArray = new NdefRecord[parcel.readInt()];
            Parcelable.Creator<NdefRecord> creator = NdefRecord.CREATOR;
            parcel.readTypedArray(ndefRecordArray, creator);
            return new NdefMessage(ndefRecordArray);
        }

        public NdefMessage[] newArray(int n) {
            return new NdefMessage[n];
        }
    };
    private static final byte FLAG_MB = -128;
    private static final byte FLAG_ME = 64;
    private final NdefRecord[] mRecords;

    public NdefMessage(byte[] byArray) throws FormatException {
        this.mRecords = null;
        if (this.parseNdefMessage(byArray) != -1) {
            return;
        }
        throw new FormatException("Error while parsing NDEF message");
    }

    public NdefMessage(NdefRecord[] ndefRecordArray) {
        NdefRecord[] ndefRecordArray2 = new NdefRecord[ndefRecordArray.length];
        NdefRecord[] ndefRecordArray3 = this.mRecords = ndefRecordArray2;
        int n = ndefRecordArray.length;
        System.arraycopy(ndefRecordArray, 0, ndefRecordArray3, 0, n);
    }

    private native int parseNdefMessage(byte[] var1);

    @Override
    public int describeContents() {
        return 0;
    }

    public NdefRecord[] getRecords() {
        return (NdefRecord[])this.mRecords.clone();
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte[] toByteArray() {
        if (this.mRecords == null) return new byte[0];
        if (this.mRecords.length == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[]{};
        int n = 0;
        int n2;
        while (n < (n2 = this.mRecords.length)) {
            byte by;
            byte by2;
            byte by3;
            byte by4;
            byte[] byArray2 = this.mRecords[n].toByteArray();
            int n3 = byArray.length;
            int n4 = byArray2.length;
            byte[] byArray3 = new byte[n3 + n4];
            byArray2[0] = n == 0 ? (by4 = (byte)(byArray2[0] | 0xFFFFFF80)) : (by3 = (byte)(byArray2[0] & 0x7F));
            int n5 = this.mRecords.length - 1;
            byArray2[0] = n != n5 ? (by2 = (byte)(byArray2[0] | 0x40)) : (by = (byte)(byArray2[0] & 0xFFFFFFBF));
            int n6 = byArray.length;
            System.arraycopy(byArray, 0, byArray3, 0, n6);
            int n7 = byArray.length;
            int n8 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray3, n7, n8);
            byArray = byArray3;
            ++n;
        }
        return byArray;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.mRecords.length;
        parcel.writeInt(n2);
        Parcelable[] parcelableArray = this.mRecords;
        parcel.writeTypedArray(parcelableArray, n);
    }
}

