/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.nfc.FormatException;
import android.os.Parcel;
import android.os.Parcelable;

public final class NdefRecord
implements Parcelable {
    public static final Parcelable.Creator<NdefRecord> CREATOR;
    private static final byte FLAG_CF = 32;
    private static final byte FLAG_IL = 8;
    private static final byte FLAG_MB = -128;
    private static final byte FLAG_ME = 64;
    private static final byte FLAG_SR = 16;
    public static final byte[] RTD_ALTERNATIVE_CARRIER;
    public static final byte[] RTD_HANDOVER_CARRIER;
    public static final byte[] RTD_HANDOVER_REQUEST;
    public static final byte[] RTD_HANDOVER_SELECT;
    public static final byte[] RTD_SMART_POSTER;
    public static final byte[] RTD_TEXT;
    public static final byte[] RTD_URI;
    public static final short TNF_ABSOLUTE_URI = 3;
    public static final short TNF_EMPTY = 0;
    public static final short TNF_EXTERNAL_TYPE = 4;
    public static final short TNF_MIME_MEDIA = 2;
    public static final short TNF_RESERVED = 7;
    public static final short TNF_UNCHANGED = 6;
    public static final short TNF_UNKNOWN = 5;
    public static final short TNF_WELL_KNOWN = 1;
    private final byte mFlags;
    private final byte[] mId;
    private final byte[] mPayload;
    private final short mTnf;
    private final byte[] mType;

    static {
        byte[] byArray = new byte[]{84};
        RTD_TEXT = byArray;
        byte[] byArray2 = new byte[]{85};
        RTD_URI = byArray2;
        RTD_SMART_POSTER = new byte[]{83, 112};
        RTD_ALTERNATIVE_CARRIER = new byte[]{97, 99};
        RTD_HANDOVER_CARRIER = new byte[]{72, 99};
        RTD_HANDOVER_REQUEST = new byte[]{72, 114};
        RTD_HANDOVER_SELECT = new byte[]{72, 115};
        CREATOR = new Parcelable.Creator<NdefRecord>(){

            @Override
            public NdefRecord createFromParcel(Parcel parcel) {
                short s = (short)parcel.readInt();
                byte[] byArray = new byte[parcel.readInt()];
                parcel.readByteArray(byArray);
                byte[] byArray2 = new byte[parcel.readInt()];
                parcel.readByteArray(byArray2);
                byte[] byArray3 = new byte[parcel.readInt()];
                parcel.readByteArray(byArray3);
                return new NdefRecord(s, byArray, byArray2, byArray3);
            }

            public NdefRecord[] newArray(int n) {
                return new NdefRecord[n];
            }
        };
    }

    public NdefRecord(short s, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray == null || byArray2 == null || byArray3 == null) {
            throw new IllegalArgumentException("Illegal null argument");
        }
        if (s < 0 || s > 7) {
            String string2 = "TNF out of range " + s;
            throw new IllegalArgumentException(string2);
        }
        int n = 65472;
        if (byArray3.length < 255) {
            n = (byte)(n | 0x10);
        }
        if (byArray2.length != 0) {
            n = (byte)(n | 8);
        }
        this.mFlags = (byte)n;
        this.mTnf = s;
        byte[] byArray4 = (byte[])byArray.clone();
        this.mType = byArray4;
        byte[] byArray5 = (byte[])byArray2.clone();
        this.mId = byArray5;
        byte[] byArray6 = (byte[])byArray3.clone();
        this.mPayload = byArray6;
    }

    public NdefRecord(byte[] byArray) throws FormatException {
        this.mFlags = 0;
        this.mTnf = 0;
        this.mType = null;
        this.mId = null;
        this.mPayload = null;
        if (this.parseNdefRecord(byArray) != -1) {
            return;
        }
        throw new FormatException("Error while parsing NDEF record");
    }

    private native byte[] generate(short var1, short var2, byte[] var3, byte[] var4, byte[] var5);

    private native int parseNdefRecord(byte[] var1);

    @Override
    public int describeContents() {
        return 0;
    }

    public byte[] getId() {
        return (byte[])this.mId.clone();
    }

    public byte[] getPayload() {
        return (byte[])this.mPayload.clone();
    }

    public short getTnf() {
        return this.mTnf;
    }

    public byte[] getType() {
        return (byte[])this.mType.clone();
    }

    public byte[] toByteArray() {
        short s = this.mFlags;
        short s2 = this.mTnf;
        byte[] byArray = this.mType;
        byte[] byArray2 = this.mId;
        byte[] byArray3 = this.mPayload;
        return this.generate(s, s2, byArray, byArray2, byArray3);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        short s = this.mTnf;
        parcel.writeInt(s);
        int n2 = this.mType.length;
        parcel.writeInt(n2);
        byte[] byArray = this.mType;
        parcel.writeByteArray(byArray);
        int n3 = this.mId.length;
        parcel.writeInt(n3);
        byte[] byArray2 = this.mId;
        parcel.writeByteArray(byArray2);
        int n4 = this.mPayload.length;
        parcel.writeInt(n4);
        byte[] byArray3 = this.mPayload;
        parcel.writeByteArray(byArray3);
    }
}

