/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.app.Activity;
import android.app.ActivityThread;
import android.app.OnActivityPausedListener;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.IPackageManager;
import android.nfc.INfcAdapter;
import android.nfc.INfcSecureElement;
import android.nfc.INfcTag;
import android.nfc.NdefMessage;
import android.nfc.NfcManager;
import android.nfc.NfcSecureElement;
import android.nfc.TechListParcel;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

public final class NfcAdapter {
    public static final String ACTION_ADAPTER_STATE_CHANGE = "android.nfc.action.ADAPTER_STATE_CHANGE";
    public static final String ACTION_LLCP_LINK_STATE_CHANGED = "android.nfc.action.LLCP_LINK_STATE_CHANGED";
    public static final String ACTION_NDEF_DISCOVERED = "android.nfc.action.NDEF_DISCOVERED";
    public static final String ACTION_RF_FIELD_OFF_DETECTED = "android.nfc.action.RF_FIELD_OFF_DETECTED";
    public static final String ACTION_RF_FIELD_ON_DETECTED = "android.nfc.action.RF_FIELD_ON_DETECTED";
    public static final String ACTION_TAG_DISCOVERED = "android.nfc.action.TAG_DISCOVERED";
    public static final String ACTION_TAG_LEFT_FIELD = "android.nfc.action.TAG_LOST";
    public static final String ACTION_TECH_DISCOVERED = "android.nfc.action.TECH_DISCOVERED";
    public static final String ACTION_TRANSACTION_DETECTED = "android.nfc.action.TRANSACTION_DETECTED";
    private static final int DISCOVERY_MODE_CARD_EMULATION = 2;
    private static final int DISCOVERY_MODE_NFCIP1 = 1;
    private static final int DISCOVERY_MODE_TAG_READER = 0;
    public static final String EXTRA_AID = "android.nfc.extra.AID";
    public static final String EXTRA_ID = "android.nfc.extra.ID";
    public static final String EXTRA_LLCP_LINK_STATE_CHANGED = "android.nfc.extra.LLCP_LINK_STATE";
    public static final String EXTRA_NDEF_MESSAGES = "android.nfc.extra.NDEF_MESSAGES";
    public static final String EXTRA_NEW_BOOLEAN_STATE = "android.nfc.isEnabled";
    public static final String EXTRA_TAG = "android.nfc.extra.TAG";
    public static final int LLCP_LINK_STATE_ACTIVATED = 0;
    public static final int LLCP_LINK_STATE_DEACTIVATED = 1;
    private static final String TAG = "NFC";
    private static boolean sIsInitialized = false;
    private static INfcAdapter sService;
    private static INfcTag sTagService;
    OnActivityPausedListener mForegroundDispatchListener;
    OnActivityPausedListener mForegroundNdefPushListener;

    NfcAdapter(Context context) {
        OnActivityPausedListener onActivityPausedListener;
        OnActivityPausedListener onActivityPausedListener2;
        this.mForegroundDispatchListener = onActivityPausedListener2 = new OnActivityPausedListener(){

            @Override
            public void onPaused(Activity activity) {
                NfcAdapter.this.disableForegroundDispatchInternal(activity, true);
            }
        };
        this.mForegroundNdefPushListener = onActivityPausedListener = new OnActivityPausedListener(){

            @Override
            public void onPaused(Activity activity) {
                NfcAdapter.this.disableForegroundNdefPushInternal(activity, true);
            }
        };
        if (NfcAdapter.setupService() != null) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static NfcAdapter getDefaultAdapter() {
        Exception exception = new Exception();
        int n = Log.w(TAG, "WARNING: NfcAdapter.getDefaultAdapter() is deprecated, use NfcAdapter.getDefaultAdapter(Context) instead", exception);
        return new NfcAdapter(null);
    }

    public static NfcAdapter getDefaultAdapter(Context context) {
        return ((NfcManager)context.getSystemService("nfc")).getDefaultAdapter();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static INfcAdapter getServiceInterface() {
        IBinder iBinder = ServiceManager.getService("nfc");
        if (iBinder != null) return INfcAdapter.Stub.asInterface(iBinder);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean hasNfcFeature() {
        IPackageManager iPackageManager = ActivityThread.getPackageManager();
        if (iPackageManager == null) {
            int n = Log.e(TAG, "Cannot get package manager, assuming no NFC feature");
            return false;
        }
        try {
            boolean bl = iPackageManager.hasSystemFeature("android.hardware.nfc");
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "Package manager query failed, assuming no NFC feature", remoteException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static INfcAdapter setupService() {
        synchronized (NfcAdapter.class) {
            if (sIsInitialized) return sService;
            sIsInitialized = true;
            if (!NfcAdapter.hasNfcFeature()) {
                int n = Log.v(TAG, "this device does not have NFC support");
                return null;
            }
            sService = NfcAdapter.getServiceInterface();
            if (sService == null) {
                int n = Log.e(TAG, "could not retrieve NFC service");
                return null;
            }
            try {
                sTagService = sService.getNfcTagInterface();
                return sService;
            }
            catch (RemoteException remoteException) {
                int n = Log.e(TAG, "could not retrieve NFC Tag service");
                return null;
            }
        }
    }

    public void attemptDeadServiceRecovery(Exception exception) {
        int n = Log.e(TAG, "NFC service dead - attempting to recover", exception);
        INfcAdapter iNfcAdapter = NfcAdapter.getServiceInterface();
        if (iNfcAdapter == null) {
            int n2 = Log.e(TAG, "could not retrieve NFC service during service recovery");
            return;
        }
        sService = iNfcAdapter;
        try {
            sTagService = iNfcAdapter.getNfcTagInterface();
            return;
        }
        catch (RemoteException remoteException) {
            int n3 = Log.e(TAG, "could not retrieve NFC tag service during service recovery");
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NfcSecureElement createNfcSecureElementConnection() {
        try {
            INfcSecureElement iNfcSecureElement = sService.getNfcSecureElementInterface();
            return new NfcSecureElement(iNfcSecureElement);
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "createNfcSecureElementConnection failed", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disable() {
        try {
            boolean bl = sService.disable();
            return bl;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return false;
        }
    }

    public void disableForegroundDispatch(Activity activity) {
        ActivityThread activityThread = ActivityThread.currentActivityThread();
        OnActivityPausedListener onActivityPausedListener = this.mForegroundDispatchListener;
        activityThread.unregisterOnActivityPausedListener(activity, onActivityPausedListener);
        this.disableForegroundDispatchInternal(activity, false);
    }

    void disableForegroundDispatchInternal(Activity activity, boolean bl) {
        try {
            INfcAdapter iNfcAdapter = sService;
            ComponentName componentName = activity.getComponentName();
            iNfcAdapter.disableForegroundDispatch(componentName);
            if (bl) {
                return;
            }
            if (activity.isResumed()) {
                return;
            }
            throw new IllegalStateException("You must disable forgeground dispatching while your activity is still resumed");
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return;
        }
    }

    public void disableForegroundNdefPush(Activity activity) {
        ActivityThread activityThread = ActivityThread.currentActivityThread();
        OnActivityPausedListener onActivityPausedListener = this.mForegroundNdefPushListener;
        activityThread.unregisterOnActivityPausedListener(activity, onActivityPausedListener);
        this.disableForegroundNdefPushInternal(activity, false);
    }

    void disableForegroundNdefPushInternal(Activity activity, boolean bl) {
        try {
            INfcAdapter iNfcAdapter = sService;
            ComponentName componentName = activity.getComponentName();
            iNfcAdapter.disableForegroundNdefPush(componentName);
            if (bl) {
                return;
            }
            if (activity.isResumed()) {
                return;
            }
            throw new IllegalStateException("You must disable forgeground NDEF push while your activity is still resumed");
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enable() {
        try {
            boolean bl = sService.enable();
            return bl;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void enableForegroundDispatch(Activity var1_1, PendingIntent var2_2, IntentFilter[] var3_3, String[][] var4_4) {
        if (var1_1 == null || var2_2 == null) {
            throw new NullPointerException();
        }
        if (!var1_1.isResumed()) {
            throw new IllegalStateException("Foregorund dispatching can only be enabled when your activity is resumed");
        }
        var5_5 = null;
        if (var4_4 == null) ** GOTO lbl10
        try {
            if (var4_4.length > 0) {
                var5_5 = new TechListParcel(var4_4);
            }
lbl10:
            // 4 sources

            var6_6 = ActivityThread.currentActivityThread();
            var7_7 = this.mForegroundDispatchListener;
            var6_6.registerOnActivityPausedListener(var1_1, var7_7);
            var8_8 = NfcAdapter.sService;
            var9_9 = var1_1.getComponentName();
            var8_8.enableForegroundDispatch(var9_9, var2_2, var3_3, var5_5);
            return;
        }
        catch (RemoteException var10_10) {
            this.attemptDeadServiceRecovery(var10_10);
            return;
        }
    }

    public void enableForegroundNdefPush(Activity activity, NdefMessage ndefMessage) {
        if (activity == null || ndefMessage == null) {
            throw new NullPointerException();
        }
        if (!activity.isResumed()) {
            throw new IllegalStateException("Foregorund NDEF push can only be enabled when your activity is resumed");
        }
        try {
            ActivityThread activityThread = ActivityThread.currentActivityThread();
            OnActivityPausedListener onActivityPausedListener = this.mForegroundNdefPushListener;
            activityThread.registerOnActivityPausedListener(activity, onActivityPausedListener);
            INfcAdapter iNfcAdapter = sService;
            ComponentName componentName = activity.getComponentName();
            iNfcAdapter.enableForegroundNdefPush(componentName, ndefMessage);
            return;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NdefMessage getLocalNdefMessage() {
        try {
            NdefMessage ndefMessage = sService.localGet();
            return ndefMessage;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return null;
        }
    }

    public INfcAdapter getService() {
        boolean bl = this.isEnabled();
        return sService;
    }

    public INfcTag getTagService() {
        boolean bl = this.isEnabled();
        return sTagService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEnabled() {
        try {
            boolean bl = sService.isEnabled();
            return bl;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return false;
        }
    }

    public void setLocalNdefMessage(NdefMessage ndefMessage) {
        try {
            sService.localSet(ndefMessage);
            return;
        }
        catch (RemoteException remoteException) {
            this.attemptDeadServiceRecovery(remoteException);
            return;
        }
    }
}

