/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.nfc.ErrorCodes;
import android.nfc.INfcSecureElement;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public final class NfcSecureElement {
    private static final String TAG = "NfcSecureElement";
    private INfcSecureElement mService;

    public NfcSecureElement(INfcSecureElement iNfcSecureElement) {
        this.mService = iNfcSecureElement;
    }

    public void closeSecureElementConnection(int n) throws IOException {
        try {
            if (!ErrorCodes.isError(this.mService.closeSecureElementConnection(n))) {
                return;
            }
            throw new IOException("Error during the conection close");
        }
        catch (RemoteException remoteException) {
            int n2 = Log.e(TAG, "RemoteException in closeSecureElement(): ", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] exchangeAPDU(int n, byte[] byArray) throws IOException {
        try {
            byte[] byArray2 = this.mService.exchangeAPDU(n, byArray);
            if (byArray2 != null) return byArray2;
            throw new IOException("Exchange APDU failed");
        }
        catch (RemoteException remoteException) {
            int n2 = Log.e(TAG, "RemoteException in exchangeAPDU(): ", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] getSecureElementTechList(int n) throws IOException {
        try {
            int[] nArray = this.mService.getSecureElementTechList(n);
            return nArray;
        }
        catch (RemoteException remoteException) {
            int n2 = Log.e(TAG, "RemoteException in getType(): ", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getSecureElementUid(int n) throws IOException {
        try {
            byte[] byArray = this.mService.getSecureElementUid(n);
            if (byArray != null) return byArray;
            throw new IOException("Get Secure Element UID failed");
        }
        catch (RemoteException remoteException) {
            int n2 = Log.e(TAG, "RemoteException in getType(): ", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int openSecureElementConnection(String string2) throws IOException {
        if (string2.equals("SmartMX")) {
            try {
                int n = this.mService.openSecureElementConnection();
                if (n == 0) throw new IOException("SmartMX connection not allowed");
                return n;
            }
            catch (RemoteException remoteException) {
                int n = Log.e(TAG, "RemoteException in openSecureElementConnection(): ", remoteException);
                return 0;
            }
        }
        if (!string2.equals("UICC")) throw new IOException("Wrong Secure Element type");
        return 0;
    }
}

