/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.nfc.INfcTag;
import android.nfc.tech.IsoDep;
import android.nfc.tech.MifareClassic;
import android.nfc.tech.MifareUltralight;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.nfc.tech.NfcA;
import android.nfc.tech.NfcB;
import android.nfc.tech.NfcF;
import android.nfc.tech.NfcV;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;

public final class Tag
implements Parcelable {
    public static final Parcelable.Creator<Tag> CREATOR = new Parcelable.Creator<Tag>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Tag createFromParcel(Parcel parcel) {
            INfcTag iNfcTag;
            byte[] byArray = Tag.readBytesWithNull(parcel);
            int[] nArray = new int[parcel.readInt()];
            parcel.readIntArray(nArray);
            Parcelable.Creator<Bundle> creator = Bundle.CREATOR;
            Bundle[] bundleArray = parcel.createTypedArray(creator);
            int n = parcel.readInt();
            if (parcel.readInt() == 0) {
                iNfcTag = INfcTag.Stub.asInterface(parcel.readStrongBinder());
                return new Tag(byArray, nArray, bundleArray, n, iNfcTag);
            }
            iNfcTag = null;
            return new Tag(byArray, nArray, bundleArray, n, iNfcTag);
        }

        public Tag[] newArray(int n) {
            return new Tag[n];
        }
    };
    int mConnectedTechnology;
    final byte[] mId;
    final int mServiceHandle;
    final INfcTag mTagService;
    final Bundle[] mTechExtras;
    final int[] mTechList;
    final String[] mTechStringList;

    public Tag(byte[] byArray, int[] nArray, Bundle[] bundleArray, int n, INfcTag iNfcTag) {
        if (nArray == null) {
            throw new IllegalArgumentException("rawTargets cannot be null");
        }
        this.mId = byArray;
        int n2 = nArray.length;
        int[] nArray2 = Arrays.copyOf(nArray, n2);
        this.mTechList = nArray2;
        String[] stringArray = this.generateTechStringList(nArray);
        this.mTechStringList = stringArray;
        int n3 = nArray.length;
        Bundle[] bundleArray2 = Arrays.copyOf(bundleArray, n3);
        this.mTechExtras = bundleArray2;
        this.mServiceHandle = n;
        this.mTagService = iNfcTag;
        this.mConnectedTechnology = -1;
    }

    public static Tag createMockTag(byte[] byArray, int[] nArray, Bundle[] bundleArray) {
        byte[] byArray2 = byArray;
        int[] nArray2 = nArray;
        Bundle[] bundleArray2 = bundleArray;
        return new Tag(byArray2, nArray2, bundleArray2, 0, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String[] generateTechStringList(int[] nArray) {
        int n = nArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            switch (nArray[n2]) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("Unknown tech type ");
                    int n3 = nArray[n2];
                    String string2 = stringBuilder.append(n3).toString();
                    throw new IllegalArgumentException(string2);
                }
                case 3: {
                    String string3;
                    stringArray[n2] = string3 = IsoDep.class.getName();
                    break;
                }
                case 8: {
                    String string4;
                    stringArray[n2] = string4 = MifareClassic.class.getName();
                    break;
                }
                case 9: {
                    String string5;
                    stringArray[n2] = string5 = MifareUltralight.class.getName();
                    break;
                }
                case 6: {
                    String string6;
                    stringArray[n2] = string6 = Ndef.class.getName();
                    break;
                }
                case 7: {
                    String string7;
                    stringArray[n2] = string7 = NdefFormatable.class.getName();
                    break;
                }
                case 1: {
                    String string8;
                    stringArray[n2] = string8 = NfcA.class.getName();
                    break;
                }
                case 2: {
                    String string9;
                    stringArray[n2] = string9 = NfcB.class.getName();
                    break;
                }
                case 4: {
                    String string10;
                    stringArray[n2] = string10 = NfcF.class.getName();
                    break;
                }
                case 5: {
                    String string11;
                    stringArray[n2] = string11 = NfcV.class.getName();
                }
            }
            ++n2;
        }
        return stringArray;
    }

    static byte[] readBytesWithNull(Parcel parcel) {
        int n = parcel.readInt();
        byte[] byArray = null;
        if (n >= 0) {
            byArray = new byte[n];
            parcel.readByteArray(byArray);
        }
        return byArray;
    }

    static void writeBytesWithNull(Parcel parcel, byte[] byArray) {
        if (byArray == null) {
            parcel.writeInt(-1);
            return;
        }
        int n = byArray.length;
        parcel.writeInt(n);
        parcel.writeByteArray(byArray);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getConnectedTechnology() {
        return this.mConnectedTechnology;
    }

    public byte[] getId() {
        return this.mId;
    }

    public int getServiceHandle() {
        return this.mServiceHandle;
    }

    public INfcTag getTagService() {
        return this.mTagService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Bundle getTechExtras(int n) {
        int n2 = -1;
        int n3 = 0;
        while (true) {
            block4: {
                block3: {
                    int n4;
                    if (n3 >= (n4 = this.mTechList.length)) break block3;
                    if (this.mTechList[n3] == n) break block4;
                    n2 = n3;
                }
                if (n2 >= 0) return this.mTechExtras[n2];
                return null;
            }
            ++n3;
        }
    }

    public String[] getTechList() {
        return this.mTechStringList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasTech(int n) {
        int[] nArray = this.mTechList;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (nArray[n3] != n) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public void setConnectedTechnology(int n) {
        synchronized (this) {
            if (this.mConnectedTechnology == -1) {
                this.mConnectedTechnology = n;
                return;
            }
            throw new IllegalStateException("Close other technology first!");
        }
    }

    public void setTechnologyDisconnected() {
        this.mConnectedTechnology = -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TAG ").append("uid = ");
        byte[] byArray = this.mId;
        StringBuilder stringBuilder2 = stringBuilder.append(byArray).append(" Tech [");
        for (int n : this.mTechList) {
            StringBuilder stringBuilder3 = stringBuilder2.append(n).append(", ");
        }
        return stringBuilder2.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.mTagService == null ? 1 : 0;
        byte[] byArray = this.mId;
        Tag.writeBytesWithNull(parcel, byArray);
        int n3 = this.mTechList.length;
        parcel.writeInt(n3);
        int[] nArray = this.mTechList;
        parcel.writeIntArray(nArray);
        Parcelable[] parcelableArray = this.mTechExtras;
        parcel.writeTypedArray(parcelableArray, 0);
        int n4 = this.mServiceHandle;
        parcel.writeInt(n4);
        parcel.writeInt(n2);
        if (n2 != 0) {
            return;
        }
        IBinder iBinder = this.mTagService.asBinder();
        parcel.writeStrongBinder(iBinder);
    }
}

