/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.INfcTag;
import android.nfc.Tag;
import android.nfc.TagLostException;
import android.nfc.TransceiveResult;
import android.nfc.tech.TagTechnology;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

abstract class BasicTagTechnology
implements TagTechnology {
    private static final String TAG = "NFC";
    boolean mIsConnected;
    int mSelectedTechnology;
    final Tag mTag;

    BasicTagTechnology(Tag tag, int n) throws RemoteException {
        this.mTag = tag;
        this.mSelectedTechnology = n;
    }

    void checkConnected() {
        int n;
        int n2 = this.mTag.getConnectedTechnology();
        if (n2 != (n = this.mSelectedTechnology) && this.mTag.getConnectedTechnology() != -1) {
            return;
        }
        throw new IllegalStateException("Call connect() first!");
    }

    @Override
    public void close() throws IOException {
        try {
            INfcTag iNfcTag = this.mTag.getTagService();
            int n = this.mTag.getServiceHandle();
            int n2 = iNfcTag.reconnect(n);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "NFC service dead", remoteException);
            return;
        }
        finally {
            this.mIsConnected = false;
            this.mTag.setTechnologyDisconnected();
        }
    }

    @Override
    public void connect() throws IOException {
        try {
            INfcTag iNfcTag = this.mTag.getTagService();
            int n = this.mTag.getServiceHandle();
            int n2 = this.mSelectedTechnology;
            if (iNfcTag.connect(n, n2) == 0) {
                Tag tag = this.mTag;
                int n3 = this.mSelectedTechnology;
                tag.setConnectedTechnology(n3);
                this.mIsConnected = true;
                return;
            }
            throw new IOException();
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "NFC service dead", remoteException);
            throw new IOException("NFC service died");
        }
    }

    @Override
    public Tag getTag() {
        return this.mTag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isConnected() {
        if (!this.mIsConnected) {
            return false;
        }
        try {
            INfcTag iNfcTag = this.mTag.getTagService();
            int n = this.mTag.getServiceHandle();
            boolean bl = iNfcTag.isPresent(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "NFC service dead", remoteException);
            return false;
        }
    }

    @Override
    public void reconnect() throws IOException {
        if (!this.mIsConnected) {
            throw new IllegalStateException("Technology not connected yet");
        }
        try {
            INfcTag iNfcTag = this.mTag.getTagService();
            int n = this.mTag.getServiceHandle();
            if (iNfcTag.reconnect(n) == 0) {
                return;
            }
            this.mIsConnected = false;
            this.mTag.setTechnologyDisconnected();
            throw new IOException();
        }
        catch (RemoteException remoteException) {
            this.mIsConnected = false;
            this.mTag.setTechnologyDisconnected();
            int n = Log.e(TAG, "NFC service dead", remoteException);
            throw new IOException("NFC service died");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] transceive(byte[] byArray, boolean bl) throws IOException {
        TransceiveResult transceiveResult;
        this.checkConnected();
        try {
            INfcTag iNfcTag = this.mTag.getTagService();
            int n = this.mTag.getServiceHandle();
            transceiveResult = iNfcTag.transceive(n, byArray, bl);
            if (transceiveResult == null) {
                throw new IOException("transceive failed");
            }
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "NFC service dead", remoteException);
            throw new IOException("NFC service died");
        }
        {
            if (transceiveResult.isSuccessful()) {
                return transceiveResult.getResponseData();
            }
            if (transceiveResult.isTagLost()) {
                throw new TagLostException("Tag was lost.");
            }
            throw new IOException("transceive failed");
        }
    }
}

