/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.Tag;
import android.nfc.tech.BasicTagTechnology;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public final class IsoDep
extends BasicTagTechnology {
    public static final String EXTRA_HIST_BYTES = "histbytes";
    public static final String EXTRA_HI_LAYER_RESP = "hiresp";
    private static final String TAG = "NFC";
    private byte[] mHiLayerResponse = null;
    private byte[] mHistBytes = null;

    public IsoDep(Tag tag) throws RemoteException {
        super(tag, 3);
        Bundle bundle = tag.getTechExtras(3);
        if (bundle == null) {
            return;
        }
        byte[] byArray = bundle.getByteArray(EXTRA_HI_LAYER_RESP);
        this.mHiLayerResponse = byArray;
        byte[] byArray2 = bundle.getByteArray(EXTRA_HIST_BYTES);
        this.mHistBytes = byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IsoDep get(Tag tag) {
        if (!tag.hasTech(3)) {
            return null;
        }
        try {
            return new IsoDep(tag);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        try {
            this.mTag.getTagService().resetIsoDepTimeout();
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "NFC service dead", remoteException);
        }
        super.close();
    }

    public byte[] getHiLayerResponse() {
        return this.mHiLayerResponse;
    }

    public byte[] getHistoricalBytes() {
        return this.mHistBytes;
    }

    public void setTimeout(int n) {
        try {
            this.mTag.getTagService().setIsoDepTimeout(n);
            return;
        }
        catch (RemoteException remoteException) {
            int n2 = Log.e(TAG, "NFC service dead", remoteException);
            return;
        }
    }

    public byte[] transceive(byte[] byArray) throws IOException {
        return this.transceive(byArray, true);
    }
}

