/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.Tag;
import android.nfc.TagLostException;
import android.nfc.tech.BasicTagTechnology;
import android.nfc.tech.NfcA;
import android.os.RemoteException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class MifareClassic
extends BasicTagTechnology {
    public static final int BLOCK_SIZE = 16;
    public static final byte[] KEY_DEFAULT = new byte[]{255, 255, 255, 255, 255, 255};
    public static final byte[] KEY_MIFARE_APPLICATION_DIRECTORY = new byte[]{160, 161, 162, 163, 164, 165};
    public static final byte[] KEY_NFC_FORUM = new byte[]{211, 247, 211, 247, 211, 247};
    private static final int MAX_BLOCK_COUNT = 256;
    private static final int MAX_SECTOR_COUNT = 40;
    public static final int SIZE_1K = 1024;
    public static final int SIZE_2K = 2048;
    public static final int SIZE_4K = 4096;
    public static final int SIZE_MINI = 320;
    public static final int TYPE_CLASSIC = 0;
    public static final int TYPE_PLUS = 1;
    public static final int TYPE_PRO = 2;
    public static final int TYPE_UNKNOWN = 255;
    private boolean mIsEmulated;
    private int mSize;
    private int mType;

    public MifareClassic(Tag tag) throws RemoteException {
        super(tag, 8);
        NfcA nfcA = NfcA.get(tag);
        this.mIsEmulated = false;
        switch (nfcA.getSak()) {
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("Tag incorrectly enumerated as Mifare Classic, SAK = ");
                short s = nfcA.getSak();
                String string2 = stringBuilder.append(s).toString();
                throw new RuntimeException(string2);
            }
            case 8: {
                this.mType = 0;
                this.mSize = 1024;
                return;
            }
            case 9: {
                this.mType = 0;
                this.mSize = 320;
                return;
            }
            case 16: {
                this.mType = 1;
                this.mSize = 2048;
                return;
            }
            case 17: {
                this.mType = 1;
                this.mSize = 4096;
                return;
            }
            case 24: {
                this.mType = 0;
                this.mSize = 4096;
                return;
            }
            case 40: {
                this.mType = 0;
                this.mSize = 1024;
                this.mIsEmulated = true;
                return;
            }
            case 56: {
                this.mType = 0;
                this.mSize = 4096;
                this.mIsEmulated = true;
                return;
            }
            case 136: {
                this.mType = 0;
                this.mSize = 1024;
                return;
            }
            case 152: 
            case 184: 
        }
        this.mType = 2;
        this.mSize = 4096;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean authenticate(int n, byte[] byArray, boolean bl) throws IOException {
        byte by;
        MifareClassic.validateSector(n);
        this.checkConnected();
        byte[] byArray2 = new byte[12];
        byArray2[0] = bl ? 96 : 97;
        byArray2[1] = by = (byte)this.sectorToBlock(n);
        byte[] byArray3 = this.getTag().getId();
        int n2 = byArray3.length - 4;
        System.arraycopy(byArray3, n2, byArray2, 2, 4);
        System.arraycopy(byArray, 0, byArray2, 6, 6);
        boolean bl2 = false;
        try {
            byte[] byArray4 = this.transceive(byArray2, bl2);
            if (byArray4 == null) return false;
            return true;
        }
        catch (TagLostException tagLostException) {
            throw tagLostException;
        }
        catch (IOException iOException) {
            // empty catch block
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MifareClassic get(Tag tag) {
        if (!tag.hasTech(8)) {
            return null;
        }
        try {
            return new MifareClassic(tag);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    private static void validateBlock(int n) {
        if (n >= 0 && n < 256) {
            return;
        }
        String string2 = "block out of bounds: " + n;
        throw new IndexOutOfBoundsException(string2);
    }

    private static void validateSector(int n) {
        if (n >= 0 && n < 40) {
            return;
        }
        String string2 = "sector out of bounds: " + n;
        throw new IndexOutOfBoundsException(string2);
    }

    private static void validateValueOperand(int n) {
        if (n >= 0) {
            return;
        }
        throw new IllegalArgumentException("value operand negative");
    }

    public boolean authenticateSectorWithKeyA(int n, byte[] byArray) throws IOException {
        return this.authenticate(n, byArray, true);
    }

    public boolean authenticateSectorWithKeyB(int n, byte[] byArray) throws IOException {
        return this.authenticate(n, byArray, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int blockToSector(int n) {
        MifareClassic.validateBlock(n);
        if (n >= 128) return (n - 128) / 16 + 32;
        return n / 4;
    }

    public void decrement(int n, int n2) throws IOException {
        MifareClassic.validateBlock(n);
        MifareClassic.validateValueOperand(n2);
        this.checkConnected();
        ByteBuffer byteBuffer = ByteBuffer.allocate(6);
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        ByteBuffer byteBuffer2 = byteBuffer.order(byteOrder);
        ByteBuffer byteBuffer3 = byteBuffer.put((byte)65472);
        byte by = (byte)n;
        ByteBuffer byteBuffer4 = byteBuffer.put(by);
        ByteBuffer byteBuffer5 = byteBuffer.putInt(n2);
        byte[] byArray = byteBuffer.array();
        byte[] byArray2 = this.transceive(byArray, false);
    }

    public int getBlockCount() {
        return this.mSize / 16;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getBlockCountInSector(int n) {
        MifareClassic.validateSector(n);
        if (n >= 32) return 16;
        return 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSectorCount() {
        switch (this.mSize) {
            default: {
                return 0;
            }
            case 1024: {
                return 16;
            }
            case 2048: {
                return 32;
            }
            case 4096: {
                return 40;
            }
            case 320: 
        }
        return 5;
    }

    public int getSize() {
        return this.mSize;
    }

    public int getType() {
        return this.mType;
    }

    public void increment(int n, int n2) throws IOException {
        MifareClassic.validateBlock(n);
        MifareClassic.validateValueOperand(n2);
        this.checkConnected();
        ByteBuffer byteBuffer = ByteBuffer.allocate(6);
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        ByteBuffer byteBuffer2 = byteBuffer.order(byteOrder);
        ByteBuffer byteBuffer3 = byteBuffer.put((byte)65473);
        byte by = (byte)n;
        ByteBuffer byteBuffer4 = byteBuffer.put(by);
        ByteBuffer byteBuffer5 = byteBuffer.putInt(n2);
        byte[] byArray = byteBuffer.array();
        byte[] byArray2 = this.transceive(byArray, false);
    }

    public boolean isEmulated() {
        return this.mIsEmulated;
    }

    public byte[] readBlock(int n) throws IOException {
        MifareClassic.validateBlock(n);
        this.checkConnected();
        byte by = (byte)n;
        byte[] byArray = new byte[]{48, by};
        return this.transceive(byArray, false);
    }

    public void restore(int n) throws IOException {
        MifareClassic.validateBlock(n);
        this.checkConnected();
        byte by = (byte)n;
        byte[] byArray = new byte[]{65474, by};
        byte[] byArray2 = this.transceive(byArray, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int sectorToBlock(int n) {
        if (n >= 32) return (n - 32) * 16 + 128;
        return n * 4;
    }

    public byte[] transceive(byte[] byArray) throws IOException {
        return this.transceive(byArray, true);
    }

    public void transfer(int n) throws IOException {
        MifareClassic.validateBlock(n);
        this.checkConnected();
        byte by = (byte)n;
        byte[] byArray = new byte[]{65456, by};
        byte[] byArray2 = this.transceive(byArray, false);
    }

    public void writeBlock(int n, byte[] byArray) throws IOException {
        byte by;
        MifareClassic.validateBlock(n);
        this.checkConnected();
        if (byArray.length != 16) {
            throw new IllegalArgumentException("must write 16-bytes");
        }
        byte[] byArray2 = new byte[byArray.length + 2];
        byArray2[0] = 65440;
        byArray2[1] = by = (byte)n;
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 2, n2);
        byte[] byArray3 = this.transceive(byArray2, false);
    }
}

