/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.Tag;
import android.nfc.tech.BasicTagTechnology;
import android.nfc.tech.NfcA;
import android.os.RemoteException;
import java.io.IOException;

public final class MifareUltralight
extends BasicTagTechnology {
    private static final int MAX_PAGE_COUNT = 256;
    private static final int NXP_MANUFACTURER_ID = 4;
    public static final int PAGE_SIZE = 4;
    public static final int TYPE_ULTRALIGHT = 1;
    public static final int TYPE_ULTRALIGHT_C = 2;
    public static final int TYPE_UNKNOWN = 255;
    private int mType;

    public MifareUltralight(Tag tag) throws RemoteException {
        super(tag, 9);
        NfcA nfcA = NfcA.get(tag);
        this.mType = -1;
        if (nfcA.getSak() != null) {
            return;
        }
        if (tag.getId()[0] != 4) {
            return;
        }
        this.mType = 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MifareUltralight get(Tag tag) {
        if (!tag.hasTech(9)) {
            return null;
        }
        try {
            return new MifareUltralight(tag);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    private static void validatePageOffset(int n) {
        if (n >= 0 && n < 256) {
            return;
        }
        String string2 = "page out of bounds: " + n;
        throw new IndexOutOfBoundsException(string2);
    }

    public int getType() {
        return this.mType;
    }

    public byte[] readPages(int n) throws IOException {
        MifareUltralight.validatePageOffset(n);
        this.checkConnected();
        byte by = (byte)n;
        byte[] byArray = new byte[]{48, by};
        return this.transceive(byArray, false);
    }

    public byte[] transceive(byte[] byArray) throws IOException {
        return this.transceive(byArray, true);
    }

    public void writePage(int n, byte[] byArray) throws IOException {
        byte by;
        MifareUltralight.validatePageOffset(n);
        this.checkConnected();
        byte[] byArray2 = new byte[byArray.length + 2];
        byArray2[0] = 65442;
        byArray2[1] = by = (byte)n;
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 2, n2);
        byte[] byArray3 = this.transceive(byArray2, false);
    }
}

