/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.FormatException;
import android.nfc.INfcTag;
import android.nfc.NdefMessage;
import android.nfc.Tag;
import android.nfc.tech.BasicTagTechnology;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public final class Ndef
extends BasicTagTechnology {
    public static final String EXTRA_NDEF_CARDSTATE = "ndefcardstate";
    public static final String EXTRA_NDEF_MAXLENGTH = "ndefmaxlength";
    public static final String EXTRA_NDEF_MSG = "ndefmsg";
    public static final String EXTRA_NDEF_TYPE = "ndeftype";
    public static final String MIFARE_CLASSIC = "com.nxp.ndef.mifareclassic";
    public static final int NDEF_MODE_READ_ONLY = 1;
    public static final int NDEF_MODE_READ_WRITE = 2;
    public static final int NDEF_MODE_UNKNOWN = 3;
    public static final String NFC_FORUM_TYPE_1 = "org.nfcforum.ndef.type1";
    public static final String NFC_FORUM_TYPE_2 = "org.nfcforum.ndef.type2";
    public static final String NFC_FORUM_TYPE_3 = "org.nfcforum.ndef.type3";
    public static final String NFC_FORUM_TYPE_4 = "org.nfcforum.ndef.type4";
    private static final String TAG = "NFC";
    public static final int TYPE_1 = 1;
    public static final int TYPE_2 = 2;
    public static final int TYPE_3 = 3;
    public static final int TYPE_4 = 4;
    public static final int TYPE_MIFARE_CLASSIC = 101;
    public static final int TYPE_OTHER = 255;
    public static final String UNKNOWN = "android.ndef.unknown";
    private final int mCardState;
    private final int mMaxNdefSize;
    private final NdefMessage mNdefMsg;
    private final int mNdefType;

    public Ndef(Tag tag) throws RemoteException {
        super(tag, 6);
        Bundle bundle = tag.getTechExtras(6);
        if (bundle != null) {
            int n;
            NdefMessage ndefMessage;
            int n2;
            int n3;
            this.mMaxNdefSize = n3 = bundle.getInt(EXTRA_NDEF_MAXLENGTH);
            this.mCardState = n2 = bundle.getInt(EXTRA_NDEF_CARDSTATE);
            this.mNdefMsg = ndefMessage = (NdefMessage)bundle.getParcelable(EXTRA_NDEF_MSG);
            this.mNdefType = n = bundle.getInt(EXTRA_NDEF_TYPE);
            return;
        }
        throw new NullPointerException("NDEF tech extras are null.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Ndef get(Tag tag) {
        if (!tag.hasTech(6)) {
            return null;
        }
        try {
            return new Ndef(tag);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canMakeReadOnly() {
        if (this.mNdefType == 1) return true;
        if (this.mNdefType != 2) return false;
        return true;
    }

    public NdefMessage getCachedNdefMessage() {
        return this.mNdefMsg;
    }

    public int getMaxSize() {
        return this.mMaxNdefSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NdefMessage getNdefMessage() throws IOException, FormatException {
        this.checkConnected();
        try {
            INfcTag iNfcTag = this.mTag.getTagService();
            int n = this.mTag.getServiceHandle();
            if (!iNfcTag.isNdef(n)) return null;
            NdefMessage ndefMessage = iNfcTag.ndefRead(n);
            if (ndefMessage != null) return ndefMessage;
            switch (iNfcTag.getLastError(n)) {
                default: {
                    throw new IOException();
                }
                case -1: {
                    throw new IOException();
                }
                case -8: 
            }
            throw new FormatException();
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "NFC service dead", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getType() {
        switch (this.mNdefType) {
            default: {
                return UNKNOWN;
            }
            case 1: {
                return NFC_FORUM_TYPE_1;
            }
            case 2: {
                return NFC_FORUM_TYPE_2;
            }
            case 3: {
                return NFC_FORUM_TYPE_3;
            }
            case 4: {
                return NFC_FORUM_TYPE_4;
            }
            case 101: 
        }
        return MIFARE_CLASSIC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isWritable() {
        if (this.mCardState != 2) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean makeReadOnly() throws IOException {
        this.checkConnected();
        try {
            INfcTag iNfcTag = this.mTag.getTagService();
            int n = this.mTag.getServiceHandle();
            if (!iNfcTag.isNdef(n)) throw new IOException("Tag is not ndef");
            int n2 = this.mTag.getServiceHandle();
            switch (iNfcTag.ndefMakeReadOnly(n2)) {
                default: {
                    throw new IOException();
                }
                case 0: {
                    return true;
                }
                case -1: {
                    throw new IOException();
                }
                case -8: 
            }
            return false;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "NFC service dead", remoteException);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public void writeNdefMessage(NdefMessage var1_1) throws IOException, FormatException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 94->120)] android.os.RemoteException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

