/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.FormatException;
import android.nfc.INfcTag;
import android.nfc.NdefMessage;
import android.nfc.Tag;
import android.nfc.tech.BasicTagTechnology;
import android.nfc.tech.MifareClassic;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public final class NdefFormatable
extends BasicTagTechnology {
    private static final String TAG = "NFC";

    public NdefFormatable(Tag tag) throws RemoteException {
        super(tag, 7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NdefFormatable get(Tag tag) {
        if (!tag.hasTech(7)) {
            return null;
        }
        try {
            return new NdefFormatable(tag);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public void format(NdefMessage ndefMessage) throws IOException, FormatException {
        this.format(ndefMessage, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void format(NdefMessage ndefMessage, boolean bl) throws IOException, FormatException {
        this.checkConnected();
        try {
            int n = this.mTag.getServiceHandle();
            INfcTag iNfcTag = this.mTag.getTagService();
            byte[] byArray = MifareClassic.KEY_DEFAULT;
            switch (iNfcTag.formatNdef(n, byArray)) {
                default: {
                    throw new IOException();
                }
                case -1: {
                    throw new IOException();
                }
                case -8: {
                    throw new FormatException();
                }
                case 0: 
            }
            if (!iNfcTag.isNdef(n)) throw new IOException();
            switch (iNfcTag.ndefWrite(n, ndefMessage)) {
                default: {
                    throw new IOException();
                }
                case -1: {
                    throw new IOException();
                }
                case -8: {
                    throw new FormatException();
                }
                case 0: 
            }
            if (!bl) {
                return;
            }
            switch (iNfcTag.ndefMakeReadOnly(n)) {
                case 0: {
                    return;
                }
                default: {
                    throw new IOException();
                }
                case -1: {
                    throw new IOException();
                }
                case -8: 
            }
            throw new IOException();
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "NFC service dead", remoteException);
            return;
        }
    }

    public void formatReadOnly(NdefMessage ndefMessage) throws IOException, FormatException {
        this.format(ndefMessage, true);
    }
}

