/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.Tag;
import android.nfc.tech.BasicTagTechnology;
import android.os.Bundle;
import android.os.RemoteException;
import java.io.IOException;

public final class NfcF
extends BasicTagTechnology {
    public static final String EXTRA_PMM = "pmm";
    public static final String EXTRA_SC = "systemcode";
    private byte[] mManufacturer = null;
    private byte[] mSystemCode = null;

    public NfcF(Tag tag) throws RemoteException {
        super(tag, 4);
        Bundle bundle = tag.getTechExtras(4);
        if (bundle == null) {
            return;
        }
        byte[] byArray = bundle.getByteArray(EXTRA_SC);
        this.mSystemCode = byArray;
        byte[] byArray2 = bundle.getByteArray(EXTRA_PMM);
        this.mManufacturer = byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NfcF get(Tag tag) {
        if (!tag.hasTech(4)) {
            return null;
        }
        try {
            return new NfcF(tag);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public byte[] getManufacturer() {
        return this.mManufacturer;
    }

    public byte[] getSystemCode() {
        return this.mSystemCode;
    }

    public byte[] transceive(byte[] byArray) throws IOException {
        return this.transceive(byArray, true);
    }
}

