/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.ETC1;
import android.opengl.GLES10;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ETC1Util {
    public static ETC1Texture compressTexture(Buffer buffer, int n, int n2, int n3, int n4) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(ETC1.getEncodedDataSize(n, n2));
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        ByteBuffer byteBuffer2 = byteBuffer.order(byteOrder);
        Buffer buffer2 = buffer;
        int n5 = n;
        int n6 = n2;
        int n7 = n4;
        ETC1.encodeImage(buffer2, n5, n6, 3, n7, byteBuffer2);
        return new ETC1Texture(n, n2, byteBuffer2);
    }

    public static ETC1Texture createTexture(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        if (inputStream.read(byArray, 0, 16) != 16) {
            throw new IOException("Unable to read PKM file header.");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16);
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        ByteBuffer byteBuffer2 = byteBuffer.order(byteOrder);
        Buffer buffer = byteBuffer2.put(byArray, 0, 16).position(0);
        if (!ETC1.isValid(byteBuffer2)) {
            throw new IOException("Not a PKM file.");
        }
        int n2 = ETC1.getWidth(byteBuffer2);
        int n3 = ETC1.getHeight(byteBuffer2);
        int n4 = ETC1.getEncodedDataSize(n2, n3);
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(n4);
        ByteOrder byteOrder2 = ByteOrder.nativeOrder();
        ByteBuffer byteBuffer4 = byteBuffer3.order(byteOrder2);
        for (int i = 0; i < n4; i += n) {
            int n5 = byArray.length;
            int n6 = n4 - i;
            n = Math.min(n5, n6);
            if (inputStream.read(byArray, 0, n) != n) {
                throw new IOException("Unable to read PKM file data.");
            }
            ByteBuffer byteBuffer5 = byteBuffer4.put(byArray, 0, n);
        }
        Buffer buffer2 = byteBuffer4.position(0);
        return new ETC1Texture(n2, n3, byteBuffer4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isETC1Supported() {
        int[] nArray = new int[20];
        GLES10.glGetIntegerv(34466, nArray, 0);
        int n = nArray[0];
        int n2 = nArray.length;
        if (n > n2) {
            nArray = new int[n];
        }
        GLES10.glGetIntegerv(34467, nArray, 0);
        int n3 = 0;
        while (n3 < n) {
            if (nArray[n3] == 36196) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void loadTexture(int n, int n2, int n3, int n4, int n5, ETC1Texture eTC1Texture) {
        int n6;
        int n7;
        int n8 = n4;
        int n9 = 6407;
        if (n8 != n9) {
            throw new IllegalArgumentException("fallbackFormat must be GL_RGB");
        }
        int n10 = n5;
        int n11 = 33635;
        if (n10 != n11 && (n7 = n5) != (n6 = 5121)) {
            throw new IllegalArgumentException("Unsupported fallbackType");
        }
        int n12 = eTC1Texture.getWidth();
        int n13 = eTC1Texture.getHeight();
        ByteBuffer byteBuffer = eTC1Texture.getData();
        if (ETC1Util.isETC1Supported()) {
            int n14 = byteBuffer.remaining();
            int n15 = n;
            int n16 = n2;
            int n17 = n3;
            GLES10.glCompressedTexImage2D(n15, n16, 36196, n12, n13, n17, n14, byteBuffer);
            return;
        }
        int n18 = n5;
        int n19 = 5121;
        boolean bl = n18 != n19;
        int n20 = bl ? 2 : 3;
        int n21 = n20 * n12;
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n21 * n13);
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        ByteBuffer byteBuffer3 = byteBuffer2;
        ByteOrder byteOrder2 = byteOrder;
        ByteBuffer byteBuffer4 = byteBuffer3.order(byteOrder2);
        int n22 = n12;
        int n23 = n13;
        ETC1.decodeImage(byteBuffer, byteBuffer4, n22, n23, n20, n21);
        int n24 = n;
        int n25 = n2;
        int n26 = n4;
        int n27 = n12;
        int n28 = n13;
        int n29 = n3;
        int n30 = n4;
        int n31 = n5;
        ByteBuffer byteBuffer5 = byteBuffer4;
        GLES10.glTexImage2D(n24, n25, n26, n27, n28, n29, n30, n31, byteBuffer5);
    }

    public static void loadTexture(int n, int n2, int n3, int n4, int n5, InputStream inputStream) throws IOException {
        ETC1Texture eTC1Texture = ETC1Util.createTexture(inputStream);
        int n6 = n;
        int n7 = n2;
        int n8 = n3;
        int n9 = n4;
        int n10 = n5;
        ETC1Util.loadTexture(n6, n7, n8, n9, n10, eTC1Texture);
    }

    public static void writeTexture(ETC1Texture eTC1Texture, OutputStream outputStream) throws IOException {
        ByteBuffer byteBuffer = eTC1Texture.getData();
        int n = byteBuffer.position();
        try {
            int n2;
            int n3 = eTC1Texture.getWidth();
            int n4 = eTC1Texture.getHeight();
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(16);
            ByteOrder byteOrder = ByteOrder.nativeOrder();
            ByteBuffer byteBuffer3 = byteBuffer2.order(byteOrder);
            ETC1.formatHeader(byteBuffer3, n3, n4);
            byte[] byArray = new byte[4096];
            ByteBuffer byteBuffer4 = byteBuffer3.get(byArray, 0, 16);
            outputStream.write(byArray, 0, 16);
            int n5 = ETC1.getEncodedDataSize(n3, n4);
            for (int i = 0; i < n5; i += n2) {
                int n6 = byArray.length;
                int n7 = n5 - i;
                n2 = Math.min(n6, n7);
                ByteBuffer byteBuffer5 = byteBuffer.get(byArray, 0, n2);
                outputStream.write(byArray, 0, n2);
            }
        }
        catch (Throwable throwable) {
            Buffer buffer = byteBuffer.position(n);
            throw throwable;
        }
        Buffer buffer = byteBuffer.position(n);
    }

    public static class ETC1Texture {
        private ByteBuffer mData;
        private int mHeight;
        private int mWidth;

        public ETC1Texture(int n, int n2, ByteBuffer byteBuffer) {
            this.mWidth = n;
            this.mHeight = n2;
            this.mData = byteBuffer;
        }

        public ByteBuffer getData() {
            return this.mData;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public int getWidth() {
            return this.mWidth;
        }
    }
}

