/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.GLWrapperBase;
import java.io.IOException;
import java.io.Writer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;
import javax.microedition.khronos.opengles.GL11Ext;

class GLLogWrapper
extends GLWrapperBase {
    private static final int FORMAT_FIXED = 2;
    private static final int FORMAT_FLOAT = 1;
    private static final int FORMAT_INT;
    private int mArgCount;
    boolean mColorArrayEnabled;
    private PointerInfo mColorPointer;
    private Writer mLog;
    private boolean mLogArgumentNames;
    boolean mNormalArrayEnabled;
    private PointerInfo mNormalPointer;
    StringBuilder mStringBuilder;
    private PointerInfo mTexCoordPointer;
    boolean mTextureCoordArrayEnabled;
    boolean mVertexArrayEnabled;
    private PointerInfo mVertexPointer;

    public GLLogWrapper(GL gL, Writer writer, boolean bl) {
        super(gL);
        PointerInfo pointerInfo;
        PointerInfo pointerInfo2;
        PointerInfo pointerInfo3;
        PointerInfo pointerInfo4;
        this.mColorPointer = pointerInfo4 = new PointerInfo();
        this.mNormalPointer = pointerInfo3 = new PointerInfo();
        this.mTexCoordPointer = pointerInfo2 = new PointerInfo();
        this.mVertexPointer = pointerInfo = new PointerInfo();
        this.mLog = writer;
        this.mLogArgumentNames = bl;
    }

    private void arg(String string2, float f) {
        String string3 = Float.toString(f);
        this.arg(string2, string3);
    }

    private void arg(String string2, int n) {
        String string3 = Integer.toString(n);
        this.arg(string2, string3);
    }

    private void arg(String string2, int n, FloatBuffer floatBuffer) {
        String string3 = this.toString(n, floatBuffer);
        this.arg(string2, string3);
    }

    private void arg(String string2, int n, IntBuffer intBuffer) {
        String string3 = this.toString(n, 0, intBuffer);
        this.arg(string2, string3);
    }

    private void arg(String string2, int n, ShortBuffer shortBuffer) {
        String string3 = this.toString(n, shortBuffer);
        this.arg(string2, string3);
    }

    private void arg(String string2, int n, float[] fArray, int n2) {
        String string3 = this.toString(n, fArray, n2);
        this.arg(string2, string3);
    }

    private void arg(String string2, int n, int[] nArray, int n2) {
        String string3 = this.toString(n, 0, nArray, n2);
        this.arg(string2, string3);
    }

    private void arg(String string2, int n, short[] sArray, int n2) {
        String string3 = this.toString(n, sArray, n2);
        this.arg(string2, string3);
    }

    private void arg(String string2, String string3) {
        int n;
        int n2 = this.mArgCount;
        this.mArgCount = n = n2 + 1;
        if (n2 > 0) {
            this.log(", ");
        }
        if (this.mLogArgumentNames) {
            String string4 = string2 + "=";
            this.log(string4);
        }
        this.log(string3);
    }

    private void arg(String string2, boolean bl) {
        String string3 = Boolean.toString(bl);
        this.arg(string2, string3);
    }

    private void argPointer(int n, int n2, int n3, Buffer buffer) {
        this.arg("size", n);
        String string2 = this.getPointerTypeName(n2);
        this.arg("type", string2);
        this.arg("stride", n3);
        String string3 = buffer.toString();
        this.arg("pointer", string3);
    }

    private void begin(String string2) {
        String string3 = string2 + '(';
        this.log(string3);
        this.mArgCount = 0;
    }

    private void bindArrays() {
        if (this.mColorArrayEnabled) {
            this.mColorPointer.bindByteBuffer();
        }
        if (this.mNormalArrayEnabled) {
            this.mNormalPointer.bindByteBuffer();
        }
        if (this.mTextureCoordArrayEnabled) {
            this.mTexCoordPointer.bindByteBuffer();
        }
        if (!this.mVertexArrayEnabled) {
            return;
        }
        this.mVertexPointer.bindByteBuffer();
    }

    private void checkError() {
        int n = this.mgl.glGetError();
        if (n == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("glError: ");
        String string2 = Integer.toString(n);
        String string3 = stringBuilder.append(string2).toString();
        this.logLine(string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doArrayElement(StringBuilder stringBuilder, boolean bl, String string2, PointerInfo pointerInfo, int n) {
        if (!bl) {
            return;
        }
        StringBuilder stringBuilder2 = stringBuilder.append(" ");
        StringBuilder stringBuilder3 = new StringBuilder();
        String string3 = string2;
        String string4 = stringBuilder3.append(string3).append(":{").toString();
        StringBuilder stringBuilder4 = stringBuilder.append(string4);
        if (pointerInfo == null || pointerInfo.mTempByteBuffer == null) {
            StringBuilder stringBuilder5 = stringBuilder.append("undefined }");
            return;
        }
        if (pointerInfo.mStride < 0) {
            StringBuilder stringBuilder6 = stringBuilder.append("invalid stride");
            return;
        }
        int n2 = pointerInfo.getStride();
        ByteBuffer byteBuffer = pointerInfo.mTempByteBuffer;
        int n3 = pointerInfo.mSize;
        int n4 = pointerInfo.mType;
        PointerInfo pointerInfo2 = pointerInfo;
        int n5 = n4;
        int n6 = pointerInfo2.sizeof(n5);
        int n7 = n2 * n;
        int n8 = 0;
        while (true) {
            if (n8 >= n3) {
                StringBuilder stringBuilder7 = stringBuilder.append("}");
                return;
            }
            if (n8 > 0) {
                StringBuilder stringBuilder8 = stringBuilder.append(", ");
            }
            switch (n4) {
                default: {
                    StringBuilder stringBuilder9 = stringBuilder.append("?");
                    break;
                }
                case 5120: {
                    String string5 = Integer.toString(byteBuffer.get(n7));
                    StringBuilder stringBuilder10 = stringBuilder.append(string5);
                    break;
                }
                case 5121: {
                    String string6 = Integer.toString(byteBuffer.get(n7) & 0xFF);
                    StringBuilder stringBuilder11 = stringBuilder.append(string6);
                    break;
                }
                case 5122: {
                    ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                    int n9 = n7 / 2;
                    String string7 = Integer.toString(shortBuffer.get(n9));
                    StringBuilder stringBuilder12 = stringBuilder.append(string7);
                    break;
                }
                case 5132: {
                    IntBuffer intBuffer = byteBuffer.asIntBuffer();
                    int n10 = n7 / 4;
                    String string8 = Integer.toString(intBuffer.get(n10));
                    StringBuilder stringBuilder13 = stringBuilder.append(string8);
                    break;
                }
                case 5126: {
                    FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                    int n11 = n7 / 4;
                    String string9 = Float.toString(floatBuffer.get(n11));
                    StringBuilder stringBuilder14 = stringBuilder.append(string9);
                }
            }
            n7 += n6;
            ++n8;
        }
    }

    private void doElement(StringBuilder stringBuilder, int n, int n2) {
        String string2 = " [" + n + " : " + n2 + "] =";
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        boolean bl = this.mVertexArrayEnabled;
        PointerInfo pointerInfo = this.mVertexPointer;
        GLLogWrapper gLLogWrapper = this;
        StringBuilder stringBuilder3 = stringBuilder;
        int n3 = n2;
        gLLogWrapper.doArrayElement(stringBuilder3, bl, "v", pointerInfo, n3);
        boolean bl2 = this.mNormalArrayEnabled;
        PointerInfo pointerInfo2 = this.mNormalPointer;
        GLLogWrapper gLLogWrapper2 = this;
        StringBuilder stringBuilder4 = stringBuilder;
        int n4 = n2;
        gLLogWrapper2.doArrayElement(stringBuilder4, bl2, "n", pointerInfo2, n4);
        boolean bl3 = this.mColorArrayEnabled;
        PointerInfo pointerInfo3 = this.mColorPointer;
        GLLogWrapper gLLogWrapper3 = this;
        StringBuilder stringBuilder5 = stringBuilder;
        int n5 = n2;
        gLLogWrapper3.doArrayElement(stringBuilder5, bl3, "c", pointerInfo3, n5);
        boolean bl4 = this.mTextureCoordArrayEnabled;
        PointerInfo pointerInfo4 = this.mTexCoordPointer;
        GLLogWrapper gLLogWrapper4 = this;
        StringBuilder stringBuilder6 = stringBuilder;
        int n6 = n2;
        gLLogWrapper4.doArrayElement(stringBuilder6, bl4, "t", pointerInfo4, n6);
        StringBuilder stringBuilder7 = stringBuilder.append("\n");
    }

    private void end() {
        this.log(");\n");
        this.flush();
    }

    private void endLogIndices() {
        String string2 = this.mStringBuilder.toString();
        this.log(string2);
        this.unbindArrays();
    }

    private void flush() {
        try {
            this.mLog.flush();
            return;
        }
        catch (IOException iOException) {
            this.mLog = null;
            return;
        }
    }

    private void formattedAppend(StringBuilder stringBuilder, int n, int n2) {
        switch (n2) {
            default: {
                return;
            }
            case 0: {
                StringBuilder stringBuilder2 = stringBuilder.append(n);
                return;
            }
            case 1: {
                float f = Float.intBitsToFloat(n);
                StringBuilder stringBuilder3 = stringBuilder.append(f);
                return;
            }
            case 2: 
        }
        float f = (float)n / 65536.0f;
        StringBuilder stringBuilder4 = stringBuilder.append(f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getBeginMode(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 0: {
                return "GL_POINTS";
            }
            case 1: {
                return "GL_LINES";
            }
            case 2: {
                return "GL_LINE_LOOP";
            }
            case 3: {
                return "GL_LINE_STRIP";
            }
            case 4: {
                return "GL_TRIANGLES";
            }
            case 5: {
                return "GL_TRIANGLE_STRIP";
            }
            case 6: 
        }
        return "GL_TRIANGLE_FAN";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getCap(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 2912: {
                return "GL_FOG";
            }
            case 2896: {
                return "GL_LIGHTING";
            }
            case 3553: {
                return "GL_TEXTURE_2D";
            }
            case 2884: {
                return "GL_CULL_FACE";
            }
            case 3008: {
                return "GL_ALPHA_TEST";
            }
            case 3042: {
                return "GL_BLEND";
            }
            case 3058: {
                return "GL_COLOR_LOGIC_OP";
            }
            case 3024: {
                return "GL_DITHER";
            }
            case 2960: {
                return "GL_STENCIL_TEST";
            }
            case 2929: {
                return "GL_DEPTH_TEST";
            }
            case 16384: {
                return "GL_LIGHT0";
            }
            case 16385: {
                return "GL_LIGHT1";
            }
            case 16386: {
                return "GL_LIGHT2";
            }
            case 16387: {
                return "GL_LIGHT3";
            }
            case 16388: {
                return "GL_LIGHT4";
            }
            case 16389: {
                return "GL_LIGHT5";
            }
            case 16390: {
                return "GL_LIGHT6";
            }
            case 16391: {
                return "GL_LIGHT7";
            }
            case 2832: {
                return "GL_POINT_SMOOTH";
            }
            case 2848: {
                return "GL_LINE_SMOOTH";
            }
            case 2903: {
                return "GL_COLOR_MATERIAL";
            }
            case 2977: {
                return "GL_NORMALIZE";
            }
            case 32826: {
                return "GL_RESCALE_NORMAL";
            }
            case 32884: {
                return "GL_VERTEX_ARRAY";
            }
            case 32885: {
                return "GL_NORMAL_ARRAY";
            }
            case 32886: {
                return "GL_COLOR_ARRAY";
            }
            case 32888: {
                return "GL_TEXTURE_COORD_ARRAY";
            }
            case 32925: {
                return "GL_MULTISAMPLE";
            }
            case 32926: {
                return "GL_SAMPLE_ALPHA_TO_COVERAGE";
            }
            case 32927: {
                return "GL_SAMPLE_ALPHA_TO_ONE";
            }
            case 32928: {
                return "GL_SAMPLE_COVERAGE";
            }
            case 3089: 
        }
        return "GL_SCISSOR_TEST";
    }

    private String getClearBufferMask(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 0x100) != 0) {
            StringBuilder stringBuilder2 = stringBuilder.append("GL_DEPTH_BUFFER_BIT");
            n &= 0xFFFFFEFF;
        }
        if ((n & 0x400) != 0) {
            if (stringBuilder.length() > 0) {
                StringBuilder stringBuilder3 = stringBuilder.append(" | ");
            }
            StringBuilder stringBuilder4 = stringBuilder.append("GL_STENCIL_BUFFER_BIT");
            n &= 0xFFFFFBFF;
        }
        if ((n & 0x4000) != 0) {
            if (stringBuilder.length() > 0) {
                StringBuilder stringBuilder5 = stringBuilder.append(" | ");
            }
            StringBuilder stringBuilder6 = stringBuilder.append("GL_COLOR_BUFFER_BIT");
            n &= 0xFFFFBFFF;
        }
        if (n != 0) {
            if (stringBuilder.length() > 0) {
                StringBuilder stringBuilder7 = stringBuilder.append(" | ");
            }
            String string2 = GLLogWrapper.getHex(n);
            StringBuilder stringBuilder8 = stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getClientState(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 32886: {
                return "GL_COLOR_ARRAY";
            }
            case 32884: {
                return "GL_VERTEX_ARRAY";
            }
            case 32885: {
                return "GL_NORMAL_ARRAY";
            }
            case 32888: 
        }
        return "GL_TEXTURE_COORD_ARRAY";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getErrorString(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 0: {
                return "GL_NO_ERROR";
            }
            case 1280: {
                return "GL_INVALID_ENUM";
            }
            case 1281: {
                return "GL_INVALID_VALUE";
            }
            case 1282: {
                return "GL_INVALID_OPERATION";
            }
            case 1283: {
                return "GL_STACK_OVERFLOW";
            }
            case 1284: {
                return "GL_STACK_UNDERFLOW";
            }
            case 1285: 
        }
        return "GL_OUT_OF_MEMORY";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFaceName(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 1032: 
        }
        return "GL_FRONT_AND_BACK";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFactor(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 0: {
                return "GL_ZERO";
            }
            case 1: {
                return "GL_ONE";
            }
            case 768: {
                return "GL_SRC_COLOR";
            }
            case 769: {
                return "GL_ONE_MINUS_SRC_COLOR";
            }
            case 774: {
                return "GL_DST_COLOR";
            }
            case 775: {
                return "GL_ONE_MINUS_DST_COLOR";
            }
            case 770: {
                return "GL_SRC_ALPHA";
            }
            case 771: {
                return "GL_ONE_MINUS_SRC_ALPHA";
            }
            case 772: {
                return "GL_DST_ALPHA";
            }
            case 773: {
                return "GL_ONE_MINUS_DST_ALPHA";
            }
            case 776: 
        }
        return "GL_SRC_ALPHA_SATURATE";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFogPName(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 2914: {
                return "GL_FOG_DENSITY";
            }
            case 2915: {
                return "GL_FOG_START";
            }
            case 2916: {
                return "GL_FOG_END";
            }
            case 2917: {
                return "GL_FOG_MODE";
            }
            case 2918: 
        }
        return "GL_FOG_COLOR";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getFogParamCount(int n) {
        int n2 = 1;
        switch (n) {
            default: {
                n2 = 0;
            }
            case 2914: 
            case 2915: 
            case 2916: 
            case 2917: {
                return n2;
            }
            case 2918: 
        }
        return 4;
    }

    private static String getHex(int n) {
        StringBuilder stringBuilder = new StringBuilder().append("0x");
        String string2 = Integer.toHexString(n);
        return stringBuilder.append(string2).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getHintMode(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 4353: {
                return "GL_FASTEST";
            }
            case 4354: {
                return "GL_NICEST";
            }
            case 4352: 
        }
        return "GL_DONT_CARE";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getHintTarget(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 3156: {
                return "GL_FOG_HINT";
            }
            case 3154: {
                return "GL_LINE_SMOOTH_HINT";
            }
            case 3152: {
                return "GL_PERSPECTIVE_CORRECTION_HINT";
            }
            case 3153: {
                return "GL_POINT_SMOOTH_HINT";
            }
            case 3155: {
                return "GL_POLYGON_SMOOTH_HINT";
            }
            case 33170: 
        }
        return "GL_GENERATE_MIPMAP_HINT";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getIndexType(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 5123: {
                return "GL_UNSIGNED_SHORT";
            }
            case 5121: 
        }
        return "GL_UNSIGNED_BYTE";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getIntegerStateFormat(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 35213: 
            case 35214: 
            case 35215: 
        }
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getIntegerStateName(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 3413: {
                return "GL_ALPHA_BITS";
            }
            case 33902: {
                return "GL_ALIASED_LINE_WIDTH_RANGE";
            }
            case 33901: {
                return "GL_ALIASED_POINT_SIZE_RANGE";
            }
            case 3412: {
                return "GL_BLUE_BITS";
            }
            case 34467: {
                return "GL_COMPRESSED_TEXTURE_FORMATS";
            }
            case 3414: {
                return "GL_DEPTH_BITS";
            }
            case 3411: {
                return "GL_GREEN_BITS";
            }
            case 33001: {
                return "GL_MAX_ELEMENTS_INDICES";
            }
            case 33000: {
                return "GL_MAX_ELEMENTS_VERTICES";
            }
            case 3377: {
                return "GL_MAX_LIGHTS";
            }
            case 3379: {
                return "GL_MAX_TEXTURE_SIZE";
            }
            case 3386: {
                return "GL_MAX_VIEWPORT_DIMS";
            }
            case 3382: {
                return "GL_MAX_MODELVIEW_STACK_DEPTH";
            }
            case 3384: {
                return "GL_MAX_PROJECTION_STACK_DEPTH";
            }
            case 3385: {
                return "GL_MAX_TEXTURE_STACK_DEPTH";
            }
            case 34018: {
                return "GL_MAX_TEXTURE_UNITS";
            }
            case 34466: {
                return "GL_NUM_COMPRESSED_TEXTURE_FORMATS";
            }
            case 3410: {
                return "GL_RED_BITS";
            }
            case 2850: {
                return "GL_SMOOTH_LINE_WIDTH_RANGE";
            }
            case 2834: {
                return "GL_SMOOTH_POINT_SIZE_RANGE";
            }
            case 3415: {
                return "GL_STENCIL_BITS";
            }
            case 3408: {
                return "GL_SUBPIXEL_BITS";
            }
            case 35213: {
                return "GL_MODELVIEW_MATRIX_FLOAT_AS_INT_BITS_OES";
            }
            case 35214: {
                return "GL_PROJECTION_MATRIX_FLOAT_AS_INT_BITS_OES";
            }
            case 35215: 
        }
        return "GL_TEXTURE_MATRIX_FLOAT_AS_INT_BITS_OES";
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    private int getIntegerStateSize(int n) {
        int n2 = 1;
        int n3 = 0;
        block10: do {
            switch (n3 == 0 ? n : n3) {
                default: {
                    n2 = 0;
                    n3 = 3377;
                    continue block10;
                }
                case 33902: {
                    n2 = 2;
                    n3 = 3377;
                    continue block10;
                }
                case 33901: {
                    n2 = 2;
                    n3 = 3377;
                    continue block10;
                }
                case 34467: {
                    int[] nArray = new int[1];
                    this.mgl.glGetIntegerv(34466, nArray, 0);
                    n2 = nArray[0];
                    n3 = 3377;
                    continue block10;
                }
                case 3386: {
                    n2 = 2;
                    n3 = 3377;
                    continue block10;
                }
                case 2850: {
                    n2 = 2;
                    n3 = 3377;
                    continue block10;
                }
                case 2834: {
                    n2 = 2;
                }
                case 3377: 
                case 3379: 
                case 3382: 
                case 3384: 
                case 3385: 
                case 3408: 
                case 3410: 
                case 3411: 
                case 3412: 
                case 3413: 
                case 3414: 
                case 3415: 
                case 33000: 
                case 33001: 
                case 34018: 
                case 34466: {
                    return n2;
                }
                case 35213: 
                case 35214: 
                case 35215: 
            }
            return 16;
        } while (true);
        return 16;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getLightModelPName(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 2899: {
                return "GL_LIGHT_MODEL_AMBIENT";
            }
            case 2898: 
        }
        return "GL_LIGHT_MODEL_TWO_SIDE";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getLightModelParamCount(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 2899: {
                return 4;
            }
            case 2898: 
        }
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getLightName(int n) {
        if (n < 16384) return GLLogWrapper.getHex(n);
        if (n > 16391) return GLLogWrapper.getHex(n);
        StringBuilder stringBuilder = new StringBuilder().append("GL_LIGHT");
        String string2 = Integer.toString(n);
        return stringBuilder.append(string2).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getLightPName(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 4608: {
                return "GL_AMBIENT";
            }
            case 4609: {
                return "GL_DIFFUSE";
            }
            case 4610: {
                return "GL_SPECULAR";
            }
            case 4611: {
                return "GL_POSITION";
            }
            case 4612: {
                return "GL_SPOT_DIRECTION";
            }
            case 4613: {
                return "GL_SPOT_EXPONENT";
            }
            case 4614: {
                return "GL_SPOT_CUTOFF";
            }
            case 4615: {
                return "GL_CONSTANT_ATTENUATION";
            }
            case 4616: {
                return "GL_LINEAR_ATTENUATION";
            }
            case 4617: 
        }
        return "GL_QUADRATIC_ATTENUATION";
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    private int getLightParamCount(int n) {
        int n2 = 1;
        int n3 = 0;
        block8: do {
            switch (n3 == 0 ? n : n3) {
                default: {
                    n2 = 0;
                    n3 = 4613;
                    continue block8;
                }
                case 4608: {
                    n2 = 4;
                    n3 = 4613;
                    continue block8;
                }
                case 4609: {
                    n2 = 4;
                    n3 = 4613;
                    continue block8;
                }
                case 4610: {
                    n2 = 4;
                    n3 = 4613;
                    continue block8;
                }
                case 4611: {
                    n2 = 4;
                }
                case 4613: 
                case 4614: 
                case 4615: 
                case 4616: 
                case 4617: {
                    return n2;
                }
                case 4612: 
            }
            return 3;
        } while (true);
        return 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getMaterialPName(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 4608: {
                return "GL_AMBIENT";
            }
            case 4609: {
                return "GL_DIFFUSE";
            }
            case 4610: {
                return "GL_SPECULAR";
            }
            case 5632: {
                return "GL_EMISSION";
            }
            case 5633: {
                return "GL_SHININESS";
            }
            case 5634: 
        }
        return "GL_AMBIENT_AND_DIFFUSE";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getMaterialParamCount(int n) {
        int n2 = 4;
        switch (n) {
            default: {
                n2 = 0;
            }
            case 4608: 
            case 4609: 
            case 4610: 
            case 5632: 
            case 5634: {
                return n2;
            }
            case 5633: 
        }
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getMatrixMode(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 5888: {
                return "GL_MODELVIEW";
            }
            case 5889: {
                return "GL_PROJECTION";
            }
            case 5890: 
        }
        return "GL_TEXTURE";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getPointerTypeName(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 5120: {
                return "GL_BYTE";
            }
            case 5121: {
                return "GL_UNSIGNED_BYTE";
            }
            case 5122: {
                return "GL_SHORT";
            }
            case 5132: {
                return "GL_FIXED";
            }
            case 5126: 
        }
        return "GL_FLOAT";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getShadeModel(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 7424: {
                return "GL_FLAT";
            }
            case 7425: 
        }
        return "GL_SMOOTH";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getTextureEnvPName(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 8704: {
                return "GL_TEXTURE_ENV_MODE";
            }
            case 8705: 
        }
        return "GL_TEXTURE_ENV_COLOR";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getTextureEnvParamCount(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 8704: {
                return 1;
            }
            case 8705: 
        }
        return 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getTextureEnvParamName(float f) {
        int n = (int)f;
        float f2 = n;
        if (f != f2) return Float.toString(f);
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 7681: {
                return "GL_REPLACE";
            }
            case 8448: {
                return "GL_MODULATE";
            }
            case 8449: {
                return "GL_DECAL";
            }
            case 3042: {
                return "GL_BLEND";
            }
            case 260: {
                return "GL_ADD";
            }
            case 34160: 
        }
        return "GL_COMBINE";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getTextureEnvTarget(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 8960: 
        }
        return "GL_TEXTURE_ENV";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getTexturePName(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 10240: {
                return "GL_TEXTURE_MAG_FILTER";
            }
            case 10241: {
                return "GL_TEXTURE_MIN_FILTER";
            }
            case 10242: {
                return "GL_TEXTURE_WRAP_S";
            }
            case 10243: {
                return "GL_TEXTURE_WRAP_T";
            }
            case 33169: {
                return "GL_GENERATE_MIPMAP";
            }
            case 35741: 
        }
        return "GL_TEXTURE_CROP_RECT_OES";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getTextureParamName(float f) {
        int n = (int)f;
        float f2 = n;
        if (f != f2) return Float.toString(f);
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 33071: {
                return "GL_CLAMP_TO_EDGE";
            }
            case 10497: {
                return "GL_REPEAT";
            }
            case 9728: {
                return "GL_NEAREST";
            }
            case 9729: {
                return "GL_LINEAR";
            }
            case 9984: {
                return "GL_NEAREST_MIPMAP_NEAREST";
            }
            case 9985: {
                return "GL_LINEAR_MIPMAP_NEAREST";
            }
            case 9986: {
                return "GL_NEAREST_MIPMAP_LINEAR";
            }
            case 9987: 
        }
        return "GL_LINEAR_MIPMAP_LINEAR";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getTextureTarget(int n) {
        switch (n) {
            default: {
                return GLLogWrapper.getHex(n);
            }
            case 3553: 
        }
        return "GL_TEXTURE_2D";
    }

    private void log(String string2) {
        try {
            this.mLog.write(string2);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void logLine(String string2) {
        String string3 = string2 + '\n';
        this.log(string3);
    }

    private void returns(int n) {
        String string2 = Integer.toString(n);
        this.returns(string2);
    }

    private void returns(String string2) {
        String string3 = ") returns " + string2 + ";\n";
        this.log(string3);
        this.flush();
    }

    private void startLogIndices() {
        StringBuilder stringBuilder;
        this.mStringBuilder = stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = this.mStringBuilder.append("\n");
        this.bindArrays();
    }

    /*
     * Enabled aggressive block sorting
     */
    private ByteBuffer toByteBuffer(int n, Buffer buffer) {
        ByteBuffer byteBuffer;
        boolean bl = n < 0;
        if (buffer instanceof ByteBuffer) {
            ByteBuffer byteBuffer2 = (ByteBuffer)buffer;
            int n2 = byteBuffer2.position();
            if (bl) {
                n = byteBuffer2.limit() - n2;
            }
            ByteBuffer byteBuffer3 = ByteBuffer.allocate(n);
            ByteOrder byteOrder = byteBuffer2.order();
            byteBuffer = byteBuffer3.order(byteOrder);
            for (int i = 0; i < n; ++i) {
                byte by = byteBuffer2.get();
                ByteBuffer byteBuffer4 = byteBuffer.put(by);
            }
            Buffer buffer2 = byteBuffer2.position(n2);
        } else if (buffer instanceof CharBuffer) {
            int n3;
            CharBuffer charBuffer = (CharBuffer)buffer;
            int n4 = charBuffer.position();
            if (bl) {
                n = (charBuffer.limit() - n4) * 2;
            }
            ByteBuffer byteBuffer5 = ByteBuffer.allocate(n);
            ByteOrder byteOrder = charBuffer.order();
            byteBuffer = byteBuffer5.order(byteOrder);
            CharBuffer charBuffer2 = byteBuffer.asCharBuffer();
            int n5 = 0;
            while (n5 < (n3 = n / 2)) {
                char c = charBuffer.get();
                CharBuffer charBuffer3 = charBuffer2.put(c);
                int n6 = n5 + 1;
            }
            Buffer buffer3 = charBuffer.position(n4);
        } else if (buffer instanceof ShortBuffer) {
            int n7;
            ShortBuffer shortBuffer = (ShortBuffer)buffer;
            int n8 = shortBuffer.position();
            if (bl) {
                n = (shortBuffer.limit() - n8) * 2;
            }
            ByteBuffer byteBuffer6 = ByteBuffer.allocate(n);
            ByteOrder byteOrder = shortBuffer.order();
            byteBuffer = byteBuffer6.order(byteOrder);
            ShortBuffer shortBuffer2 = byteBuffer.asShortBuffer();
            int n9 = 0;
            while (n9 < (n7 = n / 2)) {
                short s = shortBuffer.get();
                ShortBuffer shortBuffer3 = shortBuffer2.put(s);
                int n10 = n9 + 1;
            }
            Buffer buffer4 = shortBuffer.position(n8);
        } else if (buffer instanceof IntBuffer) {
            int n11;
            IntBuffer intBuffer = (IntBuffer)buffer;
            int n12 = intBuffer.position();
            if (bl) {
                n = (intBuffer.limit() - n12) * 4;
            }
            ByteBuffer byteBuffer7 = ByteBuffer.allocate(n);
            ByteOrder byteOrder = intBuffer.order();
            byteBuffer = byteBuffer7.order(byteOrder);
            IntBuffer intBuffer2 = byteBuffer.asIntBuffer();
            int n13 = 0;
            while (n13 < (n11 = n / 4)) {
                int n14 = intBuffer.get();
                IntBuffer intBuffer3 = intBuffer2.put(n14);
                int n15 = n13 + 1;
            }
            Buffer buffer5 = intBuffer.position(n12);
        } else if (buffer instanceof FloatBuffer) {
            int n16;
            FloatBuffer floatBuffer = (FloatBuffer)buffer;
            int n17 = floatBuffer.position();
            if (bl) {
                n = (floatBuffer.limit() - n17) * 4;
            }
            ByteBuffer byteBuffer8 = ByteBuffer.allocate(n);
            ByteOrder byteOrder = floatBuffer.order();
            byteBuffer = byteBuffer8.order(byteOrder);
            FloatBuffer floatBuffer2 = byteBuffer.asFloatBuffer();
            int n18 = 0;
            while (n18 < (n16 = n / 4)) {
                float f = floatBuffer.get();
                FloatBuffer floatBuffer3 = floatBuffer2.put(f);
                int n19 = n18 + 1;
            }
            Buffer buffer6 = floatBuffer.position(n17);
        } else if (buffer instanceof DoubleBuffer) {
            int n20;
            DoubleBuffer doubleBuffer = (DoubleBuffer)buffer;
            int n21 = doubleBuffer.position();
            if (bl) {
                n = (doubleBuffer.limit() - n21) * 8;
            }
            ByteBuffer byteBuffer9 = ByteBuffer.allocate(n);
            ByteOrder byteOrder = doubleBuffer.order();
            byteBuffer = byteBuffer9.order(byteOrder);
            DoubleBuffer doubleBuffer2 = byteBuffer.asDoubleBuffer();
            int n22 = 0;
            while (n22 < (n20 = n / 8)) {
                double d = doubleBuffer.get();
                DoubleBuffer doubleBuffer3 = doubleBuffer2.put(d);
                int n23 = n22 + 1;
            }
            Buffer buffer7 = doubleBuffer.position(n21);
        } else {
            int n24;
            if (!(buffer instanceof LongBuffer)) {
                throw new RuntimeException("Unimplemented Buffer subclass.");
            }
            LongBuffer longBuffer = (LongBuffer)buffer;
            int n25 = longBuffer.position();
            if (bl) {
                n = (longBuffer.limit() - n25) * 8;
            }
            ByteBuffer byteBuffer10 = ByteBuffer.allocate(n);
            ByteOrder byteOrder = longBuffer.order();
            byteBuffer = byteBuffer10.order(byteOrder);
            LongBuffer longBuffer2 = byteBuffer.asLongBuffer();
            int n26 = 0;
            while (n26 < (n24 = n / 8)) {
                long l = longBuffer.get();
                LongBuffer longBuffer3 = longBuffer2.put(l);
                int n27 = n26 + 1;
            }
            Buffer buffer8 = longBuffer.position(n25);
        }
        Buffer buffer9 = byteBuffer.rewind();
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        ByteBuffer byteBuffer11 = byteBuffer.order(byteOrder);
        return byteBuffer;
    }

    /*
     * Enabled aggressive block sorting
     */
    private char[] toCharIndices(int n, int n2, Buffer buffer) {
        CharBuffer charBuffer;
        char[] cArray = new char[n];
        switch (n2) {
            default: {
                return cArray;
            }
            case 5121: {
                ByteBuffer byteBuffer = this.toByteBuffer(n, buffer);
                byte[] byArray = byteBuffer.array();
                int n3 = byteBuffer.arrayOffset();
                int n4 = 0;
                while (n4 < n) {
                    char c;
                    int n5 = n3 + n4;
                    cArray[n4] = c = (char)(byArray[n5] & 0xFF);
                    ++n4;
                }
                return cArray;
            }
            case 5123: 
        }
        if (buffer instanceof CharBuffer) {
            charBuffer = (CharBuffer)buffer;
        } else {
            int n6 = n * 2;
            charBuffer = this.toByteBuffer(n6, buffer).asCharBuffer();
        }
        int n7 = charBuffer.position();
        Buffer buffer2 = charBuffer.position(0);
        CharBuffer charBuffer2 = charBuffer.get(cArray);
        Buffer buffer3 = charBuffer.position(n7);
        return cArray;
    }

    private String toString(int n, int n2, IntBuffer intBuffer) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("{\n");
        for (int i = 0; i < n; ++i) {
            String string2 = " [" + i + "] = ";
            StringBuilder stringBuilder3 = stringBuilder.append(string2);
            int n3 = intBuffer.get(i);
            this.formattedAppend(stringBuilder, n3, n2);
            StringBuilder stringBuilder4 = stringBuilder.append('\n');
        }
        StringBuilder stringBuilder5 = stringBuilder.append("}");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String toString(int n, int n2, int[] nArray, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("{\n");
        int n4 = nArray.length;
        int n5 = 0;
        while (true) {
            if (n5 >= n) {
                StringBuilder stringBuilder3 = stringBuilder.append("}");
                return stringBuilder.toString();
            }
            int n6 = n3 + n5;
            String string2 = " [" + n6 + "] = ";
            StringBuilder stringBuilder4 = stringBuilder.append(string2);
            if (n6 < 0 || n6 >= n4) {
                StringBuilder stringBuilder5 = stringBuilder.append("out of bounds");
            } else {
                int n7 = nArray[n6];
                this.formattedAppend(stringBuilder, n7, n2);
            }
            StringBuilder stringBuilder6 = stringBuilder.append('\n');
            ++n5;
        }
    }

    private String toString(int n, FloatBuffer floatBuffer) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("{\n");
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder3 = new StringBuilder().append(" [").append(i).append("] = ");
            float f = floatBuffer.get(i);
            String string2 = stringBuilder3.append(f).append('\n').toString();
            StringBuilder stringBuilder4 = stringBuilder.append(string2);
        }
        StringBuilder stringBuilder5 = stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toString(int n, ShortBuffer shortBuffer) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("{\n");
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder3 = new StringBuilder().append(" [").append(i).append("] = ");
            short s = shortBuffer.get(i);
            String string2 = stringBuilder3.append(s).append('\n').toString();
            StringBuilder stringBuilder4 = stringBuilder.append(string2);
        }
        StringBuilder stringBuilder5 = stringBuilder.append("}");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String toString(int n, float[] fArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("{\n");
        int n3 = fArray.length;
        int n4 = 0;
        while (true) {
            if (n4 >= n) {
                StringBuilder stringBuilder3 = stringBuilder.append("}");
                return stringBuilder.toString();
            }
            int n5 = n2 + n4;
            String string2 = "[" + n5 + "] = ";
            StringBuilder stringBuilder4 = stringBuilder.append(string2);
            if (n5 < 0 || n5 >= n3) {
                StringBuilder stringBuilder5 = stringBuilder.append("out of bounds");
            } else {
                float f = fArray[n5];
                StringBuilder stringBuilder6 = stringBuilder.append(f);
            }
            StringBuilder stringBuilder7 = stringBuilder.append('\n');
            ++n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String toString(int n, short[] sArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("{\n");
        int n3 = sArray.length;
        int n4 = 0;
        while (true) {
            if (n4 >= n) {
                StringBuilder stringBuilder3 = stringBuilder.append("}");
                return stringBuilder.toString();
            }
            int n5 = n2 + n4;
            String string2 = " [" + n5 + "] = ";
            StringBuilder stringBuilder4 = stringBuilder.append(string2);
            if (n5 < 0 || n5 >= n3) {
                StringBuilder stringBuilder5 = stringBuilder.append("out of bounds");
            } else {
                short s = sArray[n5];
                StringBuilder stringBuilder6 = stringBuilder.append(s);
            }
            StringBuilder stringBuilder7 = stringBuilder.append('\n');
            ++n4;
        }
    }

    private void unbindArrays() {
        if (this.mColorArrayEnabled) {
            this.mColorPointer.unbindByteBuffer();
        }
        if (this.mNormalArrayEnabled) {
            this.mNormalPointer.unbindByteBuffer();
        }
        if (this.mTextureCoordArrayEnabled) {
            this.mTexCoordPointer.unbindByteBuffer();
        }
        if (!this.mVertexArrayEnabled) {
            return;
        }
        this.mVertexPointer.unbindByteBuffer();
    }

    @Override
    public void glActiveTexture(int n) {
        this.begin("glActiveTexture");
        this.arg("texture", n);
        this.end();
        this.mgl.glActiveTexture(n);
        this.checkError();
    }

    @Override
    public void glAlphaFunc(int n, float f) {
        this.begin("glAlphaFunc");
        this.arg("func", n);
        this.arg("ref", f);
        this.end();
        this.mgl.glAlphaFunc(n, f);
        this.checkError();
    }

    @Override
    public void glAlphaFuncx(int n, int n2) {
        this.begin("glAlphaFuncx");
        this.arg("func", n);
        this.arg("ref", n2);
        this.end();
        this.mgl.glAlphaFuncx(n, n2);
        this.checkError();
    }

    @Override
    public void glBindBuffer(int n, int n2) {
        this.begin("glBindBuffer");
        this.arg("target", n);
        this.arg("buffer", n2);
        this.end();
        this.mgl11.glBindBuffer(n, n2);
        this.checkError();
    }

    @Override
    public void glBindTexture(int n, int n2) {
        this.begin("glBindTexture");
        String string2 = this.getTextureTarget(n);
        this.arg("target", string2);
        this.arg("texture", n2);
        this.end();
        this.mgl.glBindTexture(n, n2);
        this.checkError();
    }

    @Override
    public void glBlendFunc(int n, int n2) {
        this.begin("glBlendFunc");
        String string2 = this.getFactor(n);
        this.arg("sfactor", string2);
        String string3 = this.getFactor(n2);
        this.arg("dfactor", string3);
        this.end();
        this.mgl.glBlendFunc(n, n2);
        this.checkError();
    }

    @Override
    public void glBufferData(int n, int n2, Buffer buffer, int n3) {
        this.begin("glBufferData");
        this.arg("target", n);
        this.arg("size", n2);
        String string2 = buffer.toString();
        this.arg("data", string2);
        this.arg("usage", n3);
        this.end();
        this.mgl11.glBufferData(n, n2, buffer, n3);
        this.checkError();
    }

    @Override
    public void glBufferSubData(int n, int n2, int n3, Buffer buffer) {
        this.begin("glBufferSubData");
        this.arg("target", n);
        this.arg("offset", n2);
        this.arg("size", n3);
        String string2 = buffer.toString();
        this.arg("data", string2);
        this.end();
        this.mgl11.glBufferSubData(n, n2, n3, buffer);
        this.checkError();
    }

    @Override
    public void glClear(int n) {
        this.begin("glClear");
        String string2 = this.getClearBufferMask(n);
        this.arg("mask", string2);
        this.end();
        this.mgl.glClear(n);
        this.checkError();
    }

    @Override
    public void glClearColor(float f, float f2, float f3, float f4) {
        this.begin("glClearColor");
        this.arg("red", f);
        this.arg("green", f2);
        this.arg("blue", f3);
        this.arg("alpha", f4);
        this.end();
        this.mgl.glClearColor(f, f2, f3, f4);
        this.checkError();
    }

    @Override
    public void glClearColorx(int n, int n2, int n3, int n4) {
        this.begin("glClearColor");
        this.arg("red", n);
        this.arg("green", n2);
        this.arg("blue", n3);
        this.arg("alpha", n4);
        this.end();
        this.mgl.glClearColorx(n, n2, n3, n4);
        this.checkError();
    }

    @Override
    public void glClearDepthf(float f) {
        this.begin("glClearDepthf");
        this.arg("depth", f);
        this.end();
        this.mgl.glClearDepthf(f);
        this.checkError();
    }

    @Override
    public void glClearDepthx(int n) {
        this.begin("glClearDepthx");
        this.arg("depth", n);
        this.end();
        this.mgl.glClearDepthx(n);
        this.checkError();
    }

    @Override
    public void glClearStencil(int n) {
        this.begin("glClearStencil");
        this.arg("s", n);
        this.end();
        this.mgl.glClearStencil(n);
        this.checkError();
    }

    @Override
    public void glClientActiveTexture(int n) {
        this.begin("glClientActiveTexture");
        this.arg("texture", n);
        this.end();
        this.mgl.glClientActiveTexture(n);
        this.checkError();
    }

    @Override
    public void glClipPlanef(int n, FloatBuffer floatBuffer) {
        this.begin("glClipPlanef");
        this.arg("plane", n);
        this.arg("equation", 4, floatBuffer);
        this.end();
        this.mgl11.glClipPlanef(n, floatBuffer);
        this.checkError();
    }

    @Override
    public void glClipPlanef(int n, float[] fArray, int n2) {
        this.begin("glClipPlanef");
        this.arg("plane", n);
        this.arg("equation", 4, fArray, n2);
        this.arg("offset", n2);
        this.end();
        this.mgl11.glClipPlanef(n, fArray, n2);
        this.checkError();
    }

    @Override
    public void glClipPlanex(int n, IntBuffer intBuffer) {
        this.begin("glClipPlanef");
        this.arg("plane", n);
        this.arg("equation", 4, intBuffer);
        this.end();
        this.mgl11.glClipPlanex(n, intBuffer);
        this.checkError();
    }

    @Override
    public void glClipPlanex(int n, int[] nArray, int n2) {
        this.begin("glClipPlanex");
        this.arg("plane", n);
        this.arg("equation", 4, nArray, n2);
        this.arg("offset", n2);
        this.end();
        this.mgl11.glClipPlanex(n, nArray, n2);
        this.checkError();
    }

    @Override
    public void glColor4f(float f, float f2, float f3, float f4) {
        this.begin("glColor4f");
        this.arg("red", f);
        this.arg("green", f2);
        this.arg("blue", f3);
        this.arg("alpha", f4);
        this.end();
        this.mgl.glColor4f(f, f2, f3, f4);
        this.checkError();
    }

    @Override
    public void glColor4ub(byte by, byte by2, byte by3, byte by4) {
        this.begin("glColor4ub");
        this.arg("red", by);
        this.arg("green", by2);
        this.arg("blue", by3);
        this.arg("alpha", by4);
        this.end();
        this.mgl11.glColor4ub(by, by2, by3, by4);
        this.checkError();
    }

    @Override
    public void glColor4x(int n, int n2, int n3, int n4) {
        this.begin("glColor4x");
        this.arg("red", n);
        this.arg("green", n2);
        this.arg("blue", n3);
        this.arg("alpha", n4);
        this.end();
        this.mgl.glColor4x(n, n2, n3, n4);
        this.checkError();
    }

    @Override
    public void glColorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.begin("glColorMask");
        this.arg("red", bl);
        this.arg("green", bl2);
        this.arg("blue", bl3);
        this.arg("alpha", bl4);
        this.end();
        this.mgl.glColorMask(bl, bl2, bl3, bl4);
        this.checkError();
    }

    @Override
    public void glColorPointer(int n, int n2, int n3, int n4) {
        this.begin("glColorPointer");
        this.arg("size", n);
        this.arg("type", n2);
        this.arg("stride", n3);
        this.arg("offset", n4);
        this.end();
        this.mgl11.glColorPointer(n, n2, n3, n4);
        this.checkError();
    }

    @Override
    public void glColorPointer(int n, int n2, int n3, Buffer buffer) {
        PointerInfo pointerInfo;
        this.begin("glColorPointer");
        this.argPointer(n, n2, n3, buffer);
        this.end();
        GLLogWrapper gLLogWrapper = this;
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        Buffer buffer2 = buffer;
        this.mColorPointer = pointerInfo = gLLogWrapper.new PointerInfo(n4, n5, n6, buffer2);
        this.mgl.glColorPointer(n, n2, n3, buffer);
        this.checkError();
    }

    @Override
    public void glCompressedTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer) {
        this.begin("glCompressedTexImage2D");
        String string2 = this.getTextureTarget(n);
        this.arg("target", string2);
        this.arg("level", n2);
        this.arg("internalformat", n3);
        GLLogWrapper gLLogWrapper = this;
        String string3 = "width";
        int n8 = n4;
        gLLogWrapper.arg(string3, n8);
        GLLogWrapper gLLogWrapper2 = this;
        String string4 = "height";
        int n9 = n5;
        gLLogWrapper2.arg(string4, n9);
        GLLogWrapper gLLogWrapper3 = this;
        String string5 = "border";
        int n10 = n6;
        gLLogWrapper3.arg(string5, n10);
        GLLogWrapper gLLogWrapper4 = this;
        String string6 = "imageSize";
        int n11 = n7;
        gLLogWrapper4.arg(string6, n11);
        String string7 = buffer.toString();
        this.arg("data", string7);
        this.end();
        GL10 gL10 = this.mgl;
        int n12 = n;
        int n13 = n2;
        int n14 = n3;
        int n15 = n4;
        int n16 = n5;
        int n17 = n6;
        int n18 = n7;
        Buffer buffer2 = buffer;
        gL10.glCompressedTexImage2D(n12, n13, n14, n15, n16, n17, n18, buffer2);
        this.checkError();
    }

    @Override
    public void glCompressedTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        this.begin("glCompressedTexSubImage2D");
        String string2 = this.getTextureTarget(n);
        this.arg("target", string2);
        this.arg("level", n2);
        GLLogWrapper gLLogWrapper = this;
        String string3 = "xoffset";
        int n9 = n3;
        gLLogWrapper.arg(string3, n9);
        GLLogWrapper gLLogWrapper2 = this;
        String string4 = "yoffset";
        int n10 = n4;
        gLLogWrapper2.arg(string4, n10);
        GLLogWrapper gLLogWrapper3 = this;
        String string5 = "width";
        int n11 = n5;
        gLLogWrapper3.arg(string5, n11);
        GLLogWrapper gLLogWrapper4 = this;
        String string6 = "height";
        int n12 = n6;
        gLLogWrapper4.arg(string6, n12);
        GLLogWrapper gLLogWrapper5 = this;
        String string7 = "format";
        int n13 = n7;
        gLLogWrapper5.arg(string7, n13);
        GLLogWrapper gLLogWrapper6 = this;
        String string8 = "imageSize";
        int n14 = n8;
        gLLogWrapper6.arg(string8, n14);
        String string9 = buffer.toString();
        this.arg("data", string9);
        this.end();
        GL10 gL10 = this.mgl;
        int n15 = n;
        int n16 = n2;
        int n17 = n3;
        int n18 = n4;
        int n19 = n5;
        int n20 = n6;
        int n21 = n7;
        int n22 = n8;
        Buffer buffer2 = buffer;
        gL10.glCompressedTexSubImage2D(n15, n16, n17, n18, n19, n20, n21, n22, buffer2);
        this.checkError();
    }

    @Override
    public void glCopyTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.begin("glCopyTexImage2D");
        String string2 = this.getTextureTarget(n);
        this.arg("target", string2);
        this.arg("level", n2);
        this.arg("internalformat", n3);
        GLLogWrapper gLLogWrapper = this;
        String string3 = "x";
        int n9 = n4;
        gLLogWrapper.arg(string3, n9);
        GLLogWrapper gLLogWrapper2 = this;
        String string4 = "y";
        int n10 = n5;
        gLLogWrapper2.arg(string4, n10);
        GLLogWrapper gLLogWrapper3 = this;
        String string5 = "width";
        int n11 = n6;
        gLLogWrapper3.arg(string5, n11);
        GLLogWrapper gLLogWrapper4 = this;
        String string6 = "height";
        int n12 = n7;
        gLLogWrapper4.arg(string6, n12);
        GLLogWrapper gLLogWrapper5 = this;
        String string7 = "border";
        int n13 = n8;
        gLLogWrapper5.arg(string7, n13);
        this.end();
        GL10 gL10 = this.mgl;
        int n14 = n;
        int n15 = n2;
        int n16 = n3;
        int n17 = n4;
        int n18 = n5;
        int n19 = n6;
        int n20 = n7;
        int n21 = n8;
        gL10.glCopyTexImage2D(n14, n15, n16, n17, n18, n19, n20, n21);
        this.checkError();
    }

    @Override
    public void glCopyTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.begin("glCopyTexSubImage2D");
        String string2 = this.getTextureTarget(n);
        this.arg("target", string2);
        this.arg("level", n2);
        this.arg("xoffset", n3);
        GLLogWrapper gLLogWrapper = this;
        String string3 = "yoffset";
        int n9 = n4;
        gLLogWrapper.arg(string3, n9);
        GLLogWrapper gLLogWrapper2 = this;
        String string4 = "x";
        int n10 = n5;
        gLLogWrapper2.arg(string4, n10);
        GLLogWrapper gLLogWrapper3 = this;
        String string5 = "y";
        int n11 = n6;
        gLLogWrapper3.arg(string5, n11);
        GLLogWrapper gLLogWrapper4 = this;
        String string6 = "width";
        int n12 = n7;
        gLLogWrapper4.arg(string6, n12);
        GLLogWrapper gLLogWrapper5 = this;
        String string7 = "height";
        int n13 = n8;
        gLLogWrapper5.arg(string7, n13);
        this.end();
        GL10 gL10 = this.mgl;
        int n14 = n;
        int n15 = n2;
        int n16 = n3;
        int n17 = n4;
        int n18 = n5;
        int n19 = n6;
        int n20 = n7;
        int n21 = n8;
        gL10.glCopyTexSubImage2D(n14, n15, n16, n17, n18, n19, n20, n21);
        this.checkError();
    }

    @Override
    public void glCullFace(int n) {
        this.begin("glCullFace");
        this.arg("mode", n);
        this.end();
        this.mgl.glCullFace(n);
        this.checkError();
    }

    @Override
    public void glCurrentPaletteMatrixOES(int n) {
        this.begin("glCurrentPaletteMatrixOES");
        this.arg("matrixpaletteindex", n);
        this.end();
        this.mgl11Ext.glCurrentPaletteMatrixOES(n);
        this.checkError();
    }

    @Override
    public void glDeleteBuffers(int n, IntBuffer intBuffer) {
        this.begin("glDeleteBuffers");
        this.arg("n", n);
        String string2 = intBuffer.toString();
        this.arg("buffers", string2);
        this.end();
        this.mgl11.glDeleteBuffers(n, intBuffer);
        this.checkError();
    }

    @Override
    public void glDeleteBuffers(int n, int[] nArray, int n2) {
        this.begin("glDeleteBuffers");
        this.arg("n", n);
        String string2 = nArray.toString();
        this.arg("buffers", string2);
        this.arg("offset", n2);
        this.end();
        this.mgl11.glDeleteBuffers(n, nArray, n2);
        this.checkError();
    }

    @Override
    public void glDeleteTextures(int n, IntBuffer intBuffer) {
        this.begin("glDeleteTextures");
        this.arg("n", n);
        this.arg("textures", n, intBuffer);
        this.end();
        this.mgl.glDeleteTextures(n, intBuffer);
        this.checkError();
    }

    @Override
    public void glDeleteTextures(int n, int[] nArray, int n2) {
        this.begin("glDeleteTextures");
        this.arg("n", n);
        this.arg("textures", n, nArray, n2);
        this.arg("offset", n2);
        this.end();
        this.mgl.glDeleteTextures(n, nArray, n2);
        this.checkError();
    }

    @Override
    public void glDepthFunc(int n) {
        this.begin("glDepthFunc");
        this.arg("func", n);
        this.end();
        this.mgl.glDepthFunc(n);
        this.checkError();
    }

    @Override
    public void glDepthMask(boolean bl) {
        this.begin("glDepthMask");
        this.arg("flag", bl);
        this.end();
        this.mgl.glDepthMask(bl);
        this.checkError();
    }

    @Override
    public void glDepthRangef(float f, float f2) {
        this.begin("glDepthRangef");
        this.arg("near", f);
        this.arg("far", f2);
        this.end();
        this.mgl.glDepthRangef(f, f2);
        this.checkError();
    }

    @Override
    public void glDepthRangex(int n, int n2) {
        this.begin("glDepthRangex");
        this.arg("near", n);
        this.arg("far", n2);
        this.end();
        this.mgl.glDepthRangex(n, n2);
        this.checkError();
    }

    @Override
    public void glDisable(int n) {
        this.begin("glDisable");
        String string2 = this.getCap(n);
        this.arg("cap", string2);
        this.end();
        this.mgl.glDisable(n);
        this.checkError();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void glDisableClientState(int n) {
        this.begin("glDisableClientState");
        String string2 = this.getClientState(n);
        this.arg("array", string2);
        this.end();
        switch (n) {
            case 32886: {
                this.mColorArrayEnabled = false;
                break;
            }
            case 32885: {
                this.mNormalArrayEnabled = false;
                break;
            }
            case 32888: {
                this.mTextureCoordArrayEnabled = false;
                break;
            }
            case 32884: {
                this.mVertexArrayEnabled = false;
                break;
            }
        }
        this.mgl.glDisableClientState(n);
        this.checkError();
    }

    @Override
    public void glDrawArrays(int n, int n2, int n3) {
        this.begin("glDrawArrays");
        this.arg("mode", n);
        this.arg("first", n2);
        this.arg("count", n3);
        this.startLogIndices();
        for (int i = 0; i < n3; ++i) {
            StringBuilder stringBuilder = this.mStringBuilder;
            int n4 = n2 + i;
            this.doElement(stringBuilder, i, n4);
        }
        this.endLogIndices();
        this.end();
        this.mgl.glDrawArrays(n, n2, n3);
        this.checkError();
    }

    @Override
    public void glDrawElements(int n, int n2, int n3, int n4) {
        this.begin("glDrawElements");
        this.arg("mode", n);
        this.arg("count", n2);
        this.arg("type", n3);
        this.arg("offset", n4);
        this.end();
        this.mgl11.glDrawElements(n, n2, n3, n4);
        this.checkError();
    }

    @Override
    public void glDrawElements(int n, int n2, int n3, Buffer buffer) {
        this.begin("glDrawElements");
        String string2 = this.getBeginMode(n);
        this.arg("mode", string2);
        this.arg("count", n2);
        String string3 = this.getIndexType(n3);
        this.arg("type", string3);
        char[] cArray = this.toCharIndices(n2, n3, buffer);
        int n4 = cArray.length;
        this.startLogIndices();
        for (int i = 0; i < n4; ++i) {
            StringBuilder stringBuilder = this.mStringBuilder;
            char c = cArray[i];
            this.doElement(stringBuilder, i, c);
        }
        this.endLogIndices();
        this.end();
        this.mgl.glDrawElements(n, n2, n3, buffer);
        this.checkError();
    }

    @Override
    public void glDrawTexfOES(float f, float f2, float f3, float f4, float f5) {
        this.begin("glDrawTexfOES");
        this.arg("x", f);
        this.arg("y", f2);
        this.arg("z", f3);
        this.arg("width", f4);
        this.arg("height", f5);
        this.end();
        GL11Ext gL11Ext = this.mgl11Ext;
        float f6 = f;
        float f7 = f2;
        float f8 = f3;
        float f9 = f4;
        float f10 = f5;
        gL11Ext.glDrawTexfOES(f6, f7, f8, f9, f10);
        this.checkError();
    }

    @Override
    public void glDrawTexfvOES(FloatBuffer floatBuffer) {
        this.begin("glDrawTexfvOES");
        this.arg("coords", 5, floatBuffer);
        this.end();
        this.mgl11Ext.glDrawTexfvOES(floatBuffer);
        this.checkError();
    }

    @Override
    public void glDrawTexfvOES(float[] fArray, int n) {
        this.begin("glDrawTexfvOES");
        this.arg("coords", 5, fArray, n);
        this.arg("offset", n);
        this.end();
        this.mgl11Ext.glDrawTexfvOES(fArray, n);
        this.checkError();
    }

    @Override
    public void glDrawTexiOES(int n, int n2, int n3, int n4, int n5) {
        this.begin("glDrawTexiOES");
        this.arg("x", n);
        this.arg("y", n2);
        this.arg("z", n3);
        this.arg("width", n4);
        this.arg("height", n5);
        this.end();
        GL11Ext gL11Ext = this.mgl11Ext;
        int n6 = n;
        int n7 = n2;
        int n8 = n3;
        int n9 = n4;
        int n10 = n5;
        gL11Ext.glDrawTexiOES(n6, n7, n8, n9, n10);
        this.checkError();
    }

    @Override
    public void glDrawTexivOES(IntBuffer intBuffer) {
        this.begin("glDrawTexivOES");
        this.arg("coords", 5, intBuffer);
        this.end();
        this.mgl11Ext.glDrawTexivOES(intBuffer);
        this.checkError();
    }

    @Override
    public void glDrawTexivOES(int[] nArray, int n) {
        this.begin("glDrawTexivOES");
        this.arg("coords", 5, nArray, n);
        this.arg("offset", n);
        this.end();
        this.mgl11Ext.glDrawTexivOES(nArray, n);
        this.checkError();
    }

    @Override
    public void glDrawTexsOES(short s, short s2, short s3, short s4, short s5) {
        this.begin("glDrawTexsOES");
        this.arg("x", s);
        this.arg("y", s2);
        this.arg("z", s3);
        this.arg("width", s4);
        this.arg("height", s5);
        this.end();
        GL11Ext gL11Ext = this.mgl11Ext;
        short s6 = s;
        short s7 = s2;
        short s8 = s3;
        short s9 = s4;
        short s10 = s5;
        gL11Ext.glDrawTexsOES(s6, s7, s8, s9, s10);
        this.checkError();
    }

    @Override
    public void glDrawTexsvOES(ShortBuffer shortBuffer) {
        this.begin("glDrawTexsvOES");
        this.arg("coords", 5, shortBuffer);
        this.end();
        this.mgl11Ext.glDrawTexsvOES(shortBuffer);
        this.checkError();
    }

    @Override
    public void glDrawTexsvOES(short[] sArray, int n) {
        this.begin("glDrawTexsvOES");
        this.arg("coords", 5, sArray, n);
        this.arg("offset", n);
        this.end();
        this.mgl11Ext.glDrawTexsvOES(sArray, n);
        this.checkError();
    }

    @Override
    public void glDrawTexxOES(int n, int n2, int n3, int n4, int n5) {
        this.begin("glDrawTexxOES");
        this.arg("x", n);
        this.arg("y", n2);
        this.arg("z", n3);
        this.arg("width", n4);
        this.arg("height", n5);
        this.end();
        GL11Ext gL11Ext = this.mgl11Ext;
        int n6 = n;
        int n7 = n2;
        int n8 = n3;
        int n9 = n4;
        int n10 = n5;
        gL11Ext.glDrawTexxOES(n6, n7, n8, n9, n10);
        this.checkError();
    }

    @Override
    public void glDrawTexxvOES(IntBuffer intBuffer) {
        this.begin("glDrawTexxvOES");
        this.arg("coords", 5, intBuffer);
        this.end();
        this.mgl11Ext.glDrawTexxvOES(intBuffer);
        this.checkError();
    }

    @Override
    public void glDrawTexxvOES(int[] nArray, int n) {
        this.begin("glDrawTexxvOES");
        this.arg("coords", 5, nArray, n);
        this.arg("offset", n);
        this.end();
        this.mgl11Ext.glDrawTexxvOES(nArray, n);
        this.checkError();
    }

    @Override
    public void glEnable(int n) {
        this.begin("glEnable");
        String string2 = this.getCap(n);
        this.arg("cap", string2);
        this.end();
        this.mgl.glEnable(n);
        this.checkError();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void glEnableClientState(int n) {
        this.begin("glEnableClientState");
        String string2 = this.getClientState(n);
        this.arg("array", string2);
        this.end();
        switch (n) {
            case 32886: {
                this.mColorArrayEnabled = true;
                break;
            }
            case 32885: {
                this.mNormalArrayEnabled = true;
                break;
            }
            case 32888: {
                this.mTextureCoordArrayEnabled = true;
                break;
            }
            case 32884: {
                this.mVertexArrayEnabled = true;
                break;
            }
        }
        this.mgl.glEnableClientState(n);
        this.checkError();
    }

    @Override
    public void glFinish() {
        this.begin("glFinish");
        this.end();
        this.mgl.glFinish();
        this.checkError();
    }

    @Override
    public void glFlush() {
        this.begin("glFlush");
        this.end();
        this.mgl.glFlush();
        this.checkError();
    }

    @Override
    public void glFogf(int n, float f) {
        this.begin("glFogf");
        this.arg("pname", n);
        this.arg("param", f);
        this.end();
        this.mgl.glFogf(n, f);
        this.checkError();
    }

    @Override
    public void glFogfv(int n, FloatBuffer floatBuffer) {
        this.begin("glFogfv");
        String string2 = this.getFogPName(n);
        this.arg("pname", string2);
        int n2 = this.getFogParamCount(n);
        this.arg("params", n2, floatBuffer);
        this.end();
        this.mgl.glFogfv(n, floatBuffer);
        this.checkError();
    }

    @Override
    public void glFogfv(int n, float[] fArray, int n2) {
        this.begin("glFogfv");
        String string2 = this.getFogPName(n);
        this.arg("pname", string2);
        int n3 = this.getFogParamCount(n);
        this.arg("params", n3, fArray, n2);
        this.arg("offset", n2);
        this.end();
        this.mgl.glFogfv(n, fArray, n2);
        this.checkError();
    }

    @Override
    public void glFogx(int n, int n2) {
        this.begin("glFogx");
        String string2 = this.getFogPName(n);
        this.arg("pname", string2);
        this.arg("param", n2);
        this.end();
        this.mgl.glFogx(n, n2);
        this.checkError();
    }

    @Override
    public void glFogxv(int n, IntBuffer intBuffer) {
        this.begin("glFogxv");
        String string2 = this.getFogPName(n);
        this.arg("pname", string2);
        int n2 = this.getFogParamCount(n);
        this.arg("params", n2, intBuffer);
        this.end();
        this.mgl.glFogxv(n, intBuffer);
        this.checkError();
    }

    @Override
    public void glFogxv(int n, int[] nArray, int n2) {
        this.begin("glFogxv");
        String string2 = this.getFogPName(n);
        this.arg("pname", string2);
        int n3 = this.getFogParamCount(n);
        this.arg("params", n3, nArray, n2);
        this.arg("offset", n2);
        this.end();
        this.mgl.glFogxv(n, nArray, n2);
        this.checkError();
    }

    @Override
    public void glFrontFace(int n) {
        this.begin("glFrontFace");
        this.arg("mode", n);
        this.end();
        this.mgl.glFrontFace(n);
        this.checkError();
    }

    @Override
    public void glFrustumf(float f, float f2, float f3, float f4, float f5, float f6) {
        this.begin("glFrustumf");
        this.arg("left", f);
        this.arg("right", f2);
        this.arg("bottom", f3);
        this.arg("top", f4);
        this.arg("near", f5);
        this.arg("far", f6);
        this.end();
        GL10 gL10 = this.mgl;
        float f7 = f;
        float f8 = f2;
        float f9 = f3;
        float f10 = f4;
        float f11 = f5;
        float f12 = f6;
        gL10.glFrustumf(f7, f8, f9, f10, f11, f12);
        this.checkError();
    }

    @Override
    public void glFrustumx(int n, int n2, int n3, int n4, int n5, int n6) {
        this.begin("glFrustumx");
        this.arg("left", n);
        this.arg("right", n2);
        this.arg("bottom", n3);
        this.arg("top", n4);
        this.arg("near", n5);
        this.arg("far", n6);
        this.end();
        GL10 gL10 = this.mgl;
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        gL10.glFrustumx(n7, n8, n9, n10, n11, n12);
        this.checkError();
    }

    @Override
    public void glGenBuffers(int n, IntBuffer intBuffer) {
        this.begin("glGenBuffers");
        this.arg("n", n);
        String string2 = intBuffer.toString();
        this.arg("buffers", string2);
        this.end();
        this.mgl11.glGenBuffers(n, intBuffer);
        this.checkError();
    }

    @Override
    public void glGenBuffers(int n, int[] nArray, int n2) {
        this.begin("glGenBuffers");
        this.arg("n", n);
        String string2 = nArray.toString();
        this.arg("buffers", string2);
        this.arg("offset", n2);
        this.end();
        this.mgl11.glGenBuffers(n, nArray, n2);
        this.checkError();
    }

    @Override
    public void glGenTextures(int n, IntBuffer intBuffer) {
        this.begin("glGenTextures");
        this.arg("n", n);
        String string2 = intBuffer.toString();
        this.arg("textures", string2);
        this.mgl.glGenTextures(n, intBuffer);
        String string3 = this.toString(n, 0, intBuffer);
        this.returns(string3);
        this.checkError();
    }

    @Override
    public void glGenTextures(int n, int[] nArray, int n2) {
        this.begin("glGenTextures");
        this.arg("n", n);
        String string2 = Arrays.toString(nArray);
        this.arg("textures", string2);
        this.arg("offset", n2);
        this.mgl.glGenTextures(n, nArray, n2);
        String string3 = this.toString(n, 0, nArray, n2);
        this.returns(string3);
        this.checkError();
    }

    @Override
    public void glGetBooleanv(int n, IntBuffer intBuffer) {
        this.begin("glGetBooleanv");
        this.arg("pname", n);
        String string2 = intBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glGetBooleanv(n, intBuffer);
        this.checkError();
    }

    @Override
    public void glGetBooleanv(int n, boolean[] blArray, int n2) {
        this.begin("glGetBooleanv");
        this.arg("pname", n);
        String string2 = blArray.toString();
        this.arg("params", string2);
        this.arg("offset", n2);
        this.end();
        this.mgl11.glGetBooleanv(n, blArray, n2);
        this.checkError();
    }

    @Override
    public void glGetBufferParameteriv(int n, int n2, IntBuffer intBuffer) {
        this.begin("glGetBufferParameteriv");
        this.arg("target", n);
        this.arg("pname", n2);
        String string2 = intBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glGetBufferParameteriv(n, n2, intBuffer);
        this.checkError();
    }

    @Override
    public void glGetBufferParameteriv(int n, int n2, int[] nArray, int n3) {
        this.begin("glGetBufferParameteriv");
        this.arg("target", n);
        this.arg("pname", n2);
        String string2 = nArray.toString();
        this.arg("params", string2);
        this.arg("offset", n3);
        this.end();
        this.mgl11.glGetBufferParameteriv(n, n2, nArray, n3);
        this.checkError();
    }

    @Override
    public void glGetClipPlanef(int n, FloatBuffer floatBuffer) {
        this.begin("glGetClipPlanef");
        this.arg("pname", n);
        String string2 = floatBuffer.toString();
        this.arg("eqn", string2);
        this.end();
        this.mgl11.glGetClipPlanef(n, floatBuffer);
        this.checkError();
    }

    @Override
    public void glGetClipPlanef(int n, float[] fArray, int n2) {
        this.begin("glGetClipPlanef");
        this.arg("pname", n);
        String string2 = fArray.toString();
        this.arg("eqn", string2);
        this.arg("offset", n2);
        this.end();
        this.mgl11.glGetClipPlanef(n, fArray, n2);
        this.checkError();
    }

    @Override
    public void glGetClipPlanex(int n, IntBuffer intBuffer) {
        this.begin("glGetClipPlanex");
        this.arg("pname", n);
        String string2 = intBuffer.toString();
        this.arg("eqn", string2);
        this.end();
        this.mgl11.glGetClipPlanex(n, intBuffer);
        this.checkError();
    }

    @Override
    public void glGetClipPlanex(int n, int[] nArray, int n2) {
        this.begin("glGetClipPlanex");
        this.arg("pname", n);
        String string2 = nArray.toString();
        this.arg("eqn", string2);
        this.arg("offset", n2);
        this.end();
        this.mgl11.glGetClipPlanex(n, nArray, n2);
    }

    @Override
    public int glGetError() {
        this.begin("glGetError");
        int n = this.mgl.glGetError();
        this.returns(n);
        return n;
    }

    @Override
    public void glGetFixedv(int n, IntBuffer intBuffer) {
        this.begin("glGetFixedv");
        this.arg("pname", n);
        String string2 = intBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glGetFixedv(n, intBuffer);
        this.checkError();
    }

    @Override
    public void glGetFixedv(int n, int[] nArray, int n2) {
        this.begin("glGetFixedv");
        this.arg("pname", n);
        String string2 = nArray.toString();
        this.arg("params", string2);
        this.arg("offset", n2);
        this.end();
        this.mgl11.glGetFixedv(n, nArray, n2);
    }

    @Override
    public void glGetFloatv(int n, FloatBuffer floatBuffer) {
        this.begin("glGetFloatv");
        this.arg("pname", n);
        String string2 = floatBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glGetFloatv(n, floatBuffer);
        this.checkError();
    }

    @Override
    public void glGetFloatv(int n, float[] fArray, int n2) {
        this.begin("glGetFloatv");
        this.arg("pname", n);
        String string2 = fArray.toString();
        this.arg("params", string2);
        this.arg("offset", n2);
        this.end();
        this.mgl11.glGetFloatv(n, fArray, n2);
    }

    @Override
    public void glGetIntegerv(int n, IntBuffer intBuffer) {
        this.begin("glGetIntegerv");
        String string2 = this.getIntegerStateName(n);
        this.arg("pname", string2);
        String string3 = intBuffer.toString();
        this.arg("params", string3);
        this.mgl.glGetIntegerv(n, intBuffer);
        int n2 = this.getIntegerStateSize(n);
        int n3 = this.getIntegerStateFormat(n);
        String string4 = this.toString(n2, n3, intBuffer);
        this.returns(string4);
        this.checkError();
    }

    @Override
    public void glGetIntegerv(int n, int[] nArray, int n2) {
        this.begin("glGetIntegerv");
        String string2 = this.getIntegerStateName(n);
        this.arg("pname", string2);
        String string3 = Arrays.toString(nArray);
        this.arg("params", string3);
        this.arg("offset", n2);
        this.mgl.glGetIntegerv(n, nArray, n2);
        int n3 = this.getIntegerStateSize(n);
        int n4 = this.getIntegerStateFormat(n);
        String string4 = this.toString(n3, n4, nArray, n2);
        this.returns(string4);
        this.checkError();
    }

    @Override
    public void glGetLightfv(int n, int n2, FloatBuffer floatBuffer) {
        this.begin("glGetLightfv");
        this.arg("light", n);
        this.arg("pname", n2);
        String string2 = floatBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glGetLightfv(n, n2, floatBuffer);
        this.checkError();
    }

    @Override
    public void glGetLightfv(int n, int n2, float[] fArray, int n3) {
        this.begin("glGetLightfv");
        this.arg("light", n);
        this.arg("pname", n2);
        String string2 = fArray.toString();
        this.arg("params", string2);
        this.arg("offset", n3);
        this.end();
        this.mgl11.glGetLightfv(n, n2, fArray, n3);
        this.checkError();
    }

    @Override
    public void glGetLightxv(int n, int n2, IntBuffer intBuffer) {
        this.begin("glGetLightxv");
        this.arg("light", n);
        this.arg("pname", n2);
        String string2 = intBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glGetLightxv(n, n2, intBuffer);
        this.checkError();
    }

    @Override
    public void glGetLightxv(int n, int n2, int[] nArray, int n3) {
        this.begin("glGetLightxv");
        this.arg("light", n);
        this.arg("pname", n2);
        String string2 = nArray.toString();
        this.arg("params", string2);
        this.arg("offset", n3);
        this.end();
        this.mgl11.glGetLightxv(n, n2, nArray, n3);
        this.checkError();
    }

    @Override
    public void glGetMaterialfv(int n, int n2, FloatBuffer floatBuffer) {
        this.begin("glGetMaterialfv");
        this.arg("face", n);
        this.arg("pname", n2);
        String string2 = floatBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glGetMaterialfv(n, n2, floatBuffer);
        this.checkError();
    }

    @Override
    public void glGetMaterialfv(int n, int n2, float[] fArray, int n3) {
        this.begin("glGetMaterialfv");
        this.arg("face", n);
        this.arg("pname", n2);
        String string2 = fArray.toString();
        this.arg("params", string2);
        this.arg("offset", n3);
        this.end();
        this.mgl11.glGetMaterialfv(n, n2, fArray, n3);
        this.checkError();
    }

    @Override
    public void glGetMaterialxv(int n, int n2, IntBuffer intBuffer) {
        this.begin("glGetMaterialxv");
        this.arg("face", n);
        this.arg("pname", n2);
        String string2 = intBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glGetMaterialxv(n, n2, intBuffer);
        this.checkError();
    }

    @Override
    public void glGetMaterialxv(int n, int n2, int[] nArray, int n3) {
        this.begin("glGetMaterialxv");
        this.arg("face", n);
        this.arg("pname", n2);
        String string2 = nArray.toString();
        this.arg("params", string2);
        this.arg("offset", n3);
        this.end();
        this.mgl11.glGetMaterialxv(n, n2, nArray, n3);
        this.checkError();
    }

    @Override
    public void glGetPointerv(int n, Buffer[] bufferArray) {
        this.begin("glGetPointerv");
        this.arg("pname", n);
        String string2 = bufferArray.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glGetPointerv(n, bufferArray);
        this.checkError();
    }

    @Override
    public String glGetString(int n) {
        this.begin("glGetString");
        this.arg("name", n);
        String string2 = this.mgl.glGetString(n);
        this.returns(string2);
        this.checkError();
        return string2;
    }

    @Override
    public void glGetTexEnviv(int n, int n2, IntBuffer intBuffer) {
        this.begin("glGetTexEnviv");
        this.arg("env", n);
        this.arg("pname", n2);
        String string2 = intBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glGetTexEnviv(n, n2, intBuffer);
        this.checkError();
    }

    @Override
    public void glGetTexEnviv(int n, int n2, int[] nArray, int n3) {
        this.begin("glGetTexEnviv");
        this.arg("env", n);
        this.arg("pname", n2);
        String string2 = nArray.toString();
        this.arg("params", string2);
        this.arg("offset", n3);
        this.end();
        this.mgl11.glGetTexEnviv(n, n2, nArray, n3);
        this.checkError();
    }

    @Override
    public void glGetTexEnvxv(int n, int n2, IntBuffer intBuffer) {
        this.begin("glGetTexEnviv");
        this.arg("env", n);
        this.arg("pname", n2);
        String string2 = intBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glGetTexEnvxv(n, n2, intBuffer);
        this.checkError();
    }

    @Override
    public void glGetTexEnvxv(int n, int n2, int[] nArray, int n3) {
        this.begin("glGetTexEnviv");
        this.arg("env", n);
        this.arg("pname", n2);
        String string2 = nArray.toString();
        this.arg("params", string2);
        this.arg("offset", n3);
        this.end();
        this.mgl11.glGetTexEnviv(n, n2, nArray, n3);
        this.checkError();
    }

    @Override
    public void glGetTexParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        this.begin("glGetTexParameterfv");
        this.arg("target", n);
        this.arg("pname", n2);
        String string2 = floatBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glGetTexParameterfv(n, n2, floatBuffer);
        this.checkError();
    }

    @Override
    public void glGetTexParameterfv(int n, int n2, float[] fArray, int n3) {
        this.begin("glGetTexParameterfv");
        this.arg("target", n);
        this.arg("pname", n2);
        String string2 = fArray.toString();
        this.arg("params", string2);
        this.arg("offset", n3);
        this.end();
        this.mgl11.glGetTexParameterfv(n, n2, fArray, n3);
        this.checkError();
    }

    @Override
    public void glGetTexParameteriv(int n, int n2, IntBuffer intBuffer) {
        this.begin("glGetTexParameteriv");
        this.arg("target", n);
        this.arg("pname", n2);
        String string2 = intBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glGetTexParameteriv(n, n2, intBuffer);
        this.checkError();
    }

    @Override
    public void glGetTexParameteriv(int n, int n2, int[] nArray, int n3) {
        this.begin("glGetTexParameteriv");
        this.arg("target", n);
        this.arg("pname", n2);
        String string2 = nArray.toString();
        this.arg("params", string2);
        this.arg("offset", n3);
        this.end();
        this.mgl11.glGetTexEnviv(n, n2, nArray, n3);
        this.checkError();
    }

    @Override
    public void glGetTexParameterxv(int n, int n2, IntBuffer intBuffer) {
        this.begin("glGetTexParameterxv");
        this.arg("target", n);
        this.arg("pname", n2);
        String string2 = intBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glGetTexParameterxv(n, n2, intBuffer);
        this.checkError();
    }

    @Override
    public void glGetTexParameterxv(int n, int n2, int[] nArray, int n3) {
        this.begin("glGetTexParameterxv");
        this.arg("target", n);
        this.arg("pname", n2);
        String string2 = nArray.toString();
        this.arg("params", string2);
        this.arg("offset", n3);
        this.end();
        this.mgl11.glGetTexParameterxv(n, n2, nArray, n3);
        this.checkError();
    }

    @Override
    public void glHint(int n, int n2) {
        this.begin("glHint");
        String string2 = this.getHintTarget(n);
        this.arg("target", string2);
        String string3 = this.getHintMode(n2);
        this.arg("mode", string3);
        this.end();
        this.mgl.glHint(n, n2);
        this.checkError();
    }

    @Override
    public boolean glIsBuffer(int n) {
        this.begin("glIsBuffer");
        this.arg("buffer", n);
        this.end();
        boolean bl = this.mgl11.glIsBuffer(n);
        this.checkError();
        return bl;
    }

    @Override
    public boolean glIsEnabled(int n) {
        this.begin("glIsEnabled");
        this.arg("cap", n);
        this.end();
        boolean bl = this.mgl11.glIsEnabled(n);
        this.checkError();
        return bl;
    }

    @Override
    public boolean glIsTexture(int n) {
        this.begin("glIsTexture");
        this.arg("texture", n);
        this.end();
        boolean bl = this.mgl11.glIsTexture(n);
        this.checkError();
        return bl;
    }

    @Override
    public void glLightModelf(int n, float f) {
        this.begin("glLightModelf");
        String string2 = this.getLightModelPName(n);
        this.arg("pname", string2);
        this.arg("param", f);
        this.end();
        this.mgl.glLightModelf(n, f);
        this.checkError();
    }

    @Override
    public void glLightModelfv(int n, FloatBuffer floatBuffer) {
        this.begin("glLightModelfv");
        String string2 = this.getLightModelPName(n);
        this.arg("pname", string2);
        int n2 = this.getLightModelParamCount(n);
        this.arg("params", n2, floatBuffer);
        this.end();
        this.mgl.glLightModelfv(n, floatBuffer);
        this.checkError();
    }

    @Override
    public void glLightModelfv(int n, float[] fArray, int n2) {
        this.begin("glLightModelfv");
        String string2 = this.getLightModelPName(n);
        this.arg("pname", string2);
        int n3 = this.getLightModelParamCount(n);
        this.arg("params", n3, fArray, n2);
        this.arg("offset", n2);
        this.end();
        this.mgl.glLightModelfv(n, fArray, n2);
        this.checkError();
    }

    @Override
    public void glLightModelx(int n, int n2) {
        this.begin("glLightModelx");
        String string2 = this.getLightModelPName(n);
        this.arg("pname", string2);
        this.arg("param", n2);
        this.end();
        this.mgl.glLightModelx(n, n2);
        this.checkError();
    }

    @Override
    public void glLightModelxv(int n, IntBuffer intBuffer) {
        this.begin("glLightModelfv");
        String string2 = this.getLightModelPName(n);
        this.arg("pname", string2);
        int n2 = this.getLightModelParamCount(n);
        this.arg("params", n2, intBuffer);
        this.end();
        this.mgl.glLightModelxv(n, intBuffer);
        this.checkError();
    }

    @Override
    public void glLightModelxv(int n, int[] nArray, int n2) {
        this.begin("glLightModelxv");
        String string2 = this.getLightModelPName(n);
        this.arg("pname", string2);
        int n3 = this.getLightModelParamCount(n);
        this.arg("params", n3, nArray, n2);
        this.arg("offset", n2);
        this.end();
        this.mgl.glLightModelxv(n, nArray, n2);
        this.checkError();
    }

    @Override
    public void glLightf(int n, int n2, float f) {
        this.begin("glLightf");
        String string2 = this.getLightName(n);
        this.arg("light", string2);
        String string3 = this.getLightPName(n2);
        this.arg("pname", string3);
        this.arg("param", f);
        this.end();
        this.mgl.glLightf(n, n2, f);
        this.checkError();
    }

    @Override
    public void glLightfv(int n, int n2, FloatBuffer floatBuffer) {
        this.begin("glLightfv");
        String string2 = this.getLightName(n);
        this.arg("light", string2);
        String string3 = this.getLightPName(n2);
        this.arg("pname", string3);
        int n3 = this.getLightParamCount(n2);
        this.arg("params", n3, floatBuffer);
        this.end();
        this.mgl.glLightfv(n, n2, floatBuffer);
        this.checkError();
    }

    @Override
    public void glLightfv(int n, int n2, float[] fArray, int n3) {
        this.begin("glLightfv");
        String string2 = this.getLightName(n);
        this.arg("light", string2);
        String string3 = this.getLightPName(n2);
        this.arg("pname", string3);
        int n4 = this.getLightParamCount(n2);
        this.arg("params", n4, fArray, n3);
        this.arg("offset", n3);
        this.end();
        this.mgl.glLightfv(n, n2, fArray, n3);
        this.checkError();
    }

    @Override
    public void glLightx(int n, int n2, int n3) {
        this.begin("glLightx");
        String string2 = this.getLightName(n);
        this.arg("light", string2);
        String string3 = this.getLightPName(n2);
        this.arg("pname", string3);
        this.arg("param", n3);
        this.end();
        this.mgl.glLightx(n, n2, n3);
        this.checkError();
    }

    @Override
    public void glLightxv(int n, int n2, IntBuffer intBuffer) {
        this.begin("glLightxv");
        String string2 = this.getLightName(n);
        this.arg("light", string2);
        String string3 = this.getLightPName(n2);
        this.arg("pname", string3);
        int n3 = this.getLightParamCount(n2);
        this.arg("params", n3, intBuffer);
        this.end();
        this.mgl.glLightxv(n, n2, intBuffer);
        this.checkError();
    }

    @Override
    public void glLightxv(int n, int n2, int[] nArray, int n3) {
        this.begin("glLightxv");
        String string2 = this.getLightName(n);
        this.arg("light", string2);
        String string3 = this.getLightPName(n2);
        this.arg("pname", string3);
        int n4 = this.getLightParamCount(n2);
        this.arg("params", n4, nArray, n3);
        this.arg("offset", n3);
        this.end();
        this.mgl.glLightxv(n, n2, nArray, n3);
        this.checkError();
    }

    @Override
    public void glLineWidth(float f) {
        this.begin("glLineWidth");
        this.arg("width", f);
        this.end();
        this.mgl.glLineWidth(f);
        this.checkError();
    }

    @Override
    public void glLineWidthx(int n) {
        this.begin("glLineWidthx");
        this.arg("width", n);
        this.end();
        this.mgl.glLineWidthx(n);
        this.checkError();
    }

    @Override
    public void glLoadIdentity() {
        this.begin("glLoadIdentity");
        this.end();
        this.mgl.glLoadIdentity();
        this.checkError();
    }

    @Override
    public void glLoadMatrixf(FloatBuffer floatBuffer) {
        this.begin("glLoadMatrixf");
        this.arg("m", 16, floatBuffer);
        this.end();
        this.mgl.glLoadMatrixf(floatBuffer);
        this.checkError();
    }

    @Override
    public void glLoadMatrixf(float[] fArray, int n) {
        this.begin("glLoadMatrixf");
        this.arg("m", 16, fArray, n);
        this.arg("offset", n);
        this.end();
        this.mgl.glLoadMatrixf(fArray, n);
        this.checkError();
    }

    @Override
    public void glLoadMatrixx(IntBuffer intBuffer) {
        this.begin("glLoadMatrixx");
        this.arg("m", 16, intBuffer);
        this.end();
        this.mgl.glLoadMatrixx(intBuffer);
        this.checkError();
    }

    @Override
    public void glLoadMatrixx(int[] nArray, int n) {
        this.begin("glLoadMatrixx");
        this.arg("m", 16, nArray, n);
        this.arg("offset", n);
        this.end();
        this.mgl.glLoadMatrixx(nArray, n);
        this.checkError();
    }

    @Override
    public void glLoadPaletteFromModelViewMatrixOES() {
        this.begin("glLoadPaletteFromModelViewMatrixOES");
        this.end();
        this.mgl11Ext.glLoadPaletteFromModelViewMatrixOES();
        this.checkError();
    }

    @Override
    public void glLogicOp(int n) {
        this.begin("glLogicOp");
        this.arg("opcode", n);
        this.end();
        this.mgl.glLogicOp(n);
        this.checkError();
    }

    @Override
    public void glMaterialf(int n, int n2, float f) {
        this.begin("glMaterialf");
        String string2 = this.getFaceName(n);
        this.arg("face", string2);
        String string3 = this.getMaterialPName(n2);
        this.arg("pname", string3);
        this.arg("param", f);
        this.end();
        this.mgl.glMaterialf(n, n2, f);
        this.checkError();
    }

    @Override
    public void glMaterialfv(int n, int n2, FloatBuffer floatBuffer) {
        this.begin("glMaterialfv");
        String string2 = this.getFaceName(n);
        this.arg("face", string2);
        String string3 = this.getMaterialPName(n2);
        this.arg("pname", string3);
        int n3 = this.getMaterialParamCount(n2);
        this.arg("params", n3, floatBuffer);
        this.end();
        this.mgl.glMaterialfv(n, n2, floatBuffer);
        this.checkError();
    }

    @Override
    public void glMaterialfv(int n, int n2, float[] fArray, int n3) {
        this.begin("glMaterialfv");
        String string2 = this.getFaceName(n);
        this.arg("face", string2);
        String string3 = this.getMaterialPName(n2);
        this.arg("pname", string3);
        int n4 = this.getMaterialParamCount(n2);
        this.arg("params", n4, fArray, n3);
        this.arg("offset", n3);
        this.end();
        this.mgl.glMaterialfv(n, n2, fArray, n3);
        this.checkError();
    }

    @Override
    public void glMaterialx(int n, int n2, int n3) {
        this.begin("glMaterialx");
        String string2 = this.getFaceName(n);
        this.arg("face", string2);
        String string3 = this.getMaterialPName(n2);
        this.arg("pname", string3);
        this.arg("param", n3);
        this.end();
        this.mgl.glMaterialx(n, n2, n3);
        this.checkError();
    }

    @Override
    public void glMaterialxv(int n, int n2, IntBuffer intBuffer) {
        this.begin("glMaterialxv");
        String string2 = this.getFaceName(n);
        this.arg("face", string2);
        String string3 = this.getMaterialPName(n2);
        this.arg("pname", string3);
        int n3 = this.getMaterialParamCount(n2);
        this.arg("params", n3, intBuffer);
        this.end();
        this.mgl.glMaterialxv(n, n2, intBuffer);
        this.checkError();
    }

    @Override
    public void glMaterialxv(int n, int n2, int[] nArray, int n3) {
        this.begin("glMaterialxv");
        String string2 = this.getFaceName(n);
        this.arg("face", string2);
        String string3 = this.getMaterialPName(n2);
        this.arg("pname", string3);
        int n4 = this.getMaterialParamCount(n2);
        this.arg("params", n4, nArray, n3);
        this.arg("offset", n3);
        this.end();
        this.mgl.glMaterialxv(n, n2, nArray, n3);
        this.checkError();
    }

    @Override
    public void glMatrixIndexPointerOES(int n, int n2, int n3, int n4) {
        this.begin("glMatrixIndexPointerOES");
        this.arg("size", n);
        this.arg("type", n2);
        this.arg("stride", n3);
        this.arg("offset", n4);
        this.end();
        this.mgl11Ext.glMatrixIndexPointerOES(n, n2, n3, n4);
        this.checkError();
    }

    @Override
    public void glMatrixIndexPointerOES(int n, int n2, int n3, Buffer buffer) {
        this.begin("glMatrixIndexPointerOES");
        this.argPointer(n, n2, n3, buffer);
        this.end();
        this.mgl11Ext.glMatrixIndexPointerOES(n, n2, n3, buffer);
        this.checkError();
    }

    @Override
    public void glMatrixMode(int n) {
        this.begin("glMatrixMode");
        String string2 = this.getMatrixMode(n);
        this.arg("mode", string2);
        this.end();
        this.mgl.glMatrixMode(n);
        this.checkError();
    }

    @Override
    public void glMultMatrixf(FloatBuffer floatBuffer) {
        this.begin("glMultMatrixf");
        this.arg("m", 16, floatBuffer);
        this.end();
        this.mgl.glMultMatrixf(floatBuffer);
        this.checkError();
    }

    @Override
    public void glMultMatrixf(float[] fArray, int n) {
        this.begin("glMultMatrixf");
        this.arg("m", 16, fArray, n);
        this.arg("offset", n);
        this.end();
        this.mgl.glMultMatrixf(fArray, n);
        this.checkError();
    }

    @Override
    public void glMultMatrixx(IntBuffer intBuffer) {
        this.begin("glMultMatrixx");
        this.arg("m", 16, intBuffer);
        this.end();
        this.mgl.glMultMatrixx(intBuffer);
        this.checkError();
    }

    @Override
    public void glMultMatrixx(int[] nArray, int n) {
        this.begin("glMultMatrixx");
        this.arg("m", 16, nArray, n);
        this.arg("offset", n);
        this.end();
        this.mgl.glMultMatrixx(nArray, n);
        this.checkError();
    }

    @Override
    public void glMultiTexCoord4f(int n, float f, float f2, float f3, float f4) {
        this.begin("glMultiTexCoord4f");
        this.arg("target", n);
        this.arg("s", f);
        this.arg("t", f2);
        this.arg("r", f3);
        this.arg("q", f4);
        this.end();
        GL10 gL10 = this.mgl;
        int n2 = n;
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        gL10.glMultiTexCoord4f(n2, f5, f6, f7, f8);
        this.checkError();
    }

    @Override
    public void glMultiTexCoord4x(int n, int n2, int n3, int n4, int n5) {
        this.begin("glMultiTexCoord4x");
        this.arg("target", n);
        this.arg("s", n2);
        this.arg("t", n3);
        this.arg("r", n4);
        this.arg("q", n5);
        this.end();
        GL10 gL10 = this.mgl;
        int n6 = n;
        int n7 = n2;
        int n8 = n3;
        int n9 = n4;
        int n10 = n5;
        gL10.glMultiTexCoord4x(n6, n7, n8, n9, n10);
        this.checkError();
    }

    @Override
    public void glNormal3f(float f, float f2, float f3) {
        this.begin("glNormal3f");
        this.arg("nx", f);
        this.arg("ny", f2);
        this.arg("nz", f3);
        this.end();
        this.mgl.glNormal3f(f, f2, f3);
        this.checkError();
    }

    @Override
    public void glNormal3x(int n, int n2, int n3) {
        this.begin("glNormal3x");
        this.arg("nx", n);
        this.arg("ny", n2);
        this.arg("nz", n3);
        this.end();
        this.mgl.glNormal3x(n, n2, n3);
        this.checkError();
    }

    @Override
    public void glNormalPointer(int n, int n2, int n3) {
        this.begin("glNormalPointer");
        this.arg("type", n);
        this.arg("stride", n2);
        this.arg("offset", n3);
        this.end();
        this.mgl11.glNormalPointer(n, n2, n3);
    }

    @Override
    public void glNormalPointer(int n, int n2, Buffer buffer) {
        PointerInfo pointerInfo;
        this.begin("glNormalPointer");
        this.arg("type", n);
        this.arg("stride", n2);
        String string2 = buffer.toString();
        this.arg("pointer", string2);
        this.end();
        GLLogWrapper gLLogWrapper = this;
        int n3 = n;
        int n4 = n2;
        Buffer buffer2 = buffer;
        this.mNormalPointer = pointerInfo = gLLogWrapper.new PointerInfo(3, n3, n4, buffer2);
        this.mgl.glNormalPointer(n, n2, buffer);
        this.checkError();
    }

    @Override
    public void glOrthof(float f, float f2, float f3, float f4, float f5, float f6) {
        this.begin("glOrthof");
        this.arg("left", f);
        this.arg("right", f2);
        this.arg("bottom", f3);
        this.arg("top", f4);
        this.arg("near", f5);
        this.arg("far", f6);
        this.end();
        GL10 gL10 = this.mgl;
        float f7 = f;
        float f8 = f2;
        float f9 = f3;
        float f10 = f4;
        float f11 = f5;
        float f12 = f6;
        gL10.glOrthof(f7, f8, f9, f10, f11, f12);
        this.checkError();
    }

    @Override
    public void glOrthox(int n, int n2, int n3, int n4, int n5, int n6) {
        this.begin("glOrthox");
        this.arg("left", n);
        this.arg("right", n2);
        this.arg("bottom", n3);
        this.arg("top", n4);
        this.arg("near", n5);
        this.arg("far", n6);
        this.end();
        GL10 gL10 = this.mgl;
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        gL10.glOrthox(n7, n8, n9, n10, n11, n12);
        this.checkError();
    }

    @Override
    public void glPixelStorei(int n, int n2) {
        this.begin("glPixelStorei");
        this.arg("pname", n);
        this.arg("param", n2);
        this.end();
        this.mgl.glPixelStorei(n, n2);
        this.checkError();
    }

    @Override
    public void glPointParameterf(int n, float f) {
        this.begin("glPointParameterf");
        this.arg("pname", n);
        this.arg("param", f);
        this.end();
        this.mgl11.glPointParameterf(n, f);
        this.checkError();
    }

    @Override
    public void glPointParameterfv(int n, FloatBuffer floatBuffer) {
        this.begin("glPointParameterfv");
        this.arg("pname", n);
        String string2 = floatBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glPointParameterfv(n, floatBuffer);
        this.checkError();
    }

    @Override
    public void glPointParameterfv(int n, float[] fArray, int n2) {
        this.begin("glPointParameterfv");
        this.arg("pname", n);
        String string2 = fArray.toString();
        this.arg("params", string2);
        this.arg("offset", n2);
        this.end();
        this.mgl11.glPointParameterfv(n, fArray, n2);
        this.checkError();
    }

    @Override
    public void glPointParameterx(int n, int n2) {
        this.begin("glPointParameterfv");
        this.arg("pname", n);
        this.arg("param", n2);
        this.end();
        this.mgl11.glPointParameterx(n, n2);
        this.checkError();
    }

    @Override
    public void glPointParameterxv(int n, IntBuffer intBuffer) {
        this.begin("glPointParameterxv");
        this.arg("pname", n);
        String string2 = intBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glPointParameterxv(n, intBuffer);
        this.checkError();
    }

    @Override
    public void glPointParameterxv(int n, int[] nArray, int n2) {
        this.begin("glPointParameterxv");
        this.arg("pname", n);
        String string2 = nArray.toString();
        this.arg("params", string2);
        this.arg("offset", n2);
        this.end();
        this.mgl11.glPointParameterxv(n, nArray, n2);
        this.checkError();
    }

    @Override
    public void glPointSize(float f) {
        this.begin("glPointSize");
        this.arg("size", f);
        this.end();
        this.mgl.glPointSize(f);
        this.checkError();
    }

    @Override
    public void glPointSizePointerOES(int n, int n2, Buffer buffer) {
        this.begin("glPointSizePointerOES");
        this.arg("type", n);
        this.arg("stride", n2);
        String string2 = buffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glPointSizePointerOES(n, n2, buffer);
        this.checkError();
    }

    @Override
    public void glPointSizex(int n) {
        this.begin("glPointSizex");
        this.arg("size", n);
        this.end();
        this.mgl.glPointSizex(n);
        this.checkError();
    }

    @Override
    public void glPolygonOffset(float f, float f2) {
        this.begin("glPolygonOffset");
        this.arg("factor", f);
        this.arg("units", f2);
        this.end();
        this.mgl.glPolygonOffset(f, f2);
        this.checkError();
    }

    @Override
    public void glPolygonOffsetx(int n, int n2) {
        this.begin("glPolygonOffsetx");
        this.arg("factor", n);
        this.arg("units", n2);
        this.end();
        this.mgl.glPolygonOffsetx(n, n2);
        this.checkError();
    }

    @Override
    public void glPopMatrix() {
        this.begin("glPopMatrix");
        this.end();
        this.mgl.glPopMatrix();
        this.checkError();
    }

    @Override
    public void glPushMatrix() {
        this.begin("glPushMatrix");
        this.end();
        this.mgl.glPushMatrix();
        this.checkError();
    }

    @Override
    public int glQueryMatrixxOES(IntBuffer intBuffer, IntBuffer intBuffer2) {
        this.begin("glQueryMatrixxOES");
        String string2 = intBuffer.toString();
        this.arg("mantissa", string2);
        String string3 = intBuffer2.toString();
        this.arg("exponent", string3);
        this.end();
        int n = this.mgl10Ext.glQueryMatrixxOES(intBuffer, intBuffer2);
        String string4 = this.toString(16, 2, intBuffer);
        this.returns(string4);
        String string5 = this.toString(16, 0, intBuffer2);
        this.returns(string5);
        this.checkError();
        return n;
    }

    @Override
    public int glQueryMatrixxOES(int[] nArray, int n, int[] nArray2, int n2) {
        this.begin("glQueryMatrixxOES");
        String string2 = Arrays.toString(nArray);
        this.arg("mantissa", string2);
        String string3 = Arrays.toString(nArray2);
        this.arg("exponent", string3);
        this.end();
        int n3 = this.mgl10Ext.glQueryMatrixxOES(nArray, n, nArray2, n2);
        String string4 = this.toString(16, 2, nArray, n);
        this.returns(string4);
        String string5 = this.toString(16, 0, nArray2, n2);
        this.returns(string5);
        this.checkError();
        return n3;
    }

    @Override
    public void glReadPixels(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        this.begin("glReadPixels");
        this.arg("x", n);
        this.arg("y", n2);
        this.arg("width", n3);
        this.arg("height", n4);
        this.arg("format", n5);
        this.arg("type", n6);
        String string2 = buffer.toString();
        this.arg("pixels", string2);
        this.end();
        GL10 gL10 = this.mgl;
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        Buffer buffer2 = buffer;
        gL10.glReadPixels(n7, n8, n9, n10, n11, n12, buffer2);
        this.checkError();
    }

    @Override
    public void glRotatef(float f, float f2, float f3, float f4) {
        this.begin("glRotatef");
        this.arg("angle", f);
        this.arg("x", f2);
        this.arg("y", f3);
        this.arg("z", f4);
        this.end();
        this.mgl.glRotatef(f, f2, f3, f4);
        this.checkError();
    }

    @Override
    public void glRotatex(int n, int n2, int n3, int n4) {
        this.begin("glRotatex");
        this.arg("angle", n);
        this.arg("x", n2);
        this.arg("y", n3);
        this.arg("z", n4);
        this.end();
        this.mgl.glRotatex(n, n2, n3, n4);
        this.checkError();
    }

    @Override
    public void glSampleCoverage(float f, boolean bl) {
        this.begin("glSampleCoveragex");
        this.arg("value", f);
        this.arg("invert", bl);
        this.end();
        this.mgl.glSampleCoverage(f, bl);
        this.checkError();
    }

    @Override
    public void glSampleCoveragex(int n, boolean bl) {
        this.begin("glSampleCoveragex");
        this.arg("value", n);
        this.arg("invert", bl);
        this.end();
        this.mgl.glSampleCoveragex(n, bl);
        this.checkError();
    }

    @Override
    public void glScalef(float f, float f2, float f3) {
        this.begin("glScalef");
        this.arg("x", f);
        this.arg("y", f2);
        this.arg("z", f3);
        this.end();
        this.mgl.glScalef(f, f2, f3);
        this.checkError();
    }

    @Override
    public void glScalex(int n, int n2, int n3) {
        this.begin("glScalex");
        this.arg("x", n);
        this.arg("y", n2);
        this.arg("z", n3);
        this.end();
        this.mgl.glScalex(n, n2, n3);
        this.checkError();
    }

    @Override
    public void glScissor(int n, int n2, int n3, int n4) {
        this.begin("glScissor");
        this.arg("x", n);
        this.arg("y", n2);
        this.arg("width", n3);
        this.arg("height", n4);
        this.end();
        this.mgl.glScissor(n, n2, n3, n4);
        this.checkError();
    }

    @Override
    public void glShadeModel(int n) {
        this.begin("glShadeModel");
        String string2 = this.getShadeModel(n);
        this.arg("mode", string2);
        this.end();
        this.mgl.glShadeModel(n);
        this.checkError();
    }

    @Override
    public void glStencilFunc(int n, int n2, int n3) {
        this.begin("glStencilFunc");
        this.arg("func", n);
        this.arg("ref", n2);
        this.arg("mask", n3);
        this.end();
        this.mgl.glStencilFunc(n, n2, n3);
        this.checkError();
    }

    @Override
    public void glStencilMask(int n) {
        this.begin("glStencilMask");
        this.arg("mask", n);
        this.end();
        this.mgl.glStencilMask(n);
        this.checkError();
    }

    @Override
    public void glStencilOp(int n, int n2, int n3) {
        this.begin("glStencilOp");
        this.arg("fail", n);
        this.arg("zfail", n2);
        this.arg("zpass", n3);
        this.end();
        this.mgl.glStencilOp(n, n2, n3);
        this.checkError();
    }

    @Override
    public void glTexCoordPointer(int n, int n2, int n3, int n4) {
        this.begin("glTexCoordPointer");
        this.arg("size", n);
        this.arg("type", n2);
        this.arg("stride", n3);
        this.arg("offset", n4);
        this.end();
        this.mgl11.glTexCoordPointer(n, n2, n3, n4);
    }

    @Override
    public void glTexCoordPointer(int n, int n2, int n3, Buffer buffer) {
        PointerInfo pointerInfo;
        this.begin("glTexCoordPointer");
        this.argPointer(n, n2, n3, buffer);
        this.end();
        GLLogWrapper gLLogWrapper = this;
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        Buffer buffer2 = buffer;
        this.mTexCoordPointer = pointerInfo = gLLogWrapper.new PointerInfo(n4, n5, n6, buffer2);
        this.mgl.glTexCoordPointer(n, n2, n3, buffer);
        this.checkError();
    }

    @Override
    public void glTexEnvf(int n, int n2, float f) {
        this.begin("glTexEnvf");
        String string2 = this.getTextureEnvTarget(n);
        this.arg("target", string2);
        String string3 = this.getTextureEnvPName(n2);
        this.arg("pname", string3);
        String string4 = this.getTextureEnvParamName(f);
        this.arg("param", string4);
        this.end();
        this.mgl.glTexEnvf(n, n2, f);
        this.checkError();
    }

    @Override
    public void glTexEnvfv(int n, int n2, FloatBuffer floatBuffer) {
        this.begin("glTexEnvfv");
        String string2 = this.getTextureEnvTarget(n);
        this.arg("target", string2);
        String string3 = this.getTextureEnvPName(n2);
        this.arg("pname", string3);
        int n3 = this.getTextureEnvParamCount(n2);
        this.arg("params", n3, floatBuffer);
        this.end();
        this.mgl.glTexEnvfv(n, n2, floatBuffer);
        this.checkError();
    }

    @Override
    public void glTexEnvfv(int n, int n2, float[] fArray, int n3) {
        this.begin("glTexEnvfv");
        String string2 = this.getTextureEnvTarget(n);
        this.arg("target", string2);
        String string3 = this.getTextureEnvPName(n2);
        this.arg("pname", string3);
        int n4 = this.getTextureEnvParamCount(n2);
        this.arg("params", n4, fArray, n3);
        this.arg("offset", n3);
        this.end();
        this.mgl.glTexEnvfv(n, n2, fArray, n3);
        this.checkError();
    }

    @Override
    public void glTexEnvi(int n, int n2, int n3) {
        this.begin("glTexEnvi");
        this.arg("target", n);
        this.arg("pname", n2);
        this.arg("param", n3);
        this.end();
        this.mgl11.glTexEnvi(n, n2, n3);
        this.checkError();
    }

    @Override
    public void glTexEnviv(int n, int n2, IntBuffer intBuffer) {
        this.begin("glTexEnviv");
        this.arg("target", n);
        this.arg("pname", n2);
        String string2 = intBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glTexEnviv(n, n2, intBuffer);
        this.checkError();
    }

    @Override
    public void glTexEnviv(int n, int n2, int[] nArray, int n3) {
        this.begin("glTexEnviv");
        this.arg("target", n);
        this.arg("pname", n2);
        String string2 = nArray.toString();
        this.arg("params", string2);
        this.arg("offset", n3);
        this.end();
        this.mgl11.glTexEnviv(n, n2, nArray, n3);
        this.checkError();
    }

    @Override
    public void glTexEnvx(int n, int n2, int n3) {
        this.begin("glTexEnvx");
        String string2 = this.getTextureEnvTarget(n);
        this.arg("target", string2);
        String string3 = this.getTextureEnvPName(n2);
        this.arg("pname", string3);
        this.arg("param", n3);
        this.end();
        this.mgl.glTexEnvx(n, n2, n3);
        this.checkError();
    }

    @Override
    public void glTexEnvxv(int n, int n2, IntBuffer intBuffer) {
        this.begin("glTexEnvxv");
        String string2 = this.getTextureEnvTarget(n);
        this.arg("target", string2);
        String string3 = this.getTextureEnvPName(n2);
        this.arg("pname", string3);
        int n3 = this.getTextureEnvParamCount(n2);
        this.arg("params", n3, intBuffer);
        this.end();
        this.mgl.glTexEnvxv(n, n2, intBuffer);
        this.checkError();
    }

    @Override
    public void glTexEnvxv(int n, int n2, int[] nArray, int n3) {
        this.begin("glTexEnvxv");
        String string2 = this.getTextureEnvTarget(n);
        this.arg("target", string2);
        String string3 = this.getTextureEnvPName(n2);
        this.arg("pname", string3);
        int n4 = this.getTextureEnvParamCount(n2);
        this.arg("params", n4, nArray, n3);
        this.arg("offset", n3);
        this.end();
        this.mgl.glTexEnvxv(n, n2, nArray, n3);
        this.checkError();
    }

    @Override
    public void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        this.begin("glTexImage2D");
        this.arg("target", n);
        this.arg("level", n2);
        GLLogWrapper gLLogWrapper = this;
        String string2 = "internalformat";
        int n9 = n3;
        gLLogWrapper.arg(string2, n9);
        GLLogWrapper gLLogWrapper2 = this;
        String string3 = "width";
        int n10 = n4;
        gLLogWrapper2.arg(string3, n10);
        GLLogWrapper gLLogWrapper3 = this;
        String string4 = "height";
        int n11 = n5;
        gLLogWrapper3.arg(string4, n11);
        GLLogWrapper gLLogWrapper4 = this;
        String string5 = "border";
        int n12 = n6;
        gLLogWrapper4.arg(string5, n12);
        GLLogWrapper gLLogWrapper5 = this;
        String string6 = "format";
        int n13 = n7;
        gLLogWrapper5.arg(string6, n13);
        GLLogWrapper gLLogWrapper6 = this;
        String string7 = "type";
        int n14 = n8;
        gLLogWrapper6.arg(string7, n14);
        String string8 = buffer.toString();
        this.arg("pixels", string8);
        this.end();
        GL10 gL10 = this.mgl;
        int n15 = n;
        int n16 = n2;
        int n17 = n3;
        int n18 = n4;
        int n19 = n5;
        int n20 = n6;
        int n21 = n7;
        int n22 = n8;
        Buffer buffer2 = buffer;
        gL10.glTexImage2D(n15, n16, n17, n18, n19, n20, n21, n22, buffer2);
        this.checkError();
    }

    @Override
    public void glTexParameterf(int n, int n2, float f) {
        this.begin("glTexParameterf");
        String string2 = this.getTextureTarget(n);
        this.arg("target", string2);
        String string3 = this.getTexturePName(n2);
        this.arg("pname", string3);
        String string4 = this.getTextureParamName(f);
        this.arg("param", string4);
        this.end();
        this.mgl.glTexParameterf(n, n2, f);
        this.checkError();
    }

    @Override
    public void glTexParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        this.begin("glTexParameterfv");
        this.arg("target", n);
        this.arg("pname", n2);
        String string2 = floatBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glTexParameterfv(n, n2, floatBuffer);
        this.checkError();
    }

    @Override
    public void glTexParameterfv(int n, int n2, float[] fArray, int n3) {
        this.begin("glTexParameterfv");
        this.arg("target", n);
        this.arg("pname", n2);
        String string2 = fArray.toString();
        this.arg("params", string2);
        this.arg("offset", n3);
        this.end();
        this.mgl11.glTexParameterfv(n, n2, fArray, n3);
        this.checkError();
    }

    @Override
    public void glTexParameteri(int n, int n2, int n3) {
        this.begin("glTexParameterxv");
        this.arg("target", n);
        this.arg("pname", n2);
        this.arg("param", n3);
        this.end();
        this.mgl11.glTexParameteri(n, n2, n3);
        this.checkError();
    }

    @Override
    public void glTexParameteriv(int n, int n2, IntBuffer intBuffer) {
        this.begin("glTexParameteriv");
        String string2 = this.getTextureTarget(n);
        this.arg("target", string2);
        String string3 = this.getTexturePName(n2);
        this.arg("pname", string3);
        this.arg("params", 4, intBuffer);
        this.end();
        this.mgl11.glTexParameteriv(n, n2, intBuffer);
        this.checkError();
    }

    @Override
    public void glTexParameteriv(int n, int n2, int[] nArray, int n3) {
        this.begin("glTexParameteriv");
        String string2 = this.getTextureTarget(n);
        this.arg("target", string2);
        String string3 = this.getTexturePName(n2);
        this.arg("pname", string3);
        this.arg("params", 4, nArray, n3);
        this.end();
        this.mgl11.glTexParameteriv(n, n2, nArray, n3);
        this.checkError();
    }

    @Override
    public void glTexParameterx(int n, int n2, int n3) {
        this.begin("glTexParameterx");
        String string2 = this.getTextureTarget(n);
        this.arg("target", string2);
        String string3 = this.getTexturePName(n2);
        this.arg("pname", string3);
        this.arg("param", n3);
        this.end();
        this.mgl.glTexParameterx(n, n2, n3);
        this.checkError();
    }

    @Override
    public void glTexParameterxv(int n, int n2, IntBuffer intBuffer) {
        this.begin("glTexParameterxv");
        this.arg("target", n);
        this.arg("pname", n2);
        String string2 = intBuffer.toString();
        this.arg("params", string2);
        this.end();
        this.mgl11.glTexParameterxv(n, n2, intBuffer);
        this.checkError();
    }

    @Override
    public void glTexParameterxv(int n, int n2, int[] nArray, int n3) {
        this.begin("glTexParameterxv");
        this.arg("target", n);
        this.arg("pname", n2);
        String string2 = nArray.toString();
        this.arg("params", string2);
        this.arg("offset", n3);
        this.end();
        this.mgl11.glTexParameterxv(n, n2, nArray, n3);
        this.checkError();
    }

    @Override
    public void glTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        this.begin("glTexSubImage2D");
        String string2 = this.getTextureTarget(n);
        this.arg("target", string2);
        this.arg("level", n2);
        GLLogWrapper gLLogWrapper = this;
        String string3 = "xoffset";
        int n9 = n3;
        gLLogWrapper.arg(string3, n9);
        GLLogWrapper gLLogWrapper2 = this;
        String string4 = "yoffset";
        int n10 = n4;
        gLLogWrapper2.arg(string4, n10);
        GLLogWrapper gLLogWrapper3 = this;
        String string5 = "width";
        int n11 = n5;
        gLLogWrapper3.arg(string5, n11);
        GLLogWrapper gLLogWrapper4 = this;
        String string6 = "height";
        int n12 = n6;
        gLLogWrapper4.arg(string6, n12);
        GLLogWrapper gLLogWrapper5 = this;
        String string7 = "format";
        int n13 = n7;
        gLLogWrapper5.arg(string7, n13);
        GLLogWrapper gLLogWrapper6 = this;
        String string8 = "type";
        int n14 = n8;
        gLLogWrapper6.arg(string8, n14);
        String string9 = buffer.toString();
        this.arg("pixels", string9);
        this.end();
        GL10 gL10 = this.mgl;
        int n15 = n;
        int n16 = n2;
        int n17 = n3;
        int n18 = n4;
        int n19 = n5;
        int n20 = n6;
        int n21 = n7;
        int n22 = n8;
        Buffer buffer2 = buffer;
        gL10.glTexSubImage2D(n15, n16, n17, n18, n19, n20, n21, n22, buffer2);
        this.checkError();
    }

    @Override
    public void glTranslatef(float f, float f2, float f3) {
        this.begin("glTranslatef");
        this.arg("x", f);
        this.arg("y", f2);
        this.arg("z", f3);
        this.end();
        this.mgl.glTranslatef(f, f2, f3);
        this.checkError();
    }

    @Override
    public void glTranslatex(int n, int n2, int n3) {
        this.begin("glTranslatex");
        this.arg("x", n);
        this.arg("y", n2);
        this.arg("z", n3);
        this.end();
        this.mgl.glTranslatex(n, n2, n3);
        this.checkError();
    }

    @Override
    public void glVertexPointer(int n, int n2, int n3, int n4) {
        this.begin("glVertexPointer");
        this.arg("size", n);
        this.arg("type", n2);
        this.arg("stride", n3);
        this.arg("offset", n4);
        this.end();
        this.mgl11.glVertexPointer(n, n2, n3, n4);
    }

    @Override
    public void glVertexPointer(int n, int n2, int n3, Buffer buffer) {
        PointerInfo pointerInfo;
        this.begin("glVertexPointer");
        this.argPointer(n, n2, n3, buffer);
        this.end();
        GLLogWrapper gLLogWrapper = this;
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        Buffer buffer2 = buffer;
        this.mVertexPointer = pointerInfo = gLLogWrapper.new PointerInfo(n4, n5, n6, buffer2);
        this.mgl.glVertexPointer(n, n2, n3, buffer);
        this.checkError();
    }

    @Override
    public void glViewport(int n, int n2, int n3, int n4) {
        this.begin("glViewport");
        this.arg("x", n);
        this.arg("y", n2);
        this.arg("width", n3);
        this.arg("height", n4);
        this.end();
        this.mgl.glViewport(n, n2, n3, n4);
        this.checkError();
    }

    @Override
    public void glWeightPointerOES(int n, int n2, int n3, int n4) {
        this.begin("glWeightPointerOES");
        this.arg("size", n);
        this.arg("type", n2);
        this.arg("stride", n3);
        this.arg("offset", n4);
        this.end();
        this.mgl11Ext.glWeightPointerOES(n, n2, n3, n4);
        this.checkError();
    }

    @Override
    public void glWeightPointerOES(int n, int n2, int n3, Buffer buffer) {
        this.begin("glWeightPointerOES");
        this.argPointer(n, n2, n3, buffer);
        this.end();
        this.mgl11Ext.glWeightPointerOES(n, n2, n3, buffer);
        this.checkError();
    }

    private class PointerInfo {
        public Buffer mPointer;
        public int mSize;
        public int mStride;
        public ByteBuffer mTempByteBuffer;
        public int mType;

        public PointerInfo() {
        }

        public PointerInfo(int n, int n2, int n3, Buffer buffer) {
            this.mSize = n;
            this.mType = n2;
            this.mStride = n3;
            this.mPointer = buffer;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void bindByteBuffer() {
            ByteBuffer byteBuffer;
            if (this.mPointer == null) {
                byteBuffer = null;
            } else {
                GLLogWrapper gLLogWrapper = GLLogWrapper.this;
                Buffer buffer = this.mPointer;
                byteBuffer = gLLogWrapper.toByteBuffer(-1, buffer);
            }
            this.mTempByteBuffer = byteBuffer;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getStride() {
            if (this.mStride > 0) {
                return this.mStride;
            }
            int n = this.mType;
            int n2 = this.sizeof(n);
            int n3 = this.mSize;
            return n2 * n3;
        }

        /*
         * Handled duff style switch with additional control
         * Enabled aggressive block sorting
         */
        public int sizeof(int n) {
            int n2 = 1;
            int n3 = 0;
            block6: do {
                switch (n3 == 0 ? n : n3) {
                    default: {
                        n2 = 0;
                        n3 = 5120;
                        continue block6;
                    }
                    case 5122: {
                        n2 = 2;
                        n3 = 5120;
                        continue block6;
                    }
                    case 5132: {
                        n2 = 4;
                    }
                    case 5120: 
                    case 5121: {
                        return n2;
                    }
                    case 5126: 
                }
                return 4;
            } while (true);
            return 4;
        }

        public void unbindByteBuffer() {
            this.mTempByteBuffer = null;
        }
    }
}

