/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.content.Context;
import android.opengl.EGLLogWrapper;
import android.opengl.GLDebugHelper;
import android.os.SystemProperties;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.io.Writer;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;

public class GLSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback {
    public static final int DEBUG_CHECK_GL_ERROR = 1;
    public static final int DEBUG_LOG_GL_CALLS = 2;
    private static final boolean DRAW_TWICE_AFTER_SIZE_CHANGED = true;
    private static final boolean LOG_EGL = false;
    private static final boolean LOG_PAUSE_RESUME = false;
    private static final boolean LOG_RENDERER = false;
    private static final boolean LOG_RENDERER_DRAW_FRAME = false;
    private static final boolean LOG_SURFACE = false;
    private static final boolean LOG_THREADS = false;
    public static final int RENDERMODE_CONTINUOUSLY = 1;
    public static final int RENDERMODE_WHEN_DIRTY;
    private static final GLThreadManager sGLThreadManager;
    private int mDebugFlags;
    private EGLConfigChooser mEGLConfigChooser;
    private int mEGLContextClientVersion;
    private EGLContextFactory mEGLContextFactory;
    private EGLWindowSurfaceFactory mEGLWindowSurfaceFactory;
    private GLThread mGLThread;
    private GLWrapper mGLWrapper;
    private boolean mSizeChanged = true;

    static {
        sGLThreadManager = new GLThreadManager();
    }

    public GLSurfaceView(Context context) {
        super(context);
        this.init();
    }

    public GLSurfaceView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    static /* synthetic */ boolean access$902(GLSurfaceView gLSurfaceView, boolean bl) {
        gLSurfaceView.mSizeChanged = bl;
        return bl;
    }

    private void checkRenderThreadState() {
        if (this.mGLThread == null) {
            return;
        }
        throw new IllegalStateException("setRenderer has already been called for this instance.");
    }

    private void init() {
        this.getHolder().addCallback(this);
    }

    public int getDebugFlags() {
        return this.mDebugFlags;
    }

    public int getRenderMode() {
        return this.mGLThread.getRenderMode();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mGLThread.requestExitAndWait();
    }

    public void onPause() {
        this.mGLThread.onPause();
    }

    public void onResume() {
        this.mGLThread.onResume();
    }

    public void queueEvent(Runnable runnable) {
        this.mGLThread.queueEvent(runnable);
    }

    public void requestRender() {
        this.mGLThread.requestRender();
    }

    public void setDebugFlags(int n) {
        this.mDebugFlags = n;
    }

    public void setEGLConfigChooser(int n, int n2, int n3, int n4, int n5, int n6) {
        GLSurfaceView gLSurfaceView = this;
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        ComponentSizeChooser componentSizeChooser = gLSurfaceView.new ComponentSizeChooser(n7, n8, n9, n10, n11, n12);
        this.setEGLConfigChooser(componentSizeChooser);
    }

    public void setEGLConfigChooser(EGLConfigChooser eGLConfigChooser) {
        this.checkRenderThreadState();
        this.mEGLConfigChooser = eGLConfigChooser;
    }

    public void setEGLConfigChooser(boolean bl) {
        SimpleEGLConfigChooser simpleEGLConfigChooser = new SimpleEGLConfigChooser(bl);
        this.setEGLConfigChooser(simpleEGLConfigChooser);
    }

    public void setEGLContextClientVersion(int n) {
        this.checkRenderThreadState();
        this.mEGLContextClientVersion = n;
    }

    public void setEGLContextFactory(EGLContextFactory eGLContextFactory) {
        this.checkRenderThreadState();
        this.mEGLContextFactory = eGLContextFactory;
    }

    public void setEGLWindowSurfaceFactory(EGLWindowSurfaceFactory eGLWindowSurfaceFactory) {
        this.checkRenderThreadState();
        this.mEGLWindowSurfaceFactory = eGLWindowSurfaceFactory;
    }

    public void setGLWrapper(GLWrapper gLWrapper) {
        this.mGLWrapper = gLWrapper;
    }

    public void setRenderMode(int n) {
        this.mGLThread.setRenderMode(n);
    }

    public void setRenderer(Renderer renderer) {
        GLThread gLThread;
        this.checkRenderThreadState();
        if (this.mEGLConfigChooser == null) {
            SimpleEGLConfigChooser simpleEGLConfigChooser = new SimpleEGLConfigChooser(true);
            this.mEGLConfigChooser = simpleEGLConfigChooser;
        }
        if (this.mEGLContextFactory == null) {
            DefaultContextFactory defaultContextFactory = new DefaultContextFactory();
            this.mEGLContextFactory = defaultContextFactory;
        }
        if (this.mEGLWindowSurfaceFactory == null) {
            DefaultWindowSurfaceFactory defaultWindowSurfaceFactory = new DefaultWindowSurfaceFactory();
            this.mEGLWindowSurfaceFactory = defaultWindowSurfaceFactory;
        }
        this.mGLThread = gLThread = new GLThread(renderer);
        this.mGLThread.start();
    }

    @Override
    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        this.mGLThread.onWindowResize(n2, n3);
    }

    @Override
    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.mGLThread.surfaceCreated();
    }

    @Override
    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.mGLThread.surfaceDestroyed();
    }

    private static class GLThreadManager {
        private static String TAG = "GLThreadManager";
        private static final int kGLES_20 = 131072;
        private static final String kMSM7K_RENDERER_PREFIX = "Q3Dimension MSM7500 ";
        private GLThread mEglOwner;
        private boolean mGLESDriverCheckComplete;
        private int mGLESVersion;
        private boolean mGLESVersionCheckComplete;
        private boolean mMultipleGLESContextsAllowed;

        private GLThreadManager() {
        }

        private void checkGLESVersion() {
            int n;
            if (this.mGLESVersionCheckComplete) {
                return;
            }
            this.mGLESVersion = n = SystemProperties.getInt("ro.opengles.version", 0);
            if (this.mGLESVersion >= 131072) {
                this.mMultipleGLESContextsAllowed = true;
            }
            this.mGLESVersionCheckComplete = true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void checkGLDriver(GL10 gL10) {
            synchronized (this) {
                if (!this.mGLESDriverCheckComplete) {
                    this.checkGLESVersion();
                    if (this.mGLESVersion < 131072) {
                        boolean bl = !gL10.glGetString(7937).startsWith(kMSM7K_RENDERER_PREFIX);
                        this.mMultipleGLESContextsAllowed = bl;
                        this.notifyAll();
                    }
                    this.mGLESDriverCheckComplete = true;
                }
                return;
            }
        }

        public void releaseEglContextLocked(GLThread gLThread) {
            if (this.mEglOwner == gLThread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        /*
         * Enabled aggressive block sorting
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public boolean shouldReleaseEGLContextWhenPausing() {
            // MONITORENTER : this
            // MONITOREXIT : this
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean shouldTerminateEGLWhenPausing() {
            synchronized (this) {
                this.checkGLESVersion();
                boolean bl = this.mMultipleGLESContextsAllowed;
                if (bl) return false;
                return true;
            }
        }

        public void threadExiting(GLThread gLThread) {
            synchronized (this) {
                boolean bl = GLThread.access$1102(gLThread, true);
                if (this.mEglOwner == gLThread) {
                    this.mEglOwner = null;
                }
                this.notifyAll();
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean tryAcquireEglContextLocked(GLThread gLThread) {
            if (this.mEglOwner == gLThread || this.mEglOwner == null) {
                this.mEglOwner = gLThread;
                this.notifyAll();
                return true;
            }
            this.checkGLESVersion();
            if (this.mMultipleGLESContextsAllowed) {
                return true;
            }
            if (this.mEglOwner == null) return false;
            this.mEglOwner.requestReleaseEglContextLocked();
            return false;
        }
    }

    static class LogWriter
    extends Writer {
        private StringBuilder mBuilder;

        LogWriter() {
            StringBuilder stringBuilder;
            this.mBuilder = stringBuilder = new StringBuilder();
        }

        private void flushBuilder() {
            if (this.mBuilder.length() <= 0) {
                return;
            }
            String string2 = this.mBuilder.toString();
            int n = Log.v("GLSurfaceView", string2);
            StringBuilder stringBuilder = this.mBuilder;
            int n2 = this.mBuilder.length();
            StringBuilder stringBuilder2 = stringBuilder.delete(0, n2);
        }

        @Override
        public void close() {
            this.flushBuilder();
        }

        @Override
        public void flush() {
            this.flushBuilder();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void write(char[] cArray, int n, int n2) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n + n3;
                char c = cArray[n4];
                if (c == '\n') {
                    this.flushBuilder();
                } else {
                    StringBuilder stringBuilder = this.mBuilder.append(c);
                }
                ++n3;
            }
            return;
        }
    }

    class GLThread
    extends Thread {
        private EglHelper mEglHelper;
        private ArrayList<Runnable> mEventQueue;
        private boolean mExited;
        private boolean mHasSurface;
        private boolean mHaveEglContext;
        private boolean mHaveEglSurface;
        private int mHeight;
        private boolean mPaused;
        private boolean mRenderComplete;
        private int mRenderMode;
        private Renderer mRenderer;
        private boolean mRequestPaused;
        private boolean mRequestRender;
        private boolean mShouldExit;
        private boolean mShouldReleaseEglContext;
        private boolean mWaitingForSurface;
        private int mWidth;

        GLThread(Renderer renderer) {
            ArrayList arrayList = new ArrayList();
            this.mEventQueue = arrayList;
            this.mWidth = 0;
            this.mHeight = 0;
            this.mRequestRender = true;
            this.mRenderMode = 1;
            this.mRenderer = renderer;
        }

        static /* synthetic */ boolean access$1102(GLThread gLThread, boolean bl) {
            gLThread.mExited = bl;
            return bl;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void guardedRun() throws InterruptedException {
            boolean bl;
            boolean bl2;
            EglHelper eglHelper;
            GLSurfaceView gLSurfaceView = GLSurfaceView.this;
            this.mEglHelper = eglHelper = gLSurfaceView.new EglHelper();
            this.mHaveEglContext = bl2 = false;
            this.mHaveEglSurface = bl = false;
            GL10 gL10 = null;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            int n = 0;
            int n2 = 0;
            Runnable runnable = null;
            block21: while (true) {
                boolean bl10;
                block45: {
                    block41: {
                        GLThreadManager gLThreadManager = sGLThreadManager;
                        // MONITORENTER : gLThreadManager
                        while (true) {
                            block44: {
                                block43: {
                                    GLThread gLThread;
                                    GLThreadManager gLThreadManager2;
                                    block42: {
                                        if (this.mShouldExit) {
                                            // MONITOREXIT : gLThreadManager
                                            GLThreadManager gLThreadManager3 = sGLThreadManager;
                                            // MONITORENTER : gLThreadManager3
                                            this.stopEglSurfaceLocked();
                                            this.stopEglContextLocked();
                                            // MONITOREXIT : gLThreadManager3
                                            return;
                                        }
                                        if (this.mEventQueue.isEmpty()) break block42;
                                        ArrayList<Runnable> arrayList = this.mEventQueue;
                                        int n3 = 0;
                                        runnable = arrayList.remove(n3);
                                        break block43;
                                    }
                                    boolean bl11 = this.mPaused;
                                    boolean bl12 = bl11;
                                    boolean bl13 = this.mRequestPaused;
                                    boolean bl14 = bl13;
                                    if (bl12 != bl14) {
                                        boolean bl15;
                                        this.mPaused = bl15 = this.mRequestPaused;
                                        sGLThreadManager.notifyAll();
                                    }
                                    if (this.mShouldReleaseEglContext) {
                                        boolean bl16;
                                        this.stopEglSurfaceLocked();
                                        this.stopEglContextLocked();
                                        this.mShouldReleaseEglContext = bl16 = false;
                                        bl9 = true;
                                    }
                                    if (bl5) {
                                        this.stopEglSurfaceLocked();
                                        this.stopEglContextLocked();
                                        bl5 = false;
                                    }
                                    if (this.mHaveEglSurface && this.mPaused) {
                                        this.stopEglSurfaceLocked();
                                        if (sGLThreadManager.shouldReleaseEGLContextWhenPausing()) {
                                            this.stopEglContextLocked();
                                        }
                                        if (sGLThreadManager.shouldTerminateEGLWhenPausing()) {
                                            this.mEglHelper.finish();
                                        }
                                    }
                                    if (!this.mHasSurface && !this.mWaitingForSurface) {
                                        boolean bl17;
                                        if (this.mHaveEglSurface) {
                                            this.stopEglSurfaceLocked();
                                        }
                                        this.mWaitingForSurface = bl17 = true;
                                        sGLThreadManager.notifyAll();
                                    }
                                    if (this.mHasSurface && this.mWaitingForSurface) {
                                        boolean bl18;
                                        this.mWaitingForSurface = bl18 = false;
                                        sGLThreadManager.notifyAll();
                                    }
                                    if (bl8) {
                                        boolean bl19;
                                        bl7 = false;
                                        bl8 = false;
                                        this.mRenderComplete = bl19 = true;
                                        sGLThreadManager.notifyAll();
                                    }
                                    if (!this.readyToDraw()) break block44;
                                    if (!this.mHaveEglContext && !bl9 && (bl10 = (gLThreadManager2 = sGLThreadManager).tryAcquireEglContextLocked(gLThread = this))) {
                                        boolean bl20;
                                        boolean bl21;
                                        this.mEglHelper.start();
                                        this.mHaveEglContext = bl21 = (bl20 = true);
                                        bl3 = true;
                                        sGLThreadManager.notifyAll();
                                    }
                                    if (this.mHaveEglContext && !this.mHaveEglSurface) {
                                        boolean bl22;
                                        this.mHaveEglSurface = bl22 = true;
                                        bl4 = true;
                                        bl6 = true;
                                    }
                                    if (!this.mHaveEglSurface) break block44;
                                    if (GLSurfaceView.this.mSizeChanged) {
                                        bl6 = true;
                                        n = this.mWidth;
                                        n2 = this.mHeight;
                                        bl7 = true;
                                        GLSurfaceView gLSurfaceView2 = GLSurfaceView.this;
                                        boolean bl23 = false;
                                        boolean bl24 = GLSurfaceView.access$902(gLSurfaceView2, bl23);
                                    } else {
                                        boolean bl25;
                                        this.mRequestRender = bl25 = false;
                                    }
                                    sGLThreadManager.notifyAll();
                                }
                                // MONITOREXIT : gLThreadManager
                                if (runnable == null) break;
                                runnable.run();
                                runnable = null;
                                continue block21;
                                catch (RuntimeException runtimeException) {
                                    GLThreadManager gLThreadManager4 = sGLThreadManager;
                                    GLThread gLThread = this;
                                    gLThreadManager4.releaseEglContextLocked(gLThread);
                                    throw runtimeException;
                                }
                            }
                            sGLThreadManager.wait();
                        }
                        if (!bl4) break block45;
                        try {
                            EglHelper eglHelper2 = this.mEglHelper;
                            SurfaceHolder surfaceHolder = GLSurfaceView.this.getHolder();
                            gL10 = (GL10)eglHelper2.createSurface(surfaceHolder);
                            if (gL10 != null) break block41;
                        }
                        catch (Throwable throwable) {
                            GLThreadManager gLThreadManager5 = sGLThreadManager;
                            // MONITORENTER : gLThreadManager5
                            this.stopEglSurfaceLocked();
                            this.stopEglContextLocked();
                            // MONITOREXIT : gLThreadManager5
                            throw throwable;
                        }
                        GLThreadManager gLThreadManager6 = sGLThreadManager;
                        // MONITORENTER : gLThreadManager6
                        this.stopEglSurfaceLocked();
                        this.stopEglContextLocked();
                        // MONITOREXIT : gLThreadManager6
                        return;
                    }
                    sGLThreadManager.checkGLDriver(gL10);
                    bl4 = false;
                }
                if (bl3) {
                    Renderer renderer = this.mRenderer;
                    EGLConfig eGLConfig = this.mEglHelper.mEglConfig;
                    renderer.onSurfaceCreated(gL10, eGLConfig);
                    bl3 = false;
                }
                if (bl6) {
                    this.mRenderer.onSurfaceChanged(gL10, n, n2);
                    bl6 = false;
                }
                this.mRenderer.onDrawFrame(gL10);
                bl10 = this.mEglHelper.swap();
                if (!bl10) {
                    bl5 = true;
                }
                if (!bl7) continue;
                bl8 = true;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean readyToDraw() {
            if (this.mPaused) return false;
            if (!this.mHasSurface) return false;
            if (this.mWidth <= 0) return false;
            if (this.mHeight <= 0) return false;
            if (this.mRequestRender) return true;
            if (this.mRenderMode != 1) return false;
            return true;
        }

        private void stopEglContextLocked() {
            if (!this.mHaveEglContext) {
                return;
            }
            this.mEglHelper.finish();
            this.mHaveEglContext = false;
            sGLThreadManager.releaseEglContextLocked(this);
        }

        private void stopEglSurfaceLocked() {
            if (!this.mHaveEglSurface) {
                return;
            }
            this.mHaveEglSurface = false;
            this.mEglHelper.destroySurface();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean ableToDraw() {
            if (!this.mHaveEglContext) return false;
            if (!this.mHaveEglSurface) return false;
            if (!this.readyToDraw()) return false;
            return true;
        }

        public int getRenderMode() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                int n = this.mRenderMode;
                return n;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onPause() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                boolean bl = true;
                this.mRequestPaused = true;
                sGLThreadManager.notifyAll();
                while (!this.mExited && !(bl = this.mPaused)) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onResume() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                boolean bl = false;
                this.mRequestPaused = false;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                sGLThreadManager.notifyAll();
                while (!this.mExited && this.mPaused && !(bl = this.mRenderComplete)) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onWindowResize(int n, int n2) {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                boolean bl;
                this.mWidth = n;
                this.mHeight = n2;
                boolean bl2 = GLSurfaceView.access$902(GLSurfaceView.this, true);
                this.mRequestRender = true;
                this.mRenderComplete = false;
                sGLThreadManager.notifyAll();
                while (!this.mExited && !this.mPaused && !this.mRenderComplete && GLSurfaceView.this.mGLThread != null && (bl = GLSurfaceView.this.mGLThread.ableToDraw())) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        public void queueEvent(Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException("r must not be null");
            }
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                boolean bl = this.mEventQueue.add(runnable);
                sGLThreadManager.notifyAll();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void requestExitAndWait() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                boolean bl = true;
                this.mShouldExit = true;
                sGLThreadManager.notifyAll();
                while (!(bl = this.mExited)) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
                return;
            }
        }

        public void requestReleaseEglContextLocked() {
            this.mShouldReleaseEglContext = true;
            sGLThreadManager.notifyAll();
        }

        public void requestRender() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestRender = true;
                sGLThreadManager.notifyAll();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            GLThreadManager gLThreadManager;
            block3: {
                StringBuilder stringBuilder = new StringBuilder().append("GLThread ");
                long l = this.getId();
                String string2 = stringBuilder.append(l).toString();
                this.setName(string2);
                try {
                    this.guardedRun();
                }
                catch (Throwable throwable) {
                    sGLThreadManager.threadExiting(this);
                    throw throwable;
                }
                catch (InterruptedException interruptedException) {
                    gLThreadManager = sGLThreadManager;
                    break block3;
                }
                gLThreadManager = sGLThreadManager;
            }
            gLThreadManager.threadExiting(this);
        }

        public void setRenderMode(int n) {
            if (n < 0 || n > 1) {
                throw new IllegalArgumentException("renderMode");
            }
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRenderMode = n;
                sGLThreadManager.notifyAll();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void surfaceCreated() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                boolean bl = true;
                this.mHasSurface = true;
                sGLThreadManager.notifyAll();
                while (this.mWaitingForSurface && !(bl = this.mExited)) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void surfaceDestroyed() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                boolean bl = false;
                this.mHasSurface = false;
                sGLThreadManager.notifyAll();
                while (!this.mWaitingForSurface && !(bl = this.mExited)) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }
    }

    private class EglHelper {
        EGL10 mEgl;
        EGLConfig mEglConfig;
        EGLContext mEglContext;
        EGLDisplay mEglDisplay;
        EGLSurface mEglSurface;

        private void throwEglException(String string2) {
            int n = this.mEgl.eglGetError();
            this.throwEglException(string2, n);
        }

        private void throwEglException(String string2, int n) {
            StringBuilder stringBuilder = new StringBuilder().append(string2).append(" failed: ");
            String string3 = EGLLogWrapper.getErrorString(n);
            String string4 = stringBuilder.append(string3).toString();
            throw new RuntimeException(string4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public GL createSurface(SurfaceHolder surfaceHolder) {
            EGLContext eGLContext;
            EGLSurface eGLSurface;
            EGLSurface eGLSurface2;
            EGLDisplay eGLDisplay;
            EGL10 eGL10;
            EGLSurface eGLSurface3;
            EGLSurface eGLSurface4;
            EGLSurface eGLSurface5;
            EGLSurface eGLSurface6;
            EGLSurface eGLSurface7;
            if (this.mEgl == null) {
                throw new RuntimeException("egl not initialized");
            }
            if (this.mEglDisplay == null) {
                throw new RuntimeException("eglDisplay not initialized");
            }
            if (this.mEglConfig == null) {
                throw new RuntimeException("mEglConfig not initialized");
            }
            if (this.mEglSurface != null && (eGLSurface7 = this.mEglSurface) != (eGLSurface6 = EGL10.EGL_NO_SURFACE)) {
                EGL10 eGL102 = this.mEgl;
                EGLDisplay eGLDisplay2 = this.mEglDisplay;
                EGLSurface eGLSurface8 = EGL10.EGL_NO_SURFACE;
                EGLSurface eGLSurface9 = EGL10.EGL_NO_SURFACE;
                EGLContext eGLContext2 = EGL10.EGL_NO_CONTEXT;
                boolean bl = eGL102.eglMakeCurrent(eGLDisplay2, eGLSurface8, eGLSurface9, eGLContext2);
                EGLWindowSurfaceFactory eGLWindowSurfaceFactory = GLSurfaceView.this.mEGLWindowSurfaceFactory;
                EGL10 eGL103 = this.mEgl;
                EGLDisplay eGLDisplay3 = this.mEglDisplay;
                EGLSurface eGLSurface10 = this.mEglSurface;
                eGLWindowSurfaceFactory.destroySurface(eGL103, eGLDisplay3, eGLSurface10);
            }
            EGLWindowSurfaceFactory eGLWindowSurfaceFactory = GLSurfaceView.this.mEGLWindowSurfaceFactory;
            EGL10 eGL104 = this.mEgl;
            EGLDisplay eGLDisplay4 = this.mEglDisplay;
            EGLConfig eGLConfig = this.mEglConfig;
            this.mEglSurface = eGLSurface5 = eGLWindowSurfaceFactory.createWindowSurface(eGL104, eGLDisplay4, eGLConfig, surfaceHolder);
            if (this.mEglSurface == null || (eGLSurface4 = this.mEglSurface) == (eGLSurface3 = EGL10.EGL_NO_SURFACE)) {
                int n = this.mEgl.eglGetError();
                if (n == 12299) {
                    int n2 = Log.e("EglHelper", "createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                    return null;
                }
                this.throwEglException("createWindowSurface", n);
            }
            if (!(eGL10 = this.mEgl).eglMakeCurrent(eGLDisplay = this.mEglDisplay, eGLSurface2 = this.mEglSurface, eGLSurface = this.mEglSurface, eGLContext = this.mEglContext)) {
                this.throwEglException("eglMakeCurrent");
            }
            GL gL = this.mEglContext.getGL();
            if (GLSurfaceView.this.mGLWrapper != null) {
                gL = GLSurfaceView.this.mGLWrapper.wrap(gL);
            }
            if ((GLSurfaceView.this.mDebugFlags & 3) == 0) return gL;
            int n = 0;
            LogWriter logWriter = null;
            if ((GLSurfaceView.this.mDebugFlags & 1) != 0) {
                n |= 1;
            }
            if ((GLSurfaceView.this.mDebugFlags & 2) != 0) {
                logWriter = new LogWriter();
            }
            gL = GLDebugHelper.wrap(gL, n, (Writer)logWriter);
            return gL;
        }

        public void destroySurface() {
            if (this.mEglSurface == null) {
                return;
            }
            EGLSurface eGLSurface = this.mEglSurface;
            EGLSurface eGLSurface2 = EGL10.EGL_NO_SURFACE;
            if (eGLSurface == eGLSurface2) {
                return;
            }
            EGL10 eGL10 = this.mEgl;
            EGLDisplay eGLDisplay = this.mEglDisplay;
            EGLSurface eGLSurface3 = EGL10.EGL_NO_SURFACE;
            EGLSurface eGLSurface4 = EGL10.EGL_NO_SURFACE;
            EGLContext eGLContext = EGL10.EGL_NO_CONTEXT;
            boolean bl = eGL10.eglMakeCurrent(eGLDisplay, eGLSurface3, eGLSurface4, eGLContext);
            EGLWindowSurfaceFactory eGLWindowSurfaceFactory = GLSurfaceView.this.mEGLWindowSurfaceFactory;
            EGL10 eGL102 = this.mEgl;
            EGLDisplay eGLDisplay2 = this.mEglDisplay;
            EGLSurface eGLSurface5 = this.mEglSurface;
            eGLWindowSurfaceFactory.destroySurface(eGL102, eGLDisplay2, eGLSurface5);
            this.mEglSurface = null;
        }

        public void finish() {
            if (this.mEglContext != null) {
                EGLContextFactory eGLContextFactory = GLSurfaceView.this.mEGLContextFactory;
                EGL10 eGL10 = this.mEgl;
                EGLDisplay eGLDisplay = this.mEglDisplay;
                EGLContext eGLContext = this.mEglContext;
                eGLContextFactory.destroyContext(eGL10, eGLDisplay, eGLContext);
                this.mEglContext = null;
            }
            if (this.mEglDisplay == null) {
                return;
            }
            EGL10 eGL10 = this.mEgl;
            EGLDisplay eGLDisplay = this.mEglDisplay;
            boolean bl = eGL10.eglTerminate(eGLDisplay);
            this.mEglDisplay = null;
        }

        public void start() {
            EGLContext eGLContext;
            EGLContext eGLContext2;
            EGLContext eGLContext3;
            EGLConfig eGLConfig;
            EGLDisplay eGLDisplay;
            Object object;
            EGL10 eGL10 = (EGL10)EGLContext.getEGL();
            this.mEgl = eGL10;
            EGL10 eGL102 = this.mEgl;
            EGLDisplay eGLDisplay2 = eGL102.eglGetDisplay(object = EGL10.EGL_DEFAULT_DISPLAY);
            this.mEglDisplay = eGLDisplay2;
            EGLDisplay eGLDisplay3 = this.mEglDisplay;
            if (eGLDisplay3 == (eGLDisplay = EGL10.EGL_NO_DISPLAY)) {
                throw new RuntimeException("eglGetDisplay failed");
            }
            EGL10 eGL103 = this.mEgl;
            EGLDisplay eGLDisplay4 = this.mEglDisplay;
            int[] nArray = new int[2];
            if (!eGL103.eglInitialize(eGLDisplay4, nArray)) {
                throw new RuntimeException("eglInitialize failed");
            }
            EGLConfigChooser eGLConfigChooser = GLSurfaceView.this.mEGLConfigChooser;
            EGL10 eGL104 = this.mEgl;
            EGLDisplay eGLDisplay5 = this.mEglDisplay;
            this.mEglConfig = eGLConfig = eGLConfigChooser.chooseConfig(eGL104, eGLDisplay5);
            EGLContextFactory eGLContextFactory = GLSurfaceView.this.mEGLContextFactory;
            EGL10 eGL105 = this.mEgl;
            EGLDisplay eGLDisplay6 = this.mEglDisplay;
            EGLConfig eGLConfig2 = this.mEglConfig;
            this.mEglContext = eGLContext3 = eGLContextFactory.createContext(eGL105, eGLDisplay6, eGLConfig2);
            if (this.mEglContext == null || (eGLContext2 = this.mEglContext) == (eGLContext = EGL10.EGL_NO_CONTEXT)) {
                this.mEglContext = null;
                this.throwEglException("createContext");
            }
            this.mEglSurface = null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean swap() {
            EGL10 eGL10 = this.mEgl;
            EGLDisplay eGLDisplay = this.mEglDisplay;
            EGLSurface eGLSurface = this.mEglSurface;
            if (eGL10.eglSwapBuffers(eGLDisplay, eGLSurface)) return true;
            int n = this.mEgl.eglGetError();
            switch (n) {
                default: {
                    this.throwEglException("eglSwapBuffers", n);
                    return true;
                }
                case 12302: {
                    return false;
                }
                case 12299: 
            }
            StringBuilder stringBuilder = new StringBuilder().append("eglSwapBuffers returned EGL_BAD_NATIVE_WINDOW. tid=");
            long l = Thread.currentThread().getId();
            String string2 = stringBuilder.append(l).toString();
            int n2 = Log.e("EglHelper", string2);
            return true;
        }
    }

    private class SimpleEGLConfigChooser
    extends ComponentSizeChooser {
        /*
         * Enabled aggressive block sorting
         */
        public SimpleEGLConfigChooser(boolean bl) {
            int n = bl ? 16 : 0;
            SimpleEGLConfigChooser simpleEGLConfigChooser = this;
            GLSurfaceView gLSurfaceView2 = GLSurfaceView.this;
            int n2 = 5;
            int n3 = 0;
            super(5, 6, n2, 0, n, n3);
        }
    }

    private class ComponentSizeChooser
    extends BaseConfigChooser {
        protected int mAlphaSize;
        protected int mBlueSize;
        protected int mDepthSize;
        protected int mGreenSize;
        protected int mRedSize;
        protected int mStencilSize;
        private int[] mValue;

        public ComponentSizeChooser(int n, int n2, int n3, int n4, int n5, int n6) {
            int[] nArray = new int[]{12324, n, 12323, n2, 12322, n3, 12321, n4, 12325, n5, 12326, n6, 12344};
            super(nArray);
            int[] nArray2 = new int[1];
            this.mValue = nArray2;
            this.mRedSize = n;
            this.mGreenSize = n2;
            this.mBlueSize = n3;
            this.mAlphaSize = n4;
            this.mDepthSize = n5;
            this.mStencilSize = n6;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int findConfigAttrib(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int n2) {
            int[] nArray = this.mValue;
            if (!eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, nArray)) return n2;
            return this.mValue[0];
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            EGLConfig[] eGLConfigArray2 = eGLConfigArray;
            int n = eGLConfigArray2.length;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                EGLConfig eGLConfig = eGLConfigArray2[n2];
                ComponentSizeChooser componentSizeChooser = this;
                EGL10 eGL102 = eGL10;
                EGLDisplay eGLDisplay2 = eGLDisplay;
                int n4 = componentSizeChooser.findConfigAttrib(eGL102, eGLDisplay2, eGLConfig, 12325, 0);
                ComponentSizeChooser componentSizeChooser2 = this;
                EGL10 eGL103 = eGL10;
                EGLDisplay eGLDisplay3 = eGLDisplay;
                int n5 = componentSizeChooser2.findConfigAttrib(eGL103, eGLDisplay3, eGLConfig, 12326, 0);
                int n6 = this.mDepthSize;
                if (n4 >= n6 && n5 >= (n3 = this.mStencilSize)) {
                    int n7;
                    int n8;
                    int n9;
                    ComponentSizeChooser componentSizeChooser3 = this;
                    EGL10 eGL104 = eGL10;
                    EGLDisplay eGLDisplay4 = eGLDisplay;
                    int n10 = componentSizeChooser3.findConfigAttrib(eGL104, eGLDisplay4, eGLConfig, 12324, 0);
                    ComponentSizeChooser componentSizeChooser4 = this;
                    EGL10 eGL105 = eGL10;
                    EGLDisplay eGLDisplay5 = eGLDisplay;
                    int n11 = componentSizeChooser4.findConfigAttrib(eGL105, eGLDisplay5, eGLConfig, 12323, 0);
                    ComponentSizeChooser componentSizeChooser5 = this;
                    EGL10 eGL106 = eGL10;
                    EGLDisplay eGLDisplay6 = eGLDisplay;
                    int n12 = componentSizeChooser5.findConfigAttrib(eGL106, eGLDisplay6, eGLConfig, 12322, 0);
                    ComponentSizeChooser componentSizeChooser6 = this;
                    EGL10 eGL107 = eGL10;
                    EGLDisplay eGLDisplay7 = eGLDisplay;
                    int n13 = componentSizeChooser6.findConfigAttrib(eGL107, eGLDisplay7, eGLConfig, 12321, 0);
                    int n14 = this.mRedSize;
                    if (n10 != n14 && n11 != (n9 = this.mGreenSize) && n12 != (n8 = this.mBlueSize) && n13 != (n7 = this.mAlphaSize)) {
                        return eGLConfig;
                    }
                }
                ++n2;
            }
            return null;
        }
    }

    private abstract class BaseConfigChooser
    implements EGLConfigChooser {
        protected int[] mConfigSpec;

        public BaseConfigChooser(int[] nArray) {
            int[] nArray2 = this.filterConfigSpec(nArray);
            this.mConfigSpec = nArray2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int[] filterConfigSpec(int[] nArray) {
            if (GLSurfaceView.this.mEGLContextClientVersion != 2) {
                return nArray;
            }
            int n = nArray.length;
            int[] nArray2 = new int[n + 2];
            int n2 = n - 1;
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            int n3 = n - 1;
            nArray2[n3] = 12352;
            nArray2[n] = 4;
            int n4 = n + 1;
            nArray2[n4] = 12344;
            return nArray2;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
            EGL10 eGL102 = eGL10;
            EGLDisplay eGLDisplay2 = eGLDisplay;
            int[] nArray = this.mConfigSpec;
            int[] nArray2 = new int[1];
            if (!eGL102.eglChooseConfig(eGLDisplay2, nArray, null, 0, nArray2)) {
                throw new IllegalArgumentException("eglChooseConfig failed");
            }
            int n = nArray2[0];
            if (n <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGL10 eGL103 = eGL10;
            EGLDisplay eGLDisplay3 = eGLDisplay;
            int[] nArray3 = this.mConfigSpec;
            EGLConfig[] eGLConfigArray = new EGLConfig[n];
            if (!eGL103.eglChooseConfig(eGLDisplay3, nArray3, eGLConfigArray, n, nArray2)) {
                throw new IllegalArgumentException("eglChooseConfig#2 failed");
            }
            EGLConfig eGLConfig = this.chooseConfig(eGL10, eGLDisplay, eGLConfigArray);
            if (eGLConfig == null) {
                throw new IllegalArgumentException("No config chosen");
            }
            return eGLConfig;
        }

        abstract EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, EGLConfig[] var3);
    }

    public static interface EGLConfigChooser {
        public EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2);
    }

    private static class DefaultWindowSurfaceFactory
    implements EGLWindowSurfaceFactory {
        private DefaultWindowSurfaceFactory() {
        }

        @Override
        public EGLSurface createWindowSurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object) {
            return eGL10.eglCreateWindowSurface(eGLDisplay, eGLConfig, object, null);
        }

        @Override
        public void destroySurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
            boolean bl = eGL10.eglDestroySurface(eGLDisplay, eGLSurface);
        }
    }

    public static interface EGLWindowSurfaceFactory {
        public EGLSurface createWindowSurface(EGL10 var1, EGLDisplay var2, EGLConfig var3, Object var4);

        public void destroySurface(EGL10 var1, EGLDisplay var2, EGLSurface var3);
    }

    private class DefaultContextFactory
    implements EGLContextFactory {
        private int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private DefaultContextFactory() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public EGLContext createContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int[] nArray;
            int n = this.EGL_CONTEXT_CLIENT_VERSION;
            int n2 = GLSurfaceView.this.mEGLContextClientVersion;
            int[] nArray2 = new int[]{n, n2, 12344};
            EGLContext eGLContext = EGL10.EGL_NO_CONTEXT;
            if (GLSurfaceView.this.mEGLContextClientVersion != 0) {
                nArray = nArray2;
                return eGL10.eglCreateContext(eGLDisplay, eGLConfig, eGLContext, nArray);
            }
            nArray = null;
            return eGL10.eglCreateContext(eGLDisplay, eGLConfig, eGLContext, nArray);
        }

        @Override
        public void destroyContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLContext eGLContext) {
            if (eGL10.eglDestroyContext(eGLDisplay, eGLContext)) {
                return;
            }
            String string2 = "display:" + eGLDisplay + " context: " + eGLContext;
            int n = Log.e("DefaultContextFactory", string2);
            StringBuilder stringBuilder = new StringBuilder().append("eglDestroyContext failed: ");
            String string3 = EGLLogWrapper.getErrorString(eGL10.eglGetError());
            String string4 = stringBuilder.append(string3).toString();
            throw new RuntimeException(string4);
        }
    }

    public static interface EGLContextFactory {
        public EGLContext createContext(EGL10 var1, EGLDisplay var2, EGLConfig var3);

        public void destroyContext(EGL10 var1, EGLDisplay var2, EGLContext var3);
    }

    public static interface Renderer {
        public void onDrawFrame(GL10 var1);

        public void onSurfaceChanged(GL10 var1, int var2, int var3);

        public void onSurfaceCreated(GL10 var1, EGLConfig var2);
    }

    public static interface GLWrapper {
        public GL wrap(GL var1);
    }
}

