/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.graphics.Bitmap;

public final class GLUtils {
    static {
        GLUtils.nativeClassInit();
    }

    private GLUtils() {
    }

    public static int getInternalFormat(Bitmap bitmap) {
        if (bitmap == null) {
            throw new NullPointerException("getInternalFormat can't be used with a null Bitmap");
        }
        int n = GLUtils.native_getInternalFormat(bitmap);
        if (n < 0) {
            throw new IllegalArgumentException("Unknown internalformat");
        }
        return n;
    }

    public static int getType(Bitmap bitmap) {
        if (bitmap == null) {
            throw new NullPointerException("getType can't be used with a null Bitmap");
        }
        int n = GLUtils.native_getType(bitmap);
        if (n < 0) {
            throw new IllegalArgumentException("Unknown type");
        }
        return n;
    }

    private static native void nativeClassInit();

    private static native int native_getInternalFormat(Bitmap var0);

    private static native int native_getType(Bitmap var0);

    private static native int native_texImage2D(int var0, int var1, int var2, Bitmap var3, int var4, int var5);

    private static native int native_texSubImage2D(int var0, int var1, int var2, int var3, Bitmap var4, int var5, int var6);

    public static void texImage2D(int n, int n2, int n3, Bitmap bitmap, int n4) {
        if (bitmap == null) {
            throw new NullPointerException("texImage2D can't be used with a null Bitmap");
        }
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        Bitmap bitmap2 = bitmap;
        int n8 = n4;
        if (GLUtils.native_texImage2D(n5, n6, n7, bitmap2, -1, n8) == 0) {
            return;
        }
        throw new IllegalArgumentException("invalid Bitmap format");
    }

    public static void texImage2D(int n, int n2, int n3, Bitmap bitmap, int n4, int n5) {
        if (bitmap == null) {
            throw new NullPointerException("texImage2D can't be used with a null Bitmap");
        }
        if (GLUtils.native_texImage2D(n, n2, n3, bitmap, n4, n5) == 0) {
            return;
        }
        throw new IllegalArgumentException("invalid Bitmap format");
    }

    public static void texImage2D(int n, int n2, Bitmap bitmap, int n3) {
        if (bitmap == null) {
            throw new NullPointerException("texImage2D can't be used with a null Bitmap");
        }
        int n4 = n;
        int n5 = n2;
        Bitmap bitmap2 = bitmap;
        int n6 = -1;
        int n7 = n3;
        if (GLUtils.native_texImage2D(n4, n5, -1, bitmap2, n6, n7) == 0) {
            return;
        }
        throw new IllegalArgumentException("invalid Bitmap format");
    }

    public static void texSubImage2D(int n, int n2, int n3, int n4, Bitmap bitmap) {
        if (bitmap == null) {
            throw new NullPointerException("texSubImage2D can't be used with a null Bitmap");
        }
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        Bitmap bitmap2 = bitmap;
        int n9 = GLUtils.getType(bitmap);
        if (GLUtils.native_texSubImage2D(n5, n6, n7, n8, bitmap2, -1, n9) == 0) {
            return;
        }
        throw new IllegalArgumentException("invalid Bitmap format");
    }

    public static void texSubImage2D(int n, int n2, int n3, int n4, Bitmap bitmap, int n5, int n6) {
        if (bitmap == null) {
            throw new NullPointerException("texSubImage2D can't be used with a null Bitmap");
        }
        if (GLUtils.native_texSubImage2D(n, n2, n3, n4, bitmap, n5, n6) == 0) {
            return;
        }
        throw new IllegalArgumentException("invalid Bitmap format");
    }
}

