/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.Material;
import android.opengl.MaterialIndices;
import android.opengl.Object3D;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.microedition.khronos.opengles.GL10;

public class Group {
    private List<MaterialIndices> materialIndices;
    private String name;
    private Object3D parent;

    public Group(Object3D object3D) {
        ArrayList<MaterialIndices> arrayList = new ArrayList<MaterialIndices>();
        this.materialIndices = arrayList;
        this.parent = object3D;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(GL10 gL10) {
        gL10.glDisableClientState(32886);
        IntBuffer intBuffer = this.parent.getVertexBuffer();
        gL10.glVertexPointer(3, 5132, 0, intBuffer);
        gL10.glEnableClientState(32884);
        IntBuffer intBuffer2 = this.parent.getNormalBuffer();
        gL10.glNormalPointer(5132, 0, intBuffer2);
        gL10.glEnableClientState(32885);
        if (this.parent.hasTexcoords()) {
            IntBuffer intBuffer3 = this.parent.getTexcoordBuffer();
            gL10.glTexCoordPointer(2, 5132, 0, intBuffer3);
            gL10.glEnableClientState(32888);
            gL10.glEnable(3553);
        } else {
            gL10.glDisable(3553);
        }
        Iterator<MaterialIndices> iterator = this.materialIndices.iterator();
        while (iterator.hasNext()) {
            MaterialIndices materialIndices = iterator.next();
            ShortBuffer shortBuffer = materialIndices.getIndexBuffer();
            Material material = materialIndices.getMaterial();
            material.setMaterialParameters(gL10);
            if (this.parent.hasTexcoords() && material.getMap_Kd().length() > 0) {
                Object3D object3D = this.parent;
                String string2 = material.getMap_Kd();
                object3D.getTexture(string2).setTextureParameters(gL10);
            }
            int n = shortBuffer.capacity();
            gL10.glDrawElements(4, n, 5123, shortBuffer);
        }
        return;
    }

    public String getName() {
        return this.name;
    }

    public int getNumTriangles() {
        int n = 0;
        Iterator<MaterialIndices> iterator = this.materialIndices.iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.next().getIndexBuffer().capacity() / 3;
            n += n2;
        }
        return n;
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        String string2;
        int n = dataInputStream.readInt();
        this.name = string2 = dataInputStream.readUTF();
        int n2 = dataInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = dataInputStream.readInt();
            String string3 = dataInputStream.readUTF();
            Material material = this.parent.getMaterial(string3);
            int n5 = dataInputStream.readInt();
            byte[] byArray = new byte[n5 * 2];
            dataInputStream.readFully(byArray);
            ByteOrder byteOrder = ByteOrder.nativeOrder();
            ByteOrder byteOrder2 = ByteOrder.LITTLE_ENDIAN;
            if (byteOrder == byteOrder2) {
                int n6 = 0;
                for (int i = 0; i < n5; ++i) {
                    byte by;
                    byte by2 = byArray[n6];
                    int n7 = n6 + 1;
                    byArray[n6] = by = byArray[n7];
                    int n8 = n6 + 1;
                    byArray[n8] = by2;
                    n6 += 2;
                }
            }
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n5 * 2);
            ByteOrder byteOrder3 = ByteOrder.nativeOrder();
            ByteBuffer byteBuffer2 = byteBuffer.order(byteOrder3);
            ByteBuffer byteBuffer3 = byteBuffer.put(byArray);
            Buffer buffer = byteBuffer.position(0);
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            List<MaterialIndices> list = this.materialIndices;
            MaterialIndices materialIndices = new MaterialIndices(material, shortBuffer);
            boolean bl = list.add(materialIndices);
            ++n3;
        }
        return;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Group[name=");
        String string2 = this.name;
        return stringBuilder.append(string2).append("]").toString();
    }
}

