/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.Group;
import android.opengl.Material;
import android.opengl.Texture;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.microedition.khronos.opengles.GL10;

public abstract class Object3D {
    private float mBoundsMaxX;
    private float mBoundsMaxY;
    private float mBoundsMaxZ;
    private float mBoundsMinX = Float.MAX_VALUE;
    private float mBoundsMinY;
    private float mBoundsMinZ;
    private Map<String, Group> mGroups;
    private boolean mHasTexcoords = false;
    private Map<String, Material> mMaterials;
    private IntBuffer mNormalBuffer;
    private IntBuffer mTexcoordBuffer;
    private Map<String, Texture> mTextures;
    private IntBuffer mVertexBuffer;

    public Object3D() {
        this.mBoundsMaxX = Float.MIN_VALUE;
        this.mBoundsMinY = Float.MAX_VALUE;
        this.mBoundsMaxY = Float.MIN_VALUE;
        this.mBoundsMinZ = Float.MAX_VALUE;
        this.mBoundsMaxZ = Float.MIN_VALUE;
        this.reset();
    }

    private void reset() {
        this.mTexcoordBuffer = null;
        this.mNormalBuffer = null;
        this.mVertexBuffer = null;
        HashMap<String, Group> hashMap = new HashMap<String, Group>();
        this.mGroups = hashMap;
        HashMap<String, Material> hashMap2 = new HashMap<String, Material>();
        this.mMaterials = hashMap2;
        HashMap<String, Texture> hashMap3 = new HashMap<String, Texture>();
        this.mTextures = hashMap3;
    }

    private static void verifyByte(DataInputStream dataInputStream, int n) throws IOException {
        int n2 = dataInputStream.read() & 0xFF;
        if (n2 != n) {
            return;
        }
        String string2 = "Bad byte: " + n2 + " (expected " + n + ")";
        throw new RuntimeException(string2);
    }

    public void draw(GL10 gL10) {
        Iterator<Group> iterator = this.mGroups.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().draw(gL10);
        }
        return;
    }

    public float getBoundsMaxX() {
        return this.mBoundsMaxX;
    }

    public float getBoundsMaxY() {
        return this.mBoundsMaxY;
    }

    public float getBoundsMaxZ() {
        return this.mBoundsMaxZ;
    }

    public float getBoundsMinX() {
        return this.mBoundsMinX;
    }

    public float getBoundsMinY() {
        return this.mBoundsMinY;
    }

    public float getBoundsMinZ() {
        return this.mBoundsMinZ;
    }

    public Material getMaterial(String string2) {
        return this.mMaterials.get(string2);
    }

    public IntBuffer getNormalBuffer() {
        return this.mNormalBuffer;
    }

    public int getNumTriangles() {
        int n = 0;
        Iterator<Group> iterator = this.mGroups.values().iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.next().getNumTriangles();
            n += n2;
        }
        return n;
    }

    public IntBuffer getTexcoordBuffer() {
        return this.mTexcoordBuffer;
    }

    public Texture getTexture(String string2) {
        return this.mTextures.get(string2);
    }

    public IntBuffer getVertexBuffer() {
        return this.mVertexBuffer;
    }

    public boolean hasTexcoords() {
        return this.mHasTexcoords;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void load(String string2) throws IOException {
        IntBuffer intBuffer;
        IntBuffer intBuffer2;
        ByteOrder byteOrder;
        ByteOrder byteOrder2;
        int n;
        int n2;
        boolean bl;
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        DataInputStream dataInputStream;
        this.reset();
        InputStream inputStream = this.readFile(string2);
        DataInputStream dataInputStream2 = dataInputStream;
        InputStream inputStream2 = inputStream;
        dataInputStream2(inputStream2);
        DataInputStream dataInputStream3 = dataInputStream;
        int n3 = 231;
        Object3D.verifyByte(dataInputStream3, n3);
        DataInputStream dataInputStream4 = dataInputStream;
        int n4 = 108;
        Object3D.verifyByte(dataInputStream4, n4);
        DataInputStream dataInputStream5 = dataInputStream;
        int n5 = 101;
        Object3D.verifyByte(dataInputStream5, n5);
        DataInputStream dataInputStream6 = dataInputStream;
        int n6 = 115;
        Object3D.verifyByte(dataInputStream6, n6);
        int n7 = dataInputStream.readInt();
        this.mBoundsMinX = f6 = dataInputStream.readFloat();
        this.mBoundsMaxX = f5 = dataInputStream.readFloat();
        this.mBoundsMinY = f4 = dataInputStream.readFloat();
        this.mBoundsMaxY = f3 = dataInputStream.readFloat();
        this.mBoundsMinZ = f2 = dataInputStream.readFloat();
        this.mBoundsMaxZ = f = dataInputStream.readFloat();
        int n8 = dataInputStream.readInt();
        int n9 = 1;
        boolean bl2 = n8 == n9;
        this.mHasTexcoords = bl = bl2;
        int n10 = this.mHasTexcoords ? 8 : 6;
        int n11 = n7 * n10;
        int n12 = n7 * 4;
        int n13 = this.mHasTexcoords ? 8 : 6;
        int n14 = n12 * n13;
        byte[] byArray = new byte[n14];
        int n15 = 0;
        while ((n2 = n15) < (n = n14)) {
            int n16 = n14 - n15;
            DataInputStream dataInputStream7 = dataInputStream;
            byte[] byArray2 = byArray;
            int n17 = n15;
            int n18 = n16;
            int n19 = dataInputStream7.read(byArray2, n17, n18);
            n15 += n19;
        }
        ByteOrder byteOrder3 = ByteOrder.nativeOrder();
        ByteOrder byteOrder4 = byteOrder3;
        if (byteOrder4 == (byteOrder2 = (byteOrder = ByteOrder.BIG_ENDIAN))) {
            for (int i = 0; i < n14; i += 4) {
                byte by;
                byte by2 = byArray[i];
                int n20 = i + 1;
                byte by3 = byArray[n20];
                int n21 = i + 2;
                byte by4 = byArray[n21];
                int n22 = i + 3;
                byArray[i] = by = byArray[n22];
                int n23 = i + 1;
                byArray[n23] = by4;
                int n24 = i + 2;
                byArray[n24] = by3;
                int n25 = i + 3;
                byArray[n25] = by2;
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n14);
        ByteOrder byteOrder5 = ByteOrder.nativeOrder();
        ByteBuffer byteBuffer2 = byteBuffer;
        ByteOrder byteOrder6 = byteOrder5;
        ByteBuffer byteBuffer3 = byteBuffer2.order(byteOrder6);
        ByteBuffer byteBuffer4 = byteBuffer;
        byte[] byArray3 = byArray;
        ByteBuffer byteBuffer5 = byteBuffer4.put(byArray3);
        ByteBuffer byteBuffer6 = byteBuffer;
        int n26 = 0;
        Buffer buffer = byteBuffer6.position(n26);
        int n27 = n7 * 12;
        ByteBuffer byteBuffer7 = byteBuffer;
        int n28 = n27;
        Buffer buffer2 = byteBuffer7.limit(n28);
        this.mVertexBuffer = intBuffer2 = byteBuffer.slice().asIntBuffer();
        Buffer buffer3 = this.mVertexBuffer.position(0);
        if (this.mHasTexcoords) {
            IntBuffer intBuffer3;
            int n29 = byteBuffer.limit();
            ByteBuffer byteBuffer8 = byteBuffer;
            int n30 = n29;
            Buffer buffer4 = byteBuffer8.position(n30);
            int n31 = byteBuffer.position();
            int n32 = n7 * 8;
            int n33 = n31 + n32;
            ByteBuffer byteBuffer9 = byteBuffer;
            int n34 = n33;
            Buffer buffer5 = byteBuffer9.limit(n34);
            this.mTexcoordBuffer = intBuffer3 = byteBuffer.slice().asIntBuffer();
            Buffer buffer6 = this.mTexcoordBuffer.position(0);
        }
        int n35 = byteBuffer.limit();
        ByteBuffer byteBuffer10 = byteBuffer;
        int n36 = n35;
        Buffer buffer7 = byteBuffer10.position(n36);
        int n37 = byteBuffer.position();
        int n38 = n7 * 12;
        int n39 = n37 + n38;
        ByteBuffer byteBuffer11 = byteBuffer;
        int n40 = n39;
        Buffer buffer8 = byteBuffer11.limit(n40);
        this.mNormalBuffer = intBuffer = byteBuffer.slice().asIntBuffer();
        Buffer buffer9 = this.mNormalBuffer.position(0);
        int n41 = dataInputStream.readInt();
        for (int i = 0; i < n41; ++i) {
            Material material;
            Material material2 = material;
            Object3D object3D = this;
            material2(object3D);
            material.load(dataInputStream);
            Map<String, Material> map = this.mMaterials;
            String string3 = material.getName();
            Map<String, Material> map2 = map;
            String string4 = string3;
            Material material3 = material;
            Material material4 = map2.put(string4, material3);
        }
        int n42 = dataInputStream.readInt();
        int n43 = 0;
        while (n43 < n42) {
            Group group;
            Group group2 = group;
            Object3D object3D = this;
            group2(object3D);
            group.load(dataInputStream);
            Map<String, Group> map = this.mGroups;
            String string5 = group.getName();
            Map<String, Group> map3 = map;
            String string6 = string5;
            Group group3 = group;
            Group group4 = map3.put(string6, group3);
            ++n43;
        }
        return;
    }

    public void loadTexture(String string2) throws IOException {
        String string3 = string2 + ".raw";
        InputStream inputStream = this.readFile(string3);
        Texture texture = new Texture(inputStream);
        Texture texture2 = this.mTextures.put(string2, texture);
    }

    public abstract InputStream readFile(String var1) throws IOException;
}

