/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AsyncTask<Params, Progress, Result> {
    private static final int CORE_POOL_SIZE = 5;
    private static final int KEEP_ALIVE = 1;
    private static final String LOG_TAG = "AsyncTask";
    private static final int MAXIMUM_POOL_SIZE = 128;
    private static final int MESSAGE_POST_CANCEL = 3;
    private static final int MESSAGE_POST_PROGRESS = 2;
    private static final int MESSAGE_POST_RESULT = 1;
    private static final ThreadPoolExecutor sExecutor;
    private static final InternalHandler sHandler;
    private static final ThreadFactory sThreadFactory;
    private static final BlockingQueue<Runnable> sWorkQueue;
    private final FutureTask<Result> mFuture;
    private volatile Status mStatus;
    private final WorkerRunnable<Params, Result> mWorker;

    static {
        sWorkQueue = new LinkedBlockingQueue<Runnable>(10);
        sThreadFactory = new ThreadFactory(){
            private final AtomicInteger mCount;
            {
                AtomicInteger atomicInteger;
                this.mCount = atomicInteger = new AtomicInteger(1);
            }

            @Override
            public Thread newThread(Runnable runnable) {
                StringBuilder stringBuilder = new StringBuilder().append("AsyncTask #");
                int n = this.mCount.getAndIncrement();
                String string2 = stringBuilder.append(n).toString();
                return new Thread(runnable, string2);
            }
        };
        TimeUnit timeUnit = TimeUnit.SECONDS;
        BlockingQueue<Runnable> blockingQueue = sWorkQueue;
        ThreadFactory threadFactory = sThreadFactory;
        sExecutor = new ThreadPoolExecutor(5, 128, 1L, timeUnit, blockingQueue, threadFactory);
        sHandler = new InternalHandler();
    }

    public AsyncTask() {
        FutureTask futureTask;
        WorkerRunnable workerRunnable;
        Status status;
        this.mStatus = status = Status.PENDING;
        this.mWorker = workerRunnable = new WorkerRunnable<Params, Result>(){

            @Override
            public Result call() throws Exception {
                Process.setThreadPriority(10);
                AsyncTask asyncTask = AsyncTask.this;
                Object[] objectArray = this.mParams;
                return asyncTask.doInBackground(objectArray);
            }
        };
        WorkerRunnable<Params, Result> workerRunnable2 = this.mWorker;
        this.mFuture = futureTask = new FutureTask<Result>(workerRunnable2){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected void done() {
                Object var1_1;
                block5: {
                    Object v;
                    var1_1 = null;
                    try {
                        v = this.get();
                    }
                    catch (InterruptedException interruptedException) {
                        int n = Log.w(AsyncTask.LOG_TAG, interruptedException);
                        break block5;
                    }
                    catch (ExecutionException executionException) {
                        Throwable throwable = executionException.getCause();
                        throw new RuntimeException("An error occured while executing doInBackground()", throwable);
                    }
                    catch (CancellationException cancellationException) {
                        InternalHandler internalHandler = sHandler;
                        AsyncTask asyncTask = AsyncTask.this;
                        Object[] objectArray = null;
                        AsyncTaskResult<Object> asyncTaskResult = new AsyncTaskResult<Object>(asyncTask, objectArray);
                        internalHandler.obtainMessage(3, asyncTaskResult).sendToTarget();
                        return;
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException("An error occured while executing doInBackground()", throwable);
                    }
                    var1_1 = v;
                }
                InternalHandler internalHandler = sHandler;
                AsyncTask asyncTask = AsyncTask.this;
                Object[] objectArray = new Object[]{var1_1};
                AsyncTaskResult<Object> asyncTaskResult = new AsyncTaskResult<Object>(asyncTask, objectArray);
                internalHandler.obtainMessage(1, asyncTaskResult).sendToTarget();
            }
        };
    }

    private void finish(Result Result2) {
        Status status;
        if (this.isCancelled()) {
            Result2 = null;
        }
        this.onPostExecute(Result2);
        this.mStatus = status = Status.FINISHED;
    }

    public final boolean cancel(boolean bl) {
        return this.mFuture.cancel(bl);
    }

    protected abstract Result doInBackground(Params ... var1);

    /*
     * Unable to fully structure code
     */
    public final AsyncTask<Params, Progress, Result> execute(Params ... var1_1) {
        var2_2 = this.mStatus;
        var3_3 = Status.PENDING;
        if (var2_2 == var3_3) ** GOTO lbl-1000
        var4_4 = 4.$SwitchMap$android$os$AsyncTask$Status;
        var5_5 = this.mStatus.ordinal();
        switch (var4_4[var5_5]) {
            default: lbl-1000:
            // 2 sources

            {
                this.mStatus = var6_6 = Status.RUNNING;
                this.onPreExecute();
                this.mWorker.mParams = var1_1;
                var7_7 = AsyncTask.sExecutor;
                var8_8 = this.mFuture;
                var7_7.execute(var8_8);
                return this;
            }
            case 1: {
                throw new IllegalStateException("Cannot execute task: the task is already running.");
            }
            case 2: 
        }
        throw new IllegalStateException("Cannot execute task: the task has already been executed (a task can be executed only once)");
    }

    public final Result get() throws InterruptedException, ExecutionException {
        return this.mFuture.get();
    }

    public final Result get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.mFuture.get(l, timeUnit);
    }

    public final Status getStatus() {
        return this.mStatus;
    }

    public final boolean isCancelled() {
        return this.mFuture.isCancelled();
    }

    protected void onCancelled() {
    }

    protected void onPostExecute(Result Result2) {
    }

    protected void onPreExecute() {
    }

    protected void onProgressUpdate(Progress ... ProgressArray) {
    }

    protected final void publishProgress(Progress ... ProgressArray) {
        InternalHandler internalHandler = sHandler;
        AsyncTaskResult<Progress> asyncTaskResult = new AsyncTaskResult<Progress>(this, ProgressArray);
        internalHandler.obtainMessage(2, asyncTaskResult).sendToTarget();
    }

    private static class AsyncTaskResult<Data> {
        final Data[] mData;
        final AsyncTask mTask;

        AsyncTaskResult(AsyncTask asyncTask, Data ... DataArray) {
            this.mTask = asyncTask;
            this.mData = DataArray;
        }
    }

    private static abstract class WorkerRunnable<Params, Result>
    implements Callable<Result> {
        Params[] mParams;

        private WorkerRunnable() {
        }
    }

    private static class InternalHandler
    extends Handler {
        private InternalHandler() {
        }

        @Override
        public void handleMessage(Message message) {
            AsyncTaskResult asyncTaskResult = (AsyncTaskResult)message.obj;
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    AsyncTask asyncTask = asyncTaskResult.mTask;
                    Object Data2 = asyncTaskResult.mData[0];
                    asyncTask.finish(Data2);
                    return;
                }
                case 2: {
                    AsyncTask asyncTask = asyncTaskResult.mTask;
                    Data[] DataArray = asyncTaskResult.mData;
                    asyncTask.onProgressUpdate(DataArray);
                    return;
                }
                case 3: 
            }
            asyncTaskResult.mTask.onCancelled();
        }
    }

    public static final class Status
    extends Enum<Status> {
        private static final /* synthetic */ Status[] $VALUES;
        public static final /* enum */ Status FINISHED;
        public static final /* enum */ Status PENDING;
        public static final /* enum */ Status RUNNING;

        static {
            PENDING = new Status();
            RUNNING = new Status();
            FINISHED = new Status();
            Status status = PENDING;
            Status status2 = RUNNING;
            Status status3 = FINISHED;
            Status[] statusArray = new Status[]{status, status2, status3};
            $VALUES = statusArray;
        }

        public static Status valueOf(String string2) {
            return Enum.valueOf(Status.class, string2);
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }
    }
}

