/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.pm.ApplicationInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.Printer;
import android.util.SparseArray;
import android.util.TimeUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BatteryStats
implements Parcelable {
    private static final String APK_DATA = "apk";
    public static final int AUDIO_TURNED_ON = 7;
    private static final String BATTERY_DATA = "bt";
    private static final String BATTERY_LEVEL_DATA = "lv";
    private static final int BATTERY_STATS_CHECKIN_VERSION = 5;
    private static final long BYTES_PER_GB = 0x40000000L;
    private static final long BYTES_PER_KB = 1024L;
    private static final long BYTES_PER_MB = 0x100000L;
    public static final int DATA_CONNECTION_1xRTT = 7;
    public static final int DATA_CONNECTION_CDMA = 4;
    private static final String DATA_CONNECTION_COUNT_DATA = "dcc";
    public static final int DATA_CONNECTION_EDGE = 2;
    public static final int DATA_CONNECTION_EVDO_0 = 5;
    public static final int DATA_CONNECTION_EVDO_A = 6;
    public static final int DATA_CONNECTION_EVDO_B = 12;
    public static final int DATA_CONNECTION_GPRS = 1;
    public static final int DATA_CONNECTION_HSDPA = 8;
    public static final int DATA_CONNECTION_HSPA = 10;
    public static final int DATA_CONNECTION_HSUPA = 9;
    public static final int DATA_CONNECTION_IDEN = 11;
    static final String[] DATA_CONNECTION_NAMES;
    public static final int DATA_CONNECTION_NONE = 0;
    public static final int DATA_CONNECTION_OTHER = 13;
    private static final String DATA_CONNECTION_TIME_DATA = "dct";
    public static final int DATA_CONNECTION_UMTS = 3;
    public static final int FULL_WIFI_LOCK = 5;
    public static final BitDescription[] HISTORY_STATE_DESCRIPTIONS;
    private static final String KERNEL_WAKELOCK_DATA = "kwl";
    private static final boolean LOCAL_LOGV = false;
    private static final String MISC_DATA = "m";
    private static final String NETWORK_DATA = "nt";
    public static final int NUM_DATA_CONNECTION_TYPES = 14;
    public static final int NUM_SCREEN_BRIGHTNESS_BINS = 5;
    public static final int NUM_SIGNAL_STRENGTH_BINS = 5;
    private static final String PROCESS_DATA = "pr";
    public static final int SCAN_WIFI_LOCK = 6;
    public static final int SCREEN_BRIGHTNESS_BRIGHT = 4;
    public static final int SCREEN_BRIGHTNESS_DARK = 0;
    private static final String SCREEN_BRIGHTNESS_DATA = "br";
    public static final int SCREEN_BRIGHTNESS_DIM = 1;
    public static final int SCREEN_BRIGHTNESS_LIGHT = 3;
    public static final int SCREEN_BRIGHTNESS_MEDIUM = 2;
    static final String[] SCREEN_BRIGHTNESS_NAMES;
    public static final int SENSOR = 3;
    private static final String SENSOR_DATA = "sr";
    private static final String SIGNAL_SCANNING_TIME_DATA = "sst";
    private static final String SIGNAL_STRENGTH_COUNT_DATA = "sgc";
    public static final int SIGNAL_STRENGTH_GOOD = 3;
    public static final int SIGNAL_STRENGTH_GREAT = 4;
    public static final int SIGNAL_STRENGTH_MODERATE = 2;
    static final String[] SIGNAL_STRENGTH_NAMES;
    public static final int SIGNAL_STRENGTH_NONE_OR_UNKNOWN = 0;
    public static final int SIGNAL_STRENGTH_POOR = 1;
    private static final String SIGNAL_STRENGTH_TIME_DATA = "sgt";
    public static final int STATS_CURRENT = 2;
    public static final int STATS_LAST = 1;
    public static final int STATS_SINCE_CHARGED = 0;
    public static final int STATS_SINCE_UNPLUGGED = 3;
    private static final String[] STAT_NAMES;
    private static final String UID_DATA = "uid";
    private static final String USER_ACTIVITY_DATA = "ua";
    public static final int VIDEO_TURNED_ON = 8;
    private static final String WAKELOCK_DATA = "wl";
    public static final int WAKE_TYPE_FULL = 1;
    public static final int WAKE_TYPE_PARTIAL = 0;
    public static final int WAKE_TYPE_WINDOW = 2;
    private static final String WIFI_LOCK_DATA = "wfl";
    public static final int WIFI_MULTICAST_ENABLED = 7;
    public static final int WIFI_RUNNING = 4;
    private final StringBuilder mFormatBuilder;
    private final Formatter mFormatter;

    static {
        BitDescription bitDescription;
        BitDescription bitDescription2;
        BitDescription bitDescription3;
        BitDescription bitDescription4;
        BitDescription bitDescription5;
        BitDescription bitDescription6;
        BitDescription bitDescription7;
        BitDescription bitDescription8;
        BitDescription bitDescription9;
        BitDescription bitDescription10;
        BitDescription bitDescription11;
        BitDescription bitDescription12;
        BitDescription bitDescription13;
        BitDescription bitDescription14;
        BitDescription bitDescription15;
        BitDescription bitDescription16;
        BitDescription bitDescription17;
        BitDescription bitDescription18;
        BitDescription bitDescription19;
        String[] stringArray = new String[]{"t", "l", "c", "u"};
        STAT_NAMES = stringArray;
        String[] stringArray2 = new String[]{"dark", "dim", "medium", "light", "bright"};
        SCREEN_BRIGHTNESS_NAMES = stringArray2;
        String[] stringArray3 = new String[]{"none", "poor", "moderate", "good", "great"};
        SIGNAL_STRENGTH_NAMES = stringArray3;
        String[] stringArray4 = new String[]{"none", "gprs", "edge", "umts", "cdma", "evdo_0", "evdo_A", "1xrtt", "hsdpa", "hsupa", "hspa", "iden", "evdo_b", "other"};
        DATA_CONNECTION_NAMES = stringArray4;
        BitDescription[] bitDescriptionArray = new BitDescription[19];
        bitDescriptionArray[0] = bitDescription19 = new BitDescription(0x40000000, "plugged");
        bitDescriptionArray[1] = bitDescription18 = new BitDescription(0x20000000, "screen");
        bitDescriptionArray[2] = bitDescription17 = new BitDescription(0x10000000, "gps");
        bitDescriptionArray[3] = bitDescription16 = new BitDescription(0x8000000, "phone_in_call");
        bitDescriptionArray[4] = bitDescription15 = new BitDescription(0x4000000, "phone_scanning");
        bitDescriptionArray[5] = bitDescription14 = new BitDescription(0x2000000, "wifi");
        bitDescriptionArray[6] = bitDescription13 = new BitDescription(0x1000000, "wifi_running");
        bitDescriptionArray[7] = bitDescription12 = new BitDescription(0x800000, "wifi_full_lock");
        bitDescriptionArray[8] = bitDescription11 = new BitDescription(0x400000, "wifi_scan_lock");
        bitDescriptionArray[9] = bitDescription10 = new BitDescription(0x200000, "wifi_multicast");
        bitDescriptionArray[10] = bitDescription9 = new BitDescription(0x100000, "bluetooth");
        bitDescriptionArray[11] = bitDescription8 = new BitDescription(524288, "audio");
        bitDescriptionArray[12] = bitDescription7 = new BitDescription(262144, "video");
        bitDescriptionArray[13] = bitDescription6 = new BitDescription(131072, "wake_lock");
        bitDescriptionArray[14] = bitDescription5 = new BitDescription(65536, "sensor");
        String[] stringArray5 = SCREEN_BRIGHTNESS_NAMES;
        bitDescriptionArray[15] = bitDescription4 = new BitDescription(15, 0, "brightness", stringArray5);
        String[] stringArray6 = SIGNAL_STRENGTH_NAMES;
        bitDescriptionArray[16] = bitDescription3 = new BitDescription(240, 4, "signal_strength", stringArray6);
        String[] stringArray7 = new String[]{"in", "out", "emergency", "off"};
        bitDescriptionArray[17] = bitDescription2 = new BitDescription(3840, 8, "phone_state", stringArray7);
        String[] stringArray8 = DATA_CONNECTION_NAMES;
        bitDescriptionArray[18] = bitDescription = new BitDescription(61440, 12, "data_conn", stringArray8);
        HISTORY_STATE_DESCRIPTIONS = bitDescriptionArray;
    }

    public BatteryStats() {
        Formatter formatter;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = this.mFormatBuilder = (stringBuilder = new StringBuilder(32));
        this.mFormatter = formatter = new Formatter(stringBuilder2);
    }

    private static final void dumpLine(PrintWriter printWriter, int n, String string2, String string3, Object ... objectArray) {
        printWriter.print(5);
        printWriter.print(',');
        printWriter.print(n);
        printWriter.print(',');
        printWriter.print(string2);
        printWriter.print(',');
        printWriter.print(string3);
        for (Object object : objectArray) {
            printWriter.print(',');
            printWriter.print(object);
        }
        printWriter.print('\n');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String formatBytesLocked(long l) {
        this.mFormatBuilder.setLength(0);
        if (l < 1024L) {
            return l + "B";
        }
        if (l < 0x100000L) {
            Formatter formatter = this.mFormatter;
            Object[] objectArray = new Object[1];
            Double d = (double)l / 1024.0;
            objectArray[0] = d;
            Formatter formatter2 = formatter.format("%.2fKB", objectArray);
            return this.mFormatBuilder.toString();
        }
        if (l < 0x40000000L) {
            Formatter formatter = this.mFormatter;
            Object[] objectArray = new Object[1];
            Double d = (double)l / 1048576.0;
            objectArray[0] = d;
            Formatter formatter3 = formatter.format("%.2fMB", objectArray);
            return this.mFormatBuilder.toString();
        }
        Formatter formatter = this.mFormatter;
        Object[] objectArray = new Object[1];
        Double d = (double)l / 1.073741824E9;
        objectArray[0] = d;
        Formatter formatter4 = formatter.format("%.2fGB", objectArray);
        return this.mFormatBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String formatRatioLocked(long l, long l2) {
        if (l2 == 0L) {
            return "---%";
        }
        float f = l;
        float f2 = l2;
        float f3 = f / f2 * 100.0f;
        this.mFormatBuilder.setLength(0);
        Formatter formatter = this.mFormatter;
        Object[] objectArray = new Object[1];
        Float f4 = Float.valueOf(f3);
        objectArray[0] = f4;
        Formatter formatter2 = formatter.format("%.1f%%", objectArray);
        return this.mFormatBuilder.toString();
    }

    private static final void formatTime(StringBuilder stringBuilder, long l) {
        long l2 = l / 100L;
        BatteryStats.formatTimeRaw(stringBuilder, l2);
        long l3 = 100L * l2;
        long l4 = (l - l3) * 10L;
        StringBuilder stringBuilder2 = stringBuilder.append(l4);
        StringBuilder stringBuilder3 = stringBuilder.append("ms ");
    }

    private static final void formatTimeMs(StringBuilder stringBuilder, long l) {
        long l2 = l / 1000L;
        BatteryStats.formatTimeRaw(stringBuilder, l2);
        long l3 = 1000L * l2;
        long l4 = l - l3;
        StringBuilder stringBuilder2 = stringBuilder.append(l4);
        StringBuilder stringBuilder3 = stringBuilder.append("ms ");
    }

    private static final void formatTimeRaw(StringBuilder stringBuilder, long l) {
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8 = l / 86400L;
        if (l8 != 0L) {
            StringBuilder stringBuilder2 = stringBuilder.append(l8);
            StringBuilder stringBuilder3 = stringBuilder.append("d ");
        }
        if ((l7 = (l - (l6 = 24L * (l5 = l8 * 60L * 60L))) / 3600L) != 0L || l6 != 0L) {
            StringBuilder stringBuilder4 = stringBuilder.append(l7);
            StringBuilder stringBuilder5 = stringBuilder.append("h ");
        }
        if ((l4 = (l - (l3 = l6 + (l2 = l7 * 60L * 60L))) / 60L) != 0L || l3 != 0L) {
            StringBuilder stringBuilder6 = stringBuilder.append(l4);
            StringBuilder stringBuilder7 = stringBuilder.append("m ");
        }
        long l9 = l4 * 60L + l3;
        if (l == 0L && l9 == 0L) {
            return;
        }
        long l10 = l - l9;
        StringBuilder stringBuilder8 = stringBuilder.append(l10);
        StringBuilder stringBuilder9 = stringBuilder.append("s ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String printWakeLock(StringBuilder stringBuilder, Timer timer, long l, String string2, int n, String string3) {
        if (timer == null) return string3;
        long l2 = timer.getTotalTimeLocked(l, n);
        long l3 = (500L + l2) / 1000L;
        int n2 = timer.getCountLocked(n);
        if (l3 == 0L) return string3;
        StringBuilder stringBuilder2 = stringBuilder.append(string3);
        BatteryStats.formatTimeMs(stringBuilder, l3);
        if (string2 != null) {
            StringBuilder stringBuilder3 = stringBuilder.append(string2);
        }
        StringBuilder stringBuilder4 = stringBuilder.append(' ');
        StringBuilder stringBuilder5 = stringBuilder.append('(');
        StringBuilder stringBuilder6 = stringBuilder.append(n2);
        StringBuilder stringBuilder7 = stringBuilder.append(" times)");
        return ", ";
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String printWakeLockCheckin(StringBuilder stringBuilder, Timer timer, long l, String string2, int n, String string3) {
        long l2 = 0L;
        int n2 = 0;
        if (timer != null) {
            l2 = timer.getTotalTimeLocked(l, n);
            n2 = timer.getCountLocked(n);
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string3);
        long l3 = (500L + l2) / 1000L;
        StringBuilder stringBuilder3 = stringBuilder.append(l3);
        StringBuilder stringBuilder4 = stringBuilder.append(',');
        String string4 = string2 != null ? string2 + "," : "";
        StringBuilder stringBuilder5 = stringBuilder.append(string4);
        StringBuilder stringBuilder6 = stringBuilder.append(n2);
        return ",";
    }

    public abstract long computeBatteryRealtime(long var1, int var3);

    public abstract long computeBatteryUptime(long var1, int var3);

    public abstract long computeRealtime(long var1, int var3);

    public abstract long computeUptime(long var1, int var3);

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public final void dumpCheckinLocked(PrintWriter var1_1, int var2_2, int var3_3) {
        block30: {
            var4_4 = SystemClock.uptimeMillis() * 1000L;
            var6_5 = SystemClock.elapsedRealtime() * 1000L;
            var8_6 = this;
            var9_7 = var4_4;
            var11_8 = var8_6.getBatteryUptime(var9_7);
            var13_9 = this;
            var14_10 = var6_5;
            var16_11 = var13_9.getBatteryRealtime(var14_10);
            var18_12 = this;
            var19_13 = var4_4;
            var21_14 = var2_2;
            var22_15 = var18_12.computeBatteryUptime(var19_13, var21_14);
            var24_16 = this;
            var25_17 = var6_5;
            var27_18 = var2_2;
            var28_19 = var24_16.computeBatteryRealtime(var25_17, var27_18);
            var30_20 = this;
            var31_21 = var6_5;
            var33_22 = var2_2;
            var34_23 = var30_20.computeRealtime(var31_21, var33_22);
            var36_24 = this;
            var37_25 = var4_4;
            var39_26 = var2_2;
            var40_27 = var36_24.computeUptime(var37_25, var39_26);
            var42_28 = this;
            var43_29 = var16_11;
            var45_30 = var2_2;
            var46_31 = var42_28.getScreenOnTime(var43_29, var45_30);
            var48_32 = this;
            var49_33 = var16_11;
            var51_34 = var2_2;
            var52_35 = var48_32.getPhoneOnTime(var49_33, var51_34);
            var54_36 = this;
            var55_37 = var16_11;
            var57_38 = var2_2;
            var58_39 = var54_36.getWifiOnTime(var55_37, var57_38);
            var60_40 = this;
            var61_41 = var16_11;
            var63_42 = var2_2;
            var64_43 = var60_40.getGlobalWifiRunningTime(var61_41, var63_42);
            var66_44 = this;
            var67_45 = var16_11;
            var69_46 = var2_2;
            var70_47 = var66_44.getBluetoothOnTime(var67_45, var69_46);
            var72_48 = new StringBuilder(128);
            var73_49 = this.getUidStats();
            var74_50 = var73_49.size();
            var75_51 = BatteryStats.STAT_NAMES[var2_2];
            var76_52 = new Object[5];
            if (var2_2 == 0) {
                var77_53 = this.getStartCount();
lbl52:
                // 2 sources

                while (true) {
                    var76_52[0] = var77_53;
                    var78_54 = var28_19 / 1000L;
                    var76_52[1] = var78_54;
                    var79_55 = var22_15 / 1000L;
                    var76_52[2] = var79_55;
                    var80_56 = var34_23 / 1000L;
                    var76_52[3] = var80_56;
                    var81_57 = var40_27 / 1000L;
                    var76_52[4] = var81_57;
                    var82_58 = var1_1;
                    var83_59 = 0;
                    var84_60 = var75_51;
                    var85_61 = "bt";
                    var86_62 = var76_52;
                    BatteryStats.dumpLine(var82_58, var83_59, var84_60, var85_61, var86_62);
                    var87_63 = 0L;
                    var89_64 = 0L;
                    var91_65 = 0L;
                    var93_66 = 0L;
                    var95_67 = 0;
                    while ((var96_69 = ++var95_67) < (var97_70 = var74_50)) {
                        var98_71 = var73_49;
                        var99_72 = var95_67;
                        var101_74 = var100_73 = var98_71.valueAt(var99_72);
                        var102_75 = var2_2;
                        var103_76 = var101_74.getTcpBytesReceived(var102_75);
                        var87_63 += var103_76;
                        var105_77 = var100_73;
                        var106_78 = var2_2;
                        var107_79 = var105_77.getTcpBytesSent(var106_78);
                        var89_64 += var107_79;
                        var109_80 = var100_73.getWakelockStats();
                        if (var109_80.size() <= 0) continue;
                        var110_81 = var109_80.entrySet().iterator();
                        while (var110_81.hasNext()) {
                            var111_82 = var110_81.next().getValue();
                            var112_83 = var111_82;
                            var114_85 = var112_83.getWakeTime(var113_84 = 1);
                            if (var114_85 != null) {
                                var115_86 = var114_85;
                                var116_87 = var16_11;
                                var118_88 = var2_2;
                                var119_89 = var115_86.getTotalTimeLocked(var116_87, var118_88);
                                var91_65 += var119_89;
                            }
                            if ((var123_92 = (var121_90 = var111_82).getWakeTime(var122_91 = 0)) == null) continue;
                            var124_93 = var123_92;
                            var125_94 = var16_11;
                            var127_95 = var2_2;
                            var128_68 = var124_93.getTotalTimeLocked(var125_94, var127_95);
                            var93_66 += var128_68;
                        }
                    }
                    break block30;
                    break;
                }
            }
            var77_53 = "N/A";
            ** while (true)
        }
        var130_96 = new Object[10];
        var131_97 = var46_31 / 1000L;
        var130_96[0] = var131_97;
        var132_98 = var52_35 / 1000L;
        var130_96[1] = var132_98;
        var133_99 = var58_39 / 1000L;
        var130_96[2] = var133_99;
        var134_100 = var64_43 / 1000L;
        var130_96[3] = var134_100;
        var135_101 = var70_47 / 1000L;
        var130_96[4] = var135_101;
        var136_102 = var87_63;
        var130_96[5] = var136_102;
        var137_103 = var89_64;
        var130_96[6] = var137_103;
        var138_104 = var91_65;
        var130_96[7] = var138_104;
        var139_105 = var93_66;
        var130_96[8] = var139_105;
        var140_106 = this;
        var141_107 = var2_2;
        var142_108 = var140_106.getInputEventCount(var141_107);
        var130_96[9] = var142_108;
        var143_109 = var1_1;
        var144_110 = 0;
        var145_111 = var75_51;
        var146_112 = "m";
        var147_113 = var130_96;
        BatteryStats.dumpLine(var143_109, var144_110, var145_111, var146_112, var147_113);
        var148_114 = new Object[5];
        var149_115 = 0;
        while ((var150_116 = ++var149_115) < (var151_117 = 5)) {
            var152_118 = this;
            var153_119 = var149_115;
            var154_120 = var16_11;
            var156_121 = var2_2;
            var157_122 = var152_118.getScreenBrightnessTime(var153_119, var154_120, var156_121) / 1000L;
            var148_114[var149_115] = var157_122;
        }
        var158_123 = var1_1;
        var159_124 = 0;
        var160_125 = var75_51;
        var161_126 = "br";
        var162_127 = var148_114;
        BatteryStats.dumpLine(var158_123, var159_124, var160_125, var161_126, var162_127);
        var163_128 = new Object[5];
        var164_129 = 0;
        while ((var165_130 = ++var164_129) < (var166_131 = 5)) {
            var167_132 = this;
            var168_133 = var164_129;
            var169_134 = var16_11;
            var171_135 = var2_2;
            var172_136 = var167_132.getPhoneSignalStrengthTime(var168_133, var169_134, var171_135) / 1000L;
            var163_128[var164_129] = var172_136;
        }
        var173_137 = var1_1;
        var174_138 = 0;
        var175_139 = var75_51;
        var176_140 = "sgt";
        var177_141 = var163_128;
        BatteryStats.dumpLine(var173_137, var174_138, var175_139, var176_140, var177_141);
        var178_142 = new Object[1];
        var179_143 = this;
        var180_144 = var16_11;
        var182_145 = var2_2;
        var183_146 = var179_143.getPhoneSignalScanningTime(var180_144, var182_145) / 1000L;
        var178_142[0] = var183_146;
        var184_147 = var1_1;
        var185_148 = 0;
        var186_149 = var75_51;
        var187_150 = "sst";
        var188_151 = var178_142;
        BatteryStats.dumpLine(var184_147, var185_148, var186_149, var187_150, var188_151);
        var189_152 = 0;
        while ((var190_153 = ++var189_152) < (var191_154 = 5)) {
            var192_155 = this;
            var193_156 = var189_152;
            var194_157 = var2_2;
            var195_158 = var192_155.getPhoneSignalStrengthCount(var193_156, var194_157);
            var163_128[var189_152] = var195_158;
        }
        var196_159 = var1_1;
        var197_160 = 0;
        var198_161 = var75_51;
        var199_162 = "sgc";
        var200_163 = var163_128;
        BatteryStats.dumpLine(var196_159, var197_160, var198_161, var199_162, var200_163);
        var201_164 = new Object[14];
        var202_165 = 0;
        while ((var203_166 = ++var202_165) < (var204_167 = 14)) {
            var205_168 = this;
            var206_169 = var202_165;
            var207_170 = var16_11;
            var209_171 = var2_2;
            var210_172 = var205_168.getPhoneDataConnectionTime(var206_169, var207_170, var209_171) / 1000L;
            var201_164[var202_165] = var210_172;
        }
        var211_173 = var1_1;
        var212_174 = 0;
        var213_175 = var75_51;
        var214_176 = "dct";
        var215_177 = var201_164;
        BatteryStats.dumpLine(var211_173, var212_174, var213_175, var214_176, var215_177);
        var216_178 = 0;
        while ((var217_179 = ++var216_178) < (var218_180 = 14)) {
            var219_181 = this;
            var220_182 = var216_178;
            var221_183 = var2_2;
            var222_184 = var219_181.getPhoneDataConnectionCount(var220_182, var221_183);
            var201_164[var216_178] = var222_184;
        }
        var223_185 = var1_1;
        var224_186 = 0;
        var225_187 = var75_51;
        var226_188 = "dcc";
        var227_189 = var201_164;
        BatteryStats.dumpLine(var223_185, var224_186, var225_187, var226_188, var227_189);
        var228_190 = var2_2;
        var191_154 = 3;
        if (var228_190 == var191_154) {
            var230_191 = new Object[2];
            var231_192 = this.getDischargeStartLevel();
            var230_191[0] = var231_192;
            var232_193 = this.getDischargeCurrentLevel();
            var230_191[1] = var232_193;
            var233_194 = var1_1;
            var234_195 = 0;
            var235_196 = var75_51;
            var236_197 = "lv";
            var237_198 = var230_191;
            BatteryStats.dumpLine(var233_194, var234_195, var235_196, var236_197, var237_198);
        }
        if (var3_3 < 0 && (var238_199 = this.getKernelWakelockStats()).size() > 0) {
            for (Map.Entry<String, ? extends Timer> var240_201 : var238_199.entrySet()) {
                var72_48.setLength(0);
                var241_202 = var240_201.getValue();
                var242_203 = var2_2;
                var243_204 = BatteryStats.printWakeLockCheckin(var72_48, var241_202, var16_11, null, var242_203, "");
                var244_205 = new Object[2];
                var245_206 = var240_201.getKey();
                var244_205[0] = var245_206;
                var246_207 = var72_48.toString();
                var244_205[1] = var246_207;
                var247_208 = var1_1;
                var248_209 = 0;
                var249_210 = var75_51;
                var250_211 = "kwl";
                var251_212 = var244_205;
                BatteryStats.dumpLine(var247_208, var248_209, var249_210, var250_211, var251_212);
            }
        }
        var252_213 = 0;
        block9: while (true) {
            if ((var253_214 = ++var252_213) >= (var254_215 = var74_50)) {
                return;
            }
            var255_216 = var73_49;
            var256_217 = var252_213;
            var257_218 = var255_216.keyAt(var256_217);
            if (var3_3 < 0 || (var258_219 = var257_218) == (var259_220 = var3_3)) break;
lbl266:
            // 3 sources

            continue block9;
            break;
        }
        var260_221 = var73_49;
        var261_223 = var252_213;
        var263_225 = var262_224 = var260_221.valueAt(var261_223);
        var264_226 = var2_2;
        var265_227 = var263_225.getTcpBytesReceived(var264_226);
        var267_228 = var262_224;
        var268_229 = var2_2;
        var269_230 = var267_228.getTcpBytesSent(var268_229);
        var271_231 = var262_224;
        var272_232 = var16_11;
        var274_233 = var2_2;
        var275_234 = var271_231.getFullWifiLockTime(var272_232, var274_233);
        var277_235 = var262_224;
        var278_236 = var16_11;
        var280_237 = var2_2;
        var281_238 = var277_235.getScanWifiLockTime(var278_236, var280_237);
        var283_239 = var262_224;
        var284_240 = var16_11;
        var286_241 = var2_2;
        var287_242 = var283_239.getWifiRunningTime(var284_240, var286_241);
        if (var265_227 > 0L || var269_230 > 0L) {
            var289_243 = new Object[2];
            var290_244 = var265_227;
            var289_243[0] = var290_244;
            var291_245 = var269_230;
            var289_243[1] = var291_245;
            var292_246 = var1_1;
            var293_247 = var257_218;
            var294_248 = var75_51;
            var295_249 = "nt";
            var296_250 = var289_243;
            BatteryStats.dumpLine(var292_246, var293_247, var294_248, var295_249, var296_250);
        }
        if (var275_234 != 0L || var281_238 != 0L || var287_242 != 0L) {
            var297_251 = new Object[3];
            var298_252 = var275_234;
            var297_251[0] = var298_252;
            var299_253 = var281_238;
            var297_251[1] = var299_253;
            var300_254 = var287_242;
            var297_251[2] = var300_254;
            var301_255 = var1_1;
            var302_256 = var257_218;
            var303_257 = var75_51;
            var304_258 = "wfl";
            var305_259 = var297_251;
            BatteryStats.dumpLine(var301_255, var302_256, var303_257, var304_258, var305_259);
        }
        if (var262_224.hasUserActivity()) {
            var201_164 = new Object[7];
            var260_222 = false;
            var216_178 = 0;
            while ((var307_260 = var216_178) < (var308_261 = 7)) {
                var309_262 = var262_224;
                var310_263 = var216_178;
                var311_264 = var2_2;
                var312_265 = var309_262.getUserActivityCount(var310_263, var311_264);
                var313_266 = var312_265;
                var201_164[var216_178] = var313_266;
                if (var312_265 != 0) {
                    var260_222 = true;
                }
                var314_267 = var216_178 + 1;
            }
            if (var260_222) {
                var315_268 = var1_1;
                var316_269 = 0;
                var317_270 = var75_51;
                var318_271 = "ua";
                var319_272 = var201_164;
                BatteryStats.dumpLine(var315_268, var316_269, var317_270, var318_271, var319_272);
            }
        }
        if ((var320_273 = var262_224.getWakelockStats()).size() > 0) {
            for (Map.Entry<String, Object> var321_274 : var320_273.entrySet()) {
                var322_275 = (Uid.Wakelock)var321_274.getValue();
                var72_48.setLength(0);
                var323_276 = var322_275;
                var324_277 = 1;
                var325_278 = var323_276.getWakeTime(var324_277);
                var326_279 = var2_2;
                var327_280 = BatteryStats.printWakeLockCheckin(var72_48, var325_278, var16_11, "f", var326_279, "");
                var328_281 = var322_275;
                var329_282 = 0;
                var330_283 = var328_281.getWakeTime(var329_282);
                var331_284 = var2_2;
                var332_285 = BatteryStats.printWakeLockCheckin(var72_48, var330_283, var16_11, "p", var331_284, var327_280);
                var333_286 = var322_275;
                var334_287 = 2;
                var335_288 = var333_286.getWakeTime(var334_287);
                var336_289 = var2_2;
                var337_290 = BatteryStats.printWakeLockCheckin(var72_48, var335_288, var16_11, "w", var336_289, var332_285);
                if (var72_48.length() <= 0) continue;
                var338_291 = new Object[2];
                var339_292 = var321_274.getKey();
                var338_291[0] = var339_292;
                var340_293 = var72_48.toString();
                var338_291[1] = var340_293;
                var341_294 = var1_1;
                var342_295 = var257_218;
                var343_296 = var75_51;
                var344_297 = "wl";
                var345_298 = var338_291;
                BatteryStats.dumpLine(var341_294, var342_295, var343_296, var344_297, var345_298);
            }
        }
        if ((var346_299 = var262_224.getSensorStats()).size() > 0) {
            for (Map.Entry<Object, Object> var347_300 : var346_299.entrySet()) {
                var348_301 = (Uid.Sensor)var347_300.getValue();
                var349_302 = (Integer)var347_300.getKey();
                var350_303 = var348_301.getSensorTime();
                if (var350_303 == null) continue;
                var351_304 = var350_303;
                var352_305 = var16_11;
                var354_306 = var2_2;
                var355_307 = (var351_304.getTotalTimeLocked(var352_305, var354_306) + 500L) / 1000L;
                var357_308 = var350_303;
                var358_309 = var2_2;
                var359_310 = var357_308.getCountLocked(var358_309);
                if (var355_307 == 0L) continue;
                var360_311 = new Object[3];
                var361_312 = var349_302;
                var360_311[0] = var361_312;
                var362_313 = var355_307;
                var360_311[1] = var362_313;
                var363_314 = var359_310;
                var360_311[2] = var363_314;
                var364_315 = var1_1;
                var365_316 = var257_218;
                var366_317 = var75_51;
                var367_318 = "sr";
                var368_319 = var360_311;
                BatteryStats.dumpLine(var364_315, var365_316, var366_317, var367_318, var368_319);
            }
        }
        if ((var369_320 = var262_224.getProcessStats()).size() > 0) {
            for (Map.Entry<Object, Object> var370_321 : var369_320.entrySet()) {
                var372_323 = var371_322 = (Uid.Proc)var370_321.getValue();
                var373_324 = var2_2;
                var374_325 = var372_323.getUserTime(var373_324);
                var376_326 = var371_322;
                var377_327 = var2_2;
                var378_328 = var376_326.getSystemTime(var377_327);
                var380_329 = var371_322;
                var381_330 = var2_2;
                var382_331 = var380_329.getStarts(var381_330);
                if (var374_325 == 0L && var378_328 == 0L && var382_331 == 0) continue;
                var383_332 = new Object[4];
                var383_332[0] = var384_333 = var370_321.getKey();
                var385_334 = 10L * var374_325;
                var383_332[1] = var385_334;
                var386_335 = 10L * var378_328;
                var383_332[2] = var386_335;
                var387_336 = var382_331;
                var383_332[3] = var387_336;
                var388_337 = var1_1;
                var389_338 = var257_218;
                var390_339 = var75_51;
                var391_340 = "pr";
                var392_341 = var383_332;
                BatteryStats.dumpLine(var388_337, var389_338, var390_339, var391_340, var392_341);
            }
        }
        if ((var393_342 = var262_224.getPackageStats()).size() <= 0) ** GOTO lbl266
        var239_200 = var393_342.entrySet().iterator();
        block15: while (true) {
            if (var239_200.hasNext()) ** break;
            ** continue;
            var394_343 = var239_200.next();
            var396_345 = var395_344 = (Uid.Pkg)var394_343.getValue();
            var397_346 = var2_2;
            var398_347 = var396_345.getWakeups(var397_346);
            var399_348 = var395_344.getServiceStats().entrySet().iterator();
            while (true) {
                if (!var399_348.hasNext()) continue block15;
                var400_349 = var399_348.next();
                var402_351 = var401_350 = var400_349.getValue();
                var403_352 = var11_8;
                var405_353 = var2_2;
                var406_354 = var402_351.getStartTime(var403_352, var405_353);
                var408_355 = var401_350;
                var409_356 = var2_2;
                var410_357 = var408_355.getStarts(var409_356);
                var411_358 = var401_350;
                var412_359 = var2_2;
                var413_360 = var411_358.getLaunches(var412_359);
                if (var406_354 == 0L && var410_357 == 0 && var413_360 == 0) continue;
                var414_361 = new Object[6];
                var415_362 = var398_347;
                var414_361[0] = var415_362;
                var414_361[1] = var416_363 = var394_343.getKey();
                var417_364 = var400_349.getKey();
                var414_361[2] = var417_364;
                var418_365 = var406_354 / 1000L;
                var414_361[3] = var418_365;
                var419_366 = var410_357;
                var414_361[4] = var419_366;
                var420_367 = var413_360;
                var414_361[5] = var420_367;
                var421_368 = var1_1;
                var422_369 = var257_218;
                var423_370 = var75_51;
                var424_371 = "apk";
                var425_372 = var414_361;
                BatteryStats.dumpLine(var421_368, var422_369, var423_370, var424_371, var425_372);
            }
            break;
        }
    }

    public void dumpCheckinLocked(PrintWriter printWriter, String[] stringArray, List<ApplicationInfo> list) {
        boolean bl = false;
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string2 = "-u";
            String string3 = stringArray2[i];
            String string4 = string3;
            if (!string2.equals(string4)) continue;
            bl = true;
        }
        if (list != null) {
            int n2;
            int n3;
            int n4;
            SparseArray sparseArray = new SparseArray();
            int n5 = 0;
            while ((n4 = ++n5) < (n3 = (n2 = list.size()))) {
                List<ApplicationInfo> list2 = list;
                int n6 = n5;
                ApplicationInfo applicationInfo = list2.get(n6);
                int n7 = applicationInfo.uid;
                ArrayList<String> arrayList = (ArrayList<String>)sparseArray.get(n7);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    int n8 = applicationInfo.uid;
                    SparseArray sparseArray2 = sparseArray;
                    int n9 = n8;
                    ArrayList<String> arrayList2 = arrayList;
                    sparseArray2.put(n9, arrayList2);
                }
                String string5 = applicationInfo.packageName;
                ArrayList<String> arrayList3 = arrayList;
                String string6 = string5;
                boolean bl2 = arrayList3.add(string6);
            }
            SparseArray<? extends Uid> sparseArray3 = this.getUidStats();
            int n10 = sparseArray3.size();
            String[] stringArray3 = new String[2];
            for (int i = 0; i < n10; ++i) {
                int n11;
                int n12;
                int n13;
                SparseArray sparseArray4 = sparseArray;
                SparseArray<? extends Uid> sparseArray5 = sparseArray3;
                int n14 = i;
                int n15 = sparseArray5.keyAt(n14);
                int n16 = n15;
                ArrayList arrayList = (ArrayList)sparseArray4.get(n16);
                if (arrayList == null) continue;
                int n17 = 0;
                while ((n13 = ++n17) < (n12 = (n11 = arrayList.size()))) {
                    String string7;
                    String string8;
                    stringArray3[0] = string8 = Integer.toString(n15);
                    stringArray3[1] = string7 = (String)arrayList.get(n17);
                    Object[] objectArray = stringArray3;
                    PrintWriter printWriter2 = printWriter;
                    int n18 = 0;
                    String string9 = "i";
                    String string10 = UID_DATA;
                    Object[] objectArray2 = objectArray;
                    BatteryStats.dumpLine(printWriter2, n18, string9, string10, objectArray2);
                }
            }
        }
        if (bl) {
            BatteryStats batteryStats = this;
            PrintWriter printWriter3 = printWriter;
            int n19 = 3;
            int n20 = 65535;
            batteryStats.dumpCheckinLocked(printWriter3, n19, n20);
            return;
        }
        BatteryStats batteryStats = this;
        PrintWriter printWriter4 = printWriter;
        int n21 = 0;
        int n22 = 65535;
        batteryStats.dumpCheckinLocked(printWriter4, n21, n22);
        BatteryStats batteryStats2 = this;
        PrintWriter printWriter5 = printWriter;
        int n23 = 3;
        int n24 = 65535;
        batteryStats2.dumpCheckinLocked(printWriter5, n23, n24);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dumpLocked(PrintWriter printWriter) {
        HistoryItem historyItem = new HistoryItem();
        if (this.startIteratingHistoryLocked()) {
            HistoryItem historyItem2;
            BatteryStats batteryStats;
            PrintWriter printWriter2 = printWriter;
            String string2 = "Battery History:";
            printWriter2.println(string2);
            long l = this.getHistoryBaseTime();
            long l2 = SystemClock.elapsedRealtime();
            long l3 = l + l2;
            int n = 0;
            byte by = 65535;
            byte by2 = -1;
            byte by3 = -1;
            char c = '\uffff';
            char c2 = '\uffff';
            while ((batteryStats = this).getNextHistoryLocked(historyItem2 = historyItem)) {
                PrintWriter printWriter3 = printWriter;
                String string3 = "  ";
                printWriter3.print(string3);
                long l4 = historyItem.time - l3;
                PrintWriter printWriter4 = printWriter;
                byte by4 = 19;
                TimeUtils.formatDuration(l4, printWriter4, by4);
                PrintWriter printWriter5 = printWriter;
                String string4 = " ";
                printWriter5.print(string4);
                byte by5 = historyItem.cmd;
                by4 = 1;
                if (by5 == by4) {
                    PrintWriter printWriter6 = printWriter;
                    String string5 = " START";
                    printWriter6.println(string5);
                } else {
                    byte by6 = historyItem.cmd;
                    byte by7 = 2;
                    if (by6 == by7) {
                        PrintWriter printWriter7 = printWriter;
                        String string6 = " *OVERFLOW*";
                        printWriter7.println(string6);
                    } else {
                        char c3;
                        char c4;
                        char c5;
                        char c6;
                        char c7;
                        char c8;
                        byte by8;
                        byte by9;
                        byte by10;
                        byte by11;
                        byte by12;
                        byte by13;
                        byte by14 = historyItem.batteryLevel;
                        byte by15 = 10;
                        if (by14 < by15) {
                            PrintWriter printWriter8 = printWriter;
                            String string7 = "00";
                            printWriter8.print(string7);
                        } else {
                            byte by16 = historyItem.batteryLevel;
                            byte by17 = 100;
                            if (by16 < by17) {
                                PrintWriter printWriter9 = printWriter;
                                String string8 = "0";
                                printWriter9.print(string8);
                            }
                        }
                        byte by18 = historyItem.batteryLevel;
                        PrintWriter printWriter10 = printWriter;
                        byte by19 = by18;
                        printWriter10.print(by19);
                        PrintWriter printWriter11 = printWriter;
                        String string9 = " ";
                        printWriter11.print(string9);
                        int n2 = historyItem.states;
                        int n3 = 16;
                        if (n2 < n3) {
                            PrintWriter printWriter12 = printWriter;
                            String string10 = "0000000";
                            printWriter12.print(string10);
                        } else {
                            int n4 = historyItem.states;
                            int n5 = 256;
                            if (n4 < n5) {
                                PrintWriter printWriter13 = printWriter;
                                String string11 = "000000";
                                printWriter13.print(string11);
                            } else {
                                int n6 = historyItem.states;
                                int n7 = 4096;
                                if (n6 < n7) {
                                    PrintWriter printWriter14 = printWriter;
                                    String string12 = "00000";
                                    printWriter14.print(string12);
                                } else {
                                    int n8 = historyItem.states;
                                    int n9 = 65536;
                                    if (n8 < n9) {
                                        PrintWriter printWriter15 = printWriter;
                                        String string13 = "0000";
                                        printWriter15.print(string13);
                                    } else {
                                        int n10 = historyItem.states;
                                        int n11 = 0x100000;
                                        if (n10 < n11) {
                                            PrintWriter printWriter16 = printWriter;
                                            String string14 = "000";
                                            printWriter16.print(string14);
                                        } else {
                                            int n12 = historyItem.states;
                                            int n13 = 0x1000000;
                                            if (n12 < n13) {
                                                PrintWriter printWriter17 = printWriter;
                                                String string15 = "00";
                                                printWriter17.print(string15);
                                            } else {
                                                int n14 = historyItem.states;
                                                int n15 = 0x10000000;
                                                if (n14 < n15) {
                                                    PrintWriter printWriter18 = printWriter;
                                                    String string16 = "0";
                                                    printWriter18.print(string16);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        String string17 = Integer.toHexString(historyItem.states);
                        PrintWriter printWriter19 = printWriter;
                        String string18 = string17;
                        printWriter19.print(string18);
                        byte by20 = historyItem.batteryStatus;
                        byte by21 = by;
                        byte by22 = by20;
                        if (by21 != by22) {
                            by = historyItem.batteryStatus;
                            PrintWriter printWriter20 = printWriter;
                            String string19 = " status=";
                            printWriter20.print(string19);
                            switch (by) {
                                default: {
                                    PrintWriter printWriter21 = printWriter;
                                    byte by23 = by;
                                    printWriter21.print(by23);
                                    break;
                                }
                                case 1: {
                                    PrintWriter printWriter22 = printWriter;
                                    String string20 = "unknown";
                                    printWriter22.print(string20);
                                    break;
                                }
                                case 2: {
                                    PrintWriter printWriter23 = printWriter;
                                    String string21 = "charging";
                                    printWriter23.print(string21);
                                    break;
                                }
                                case 3: {
                                    PrintWriter printWriter24 = printWriter;
                                    String string22 = "discharging";
                                    printWriter24.print(string22);
                                    break;
                                }
                                case 4: {
                                    PrintWriter printWriter25 = printWriter;
                                    String string23 = "not-charging";
                                    printWriter25.print(string23);
                                    break;
                                }
                                case 5: {
                                    PrintWriter printWriter26 = printWriter;
                                    String string24 = "full";
                                    printWriter26.print(string24);
                                }
                            }
                        }
                        if ((by13 = by2) != (by12 = (by11 = historyItem.batteryHealth))) {
                            by2 = historyItem.batteryHealth;
                            PrintWriter printWriter27 = printWriter;
                            String string25 = " health=";
                            printWriter27.print(string25);
                            switch (by2) {
                                default: {
                                    PrintWriter printWriter28 = printWriter;
                                    byte by24 = by2;
                                    printWriter28.print(by24);
                                    break;
                                }
                                case 1: {
                                    PrintWriter printWriter29 = printWriter;
                                    String string26 = "unknown";
                                    printWriter29.print(string26);
                                    break;
                                }
                                case 2: {
                                    PrintWriter printWriter30 = printWriter;
                                    String string27 = "good";
                                    printWriter30.print(string27);
                                    break;
                                }
                                case 3: {
                                    PrintWriter printWriter31 = printWriter;
                                    String string28 = "overheat";
                                    printWriter31.print(string28);
                                    break;
                                }
                                case 4: {
                                    PrintWriter printWriter32 = printWriter;
                                    String string29 = "dead";
                                    printWriter32.print(string29);
                                    break;
                                }
                                case 5: {
                                    PrintWriter printWriter33 = printWriter;
                                    String string30 = "over-voltage";
                                    printWriter33.print(string30);
                                    break;
                                }
                                case 6: {
                                    PrintWriter printWriter34 = printWriter;
                                    String string31 = "failure";
                                    printWriter34.print(string31);
                                }
                            }
                        }
                        if ((by10 = by3) != (by9 = (by8 = historyItem.batteryPlugType))) {
                            by3 = historyItem.batteryPlugType;
                            PrintWriter printWriter35 = printWriter;
                            String string32 = " plug=";
                            printWriter35.print(string32);
                            switch (by3) {
                                default: {
                                    PrintWriter printWriter36 = printWriter;
                                    byte by25 = by3;
                                    printWriter36.print(by25);
                                    break;
                                }
                                case 0: {
                                    PrintWriter printWriter37 = printWriter;
                                    String string33 = "none";
                                    printWriter37.print(string33);
                                    break;
                                }
                                case 1: {
                                    PrintWriter printWriter38 = printWriter;
                                    String string34 = "ac";
                                    printWriter38.print(string34);
                                    break;
                                }
                                case 2: {
                                    PrintWriter printWriter39 = printWriter;
                                    String string35 = "usb";
                                    printWriter39.print(string35);
                                }
                            }
                        }
                        if ((c8 = c) != (c7 = (c6 = historyItem.batteryTemperature))) {
                            c = historyItem.batteryTemperature;
                            PrintWriter printWriter40 = printWriter;
                            String string36 = " temp=";
                            printWriter40.print(string36);
                            PrintWriter printWriter41 = printWriter;
                            char c9 = c;
                            printWriter41.print((int)c9);
                        }
                        if ((c5 = c2) != (c4 = (c3 = historyItem.batteryVoltage))) {
                            c2 = historyItem.batteryVoltage;
                            PrintWriter printWriter42 = printWriter;
                            String string37 = " volt=";
                            printWriter42.print(string37);
                            PrintWriter printWriter43 = printWriter;
                            char c10 = c2;
                            printWriter43.print((int)c10);
                        }
                        int n16 = historyItem.states;
                        BitDescription[] bitDescriptionArray = HISTORY_STATE_DESCRIPTIONS;
                        BatteryStats batteryStats2 = this;
                        PrintWriter printWriter44 = printWriter;
                        int n17 = n;
                        int n18 = n16;
                        BitDescription[] bitDescriptionArray2 = bitDescriptionArray;
                        batteryStats2.printBitDescriptions(printWriter44, n17, n18, bitDescriptionArray2);
                        printWriter.println();
                    }
                }
                n = historyItem.states;
            }
            PrintWriter printWriter45 = printWriter;
            String string38 = "";
            printWriter45.println(string38);
        }
        SparseArray<? extends Uid> sparseArray = this.getUidStats();
        int n = sparseArray.size();
        boolean bl = false;
        long l = SystemClock.elapsedRealtime();
        int n19 = 64;
        StringBuilder stringBuilder = new StringBuilder(n19);
        int n20 = 0;
        while (true) {
            block54: {
                int n21;
                int n22;
                int n23;
                int n24;
                SparseArray<? extends Uid.Pid> sparseArray2;
                block55: {
                    block53: {
                        if (n20 >= n) break block53;
                        SparseArray<? extends Uid> sparseArray3 = sparseArray;
                        int n25 = n20;
                        sparseArray2 = sparseArray3.valueAt(n25).getPidStats();
                        if (sparseArray2 == null) break block54;
                        n24 = 0;
                        break block55;
                    }
                    if (bl) {
                        PrintWriter printWriter46 = printWriter;
                        String string39 = "";
                        printWriter46.println(string39);
                    }
                    PrintWriter printWriter47 = printWriter;
                    String string40 = "Statistics since last charge:";
                    printWriter47.println(string40);
                    StringBuilder stringBuilder2 = new StringBuilder().append("  System starts: ");
                    int n26 = this.getStartCount();
                    StringBuilder stringBuilder3 = stringBuilder2.append(n26).append(", currently on battery: ");
                    boolean bl2 = this.getIsOnBattery();
                    String string41 = stringBuilder3.append(bl2).toString();
                    PrintWriter printWriter48 = printWriter;
                    String string42 = string41;
                    printWriter48.println(string42);
                    BatteryStats batteryStats = this;
                    PrintWriter printWriter49 = printWriter;
                    String string43 = "";
                    int n27 = 0;
                    int n28 = 65535;
                    batteryStats.dumpLocked(printWriter49, string43, n27, n28);
                    PrintWriter printWriter50 = printWriter;
                    String string44 = "";
                    printWriter50.println(string44);
                    PrintWriter printWriter51 = printWriter;
                    String string45 = "Statistics since last unplugged:";
                    printWriter51.println(string45);
                    BatteryStats batteryStats3 = this;
                    PrintWriter printWriter52 = printWriter;
                    String string46 = "";
                    int n29 = 3;
                    int n30 = 65535;
                    batteryStats3.dumpLocked(printWriter52, string46, n29, n30);
                    return;
                }
                while ((n23 = n24) < (n22 = (n21 = sparseArray2.size()))) {
                    long l5;
                    SparseArray<? extends Uid.Pid> sparseArray4 = sparseArray2;
                    int n31 = n24;
                    Uid.Pid pid = sparseArray4.valueAt(n31);
                    if (!bl) {
                        PrintWriter printWriter53 = printWriter;
                        String string47 = "Per-PID Stats:";
                        printWriter53.println(string47);
                        bl = true;
                    }
                    long l6 = pid.mWakeSum;
                    if (pid.mWakeStart != 0L) {
                        long l7 = pid.mWakeStart;
                        l5 = l - l7;
                    } else {
                        l5 = 0L;
                    }
                    long l8 = l6 + l5;
                    PrintWriter printWriter54 = printWriter;
                    String string48 = "  PID ";
                    printWriter54.print(string48);
                    SparseArray<? extends Uid.Pid> sparseArray5 = sparseArray2;
                    int n32 = n24++;
                    int n33 = sparseArray5.keyAt(n32);
                    PrintWriter printWriter55 = printWriter;
                    int n34 = n33;
                    printWriter55.print(n34);
                    PrintWriter printWriter56 = printWriter;
                    String string49 = " wake time: ";
                    printWriter56.print(string49);
                    long l9 = l8;
                    PrintWriter printWriter57 = printWriter;
                    TimeUtils.formatDuration(l9, printWriter57);
                    PrintWriter printWriter58 = printWriter;
                    String string50 = "";
                    printWriter58.println(string50);
                }
            }
            ++n20;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void dumpLocked(PrintWriter printWriter, String string2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Map<String, ? extends Timer> map;
        int n9;
        int n10;
        long l = SystemClock.uptimeMillis() * 1000L;
        long l2 = SystemClock.elapsedRealtime() * 1000L;
        BatteryStats batteryStats = this;
        long l3 = l;
        long l4 = batteryStats.getBatteryUptime(l3);
        BatteryStats batteryStats2 = this;
        long l5 = l2;
        long l6 = batteryStats2.getBatteryRealtime(l5);
        BatteryStats batteryStats3 = this;
        long l7 = l;
        int n11 = n;
        long l8 = batteryStats3.computeBatteryUptime(l7, n11);
        BatteryStats batteryStats4 = this;
        long l9 = l2;
        int n12 = n;
        long l10 = batteryStats4.computeBatteryRealtime(l9, n12);
        BatteryStats batteryStats5 = this;
        long l11 = l2;
        int n13 = n;
        long l12 = batteryStats5.computeRealtime(l11, n13);
        BatteryStats batteryStats6 = this;
        long l13 = l;
        int n14 = n;
        long l14 = batteryStats6.computeUptime(l13, n14);
        StringBuilder stringBuilder = new StringBuilder(128);
        SparseArray<? extends Uid> sparseArray = this.getUidStats();
        int n15 = sparseArray.size();
        stringBuilder.setLength(0);
        StringBuilder stringBuilder2 = stringBuilder;
        String string3 = string2;
        StringBuilder stringBuilder3 = stringBuilder2.append(string3);
        StringBuilder stringBuilder4 = stringBuilder.append("  Time on battery: ");
        long l15 = l10 / 1000L;
        BatteryStats.formatTimeMs(stringBuilder, l15);
        StringBuilder stringBuilder5 = stringBuilder.append("(");
        BatteryStats batteryStats7 = this;
        long l16 = l10;
        long l17 = l12;
        String string4 = batteryStats7.formatRatioLocked(l16, l17);
        StringBuilder stringBuilder6 = stringBuilder.append(string4);
        StringBuilder stringBuilder7 = stringBuilder.append(") realtime, ");
        long l18 = l8 / 1000L;
        BatteryStats.formatTimeMs(stringBuilder, l18);
        StringBuilder stringBuilder8 = stringBuilder.append("(");
        BatteryStats batteryStats8 = this;
        long l19 = l8;
        long l20 = l12;
        String string5 = batteryStats8.formatRatioLocked(l19, l20);
        StringBuilder stringBuilder9 = stringBuilder.append(string5);
        StringBuilder stringBuilder10 = stringBuilder.append(") uptime");
        String string6 = stringBuilder.toString();
        PrintWriter printWriter2 = printWriter;
        String string7 = string6;
        printWriter2.println(string7);
        stringBuilder.setLength(0);
        StringBuilder stringBuilder11 = stringBuilder;
        String string8 = string2;
        StringBuilder stringBuilder12 = stringBuilder11.append(string8);
        StringBuilder stringBuilder13 = stringBuilder.append("  Total run time: ");
        long l21 = l12 / 1000L;
        BatteryStats.formatTimeMs(stringBuilder, l21);
        StringBuilder stringBuilder14 = stringBuilder.append("realtime, ");
        long l22 = l14 / 1000L;
        BatteryStats.formatTimeMs(stringBuilder, l22);
        StringBuilder stringBuilder15 = stringBuilder.append("uptime, ");
        String string9 = stringBuilder.toString();
        PrintWriter printWriter3 = printWriter;
        String string10 = string9;
        printWriter3.println(string10);
        BatteryStats batteryStats9 = this;
        long l23 = l6;
        int n16 = n;
        long l24 = batteryStats9.getScreenOnTime(l23, n16);
        BatteryStats batteryStats10 = this;
        long l25 = l6;
        int n17 = n;
        long l26 = batteryStats10.getPhoneOnTime(l25, n17);
        BatteryStats batteryStats11 = this;
        long l27 = l6;
        int n18 = n;
        long l28 = batteryStats11.getGlobalWifiRunningTime(l27, n18);
        BatteryStats batteryStats12 = this;
        long l29 = l6;
        int n19 = n;
        long l30 = batteryStats12.getWifiOnTime(l29, n19);
        BatteryStats batteryStats13 = this;
        long l31 = l6;
        int n20 = n;
        long l32 = batteryStats13.getBluetoothOnTime(l31, n20);
        stringBuilder.setLength(0);
        StringBuilder stringBuilder16 = stringBuilder;
        String string11 = string2;
        StringBuilder stringBuilder17 = stringBuilder16.append(string11);
        StringBuilder stringBuilder18 = stringBuilder.append("  Screen on: ");
        long l33 = l24 / 1000L;
        BatteryStats.formatTimeMs(stringBuilder, l33);
        StringBuilder stringBuilder19 = stringBuilder.append("(");
        BatteryStats batteryStats14 = this;
        long l34 = l24;
        long l35 = l10;
        String string12 = batteryStats14.formatRatioLocked(l34, l35);
        StringBuilder stringBuilder20 = stringBuilder.append(string12);
        StringBuilder stringBuilder21 = stringBuilder.append("), Input events: ");
        BatteryStats batteryStats15 = this;
        int n21 = n;
        int n22 = batteryStats15.getInputEventCount(n21);
        StringBuilder stringBuilder22 = stringBuilder.append(n22);
        StringBuilder stringBuilder23 = stringBuilder.append(", Active phone call: ");
        long l36 = l26 / 1000L;
        BatteryStats.formatTimeMs(stringBuilder, l36);
        StringBuilder stringBuilder24 = stringBuilder.append("(");
        BatteryStats batteryStats16 = this;
        long l37 = l26;
        long l38 = l10;
        String string13 = batteryStats16.formatRatioLocked(l37, l38);
        StringBuilder stringBuilder25 = stringBuilder.append(string13);
        StringBuilder stringBuilder26 = stringBuilder.append(")");
        String string14 = stringBuilder.toString();
        PrintWriter printWriter4 = printWriter;
        String string15 = string14;
        printWriter4.println(string15);
        stringBuilder.setLength(0);
        StringBuilder stringBuilder27 = stringBuilder;
        String string16 = string2;
        StringBuilder stringBuilder28 = stringBuilder27.append(string16);
        StringBuilder stringBuilder29 = stringBuilder.append("  Screen brightnesses: ");
        boolean bl = false;
        int n23 = 0;
        while ((n10 = ++n23) < (n9 = 5)) {
            BatteryStats batteryStats17 = this;
            int n24 = n23;
            long l39 = l6;
            int n25 = n;
            long l40 = batteryStats17.getScreenBrightnessTime(n24, l39, n25);
            if (l40 == 0L) continue;
            if (bl) {
                StringBuilder stringBuilder30 = stringBuilder.append(", ");
            }
            bl = true;
            String string17 = SCREEN_BRIGHTNESS_NAMES[n23];
            StringBuilder stringBuilder31 = stringBuilder.append(string17);
            StringBuilder stringBuilder32 = stringBuilder.append(" ");
            long l41 = l40 / 1000L;
            BatteryStats.formatTimeMs(stringBuilder, l41);
            StringBuilder stringBuilder33 = stringBuilder.append("(");
            BatteryStats batteryStats18 = this;
            long l42 = l40;
            long l43 = l24;
            String string18 = batteryStats18.formatRatioLocked(l42, l43);
            StringBuilder stringBuilder34 = stringBuilder.append(string18);
            StringBuilder stringBuilder35 = stringBuilder.append(")");
        }
        if (!bl) {
            StringBuilder stringBuilder36 = stringBuilder.append("No activity");
        }
        String string19 = stringBuilder.toString();
        PrintWriter printWriter5 = printWriter;
        String string20 = string19;
        printWriter5.println(string20);
        long l44 = 0L;
        long l45 = 0L;
        long l46 = 0L;
        long l47 = 0L;
        if (n2 < 0 && (map = this.getKernelWakelockStats()).size() > 0) {
            for (Map.Entry<String, ? extends Timer> entry : map.entrySet()) {
                int n26;
                stringBuilder.setLength(0);
                StringBuilder stringBuilder37 = stringBuilder;
                String string21 = string2;
                StringBuilder stringBuilder38 = stringBuilder37.append(string21);
                StringBuilder stringBuilder39 = stringBuilder.append("  Kernel Wake lock ");
                String string22 = entry.getKey();
                StringBuilder stringBuilder40 = stringBuilder.append(string22);
                Timer timer = entry.getValue();
                if (BatteryStats.printWakeLock(stringBuilder, timer, l6, null, n26 = n, ": ").equals(": ")) continue;
                StringBuilder stringBuilder41 = stringBuilder.append(" realtime");
                String string23 = stringBuilder.toString();
                PrintWriter printWriter6 = printWriter;
                String string24 = string23;
                printWriter6.println(string24);
            }
        }
        int n27 = 0;
        while ((n8 = ++n27) < (n7 = n15)) {
            Uid uid;
            SparseArray<? extends Uid> sparseArray2 = sparseArray;
            int n28 = n27;
            Uid uid2 = uid = sparseArray2.valueAt(n28);
            int n29 = n;
            long l48 = uid2.getTcpBytesReceived(n29);
            l44 += l48;
            Uid uid3 = uid;
            int n30 = n;
            long l49 = uid3.getTcpBytesSent(n30);
            l45 += l49;
            Map<String, ? extends Uid.Wakelock> map2 = uid.getWakelockStats();
            if (map2.size() <= 0) continue;
            Iterator<Map.Entry<Object, Object>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                int n31;
                Uid.Wakelock wakelock;
                Timer timer;
                int n32;
                Uid.Wakelock wakelock2 = (Uid.Wakelock)iterator.next().getValue();
                Uid.Wakelock wakelock3 = wakelock2;
                Timer timer2 = wakelock3.getWakeTime(n32 = 1);
                if (timer2 != null) {
                    Timer timer3 = timer2;
                    long l50 = l6;
                    int n33 = n;
                    long l51 = timer3.getTotalTimeLocked(l50, n33);
                    l46 += l51;
                }
                if ((timer = (wakelock = wakelock2).getWakeTime(n31 = 0)) == null) continue;
                Timer timer4 = timer;
                long l52 = l6;
                int n34 = n;
                long l53 = timer4.getTotalTimeLocked(l52, n34);
                l47 += l53;
            }
        }
        printWriter.print(string2);
        PrintWriter printWriter7 = printWriter;
        String string25 = "  Total received: ";
        printWriter7.print(string25);
        BatteryStats batteryStats19 = this;
        long l54 = l44;
        String string26 = batteryStats19.formatBytesLocked(l54);
        PrintWriter printWriter8 = printWriter;
        String string27 = string26;
        printWriter8.print(string27);
        PrintWriter printWriter9 = printWriter;
        String string28 = ", Total sent: ";
        printWriter9.print(string28);
        BatteryStats batteryStats20 = this;
        long l55 = l45;
        String string29 = batteryStats20.formatBytesLocked(l55);
        PrintWriter printWriter10 = printWriter;
        String string30 = string29;
        printWriter10.println(string30);
        stringBuilder.setLength(0);
        StringBuilder stringBuilder42 = stringBuilder;
        String string31 = string2;
        StringBuilder stringBuilder43 = stringBuilder42.append(string31);
        StringBuilder stringBuilder44 = stringBuilder.append("  Total full wakelock time: ");
        long l56 = (500L + l46) / 1000L;
        BatteryStats.formatTimeMs(stringBuilder, l56);
        StringBuilder stringBuilder45 = stringBuilder.append(", Total partial waklock time: ");
        long l57 = (500L + l47) / 1000L;
        BatteryStats.formatTimeMs(stringBuilder, l57);
        String string32 = stringBuilder.toString();
        PrintWriter printWriter11 = printWriter;
        String string33 = string32;
        printWriter11.println(string33);
        stringBuilder.setLength(0);
        StringBuilder stringBuilder46 = stringBuilder;
        String string34 = string2;
        StringBuilder stringBuilder47 = stringBuilder46.append(string34);
        StringBuilder stringBuilder48 = stringBuilder.append("  Signal levels: ");
        boolean bl2 = false;
        int n35 = 0;
        while ((n6 = ++n35) < (n5 = 5)) {
            BatteryStats batteryStats21 = this;
            int n36 = n35;
            long l58 = l6;
            int n37 = n;
            long l59 = batteryStats21.getPhoneSignalStrengthTime(n36, l58, n37);
            if (l59 == 0L) continue;
            if (bl2) {
                StringBuilder stringBuilder49 = stringBuilder.append(", ");
            }
            bl2 = true;
            String string35 = SIGNAL_STRENGTH_NAMES[n35];
            StringBuilder stringBuilder50 = stringBuilder.append(string35);
            StringBuilder stringBuilder51 = stringBuilder.append(" ");
            long l60 = l59 / 1000L;
            BatteryStats.formatTimeMs(stringBuilder, l60);
            StringBuilder stringBuilder52 = stringBuilder.append("(");
            BatteryStats batteryStats22 = this;
            long l61 = l59;
            long l62 = l10;
            String string36 = batteryStats22.formatRatioLocked(l61, l62);
            StringBuilder stringBuilder53 = stringBuilder.append(string36);
            StringBuilder stringBuilder54 = stringBuilder.append(") ");
            BatteryStats batteryStats23 = this;
            int n38 = n35;
            int n39 = n;
            int n40 = batteryStats23.getPhoneSignalStrengthCount(n38, n39);
            StringBuilder stringBuilder55 = stringBuilder.append(n40);
            StringBuilder stringBuilder56 = stringBuilder.append("x");
        }
        if (!bl2) {
            StringBuilder stringBuilder57 = stringBuilder.append("No activity");
        }
        String string37 = stringBuilder.toString();
        PrintWriter printWriter12 = printWriter;
        String string38 = string37;
        printWriter12.println(string38);
        stringBuilder.setLength(0);
        StringBuilder stringBuilder58 = stringBuilder;
        String string39 = string2;
        StringBuilder stringBuilder59 = stringBuilder58.append(string39);
        StringBuilder stringBuilder60 = stringBuilder.append("  Signal scanning time: ");
        BatteryStats batteryStats24 = this;
        long l63 = l6;
        int n41 = n;
        long l64 = batteryStats24.getPhoneSignalScanningTime(l63, n41) / 1000L;
        BatteryStats.formatTimeMs(stringBuilder, l64);
        String string40 = stringBuilder.toString();
        PrintWriter printWriter13 = printWriter;
        String string41 = string40;
        printWriter13.println(string41);
        stringBuilder.setLength(0);
        StringBuilder stringBuilder61 = stringBuilder;
        String string42 = string2;
        StringBuilder stringBuilder62 = stringBuilder61.append(string42);
        StringBuilder stringBuilder63 = stringBuilder.append("  Radio types: ");
        boolean bl3 = false;
        int n42 = 0;
        while ((n4 = ++n42) < (n3 = 14)) {
            BatteryStats batteryStats25 = this;
            int n43 = n42;
            long l65 = l6;
            int n44 = n;
            long l66 = batteryStats25.getPhoneDataConnectionTime(n43, l65, n44);
            if (l66 == 0L) continue;
            if (bl3) {
                StringBuilder stringBuilder64 = stringBuilder.append(", ");
            }
            bl3 = true;
            String string43 = DATA_CONNECTION_NAMES[n42];
            StringBuilder stringBuilder65 = stringBuilder.append(string43);
            StringBuilder stringBuilder66 = stringBuilder.append(" ");
            long l67 = l66 / 1000L;
            BatteryStats.formatTimeMs(stringBuilder, l67);
            StringBuilder stringBuilder67 = stringBuilder.append("(");
            BatteryStats batteryStats26 = this;
            long l68 = l66;
            long l69 = l10;
            String string44 = batteryStats26.formatRatioLocked(l68, l69);
            StringBuilder stringBuilder68 = stringBuilder.append(string44);
            StringBuilder stringBuilder69 = stringBuilder.append(") ");
            BatteryStats batteryStats27 = this;
            int n45 = n42;
            int n46 = n;
            int n47 = batteryStats27.getPhoneDataConnectionCount(n45, n46);
            StringBuilder stringBuilder70 = stringBuilder.append(n47);
            StringBuilder stringBuilder71 = stringBuilder.append("x");
        }
        if (!bl3) {
            StringBuilder stringBuilder72 = stringBuilder.append("No activity");
        }
        String string45 = stringBuilder.toString();
        PrintWriter printWriter14 = printWriter;
        String string46 = string45;
        printWriter14.println(string46);
        stringBuilder.setLength(0);
        StringBuilder stringBuilder73 = stringBuilder;
        String string47 = string2;
        StringBuilder stringBuilder74 = stringBuilder73.append(string47);
        StringBuilder stringBuilder75 = stringBuilder.append("  Radio data uptime when unplugged: ");
        long l70 = this.getRadioDataUptime() / 1000L;
        StringBuilder stringBuilder76 = stringBuilder.append(l70);
        StringBuilder stringBuilder77 = stringBuilder.append(" ms");
        String string48 = stringBuilder.toString();
        PrintWriter printWriter15 = printWriter;
        String string49 = string48;
        printWriter15.println(string49);
        stringBuilder.setLength(0);
        StringBuilder stringBuilder78 = stringBuilder;
        String string50 = string2;
        StringBuilder stringBuilder79 = stringBuilder78.append(string50);
        StringBuilder stringBuilder80 = stringBuilder.append("  Wifi on: ");
        long l71 = l30 / 1000L;
        BatteryStats.formatTimeMs(stringBuilder, l71);
        StringBuilder stringBuilder81 = stringBuilder.append("(");
        BatteryStats batteryStats28 = this;
        long l72 = l30;
        long l73 = l10;
        String string51 = batteryStats28.formatRatioLocked(l72, l73);
        StringBuilder stringBuilder82 = stringBuilder.append(string51);
        StringBuilder stringBuilder83 = stringBuilder.append("), Wifi running: ");
        long l74 = l28 / 1000L;
        BatteryStats.formatTimeMs(stringBuilder, l74);
        StringBuilder stringBuilder84 = stringBuilder.append("(");
        BatteryStats batteryStats29 = this;
        long l75 = l28;
        long l76 = l10;
        String string52 = batteryStats29.formatRatioLocked(l75, l76);
        StringBuilder stringBuilder85 = stringBuilder.append(string52);
        StringBuilder stringBuilder86 = stringBuilder.append("), Bluetooth on: ");
        long l77 = l32 / 1000L;
        BatteryStats.formatTimeMs(stringBuilder, l77);
        StringBuilder stringBuilder87 = stringBuilder.append("(");
        BatteryStats batteryStats30 = this;
        long l78 = l32;
        long l79 = l10;
        String string53 = batteryStats30.formatRatioLocked(l78, l79);
        StringBuilder stringBuilder88 = stringBuilder.append(string53);
        StringBuilder stringBuilder89 = stringBuilder.append(")");
        String string54 = stringBuilder.toString();
        PrintWriter printWriter16 = printWriter;
        String string55 = string54;
        printWriter16.println(string55);
        PrintWriter printWriter17 = printWriter;
        String string56 = " ";
        printWriter17.println(string56);
        int n48 = n;
        int n49 = 3;
        if (n48 == n49) {
            if (this.getIsOnBattery()) {
                printWriter.print(string2);
                PrintWriter printWriter18 = printWriter;
                String string57 = "  Device is currently unplugged";
                printWriter18.println(string57);
                printWriter.print(string2);
                PrintWriter printWriter19 = printWriter;
                String string58 = "    Discharge cycle start level: ";
                printWriter19.print(string58);
                int n50 = this.getDischargeStartLevel();
                PrintWriter printWriter20 = printWriter;
                int n51 = n50;
                printWriter20.println(n51);
                printWriter.print(string2);
                PrintWriter printWriter21 = printWriter;
                String string59 = "    Discharge cycle current level: ";
                printWriter21.print(string59);
                int n52 = this.getDischargeCurrentLevel();
                PrintWriter printWriter22 = printWriter;
                int n53 = n52;
                printWriter22.println(n53);
            } else {
                printWriter.print(string2);
                PrintWriter printWriter23 = printWriter;
                String string60 = "  Device is currently plugged into power";
                printWriter23.println(string60);
                printWriter.print(string2);
                PrintWriter printWriter24 = printWriter;
                String string61 = "    Last discharge cycle start level: ";
                printWriter24.print(string61);
                int n54 = this.getDischargeStartLevel();
                PrintWriter printWriter25 = printWriter;
                int n55 = n54;
                printWriter25.println(n55);
                printWriter.print(string2);
                PrintWriter printWriter26 = printWriter;
                String string62 = "    Last discharge cycle end level: ";
                printWriter26.print(string62);
                int n56 = this.getDischargeCurrentLevel();
                PrintWriter printWriter27 = printWriter;
                int n57 = n56;
                printWriter27.println(n57);
            }
            PrintWriter printWriter28 = printWriter;
            String string63 = " ";
            printWriter28.println(string63);
        } else {
            printWriter.print(string2);
            PrintWriter printWriter29 = printWriter;
            String string64 = "  Device battery use since last full charge";
            printWriter29.println(string64);
            printWriter.print(string2);
            PrintWriter printWriter30 = printWriter;
            String string65 = "    Amount discharged (lower bound): ";
            printWriter30.print(string65);
            int n58 = this.getLowDischargeAmountSinceCharge();
            PrintWriter printWriter31 = printWriter;
            int n59 = n58;
            printWriter31.println(n59);
            printWriter.print(string2);
            PrintWriter printWriter32 = printWriter;
            String string66 = "    Amount discharged (upper bound): ";
            printWriter32.print(string66);
            int n60 = this.getHighDischargeAmountSinceCharge();
            PrintWriter printWriter33 = printWriter;
            int n61 = n60;
            printWriter33.println(n61);
            PrintWriter printWriter34 = printWriter;
            String string67 = " ";
            printWriter34.println(string67);
        }
        int n62 = 0;
        int n63;
        int n64;
        while ((n64 = ++n62) < (n63 = n15)) {
            Map<String, ? extends Uid.Pkg> map3;
            Map<String, ? extends Uid.Proc> map4;
            Map<Integer, ? extends Uid.Sensor> map5;
            Map<String, ? extends Uid.Wakelock> map6;
            int n65;
            int n66;
            int n67;
            int n68;
            int n69;
            SparseArray<? extends Uid> sparseArray3 = sparseArray;
            int n70 = n62;
            int n71 = sparseArray3.keyAt(n70);
            if (n2 >= 0 && (n69 = n71) != (n68 = n2) && (n67 = n71) != (n66 = 1000)) continue;
            SparseArray<? extends Uid> sparseArray4 = sparseArray;
            int n72 = n62;
            Uid uid = sparseArray4.valueAt(n72);
            StringBuilder stringBuilder90 = new StringBuilder();
            String string68 = string2;
            StringBuilder stringBuilder91 = stringBuilder90.append(string68).append("  #");
            int n73 = n71;
            String string69 = stringBuilder91.append(n73).append(":").toString();
            PrintWriter printWriter35 = printWriter;
            String string70 = string69;
            printWriter35.println(string70);
            boolean bl4 = false;
            Uid uid4 = uid;
            int n74 = n;
            long l80 = uid4.getTcpBytesReceived(n74);
            Uid uid5 = uid;
            int n75 = n;
            long l81 = uid5.getTcpBytesSent(n75);
            Uid uid6 = uid;
            long l82 = l6;
            int n76 = n;
            long l83 = uid6.getFullWifiLockTime(l82, n76);
            Uid uid7 = uid;
            long l84 = l6;
            int n77 = n;
            long l85 = uid7.getScanWifiLockTime(l84, n77);
            Uid uid8 = uid;
            long l86 = l6;
            int n78 = n;
            long l87 = uid8.getWifiRunningTime(l86, n78);
            if (l80 != 0L || l81 != 0L) {
                printWriter.print(string2);
                PrintWriter printWriter36 = printWriter;
                String string71 = "    Network: ";
                printWriter36.print(string71);
                BatteryStats batteryStats31 = this;
                long l88 = l80;
                String string72 = batteryStats31.formatBytesLocked(l88);
                PrintWriter printWriter37 = printWriter;
                String string73 = string72;
                printWriter37.print(string73);
                PrintWriter printWriter38 = printWriter;
                String string74 = " received, ";
                printWriter38.print(string74);
                BatteryStats batteryStats32 = this;
                long l89 = l81;
                String string75 = batteryStats32.formatBytesLocked(l89);
                PrintWriter printWriter39 = printWriter;
                String string76 = string75;
                printWriter39.print(string76);
                PrintWriter printWriter40 = printWriter;
                String string77 = " sent";
                printWriter40.println(string77);
            }
            if (uid.hasUserActivity()) {
                int n79;
                int n80;
                n63 = 0;
                n42 = 0;
                while ((n80 = n42) < (n79 = 5)) {
                    Uid uid9 = uid;
                    int n81 = n42;
                    int n82 = n;
                    n65 = uid9.getUserActivityCount(n81, n82);
                    if (n65 != 0) {
                        if (n63 == 0) {
                            stringBuilder.setLength(0);
                            StringBuilder stringBuilder92 = stringBuilder.append("    User activity: ");
                            n63 = 1;
                        } else {
                            StringBuilder stringBuilder93 = stringBuilder.append(", ");
                        }
                        StringBuilder stringBuilder94 = stringBuilder;
                        int n83 = n65;
                        StringBuilder stringBuilder95 = stringBuilder94.append(n83);
                        StringBuilder stringBuilder96 = stringBuilder.append(" ");
                        String string78 = Uid.USER_ACTIVITY_TYPES[n42];
                        StringBuilder stringBuilder97 = stringBuilder.append(string78);
                    }
                    int n84 = n42 + 1;
                }
                if (n63 != 0) {
                    String string79 = stringBuilder.toString();
                    PrintWriter printWriter41 = printWriter;
                    String string80 = string79;
                    printWriter41.println(string80);
                }
            }
            if (l83 != 0L || l85 != 0L || l87 != 0L) {
                stringBuilder.setLength(0);
                StringBuilder stringBuilder98 = stringBuilder;
                String string81 = string2;
                StringBuilder stringBuilder99 = stringBuilder98.append(string81);
                StringBuilder stringBuilder100 = stringBuilder.append("    Wifi Running: ");
                long l90 = l87 / 1000L;
                BatteryStats.formatTimeMs(stringBuilder, l90);
                StringBuilder stringBuilder101 = stringBuilder.append("(");
                BatteryStats batteryStats33 = this;
                long l91 = l87;
                long l92 = l10;
                String string82 = batteryStats33.formatRatioLocked(l91, l92);
                StringBuilder stringBuilder102 = stringBuilder.append(string82);
                StringBuilder stringBuilder103 = stringBuilder.append(")\n");
                StringBuilder stringBuilder104 = stringBuilder;
                String string83 = string2;
                StringBuilder stringBuilder105 = stringBuilder104.append(string83);
                StringBuilder stringBuilder106 = stringBuilder.append("    Full Wifi Lock: ");
                long l93 = l83 / 1000L;
                BatteryStats.formatTimeMs(stringBuilder, l93);
                StringBuilder stringBuilder107 = stringBuilder.append("(");
                BatteryStats batteryStats34 = this;
                long l94 = l83;
                long l95 = l10;
                String string84 = batteryStats34.formatRatioLocked(l94, l95);
                StringBuilder stringBuilder108 = stringBuilder.append(string84);
                StringBuilder stringBuilder109 = stringBuilder.append(")\n");
                StringBuilder stringBuilder110 = stringBuilder;
                String string85 = string2;
                StringBuilder stringBuilder111 = stringBuilder110.append(string85);
                StringBuilder stringBuilder112 = stringBuilder.append("    Scan Wifi Lock: ");
                long l96 = l85 / 1000L;
                BatteryStats.formatTimeMs(stringBuilder, l96);
                StringBuilder stringBuilder113 = stringBuilder.append("(");
                BatteryStats batteryStats35 = this;
                long l97 = l85;
                long l98 = l10;
                String string86 = batteryStats35.formatRatioLocked(l97, l98);
                StringBuilder stringBuilder114 = stringBuilder.append(string86);
                StringBuilder stringBuilder115 = stringBuilder.append(")");
                String string87 = stringBuilder.toString();
                PrintWriter printWriter42 = printWriter;
                String string88 = string87;
                printWriter42.println(string88);
            }
            if ((map6 = uid.getWakelockStats()).size() > 0) {
                for (Map.Entry<String, Object> entry : map6.entrySet()) {
                    int n85;
                    Uid.Wakelock wakelock = (Uid.Wakelock)entry.getValue();
                    stringBuilder.setLength(0);
                    StringBuilder stringBuilder116 = stringBuilder;
                    String string89 = string2;
                    StringBuilder stringBuilder117 = stringBuilder116.append(string89);
                    StringBuilder stringBuilder118 = stringBuilder.append("    Wake lock ");
                    String string90 = entry.getKey();
                    StringBuilder stringBuilder119 = stringBuilder.append(string90);
                    Uid.Wakelock wakelock4 = wakelock;
                    int n86 = 1;
                    Timer timer = wakelock4.getWakeTime(n86);
                    int n87 = n;
                    String string91 = BatteryStats.printWakeLock(stringBuilder, timer, l6, "full", n87, ": ");
                    Uid.Wakelock wakelock5 = wakelock;
                    int n88 = 0;
                    Timer timer5 = wakelock5.getWakeTime(n88);
                    int n89 = n;
                    String string92 = BatteryStats.printWakeLock(stringBuilder, timer5, l6, "partial", n89, string91);
                    Uid.Wakelock wakelock6 = wakelock;
                    int n90 = 2;
                    Timer timer6 = wakelock6.getWakeTime(n90);
                    if (BatteryStats.printWakeLock(stringBuilder, timer6, l6, "window", n85 = n, string92).equals(": ")) continue;
                    StringBuilder stringBuilder120 = stringBuilder.append(" realtime");
                    String string93 = stringBuilder.toString();
                    PrintWriter printWriter43 = printWriter;
                    String string94 = string93;
                    printWriter43.println(string94);
                    bl4 = true;
                }
            }
            if ((map5 = uid.getSensorStats()).size() > 0) {
                for (Map.Entry<Object, Object> entry : map5.entrySet()) {
                    int n91;
                    Uid.Sensor sensor = (Uid.Sensor)entry.getValue();
                    int n92 = (Integer)entry.getKey();
                    stringBuilder.setLength(0);
                    StringBuilder stringBuilder121 = stringBuilder;
                    String string95 = string2;
                    StringBuilder stringBuilder122 = stringBuilder121.append(string95);
                    StringBuilder stringBuilder123 = stringBuilder.append("    Sensor ");
                    int n93 = n91 = sensor.getHandle();
                    n65 = 55536;
                    if (n93 == n65) {
                        StringBuilder stringBuilder124 = stringBuilder.append("GPS");
                    } else {
                        StringBuilder stringBuilder125 = stringBuilder;
                        int n94 = n91;
                        StringBuilder stringBuilder126 = stringBuilder125.append(n94);
                    }
                    StringBuilder stringBuilder127 = stringBuilder.append(": ");
                    Timer timer = sensor.getSensorTime();
                    if (timer != null) {
                        Timer timer7 = timer;
                        long l99 = l6;
                        int n95 = n;
                        long l100 = (timer7.getTotalTimeLocked(l99, n95) + 500L) / 1000L;
                        Timer timer8 = timer;
                        int n96 = n;
                        int n97 = timer8.getCountLocked(n96);
                        if (l100 != 0L) {
                            StringBuilder stringBuilder128 = stringBuilder;
                            long l101 = l100;
                            BatteryStats.formatTimeMs(stringBuilder128, l101);
                            StringBuilder stringBuilder129 = stringBuilder.append("realtime (");
                            StringBuilder stringBuilder130 = stringBuilder;
                            int n98 = n97;
                            StringBuilder stringBuilder131 = stringBuilder130.append(n98);
                            StringBuilder stringBuilder132 = stringBuilder.append(" times)");
                        } else {
                            StringBuilder stringBuilder133 = stringBuilder.append("(not used)");
                        }
                    } else {
                        StringBuilder stringBuilder134 = stringBuilder.append("(not used)");
                    }
                    String string96 = stringBuilder.toString();
                    PrintWriter printWriter44 = printWriter;
                    String string97 = string96;
                    printWriter44.println(string97);
                    bl4 = true;
                }
            }
            if ((map4 = uid.getProcessStats()).size() > 0) {
                for (Map.Entry<Object, Object> entry : map4.entrySet()) {
                    int n99;
                    int n100;
                    Uid.Proc proc;
                    Uid.Proc proc2 = proc = (Uid.Proc)entry.getValue();
                    int n101 = n;
                    long l102 = proc2.getUserTime(n101);
                    Uid.Proc proc3 = proc;
                    int n102 = n;
                    long l103 = proc3.getSystemTime(n102);
                    Uid.Proc proc4 = proc;
                    int n103 = n;
                    int n104 = proc4.getStarts(n103);
                    int n105 = n == 0 ? proc.countExcessivePowers() : 0;
                    if (l102 == 0L && l103 == 0L && n104 == 0 && n105 == 0) continue;
                    stringBuilder.setLength(0);
                    StringBuilder stringBuilder135 = stringBuilder;
                    String string98 = string2;
                    StringBuilder stringBuilder136 = stringBuilder135.append(string98);
                    StringBuilder stringBuilder137 = stringBuilder.append("    Proc ");
                    String string99 = (String)entry.getKey();
                    StringBuilder stringBuilder138 = stringBuilder.append(string99);
                    StringBuilder stringBuilder139 = stringBuilder.append(":\n");
                    StringBuilder stringBuilder140 = stringBuilder;
                    String string100 = string2;
                    StringBuilder stringBuilder141 = stringBuilder140.append(string100);
                    StringBuilder stringBuilder142 = stringBuilder.append("      CPU: ");
                    StringBuilder stringBuilder143 = stringBuilder;
                    long l104 = l102;
                    BatteryStats.formatTime(stringBuilder143, l104);
                    StringBuilder stringBuilder144 = stringBuilder.append("usr + ");
                    StringBuilder stringBuilder145 = stringBuilder;
                    long l105 = l103;
                    BatteryStats.formatTime(stringBuilder145, l105);
                    StringBuilder stringBuilder146 = stringBuilder.append("krn");
                    if (n104 != 0) {
                        StringBuilder stringBuilder147 = stringBuilder.append("\n");
                        StringBuilder stringBuilder148 = stringBuilder;
                        String string101 = string2;
                        StringBuilder stringBuilder149 = stringBuilder148.append(string101);
                        StringBuilder stringBuilder150 = stringBuilder.append("      ");
                        StringBuilder stringBuilder151 = stringBuilder;
                        int n106 = n104;
                        StringBuilder stringBuilder152 = stringBuilder151.append(n106);
                        StringBuilder stringBuilder153 = stringBuilder.append(" proc starts");
                    }
                    String string102 = stringBuilder.toString();
                    PrintWriter printWriter45 = printWriter;
                    String string103 = string102;
                    printWriter45.println(string103);
                    int n107 = 0;
                    while ((n100 = ++n107) < (n99 = n105)) {
                        Uid.Proc proc5 = proc;
                        int n108 = n107;
                        Uid.Proc.ExcessivePower excessivePower = proc5.getExcessivePower(n108);
                        if (excessivePower == null) continue;
                        printWriter.print(string2);
                        PrintWriter printWriter46 = printWriter;
                        String string104 = "      * Killed for ";
                        printWriter46.print(string104);
                        if (excessivePower.type == 1) {
                            PrintWriter printWriter47 = printWriter;
                            String string105 = "wake lock";
                            printWriter47.print(string105);
                        } else if (excessivePower.type == 2) {
                            PrintWriter printWriter48 = printWriter;
                            String string106 = "cpu";
                            printWriter48.print(string106);
                        } else {
                            PrintWriter printWriter49 = printWriter;
                            String string107 = "unknown";
                            printWriter49.print(string107);
                        }
                        PrintWriter printWriter50 = printWriter;
                        String string108 = " use: ";
                        printWriter50.print(string108);
                        long l106 = excessivePower.usedTime;
                        PrintWriter printWriter51 = printWriter;
                        TimeUtils.formatDuration(l106, printWriter51);
                        PrintWriter printWriter52 = printWriter;
                        String string109 = " over ";
                        printWriter52.print(string109);
                        long l107 = excessivePower.overTime;
                        PrintWriter printWriter53 = printWriter;
                        TimeUtils.formatDuration(l107, printWriter53);
                        PrintWriter printWriter54 = printWriter;
                        String string110 = " (";
                        printWriter54.print(string110);
                        long l108 = excessivePower.usedTime * 100L;
                        long l109 = excessivePower.overTime;
                        long l110 = l108 / l109;
                        PrintWriter printWriter55 = printWriter;
                        long l111 = l110;
                        printWriter55.print(l111);
                        PrintWriter printWriter56 = printWriter;
                        String string111 = "%)";
                        printWriter56.println(string111);
                    }
                    bl4 = true;
                }
            }
            if ((map3 = uid.getPackageStats()).size() > 0) {
                for (Map.Entry<Object, Object> entry : map3.entrySet()) {
                    Map<String, ? extends Uid.Pkg.Serv> map7;
                    Uid.Pkg pkg;
                    printWriter.print(string2);
                    PrintWriter printWriter57 = printWriter;
                    String string112 = "    Apk ";
                    printWriter57.print(string112);
                    String string113 = (String)entry.getKey();
                    PrintWriter printWriter58 = printWriter;
                    String string114 = string113;
                    printWriter58.print(string114);
                    PrintWriter printWriter59 = printWriter;
                    String string115 = ":";
                    printWriter59.println(string115);
                    boolean bl5 = false;
                    Uid.Pkg pkg2 = pkg = (Uid.Pkg)entry.getValue();
                    int n109 = n;
                    int n110 = pkg2.getWakeups(n109);
                    if (n110 != 0) {
                        printWriter.print(string2);
                        PrintWriter printWriter60 = printWriter;
                        String string116 = "      ";
                        printWriter60.print(string116);
                        PrintWriter printWriter61 = printWriter;
                        int n111 = n110;
                        printWriter61.print(n111);
                        PrintWriter printWriter62 = printWriter;
                        String string117 = " wakeup alarms";
                        printWriter62.println(string117);
                        bl5 = true;
                    }
                    if ((map7 = pkg.getServiceStats()).size() > 0) {
                        for (Map.Entry<String, ? extends Uid.Pkg.Serv> entry2 : map7.entrySet()) {
                            Uid.Pkg.Serv serv;
                            Uid.Pkg.Serv serv2 = serv = entry2.getValue();
                            long l112 = l4;
                            int n112 = n;
                            long l113 = serv2.getStartTime(l112, n112);
                            Uid.Pkg.Serv serv3 = serv;
                            int n113 = n;
                            int n114 = serv3.getStarts(n113);
                            Uid.Pkg.Serv serv4 = serv;
                            int n115 = n;
                            int n116 = serv4.getLaunches(n115);
                            if (l113 == 0L && n114 == 0 && n116 == 0) continue;
                            stringBuilder.setLength(0);
                            StringBuilder stringBuilder154 = stringBuilder;
                            String string118 = string2;
                            StringBuilder stringBuilder155 = stringBuilder154.append(string118);
                            StringBuilder stringBuilder156 = stringBuilder.append("      Service ");
                            String string119 = entry2.getKey();
                            StringBuilder stringBuilder157 = stringBuilder.append(string119);
                            StringBuilder stringBuilder158 = stringBuilder.append(":\n");
                            StringBuilder stringBuilder159 = stringBuilder;
                            String string120 = string2;
                            StringBuilder stringBuilder160 = stringBuilder159.append(string120);
                            StringBuilder stringBuilder161 = stringBuilder.append("        Created for: ");
                            long l114 = l113 / 1000L;
                            BatteryStats.formatTimeMs(stringBuilder, l114);
                            StringBuilder stringBuilder162 = stringBuilder.append(" uptime\n");
                            StringBuilder stringBuilder163 = stringBuilder;
                            String string121 = string2;
                            StringBuilder stringBuilder164 = stringBuilder163.append(string121);
                            StringBuilder stringBuilder165 = stringBuilder.append("        Starts: ");
                            StringBuilder stringBuilder166 = stringBuilder;
                            int n117 = n114;
                            StringBuilder stringBuilder167 = stringBuilder166.append(n117);
                            StringBuilder stringBuilder168 = stringBuilder.append(", launches: ");
                            StringBuilder stringBuilder169 = stringBuilder;
                            int n118 = n116;
                            StringBuilder stringBuilder170 = stringBuilder169.append(n118);
                            String string122 = stringBuilder.toString();
                            PrintWriter printWriter63 = printWriter;
                            String string123 = string122;
                            printWriter63.println(string123);
                            bl5 = true;
                        }
                    }
                    if (!bl5) {
                        printWriter.print(string2);
                        PrintWriter printWriter64 = printWriter;
                        String string124 = "      (nothing executed)";
                        printWriter64.println(string124);
                    }
                    bl4 = true;
                }
            }
            if (bl4) continue;
            printWriter.print(string2);
            PrintWriter printWriter65 = printWriter;
            String string125 = "    (nothing executed)";
            printWriter65.println(string125);
        }
        return;
    }

    public abstract long getBatteryRealtime(long var1);

    public abstract long getBatteryUptime(long var1);

    public abstract long getBluetoothOnTime(long var1, int var3);

    public abstract int getCpuSpeedSteps();

    public abstract int getDischargeCurrentLevel();

    public abstract int getDischargeStartLevel();

    public abstract long getGlobalWifiRunningTime(long var1, int var3);

    public abstract int getHighDischargeAmountSinceCharge();

    public abstract HistoryItem getHistory();

    public abstract long getHistoryBaseTime();

    public abstract int getInputEventCount(int var1);

    public abstract boolean getIsOnBattery();

    public abstract Map<String, ? extends Timer> getKernelWakelockStats();

    public abstract int getLowDischargeAmountSinceCharge();

    public abstract boolean getNextHistoryLocked(HistoryItem var1);

    public abstract int getPhoneDataConnectionCount(int var1, int var2);

    public abstract long getPhoneDataConnectionTime(int var1, long var2, int var4);

    public abstract long getPhoneOnTime(long var1, int var3);

    public abstract long getPhoneSignalScanningTime(long var1, int var3);

    public abstract int getPhoneSignalStrengthCount(int var1, int var2);

    public abstract long getPhoneSignalStrengthTime(int var1, long var2, int var4);

    public abstract long getRadioDataUptime();

    public long getRadioDataUptimeMs() {
        return this.getRadioDataUptime() / 1000L;
    }

    public abstract long getScreenBrightnessTime(int var1, long var2, int var4);

    public abstract long getScreenOnTime(long var1, int var3);

    public abstract int getStartCount();

    public abstract SparseArray<? extends Uid> getUidStats();

    public abstract long getWifiOnTime(long var1, int var3);

    /*
     * Enabled aggressive block sorting
     */
    void printBitDescriptions(PrintWriter printWriter, int n, int n2, BitDescription[] bitDescriptionArray) {
        int n3 = n ^ n2;
        if (n3 == 0) {
            return;
        }
        int n4 = 0;
        int n5;
        while (n4 < (n5 = bitDescriptionArray.length)) {
            BitDescription bitDescription = bitDescriptionArray[n4];
            if ((bitDescription.mask & n3) != 0) {
                if (bitDescription.shift < 0) {
                    String string2 = (bitDescription.mask & n2) != 0 ? " +" : " -";
                    printWriter.print(string2);
                    String string3 = bitDescription.name;
                    printWriter.print(string3);
                } else {
                    int n6;
                    printWriter.print(" ");
                    String string4 = bitDescription.name;
                    printWriter.print(string4);
                    printWriter.print("=");
                    int n7 = bitDescription.mask & n2;
                    int n8 = bitDescription.shift;
                    int n9 = n7 >> n8;
                    if (bitDescription.values != null && n9 >= 0 && n9 < (n6 = bitDescription.values.length)) {
                        String string5 = bitDescription.values[n9];
                        printWriter.print(string5);
                    } else {
                        printWriter.print(n9);
                    }
                }
            }
            ++n4;
        }
        return;
    }

    public abstract boolean startIteratingHistoryLocked();

    public static final class BitDescription {
        public final int mask;
        public final String name;
        public final int shift;
        public final String[] values;

        public BitDescription(int n, int n2, String string2, String[] stringArray) {
            this.mask = n;
            this.shift = n2;
            this.name = string2;
            this.values = stringArray;
        }

        public BitDescription(int n, String string2) {
            this.mask = n;
            this.shift = -1;
            this.name = string2;
            this.values = null;
        }
    }

    public static final class HistoryItem
    implements Parcelable {
        public static final byte CMD_OVERFLOW = 2;
        public static final byte CMD_START = 1;
        public static final byte CMD_UPDATE = 0;
        public static final int MOST_INTERESTING_STATES = 0x78000000;
        public static final int STATE_AUDIO_ON_FLAG = 524288;
        public static final int STATE_BATTERY_PLUGGED_FLAG = 0x40000000;
        public static final int STATE_BLUETOOTH_ON_FLAG = 0x100000;
        public static final int STATE_BRIGHTNESS_MASK = 15;
        public static final int STATE_BRIGHTNESS_SHIFT = 0;
        public static final int STATE_DATA_CONNECTION_MASK = 61440;
        public static final int STATE_DATA_CONNECTION_SHIFT = 12;
        public static final int STATE_GPS_ON_FLAG = 0x10000000;
        public static final int STATE_PHONE_IN_CALL_FLAG = 0x8000000;
        public static final int STATE_PHONE_SCANNING_FLAG = 0x4000000;
        public static final int STATE_PHONE_STATE_MASK = 3840;
        public static final int STATE_PHONE_STATE_SHIFT = 8;
        public static final int STATE_SCREEN_ON_FLAG = 0x20000000;
        public static final int STATE_SENSOR_ON_FLAG = 65536;
        public static final int STATE_SIGNAL_STRENGTH_MASK = 240;
        public static final int STATE_SIGNAL_STRENGTH_SHIFT = 4;
        public static final int STATE_VIDEO_ON_FLAG = 262144;
        public static final int STATE_WAKE_LOCK_FLAG = 131072;
        public static final int STATE_WIFI_FULL_LOCK_FLAG = 0x800000;
        public static final int STATE_WIFI_MULTICAST_ON_FLAG = 0x200000;
        public static final int STATE_WIFI_ON_FLAG = 0x2000000;
        public static final int STATE_WIFI_RUNNING_FLAG = 0x1000000;
        public static final int STATE_WIFI_SCAN_LOCK_FLAG = 0x400000;
        public byte batteryHealth;
        public byte batteryLevel;
        public byte batteryPlugType;
        public byte batteryStatus;
        public char batteryTemperature;
        public char batteryVoltage;
        public byte cmd;
        public HistoryItem next;
        public int states;
        public long time;

        public HistoryItem() {
        }

        public HistoryItem(long l, Parcel parcel) {
            int n;
            char c;
            char c2;
            byte by;
            byte by2;
            byte by3;
            byte by4;
            byte by5;
            this.time = l;
            int n2 = parcel.readInt();
            this.cmd = by5 = (byte)(n2 & 0xFF);
            this.batteryLevel = by4 = (byte)(n2 >> 8 & 0xFF);
            this.batteryStatus = by3 = (byte)(n2 >> 16 & 0xF);
            this.batteryHealth = by2 = (byte)(n2 >> 20 & 0xF);
            this.batteryPlugType = by = (byte)(n2 >> 24 & 0xF);
            int n3 = parcel.readInt();
            this.batteryTemperature = c2 = (char)(n3 & 0xFFFF);
            this.batteryVoltage = c = (char)(n3 >> 16 & 0xFFFF);
            this.states = n = parcel.readInt();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean same(HistoryItem historyItem) {
            byte by = this.batteryLevel;
            byte by2 = historyItem.batteryLevel;
            if (by == by2) return false;
            byte by3 = this.batteryStatus;
            byte by4 = historyItem.batteryStatus;
            if (by3 == by4) return false;
            byte by5 = this.batteryHealth;
            byte by6 = historyItem.batteryHealth;
            if (by5 == by6) return false;
            byte by7 = this.batteryPlugType;
            byte by8 = historyItem.batteryPlugType;
            if (by7 == by8) return false;
            char c = this.batteryTemperature;
            char c2 = historyItem.batteryTemperature;
            if (c == c2) return false;
            char c3 = this.batteryVoltage;
            char c4 = historyItem.batteryVoltage;
            if (c3 == c4) return false;
            int n = this.states;
            int n2 = historyItem.states;
            if (n == n2) return false;
            return true;
        }

        public void setTo(long l, byte by, HistoryItem historyItem) {
            int n;
            char c;
            char c2;
            byte by2;
            byte by3;
            byte by4;
            byte by5;
            this.time = l;
            this.cmd = by;
            this.batteryLevel = by5 = historyItem.batteryLevel;
            this.batteryStatus = by4 = historyItem.batteryStatus;
            this.batteryHealth = by3 = historyItem.batteryHealth;
            this.batteryPlugType = by2 = historyItem.batteryPlugType;
            this.batteryTemperature = c2 = historyItem.batteryTemperature;
            this.batteryVoltage = c = historyItem.batteryVoltage;
            this.states = n = historyItem.states;
        }

        public void setTo(HistoryItem historyItem) {
            int n;
            char c;
            char c2;
            byte by;
            byte by2;
            byte by3;
            byte by4;
            byte by5;
            long l;
            this.time = l = historyItem.time;
            this.cmd = by5 = historyItem.cmd;
            this.batteryLevel = by4 = historyItem.batteryLevel;
            this.batteryStatus = by3 = historyItem.batteryStatus;
            this.batteryHealth = by2 = historyItem.batteryHealth;
            this.batteryPlugType = by = historyItem.batteryPlugType;
            this.batteryTemperature = c2 = historyItem.batteryTemperature;
            this.batteryVoltage = c = historyItem.batteryVoltage;
            this.states = n = historyItem.states;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            long l = this.time;
            parcel.writeLong(l);
            int n2 = this.cmd & 0xFF;
            int n3 = this.batteryLevel << 8 & 0xFF00;
            int n4 = n2 | n3;
            int n5 = this.batteryStatus << 16 & 0xF0000;
            int n6 = n4 | n5;
            int n7 = this.batteryHealth << 20 & 0xF00000;
            int n8 = n6 | n7;
            int n9 = this.batteryPlugType << 24 & 0xF000000;
            int n10 = n8 | n9;
            parcel.writeInt(n10);
            int n11 = this.batteryTemperature & 0xFFFF;
            int n12 = this.batteryVoltage << 16 & 0xFFFF0000;
            int n13 = n11 | n12;
            parcel.writeInt(n13);
            int n14 = this.states;
            parcel.writeInt(n14);
        }
    }

    public static abstract class Uid {
        public static final int NUM_USER_ACTIVITY_TYPES = 7;
        static final String[] USER_ACTIVITY_TYPES;

        static {
            String[] stringArray = new String[]{"other", "cheek", "touch", "long_touch", "touch_up", "button", "unknown"};
            USER_ACTIVITY_TYPES = stringArray;
        }

        public abstract long getAudioTurnedOnTime(long var1, int var3);

        public abstract long getFullWifiLockTime(long var1, int var3);

        public abstract Map<String, ? extends Pkg> getPackageStats();

        public abstract SparseArray<? extends Pid> getPidStats();

        public abstract Map<String, ? extends Proc> getProcessStats();

        public abstract long getScanWifiLockTime(long var1, int var3);

        public abstract Map<Integer, ? extends Sensor> getSensorStats();

        public abstract long getTcpBytesReceived(int var1);

        public abstract long getTcpBytesSent(int var1);

        public abstract int getUid();

        public abstract int getUserActivityCount(int var1, int var2);

        public abstract long getVideoTurnedOnTime(long var1, int var3);

        public abstract Map<String, ? extends Wakelock> getWakelockStats();

        public abstract long getWifiMulticastTime(long var1, int var3);

        public abstract long getWifiRunningTime(long var1, int var3);

        public abstract boolean hasUserActivity();

        public abstract void noteAudioTurnedOffLocked();

        public abstract void noteAudioTurnedOnLocked();

        public abstract void noteFullWifiLockAcquiredLocked();

        public abstract void noteFullWifiLockReleasedLocked();

        public abstract void noteScanWifiLockAcquiredLocked();

        public abstract void noteScanWifiLockReleasedLocked();

        public abstract void noteUserActivityLocked(int var1);

        public abstract void noteVideoTurnedOffLocked();

        public abstract void noteVideoTurnedOnLocked();

        public abstract void noteWifiMulticastDisabledLocked();

        public abstract void noteWifiMulticastEnabledLocked();

        public abstract void noteWifiRunningLocked();

        public abstract void noteWifiStoppedLocked();

        public static abstract class Pkg {
            public abstract Map<String, ? extends Serv> getServiceStats();

            public abstract int getWakeups(int var1);

            public abstract class Serv {
                public abstract int getLaunches(int var1);

                public abstract long getStartTime(long var1, int var3);

                public abstract int getStarts(int var1);
            }
        }

        public static abstract class Proc {
            public abstract int countExcessivePowers();

            public abstract ExcessivePower getExcessivePower(int var1);

            public abstract long getForegroundTime(int var1);

            public abstract int getStarts(int var1);

            public abstract long getSystemTime(int var1);

            public abstract long getTimeAtCpuSpeedStep(int var1, int var2);

            public abstract long getUserTime(int var1);

            public static class ExcessivePower {
                public static final int TYPE_CPU = 2;
                public static final int TYPE_WAKE = 1;
                public long overTime;
                public int type;
                public long usedTime;
            }
        }

        public class Pid {
            public long mWakeStart;
            public long mWakeSum;
        }

        public static abstract class Sensor {
            public static final int GPS = 55536;

            public abstract int getHandle();

            public abstract Timer getSensorTime();
        }

        public static abstract class Wakelock {
            public abstract Timer getWakeTime(int var1);
        }
    }

    public static abstract class Timer {
        public abstract int getCountLocked(int var1);

        public abstract long getTotalTimeLocked(long var1, int var3);

        public abstract void logState(Printer var1, String var2);
    }

    public static abstract class Counter {
        public abstract int getCountLocked(int var1);

        public abstract void logState(Printer var1, String var2);
    }
}

