/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.StrictMode;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class Binder
implements IBinder {
    private static final boolean FIND_POTENTIAL_LEAKS = false;
    private static final String TAG = "Binder";
    private String mDescriptor;
    private int mObject;
    private IInterface mOwner;

    public Binder() {
        this.init();
    }

    public static final native long clearCallingIdentity();

    private final native void destroy();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean execTransact(int n, int n2, int n3, int n4) {
        boolean bl;
        Parcel parcel = Parcel.obtain(n2);
        Parcel parcel2 = Parcel.obtain(n3);
        try {
            boolean bl2;
            bl = bl2 = this.onTransact(n, parcel, parcel2, n4);
        }
        catch (RemoteException remoteException) {
            parcel2.writeException(remoteException);
            bl = true;
        }
        catch (RuntimeException runtimeException) {
            parcel2.writeException(runtimeException);
            bl = true;
        }
        parcel2.recycle();
        parcel.recycle();
        return bl;
    }

    public static final native void flushPendingCommands();

    public static final native int getCallingPid();

    public static final native int getCallingUid();

    public static final native int getThreadStrictModePolicy();

    private final native void init();

    public static final native void joinThreadPool();

    public static final native void restoreCallingIdentity(long var0);

    public static final native void setThreadStrictModePolicy(int var0);

    public void attachInterface(IInterface iInterface, String string2) {
        this.mOwner = iInterface;
        this.mDescriptor = string2;
    }

    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, String[] stringArray) {
        FileOutputStream fileOutputStream = new FileOutputStream(fileDescriptor);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        try {
            this.dump(fileDescriptor, printWriter, stringArray);
            return;
        }
        finally {
            printWriter.flush();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public String getInterfaceDescriptor() {
        return this.mDescriptor;
    }

    @Override
    public boolean isBinderAlive() {
        return true;
    }

    @Override
    public void linkToDeath(IBinder.DeathRecipient deathRecipient, int n) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        if (n == 1598968902) {
            String string2 = this.getInterfaceDescriptor();
            parcel2.writeString(string2);
            return true;
        }
        if (n != 1598311760) return false;
        ParcelFileDescriptor parcelFileDescriptor = parcel.readFileDescriptor();
        String[] stringArray = parcel.readStringArray();
        if (parcelFileDescriptor != null) {
            FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
            this.dump(fileDescriptor, stringArray);
        }
        if (parcel2 != null) {
            parcel2.writeNoException();
            return true;
        }
        StrictMode.clearGatheredViolations();
        return true;
        finally {
            parcelFileDescriptor.close();
        }
    }

    @Override
    public boolean pingBinder() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IInterface queryLocalInterface(String string2) {
        if (!this.mDescriptor.equals(string2)) return null;
        return this.mOwner;
    }

    @Override
    public final boolean transact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        if (parcel != null) {
            parcel.setDataPosition(0);
        }
        boolean bl = this.onTransact(n, parcel, parcel2, n2);
        if (parcel2 != null) {
            parcel2.setDataPosition(0);
        }
        return bl;
    }

    @Override
    public boolean unlinkToDeath(IBinder.DeathRecipient deathRecipient, int n) {
        return true;
    }
}

