/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.util.Log;
import java.io.FileDescriptor;
import java.lang.ref.WeakReference;

final class BinderProxy
implements IBinder {
    private int mObject;
    private final WeakReference mSelf;

    BinderProxy() {
        WeakReference<BinderProxy> weakReference;
        this.mSelf = weakReference = new WeakReference<BinderProxy>(this);
    }

    private final native void destroy();

    private static final void sendDeathNotice(IBinder.DeathRecipient deathRecipient) {
        try {
            deathRecipient.binderDied();
            return;
        }
        catch (RuntimeException runtimeException) {
            int n = Log.w("BinderNative", "Uncaught exception from death notification", runtimeException);
            return;
        }
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, String[] stringArray) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeFileDescriptor(fileDescriptor);
        parcel.writeStringArray(stringArray);
        try {
            boolean bl = this.transact(1598311760, parcel, parcel2, 0);
            parcel2.readException();
            return;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public native String getInterfaceDescriptor() throws RemoteException;

    @Override
    public native boolean isBinderAlive();

    @Override
    public native void linkToDeath(IBinder.DeathRecipient var1, int var2) throws RemoteException;

    @Override
    public native boolean pingBinder();

    @Override
    public IInterface queryLocalInterface(String string2) {
        return null;
    }

    @Override
    public native boolean transact(int var1, Parcel var2, Parcel var3, int var4) throws RemoteException;

    @Override
    public native boolean unlinkToDeath(IBinder.DeathRecipient var1, int var2);
}

