/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.SystemProperties;

public class Build {
    public static final String BOARD;
    public static final String BOOTLOADER;
    public static final String BRAND;
    public static final String CPU_ABI;
    public static final String CPU_ABI2;
    public static final String DEVICE;
    public static final String DISPLAY;
    public static final String FINGERPRINT;
    public static final String HARDWARE;
    public static final String HOST;
    public static final String ID;
    public static final String MANUFACTURER;
    public static final String MODEL;
    public static final String PRODUCT;
    public static final String RADIO;
    public static final String SERIAL;
    public static final String TAGS;
    public static final long TIME = 0L;
    public static final String TYPE;
    public static final String UNKNOWN = "unknown";
    public static final String USER;

    static {
        ID = Build.getString("ro.build.id");
        DISPLAY = Build.getString("ro.build.display.id");
        PRODUCT = Build.getString("ro.product.name");
        DEVICE = Build.getString("ro.product.device");
        BOARD = Build.getString("ro.product.board");
        CPU_ABI = Build.getString("ro.product.cpu.abi");
        CPU_ABI2 = Build.getString("ro.product.cpu.abi2");
        MANUFACTURER = Build.getString("ro.product.manufacturer");
        BRAND = Build.getString("ro.product.brand");
        MODEL = Build.getString("ro.product.model");
        BOOTLOADER = Build.getString("ro.bootloader");
        RADIO = Build.getString("gsm.version.baseband");
        HARDWARE = Build.getString("ro.hardware");
        SERIAL = Build.getString("ro.serialno");
        TYPE = Build.getString("ro.build.type");
        TAGS = Build.getString("ro.build.tags");
        FINGERPRINT = Build.getString("ro.build.fingerprint");
        TIME = Build.getLong("ro.build.date.utc") * 1000L;
        USER = Build.getString("ro.build.user");
        HOST = Build.getString("ro.build.host");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long getLong(String string2) {
        try {
            long l = Long.parseLong(SystemProperties.get(string2));
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            return 65535L;
        }
    }

    private static String getString(String string2) {
        return SystemProperties.get(string2, UNKNOWN);
    }

    public static class VERSION_CODES {
        public static final int BASE = 1;
        public static final int BASE_1_1 = 2;
        public static final int CUPCAKE = 3;
        public static final int CUR_DEVELOPMENT = 10000;
        public static final int DONUT = 4;
        public static final int ECLAIR = 5;
        public static final int ECLAIR_0_1 = 6;
        public static final int ECLAIR_MR1 = 7;
        public static final int FROYO = 8;
        public static final int GINGERBREAD = 9;
        public static final int GINGERBREAD_MR1 = 10;
    }

    public static class VERSION {
        public static final String CODENAME;
        public static final String INCREMENTAL;
        public static final String RELEASE;
        @Deprecated
        public static final String SDK;
        public static final int SDK_INT;

        static {
            INCREMENTAL = Build.getString("ro.build.version.incremental");
            RELEASE = Build.getString("ro.build.version.release");
            SDK = Build.getString("ro.build.version.sdk");
            SDK_INT = SystemProperties.getInt("ro.build.version.sdk", 0);
            CODENAME = Build.getString("ro.build.version.codename");
        }
    }
}

